"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArtifactType = void 0;
/**
 * Type of cloud artifact.
 */
var ArtifactType;
(function (ArtifactType) {
    /**
     * Stub required because of JSII.
     */
    ArtifactType["NONE"] = "none";
    /**
     * The artifact is an AWS CloudFormation stack.
     */
    ArtifactType["AWS_CLOUDFORMATION_STACK"] = "aws:cloudformation:stack";
    /**
     * The artifact contains the CDK application's construct tree.
     */
    ArtifactType["CDK_TREE"] = "cdk:tree";
    /**
     * Manifest for all assets in the Cloud Assembly
     */
    ArtifactType["ASSET_MANIFEST"] = "cdk:asset-manifest";
    /**
     * Nested Cloud Assembly
     */
    ArtifactType["NESTED_CLOUD_ASSEMBLY"] = "cdk:cloud-assembly";
})(ArtifactType = exports.ArtifactType || (exports.ArtifactType = {}));
//# sourceMappingURL=data:application/json;base64,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