"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomState = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const __1 = require("..");
const state_1 = require("./state");
/**
 * State defined by supplying Amazon States Language (ASL) in the state machine.
 *
 */
class CustomState extends state_1.State {
    constructor(scope, id, props) {
        super(scope, id, {});
        jsiiDeprecationWarnings.monocdk_aws_stepfunctions_CustomStateProps(props);
        this.endStates = [this];
        this.stateJson = props.stateJson;
    }
    /**
     * Continue normal execution with the given state
     */
    next(next) {
        jsiiDeprecationWarnings.monocdk_aws_stepfunctions_IChainable(next);
        super.makeNext(next.startState);
        return __1.Chain.sequence(this, next);
    }
    /**
     * Returns the Amazon States Language object for this state
     */
    toStateJson() {
        return {
            ...this.renderNextEnd(),
            ...this.stateJson,
        };
    }
}
exports.CustomState = CustomState;
_a = JSII_RTTI_SYMBOL_1;
CustomState[_a] = { fqn: "monocdk.aws_stepfunctions.CustomState", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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