import * as iam from '../../../aws-iam';
import * as sfn from '../../../aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Properties for invoking an Activity worker
 */
export interface StepFunctionsInvokeActivityProps extends sfn.TaskStateBaseProps {
    /**
     * Step Functions Activity to invoke
     */
    readonly activity: sfn.IActivity;
}
/**
 * A Step Functions Task to invoke an Activity worker.
 *
 * An Activity can be used directly as a Resource.
 */
export declare class StepFunctionsInvokeActivity extends sfn.TaskStateBase {
    private readonly props;
    protected readonly taskMetrics?: sfn.TaskMetricsConfig;
    protected readonly taskPolicies?: iam.PolicyStatement[];
    constructor(scope: Construct, id: string, props: StepFunctionsInvokeActivityProps);
    /**
     * @internal
     */
    protected _renderTask(): any;
}
