"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluateExpression = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("../../aws-iam");
const lambda = require("../../aws-lambda");
const sfn = require("../../aws-stepfunctions");
/**
 * A Step Functions Task to evaluate an expression
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 */
class EvaluateExpression extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_stepfunctions_tasks_EvaluateExpressionProps(props);
        this.evalFn = createEvalFn((_b = this.props.runtime) !== null && _b !== void 0 ? _b : lambda.Runtime.NODEJS_14_X, this);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [this.evalFn.functionArn],
                actions: ['lambda:InvokeFunction'],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9-_]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.JsonPath.stringAt(m),
            }), {});
        }
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            Resource: this.evalFn.functionArn,
            Parameters: sfn.FieldUtils.renderObject(parameters),
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
_a = JSII_RTTI_SYMBOL_1;
EvaluateExpression[_a] = { fqn: "monocdk.aws_stepfunctions_tasks.EvaluateExpression", version: "1.149.0" };
function createEvalFn(runtime, scope) {
    const lambdaPurpose = 'Eval';
    const nodeJsGuids = {
        [lambda.Runtime.NODEJS_14_X.name]: 'da2d1181-604e-4a45-8694-1a6abd7fe42d',
        [lambda.Runtime.NODEJS_12_X.name]: '2b81e383-aad2-44db-8aaf-b4809ae0e3b4',
        [lambda.Runtime.NODEJS_10_X.name]: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
    };
    switch (runtime) {
        case lambda.Runtime.NODEJS_14_X:
        case lambda.Runtime.NODEJS_12_X:
        case lambda.Runtime.NODEJS_10_X:
            const uuid = nodeJsGuids[runtime.name];
            if (uuid) {
                return new lambda.SingletonFunction(scope, 'EvalFunction', {
                    runtime,
                    uuid,
                    handler: 'index.handler',
                    lambdaPurpose,
                    code: lambda.Code.fromAsset(path.join(__dirname, 'eval-nodejs-handler')),
                });
            }
            break;
    }
    throw new Error(`The runtime ${runtime.name} is currently not supported.`);
}
//# sourceMappingURL=data:application/json;base64,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