"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpMethods = exports.EksCall = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sfn = require("../../../aws-stepfunctions");
const task_utils_1 = require("../private/task-utils");
/**
 * Call a EKS endpoint as a Task
 *
 * @see https://docs.aws.amazon.com/step-functions/latest/dg/connect-eks.html
 */
class EksCall extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_stepfunctions_tasks_EksCallProps(props);
        this.integrationPattern = (_b = props.integrationPattern) !== null && _b !== void 0 ? _b : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EksCall.SUPPORTED_INTEGRATION_PATTERNS);
        try {
            this.clusterEndpoint = this.props.cluster.clusterEndpoint;
        }
        catch (e) {
            throw new Error('The "clusterEndpoint" property must be specified when using an imported Cluster.');
        }
        try {
            this.clusterCertificateAuthorityData = this.props.cluster.clusterCertificateAuthorityData;
        }
        catch (e) {
            throw new Error('The "clusterCertificateAuthorityData" property must be specified when using an imported Cluster.');
        }
    }
    /**
     * Provides the EKS Call service integration task configuration
     * @internal
     */
    _renderTask() {
        var _b;
        return {
            Resource: task_utils_1.integrationResourceArn('eks', 'call', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                ClusterName: this.props.cluster.clusterName,
                CertificateAuthority: this.clusterCertificateAuthorityData,
                Endpoint: this.clusterEndpoint,
                Method: this.props.httpMethod,
                Path: this.props.httpPath,
                QueryParameters: this.props.queryParameters,
                RequestBody: (_b = this.props.requestBody) === null || _b === void 0 ? void 0 : _b.value,
            }),
        };
    }
}
exports.EksCall = EksCall;
_a = JSII_RTTI_SYMBOL_1;
EksCall[_a] = { fqn: "monocdk.aws_stepfunctions_tasks.EksCall", version: "1.149.0" };
EksCall.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
];
/**
 * Method type of a EKS call
 */
var HttpMethods;
(function (HttpMethods) {
    /**
     * Retrieve data from a server at the specified resource
     */
    HttpMethods["GET"] = "GET";
    /**
     * Send data to the API endpoint to create or update a resource
     */
    HttpMethods["POST"] = "POST";
    /**
     * Send data to the API endpoint to update or create a resource
     */
    HttpMethods["PUT"] = "PUT";
    /**
     * Delete the resource at the specified endpoint
     */
    HttpMethods["DELETE"] = "DELETE";
    /**
     * Apply partial modifications to the resource
     */
    HttpMethods["PATCH"] = "PATCH";
    /**
     * Retrieve data from a server at the specified resource without the response body
     */
    HttpMethods["HEAD"] = "HEAD";
})(HttpMethods = exports.HttpMethods || (exports.HttpMethods = {}));
//# sourceMappingURL=data:application/json;base64,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