"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateJsonPath = exports.transformAttributeValueMap = exports.getDynamoResourceArn = exports.DynamoMethod = void 0;
const sfn = require("../../../../aws-stepfunctions");
const task_utils_1 = require("../../private/task-utils");
var DynamoMethod;
(function (DynamoMethod) {
    DynamoMethod["GET"] = "Get";
    DynamoMethod["PUT"] = "Put";
    DynamoMethod["DELETE"] = "Delete";
    DynamoMethod["UPDATE"] = "Update";
})(DynamoMethod = exports.DynamoMethod || (exports.DynamoMethod = {}));
function getDynamoResourceArn(method) {
    return task_utils_1.integrationResourceArn('dynamodb', `${method.toLowerCase()}Item`, sfn.IntegrationPattern.REQUEST_RESPONSE);
}
exports.getDynamoResourceArn = getDynamoResourceArn;
function transformAttributeValueMap(attrMap) {
    const transformedValue = {};
    for (const key in attrMap) {
        if (key) {
            transformedValue[key] = attrMap[key].toObject();
        }
    }
    return attrMap ? transformedValue : undefined;
}
exports.transformAttributeValueMap = transformAttributeValueMap;
function validateJsonPath(value) {
    if (!value.startsWith('$')) {
        throw new Error("Data JSON path values must either be exactly equal to '$' or start with '$.'");
    }
}
exports.validateJsonPath = validateJsonPath;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1dGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxxREFBcUQ7QUFDckQseURBQWtFO0FBR2xFLElBQVksWUFLWDtBQUxELFdBQVksWUFBWTtJQUN0QiwyQkFBVyxDQUFBO0lBQ1gsMkJBQVcsQ0FBQTtJQUNYLGlDQUFpQixDQUFBO0lBQ2pCLGlDQUFpQixDQUFBO0FBQ25CLENBQUMsRUFMVyxZQUFZLEdBQVosb0JBQVksS0FBWixvQkFBWSxRQUt2QjtBQUVELFNBQWdCLG9CQUFvQixDQUFDLE1BQW9CO0lBQ3ZELE9BQU8sbUNBQXNCLENBQUMsVUFBVSxFQUFFLEdBQUcsTUFBTSxDQUFDLFdBQVcsRUFBRSxNQUFNLEVBQUUsR0FBRyxDQUFDLGtCQUFrQixDQUFDLGdCQUFnQixDQUFDLENBQUM7QUFDcEgsQ0FBQztBQUZELG9EQUVDO0FBRUQsU0FBZ0IsMEJBQTBCLENBQUMsT0FBaUQ7SUFDMUYsTUFBTSxnQkFBZ0IsR0FBUSxFQUFFLENBQUM7SUFDakMsS0FBSyxNQUFNLEdBQUcsSUFBSSxPQUFPLEVBQUU7UUFDekIsSUFBSSxHQUFHLEVBQUU7WUFDUCxnQkFBZ0IsQ0FBQyxHQUFHLENBQUMsR0FBRyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUM7U0FDakQ7S0FDRjtJQUNELE9BQU8sT0FBTyxDQUFDLENBQUMsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0FBQ2hELENBQUM7QUFSRCxnRUFRQztBQUVELFNBQWdCLGdCQUFnQixDQUFDLEtBQWE7SUFDNUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLEVBQUU7UUFDMUIsTUFBTSxJQUFJLEtBQUssQ0FBQyw4RUFBOEUsQ0FBQyxDQUFDO0tBQ2pHO0FBQ0gsQ0FBQztBQUpELDRDQUlDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc2ZuIGZyb20gJy4uLy4uLy4uLy4uL2F3cy1zdGVwZnVuY3Rpb25zJztcbmltcG9ydCB7IGludGVncmF0aW9uUmVzb3VyY2VBcm4gfSBmcm9tICcuLi8uLi9wcml2YXRlL3Rhc2stdXRpbHMnO1xuaW1wb3J0IHsgRHluYW1vQXR0cmlidXRlVmFsdWUgfSBmcm9tICcuLi9zaGFyZWQtdHlwZXMnO1xuXG5leHBvcnQgZW51bSBEeW5hbW9NZXRob2Qge1xuICBHRVQgPSAnR2V0JyxcbiAgUFVUID0gJ1B1dCcsXG4gIERFTEVURSA9ICdEZWxldGUnLFxuICBVUERBVEUgPSAnVXBkYXRlJyxcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdldER5bmFtb1Jlc291cmNlQXJuKG1ldGhvZDogRHluYW1vTWV0aG9kKSB7XG4gIHJldHVybiBpbnRlZ3JhdGlvblJlc291cmNlQXJuKCdkeW5hbW9kYicsIGAke21ldGhvZC50b0xvd2VyQ2FzZSgpfUl0ZW1gLCBzZm4uSW50ZWdyYXRpb25QYXR0ZXJuLlJFUVVFU1RfUkVTUE9OU0UpO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gdHJhbnNmb3JtQXR0cmlidXRlVmFsdWVNYXAoYXR0ck1hcD86IHsgW2tleTogc3RyaW5nXTogRHluYW1vQXR0cmlidXRlVmFsdWUgfSkge1xuICBjb25zdCB0cmFuc2Zvcm1lZFZhbHVlOiBhbnkgPSB7fTtcbiAgZm9yIChjb25zdCBrZXkgaW4gYXR0ck1hcCkge1xuICAgIGlmIChrZXkpIHtcbiAgICAgIHRyYW5zZm9ybWVkVmFsdWVba2V5XSA9IGF0dHJNYXBba2V5XS50b09iamVjdCgpO1xuICAgIH1cbiAgfVxuICByZXR1cm4gYXR0ck1hcCA/IHRyYW5zZm9ybWVkVmFsdWUgOiB1bmRlZmluZWQ7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiB2YWxpZGF0ZUpzb25QYXRoKHZhbHVlOiBzdHJpbmcpIHtcbiAgaWYgKCF2YWx1ZS5zdGFydHNXaXRoKCckJykpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJEYXRhIEpTT04gcGF0aCB2YWx1ZXMgbXVzdCBlaXRoZXIgYmUgZXhhY3RseSBlcXVhbCB0byAnJCcgb3Igc3RhcnQgd2l0aCAnJC4nXCIpO1xuICB9XG59XG4iXX0=