"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sns = require("../../aws-sns");
const sqs = require("../../aws-sqs");
const cdk = require("../../core");
const subs = require("../lib");
/// !cdk-integ *
const app = new cdk.App();
/// !show
const topicStack = new cdk.Stack(app, 'TopicStack', {
    env: { account: process.env.CDK_DEFAULT_ACCOUNT, region: 'us-east-1' },
});
const topic = new sns.Topic(topicStack, 'MyTopic', {
    topicName: cdk.PhysicalName.GENERATE_IF_NEEDED,
});
const queueStack = new cdk.Stack(app, 'QueueStack', {
    env: { region: 'us-east-2' },
});
const queue = new sqs.Queue(queueStack, 'MyQueue');
topic.addSubscription(new subs.SqsSubscription(queue));
/// !hide
app.synth();
//# sourceMappingURL=data:application/json;base64,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