"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReceiptRuleSet = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const receipt_rule_1 = require("./receipt-rule");
const ses_generated_1 = require("./ses.generated");
/**
 * A new or imported receipt rule set.
 */
class ReceiptRuleSetBase extends core_1.Resource {
    /**
     * Adds a new receipt rule in this rule set. The new rule is added after
     * the last added rule unless `after` is specified.
     */
    addRule(id, options) {
        var _b;
        this.lastAddedRule = new receipt_rule_1.ReceiptRule(this, id, {
            after: (_b = this.lastAddedRule) !== null && _b !== void 0 ? _b : undefined,
            ruleSet: this,
            ...options,
        });
        return this.lastAddedRule;
    }
    /**
     * Adds a drop spam rule
     */
    addDropSpamRule() {
        const dropSpam = new receipt_rule_1.DropSpamReceiptRule(this, 'DropSpam', {
            ruleSet: this,
        });
        this.lastAddedRule = dropSpam.rule;
    }
}
/**
 * A new receipt rule set.
 */
class ReceiptRuleSet extends ReceiptRuleSetBase {
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.receiptRuleSetName,
        });
        jsiiDeprecationWarnings.monocdk_aws_ses_ReceiptRuleSetProps(props);
        const resource = new ses_generated_1.CfnReceiptRuleSet(this, 'Resource', {
            ruleSetName: this.physicalName,
        });
        this.receiptRuleSetName = resource.ref;
        if (props) {
            if (props.dropSpam) {
                this.addDropSpamRule();
            }
            const rules = props.rules || [];
            rules.forEach((ruleOption, idx) => this.addRule(`Rule${idx}`, ruleOption));
        }
    }
    /**
     * Import an exported receipt rule set.
     */
    static fromReceiptRuleSetName(scope, id, receiptRuleSetName) {
        class Import extends ReceiptRuleSetBase {
            constructor() {
                super(...arguments);
                this.receiptRuleSetName = receiptRuleSetName;
            }
        }
        return new Import(scope, id);
    }
}
exports.ReceiptRuleSet = ReceiptRuleSet;
_a = JSII_RTTI_SYMBOL_1;
ReceiptRuleSet[_a] = { fqn: "monocdk.aws_ses.ReceiptRuleSet", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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