"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Stop = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Terminates the evaluation of the receipt rule set and optionally publishes a
 * notification to Amazon SNS.
 */
class Stop {
    constructor(props = {}) {
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_ses_actions_StopProps(props);
    }
    bind(_rule) {
        var _b;
        jsiiDeprecationWarnings.monocdk_aws_ses_IReceiptRule(_rule);
        return {
            stopAction: {
                scope: 'RuleSet',
                topicArn: (_b = this.props.topic) === null || _b === void 0 ? void 0 : _b.topicArn,
            },
        };
    }
}
exports.Stop = Stop;
_a = JSII_RTTI_SYMBOL_1;
Stop[_a] = { fqn: "monocdk.aws_ses_actions.Stop", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN0b3AudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBYUE7OztHQUdHO0FBQ0gsTUFBYSxJQUFJO0lBQ2YsWUFBNkIsUUFBbUIsRUFBRTtRQUFyQixVQUFLLEdBQUwsS0FBSyxDQUFnQjs7S0FDakQ7SUFFTSxJQUFJLENBQUMsS0FBdUI7OztRQUNqQyxPQUFPO1lBQ0wsVUFBVSxFQUFFO2dCQUNWLEtBQUssRUFBRSxTQUFTO2dCQUNoQixRQUFRLFFBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLDBDQUFFLFFBQVE7YUFDckM7U0FDRixDQUFDO0tBQ0g7O0FBWEgsb0JBWUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBzZXMgZnJvbSAnLi4vLi4vYXdzLXNlcyc7XG5pbXBvcnQgKiBhcyBzbnMgZnJvbSAnLi4vLi4vYXdzLXNucyc7XG5cbi8qKlxuICogQ29uc3RydWN0aW9uIHByb3BlcnRpZXMgZm9yIGEgc3RvcCBhY3Rpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3RvcFByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBTTlMgdG9waWMgdG8gbm90aWZ5IHdoZW4gdGhlIHN0b3AgYWN0aW9uIGlzIHRha2VuLlxuICAgKi9cbiAgcmVhZG9ubHkgdG9waWM/OiBzbnMuSVRvcGljO1xufVxuXG4vKipcbiAqIFRlcm1pbmF0ZXMgdGhlIGV2YWx1YXRpb24gb2YgdGhlIHJlY2VpcHQgcnVsZSBzZXQgYW5kIG9wdGlvbmFsbHkgcHVibGlzaGVzIGFcbiAqIG5vdGlmaWNhdGlvbiB0byBBbWF6b24gU05TLlxuICovXG5leHBvcnQgY2xhc3MgU3RvcCBpbXBsZW1lbnRzIHNlcy5JUmVjZWlwdFJ1bGVBY3Rpb24ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBTdG9wUHJvcHMgPSB7fSkge1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3J1bGU6IHNlcy5JUmVjZWlwdFJ1bGUpOiBzZXMuUmVjZWlwdFJ1bGVBY3Rpb25Db25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBzdG9wQWN0aW9uOiB7XG4gICAgICAgIHNjb3BlOiAnUnVsZVNldCcsXG4gICAgICAgIHRvcGljQXJuOiB0aGlzLnByb3BzLnRvcGljPy50b3BpY0FybixcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19