"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Sns = exports.EmailEncoding = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The type of email encoding to use for a SNS action.
 */
var EmailEncoding;
(function (EmailEncoding) {
    /**
     * Base 64
     */
    EmailEncoding["BASE64"] = "Base64";
    /**
     * UTF-8
     */
    EmailEncoding["UTF8"] = "UTF-8";
})(EmailEncoding = exports.EmailEncoding || (exports.EmailEncoding = {}));
/**
 * Publishes the email content within a notification to Amazon SNS.
 */
class Sns {
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_ses_actions_SnsProps(props);
    }
    bind(_rule) {
        jsiiDeprecationWarnings.monocdk_aws_ses_IReceiptRule(_rule);
        return {
            snsAction: {
                encoding: this.props.encoding,
                topicArn: this.props.topic.topicArn,
            },
        };
    }
}
exports.Sns = Sns;
_a = JSII_RTTI_SYMBOL_1;
Sns[_a] = { fqn: "monocdk.aws_ses_actions.Sns", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUdBOztHQUVHO0FBQ0gsSUFBWSxhQVVYO0FBVkQsV0FBWSxhQUFhO0lBQ3ZCOztPQUVHO0lBQ0gsa0NBQWlCLENBQUE7SUFFakI7O09BRUc7SUFDSCwrQkFBYyxDQUFBO0FBQ2hCLENBQUMsRUFWVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQVV4QjtBQW1CRDs7R0FFRztBQUNILE1BQWEsR0FBRztJQUNkLFlBQTZCLEtBQWU7UUFBZixVQUFLLEdBQUwsS0FBSyxDQUFVOztLQUMzQztJQUVNLElBQUksQ0FBQyxLQUF1Qjs7UUFDakMsT0FBTztZQUNMLFNBQVMsRUFBRTtnQkFDVCxRQUFRLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO2dCQUM3QixRQUFRLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsUUFBUTthQUNwQztTQUNGLENBQUM7S0FDSDs7QUFYSCxrQkFZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHNlcyBmcm9tICcuLi8uLi9hd3Mtc2VzJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICcuLi8uLi9hd3Mtc25zJztcblxuLyoqXG4gKiBUaGUgdHlwZSBvZiBlbWFpbCBlbmNvZGluZyB0byB1c2UgZm9yIGEgU05TIGFjdGlvbi5cbiAqL1xuZXhwb3J0IGVudW0gRW1haWxFbmNvZGluZyB7XG4gIC8qKlxuICAgKiBCYXNlIDY0XG4gICAqL1xuICBCQVNFNjQgPSAnQmFzZTY0JyxcblxuICAvKipcbiAgICogVVRGLThcbiAgICovXG4gIFVURjggPSAnVVRGLTgnLFxufVxuXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBhIFNOUyBhY3Rpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU25zUHJvcHMge1xuICAvKipcbiAgICogVGhlIGVuY29kaW5nIHRvIHVzZSBmb3IgdGhlIGVtYWlsIHdpdGhpbiB0aGUgQW1hem9uIFNOUyBub3RpZmljYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IFVURi04XG4gICAqL1xuICByZWFkb25seSBlbmNvZGluZz86IEVtYWlsRW5jb2Rpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBTTlMgdG9waWMgdG8gbm90aWZ5LlxuICAgKi9cbiAgcmVhZG9ubHkgdG9waWM6IHNucy5JVG9waWM7XG59XG5cbi8qKlxuICogUHVibGlzaGVzIHRoZSBlbWFpbCBjb250ZW50IHdpdGhpbiBhIG5vdGlmaWNhdGlvbiB0byBBbWF6b24gU05TLlxuICovXG5leHBvcnQgY2xhc3MgU25zIGltcGxlbWVudHMgc2VzLklSZWNlaXB0UnVsZUFjdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IFNuc1Byb3BzKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcnVsZTogc2VzLklSZWNlaXB0UnVsZSk6IHNlcy5SZWNlaXB0UnVsZUFjdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHNuc0FjdGlvbjoge1xuICAgICAgICBlbmNvZGluZzogdGhpcy5wcm9wcy5lbmNvZGluZyxcbiAgICAgICAgdG9waWNBcm46IHRoaXMucHJvcHMudG9waWMudG9waWNBcm4sXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==