"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../core");
const servicediscovery = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-servicediscovery-integ');
const namespace = new servicediscovery.HttpNamespace(stack, 'MyNamespace', {
    name: 'covfefe',
});
const service1 = namespace.createService('NonIpService', {
    description: 'service registering non-ip instances',
});
service1.registerNonIpInstance('NonIpInstance', {
    customAttributes: { arn: 'arn:aws:s3:::mybucket' },
});
const service2 = namespace.createService('IpService', {
    description: 'service registering ip instances',
    healthCheck: {
        type: servicediscovery.HealthCheckType.HTTP,
        resourcePath: '/check',
    },
});
service2.registerIpInstance('IpInstance', {
    ipv4: '54.239.25.192',
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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