"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
class InstanceBase extends core_1.Resource {
    /**
     * Generate a unique instance Id that is safe to pass to CloudMap
     */
    uniqueInstanceId() {
        // Max length of 64 chars, get the last 64 chars
        const id = core_1.Names.uniqueId(this);
        return id.substring(Math.max(id.length - 64, 0), id.length);
    }
}
exports.InstanceBase = InstanceBase;
_a = JSII_RTTI_SYMBOL_1;
InstanceBase[_a] = { fqn: "monocdk.aws_servicediscovery.InstanceBase", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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