"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AliasTargetInstance = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Instance that uses Route 53 Alias record type. Currently, the only resource types supported are Elastic Load
 * Balancers.
 *
 * @resource AWS::ServiceDiscovery::Instance
 */
class AliasTargetInstance extends instance_1.InstanceBase {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_servicediscovery_AliasTargetInstanceProps(props);
        if (props.service.namespace.type === namespace_1.NamespaceType.HTTP) {
            throw new Error('Namespace associated with Service must be a DNS Namespace.');
        }
        // Should already be enforced when creating service, but validates if service is not instantiated with #createService
        const dnsRecordType = props.service.dnsRecordType;
        if (dnsRecordType !== service_1.DnsRecordType.A
            && dnsRecordType !== service_1.DnsRecordType.AAAA
            && dnsRecordType !== service_1.DnsRecordType.A_AAAA) {
            throw new Error('Service must use `A` or `AAAA` records to register an AliasRecordTarget.');
        }
        if (props.service.routingPolicy !== service_1.RoutingPolicy.WEIGHTED) {
            throw new Error('Service must use `WEIGHTED` routing policy.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceAttributes: {
                AWS_ALIAS_DNS_NAME: props.dnsName,
                ...props.customAttributes,
            },
            instanceId: props.instanceId || core_1.Names.uniqueId(this),
            serviceId: props.service.serviceId,
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.dnsName = props.dnsName;
    }
}
exports.AliasTargetInstance = AliasTargetInstance;
_a = JSII_RTTI_SYMBOL_1;
AliasTargetInstance[_a] = { fqn: "monocdk.aws_servicediscovery.AliasTargetInstance", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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