"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributeGroup = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const validation_1 = require("./private/validation");
const servicecatalogappregistry_generated_1 = require("./servicecatalogappregistry.generated");
class AttributeGroupBase extends cdk.Resource {
}
/**
 * A Service Catalog AppRegistry Attribute Group.
 */
class AttributeGroup extends AttributeGroupBase {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_servicecatalogappregistry_AttributeGroupProps(props);
        this.validateAttributeGroupProps(props);
        const attributeGroup = new servicecatalogappregistry_generated_1.CfnAttributeGroup(this, 'Resource', {
            name: props.attributeGroupName,
            description: props.description,
            attributes: props.attributes,
        });
        this.attributeGroupArn = attributeGroup.attrArn;
        this.attributeGroupId = attributeGroup.attrId;
    }
    /**
     * Imports an attribute group construct that represents an external attribute group.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attributeGroupArn the Amazon Resource Name of the existing AppRegistry attribute group
     */
    static fromAttributeGroupArn(scope, id, attributeGroupArn) {
        const arn = cdk.Stack.of(scope).splitArn(attributeGroupArn, cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME);
        const attributeGroupId = arn.resourceName;
        if (!attributeGroupId) {
            throw new Error('Missing required Attribute Group ID from Attribute Group ARN: ' + attributeGroupArn);
        }
        class Import extends AttributeGroupBase {
            constructor() {
                super(...arguments);
                this.attributeGroupArn = attributeGroupArn;
                this.attributeGroupId = attributeGroupId;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: attributeGroupArn,
        });
    }
    validateAttributeGroupProps(props) {
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group name', 1, 256, props.attributeGroupName);
        validation_1.InputValidator.validateRegex(this.node.path, 'attribute group name', /^[a-zA-Z0-9-_]+$/, props.attributeGroupName);
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group description', 0, 1024, props.description);
    }
}
exports.AttributeGroup = AttributeGroup;
_a = JSII_RTTI_SYMBOL_1;
AttributeGroup[_a] = { fqn: "monocdk.aws_servicecatalogappregistry.AttributeGroup", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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