import * as cdk from '../../core';
import { Construct } from 'constructs';
/**
 * A Service Catalog AppRegistry Attribute Group.
 */
export interface IAttributeGroup extends cdk.IResource {
    /**
     * The ARN of the attribute group.
     * @attribute
     */
    readonly attributeGroupArn: string;
    /**
     * The ID of the attribute group.
     * @attribute
     */
    readonly attributeGroupId: string;
}
/**
 * Properties for a Service Catalog AppRegistry Attribute Group
 */
export interface AttributeGroupProps {
    /**
     * Enforces a particular physical attribute group name.
     */
    readonly attributeGroupName: string;
    /**
     * Description for attribute group.
     * @default - No description provided
     */
    readonly description?: string;
    /**
     * A JSON of nested key-value pairs that represent the attributes in the group.
     * Attributes maybe an empty JSON '{}', but must be explicitly stated.
     */
    readonly attributes: {
        [key: string]: any;
    };
}
declare abstract class AttributeGroupBase extends cdk.Resource implements IAttributeGroup {
    abstract readonly attributeGroupArn: string;
    abstract readonly attributeGroupId: string;
}
/**
 * A Service Catalog AppRegistry Attribute Group.
 */
export declare class AttributeGroup extends AttributeGroupBase implements IAttributeGroup {
    /**
     * Imports an attribute group construct that represents an external attribute group.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attributeGroupArn the Amazon Resource Name of the existing AppRegistry attribute group
     */
    static fromAttributeGroupArn(scope: Construct, id: string, attributeGroupArn: string): IAttributeGroup;
    readonly attributeGroupArn: string;
    readonly attributeGroupId: string;
    constructor(scope: Construct, id: string, props: AttributeGroupProps);
    private validateAttributeGroupProps;
}
export {};
