"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretRotation = exports.SecretRotationApplication = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("../../aws-ec2");
const lambda = require("../../aws-lambda");
const serverless = require("../../aws-sam");
const core_1 = require("../../core");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../core");
/**
 * A secret rotation serverless application.
 */
class SecretRotationApplication {
    constructor(applicationId, semanticVersion, options) {
        jsiiDeprecationWarnings.monocdk_aws_secretsmanager_SecretRotationApplicationOptions(options);
        this.applicationId = `arn:aws:serverlessrepo:us-east-1:297356227824:applications/${applicationId}`;
        this.semanticVersion = semanticVersion;
        this.applicationName = applicationId;
        this.isMultiUser = options && options.isMultiUser;
    }
    /**
     * Returns the application ARN for the current partition.
     * Can be used in combination with a `CfnMapping` to automatically select the correct ARN based on the current partition.
     */
    applicationArnForPartition(partition) {
        if (partition === 'aws') {
            return this.applicationId;
        }
        else if (partition === 'aws-cn') {
            return `arn:aws-cn:serverlessrepo:cn-north-1:193023089310:applications/${this.applicationName}`;
        }
        else if (partition === 'aws-us-gov') {
            return `arn:aws-us-gov:serverlessrepo:us-gov-west-1:023102451235:applications/${this.applicationName}`;
        }
        else {
            throw new Error(`unsupported partition: ${partition}`);
        }
    }
    /**
     * The semantic version of the app for the current partition.
     * Can be used in combination with a `CfnMapping` to automatically select the correct version based on the current partition.
     */
    semanticVersionForPartition(partition) {
        if (partition === 'aws') {
            return this.semanticVersion;
        }
        else if (partition === 'aws-cn') {
            return '1.1.37';
        }
        else if (partition === 'aws-us-gov') {
            return '1.1.93';
        }
        else {
            throw new Error(`unsupported partition: ${partition}`);
        }
    }
}
exports.SecretRotationApplication = SecretRotationApplication;
_a = JSII_RTTI_SYMBOL_1;
SecretRotationApplication[_a] = { fqn: "monocdk.aws_secretsmanager.SecretRotationApplication", version: "1.149.0" };
/**
 * Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the single user rotation scheme
 */
SecretRotationApplication.MARIADB_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRDSMariaDBRotationSingleUser', '1.1.60');
/**
 * Conducts an AWS SecretsManager secret rotation for RDS MariaDB using the multi user rotation scheme
 */
SecretRotationApplication.MARIADB_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRDSMariaDBRotationMultiUser', '1.1.60', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for RDS MySQL using the single user rotation scheme
 */
SecretRotationApplication.MYSQL_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRDSMySQLRotationSingleUser', '1.1.60');
/**
 * Conducts an AWS SecretsManager secret rotation for RDS MySQL using the multi user rotation scheme
 */
SecretRotationApplication.MYSQL_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRDSMySQLRotationMultiUser', '1.1.60', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for RDS Oracle using the single user rotation scheme
 */
SecretRotationApplication.ORACLE_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRDSOracleRotationSingleUser', '1.1.60');
/**
 * Conducts an AWS SecretsManager secret rotation for RDS Oracle using the multi user rotation scheme
 */
SecretRotationApplication.ORACLE_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRDSOracleRotationMultiUser', '1.1.60', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the single user rotation scheme
 */
SecretRotationApplication.POSTGRES_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRDSPostgreSQLRotationSingleUser', '1.1.60');
/**
 * Conducts an AWS SecretsManager secret rotation for RDS PostgreSQL using the multi user rotation scheme
 */
SecretRotationApplication.POSTGRES_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRDSPostgreSQLRotationMultiUser', '1.1.60', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the single user rotation scheme
 */
SecretRotationApplication.SQLSERVER_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRDSSQLServerRotationSingleUser', '1.1.60');
/**
 * Conducts an AWS SecretsManager secret rotation for RDS SQL Server using the multi user rotation scheme
 */
SecretRotationApplication.SQLSERVER_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRDSSQLServerRotationMultiUser', '1.1.60', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the single user rotation scheme
 */
SecretRotationApplication.REDSHIFT_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerRedshiftRotationSingleUser', '1.1.60');
/**
 * Conducts an AWS SecretsManager secret rotation for Amazon Redshift using the multi user rotation scheme
 */
SecretRotationApplication.REDSHIFT_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerRedshiftRotationMultiUser', '1.1.60', {
    isMultiUser: true,
});
/**
 * Conducts an AWS SecretsManager secret rotation for MongoDB using the single user rotation scheme
 */
SecretRotationApplication.MONGODB_ROTATION_SINGLE_USER = new SecretRotationApplication('SecretsManagerMongoDBRotationSingleUser', '1.1.60');
/**
 * Conducts an AWS SecretsManager secret rotation for MongoDB using the multi user rotation scheme
 */
SecretRotationApplication.MONGODB_ROTATION_MULTI_USER = new SecretRotationApplication('SecretsManagerMongoDBRotationMultiUser', '1.1.60', {
    isMultiUser: true,
});
/**
 * Secret rotation for a service or database
 */
class SecretRotation extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_secretsmanager_SecretRotationProps(props);
        if (!props.target.connections.defaultPort) {
            throw new Error('The `target` connections must have a default port range.');
        }
        if (props.application.isMultiUser && !props.masterSecret) {
            throw new Error('The `masterSecret` must be specified for application using the multi user scheme.');
        }
        // Max length of 64 chars, get the last 64 chars
        const uniqueId = core_1.Names.uniqueId(this);
        const rotationFunctionName = uniqueId.substring(Math.max(uniqueId.length - 64, 0), uniqueId.length);
        const securityGroup = props.securityGroup || new ec2.SecurityGroup(this, 'SecurityGroup', {
            vpc: props.vpc,
        });
        props.target.connections.allowDefaultPortFrom(securityGroup);
        const parameters = {
            endpoint: `https://${props.endpoint ? `${props.endpoint.vpcEndpointId}.` : ''}secretsmanager.${core_1.Stack.of(this).region}.${core_1.Stack.of(this).urlSuffix}`,
            functionName: rotationFunctionName,
            vpcSubnetIds: props.vpc.selectSubnets(props.vpcSubnets).subnetIds.join(','),
            vpcSecurityGroupIds: securityGroup.securityGroupId,
        };
        if (props.excludeCharacters !== undefined) {
            parameters.excludeCharacters = props.excludeCharacters;
        }
        if (props.secret.encryptionKey) {
            parameters.kmsKeyArn = props.secret.encryptionKey.keyArn;
        }
        if (props.masterSecret) {
            parameters.masterSecretArn = props.masterSecret.secretArn;
            if (props.masterSecret.encryptionKey) {
                parameters.masterSecretKmsKeyArn = props.masterSecret.encryptionKey.keyArn;
            }
        }
        const sarMapping = new core_1.CfnMapping(this, 'SARMapping', {
            mapping: {
                'aws': {
                    applicationId: props.application.applicationArnForPartition('aws'),
                    semanticVersion: props.application.semanticVersionForPartition('aws'),
                },
                'aws-cn': {
                    applicationId: props.application.applicationArnForPartition('aws-cn'),
                    semanticVersion: props.application.semanticVersionForPartition('aws-cn'),
                },
                'aws-us-gov': {
                    applicationId: props.application.applicationArnForPartition('aws-us-gov'),
                    semanticVersion: props.application.semanticVersionForPartition('aws-us-gov'),
                },
            },
        });
        const application = new serverless.CfnApplication(this, 'Resource', {
            location: {
                applicationId: sarMapping.findInMap(core_1.Aws.PARTITION, 'applicationId'),
                semanticVersion: sarMapping.findInMap(core_1.Aws.PARTITION, 'semanticVersion'),
            },
            parameters,
        });
        // This creates a CF a dependency between the rotation schedule and the
        // serverless application. This is needed because it's the application
        // that creates the Lambda permission to invoke the function.
        // See https://docs.aws.amazon.com/secretsmanager/latest/userguide/integrating_cloudformation.html
        const rotationLambda = lambda.Function.fromFunctionArn(this, 'RotationLambda', core_1.Token.asString(application.getAtt('Outputs.RotationLambdaARN')));
        props.secret.addRotationSchedule('RotationSchedule', {
            rotationLambda,
            automaticallyAfter: props.automaticallyAfter,
        });
        // Prevent master secret deletion when rotation is in place
        if (props.masterSecret) {
            props.masterSecret.denyAccountRootDelete();
        }
    }
}
exports.SecretRotation = SecretRotation;
_b = JSII_RTTI_SYMBOL_1;
SecretRotation[_b] = { fqn: "monocdk.aws_secretsmanager.SecretRotation", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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