"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const s3 = require("../../aws-s3");
const core_1 = require("../../core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("../../core");
/**
 * Use a Lambda function as a bucket notification destination
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
        jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
    }
    bind(_scope, bucket) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_s3_IBucket(bucket);
        const permissionId = `AllowBucketNotificationsTo${core_1.Names.nodeUniqueId(this.fn.permissionsNode)}`;
        if (!core_2.Construct.isConstruct(bucket)) {
            throw new Error(`LambdaDestination for function ${core_1.Names.nodeUniqueId(this.fn.permissionsNode)} can only be configured on a
        bucket construct (Bucket ${bucket.bucketName})`);
        }
        if (bucket.node.tryFindChild(permissionId) === undefined) {
            this.fn.addPermission(permissionId, {
                sourceAccount: core_1.Stack.of(bucket).account,
                principal: new iam.ServicePrincipal('s3.amazonaws.com'),
                sourceArn: bucket.bucketArn,
                // Placing the permissions node in the same scope as the s3 bucket.
                // Otherwise, there is a circular dependency when the s3 bucket
                // and lambda functions declared in different stacks.
                scope: bucket,
            });
        }
        // if we have a permission resource for this relationship, add it as a dependency
        // to the bucket notifications resource, so it will be created first.
        const permission = bucket.node.tryFindChild(permissionId);
        return {
            type: s3.BucketNotificationDestinationType.LAMBDA,
            arn: this.fn.functionArn,
            dependencies: permission ? [permission] : undefined,
        };
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "monocdk.aws_s3_notifications.LambdaDestination", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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