"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toSymlinkFollow = void 0;
const assets_1 = require("../../assets");
const core_1 = require("../../core");
function toSymlinkFollow(follow) {
    if (!follow) {
        return undefined;
    }
    switch (follow) {
        case assets_1.FollowMode.NEVER: return core_1.SymlinkFollowMode.NEVER;
        case assets_1.FollowMode.ALWAYS: return core_1.SymlinkFollowMode.ALWAYS;
        case assets_1.FollowMode.BLOCK_EXTERNAL: return core_1.SymlinkFollowMode.BLOCK_EXTERNAL;
        case assets_1.FollowMode.EXTERNAL: return core_1.SymlinkFollowMode.EXTERNAL;
        default:
            throw new Error(`unknown follow mode: ${follow}`);
    }
}
exports.toSymlinkFollow = toSymlinkFollow;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tcGF0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tcGF0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHlDQUEwQztBQUMxQyxxQ0FBK0M7QUFFL0MsU0FBZ0IsZUFBZSxDQUFDLE1BQW1CO0lBQ2pELElBQUksQ0FBQyxNQUFNLEVBQUU7UUFDWCxPQUFPLFNBQVMsQ0FBQztLQUNsQjtJQUVELFFBQVEsTUFBTSxFQUFFO1FBQ2QsS0FBSyxtQkFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sd0JBQWlCLENBQUMsS0FBSyxDQUFDO1FBQ3RELEtBQUssbUJBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxPQUFPLHdCQUFpQixDQUFDLE1BQU0sQ0FBQztRQUN4RCxLQUFLLG1CQUFVLENBQUMsY0FBYyxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxjQUFjLENBQUM7UUFDeEUsS0FBSyxtQkFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLE9BQU8sd0JBQWlCLENBQUMsUUFBUSxDQUFDO1FBQzVEO1lBQ0UsTUFBTSxJQUFJLEtBQUssQ0FBQyx3QkFBd0IsTUFBTSxFQUFFLENBQUMsQ0FBQztLQUNyRDtBQUNILENBQUM7QUFiRCwwQ0FhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEZvbGxvd01vZGUgfSBmcm9tICcuLi8uLi9hc3NldHMnO1xuaW1wb3J0IHsgU3ltbGlua0ZvbGxvd01vZGUgfSBmcm9tICcuLi8uLi9jb3JlJztcblxuZXhwb3J0IGZ1bmN0aW9uIHRvU3ltbGlua0ZvbGxvdyhmb2xsb3c/OiBGb2xsb3dNb2RlKTogU3ltbGlua0ZvbGxvd01vZGUgfCB1bmRlZmluZWQge1xuICBpZiAoIWZvbGxvdykge1xuICAgIHJldHVybiB1bmRlZmluZWQ7XG4gIH1cblxuICBzd2l0Y2ggKGZvbGxvdykge1xuICAgIGNhc2UgRm9sbG93TW9kZS5ORVZFUjogcmV0dXJuIFN5bWxpbmtGb2xsb3dNb2RlLk5FVkVSO1xuICAgIGNhc2UgRm9sbG93TW9kZS5BTFdBWVM6IHJldHVybiBTeW1saW5rRm9sbG93TW9kZS5BTFdBWVM7XG4gICAgY2FzZSBGb2xsb3dNb2RlLkJMT0NLX0VYVEVSTkFMOiByZXR1cm4gU3ltbGlua0ZvbGxvd01vZGUuQkxPQ0tfRVhURVJOQUw7XG4gICAgY2FzZSBGb2xsb3dNb2RlLkVYVEVSTkFMOiByZXR1cm4gU3ltbGlua0ZvbGxvd01vZGUuRVhURVJOQUw7XG4gICAgZGVmYXVsdDpcbiAgICAgIHRocm93IG5ldyBFcnJvcihgdW5rbm93biBmb2xsb3cgbW9kZTogJHtmb2xsb3d9YCk7XG4gIH1cbn1cbiJdfQ==