"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Asset = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const kms = require("../../aws-kms");
const s3 = require("../../aws-s3");
const cdk = require("../../core");
const cxapi = require("../../cx-api");
const compat_1 = require("./compat");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../core");
/**
 * An asset represents a local file or directory, which is automatically uploaded to S3
 * and then can be referenced within a CDK application.
 */
class Asset extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_s3_assets_AssetProps(props);
        this.isBundled = props.bundling != null;
        // stage the asset source (conditionally).
        const staging = new cdk.AssetStaging(this, 'Stage', {
            ...props,
            sourcePath: path.resolve(props.path),
            follow: (_b = props.followSymlinks) !== null && _b !== void 0 ? _b : compat_1.toSymlinkFollow(props.follow),
            assetHash: (_c = props.assetHash) !== null && _c !== void 0 ? _c : props.sourceHash,
        });
        this.assetHash = staging.assetHash;
        this.sourceHash = this.assetHash;
        const stack = cdk.Stack.of(this);
        this.assetPath = staging.relativeStagedPath(stack);
        this.isFile = staging.packaging === cdk.FileAssetPackaging.FILE;
        this.isZipArchive = staging.isArchive;
        const location = stack.synthesizer.addFileAsset({
            packaging: staging.packaging,
            sourceHash: this.sourceHash,
            fileName: this.assetPath,
        });
        this.s3BucketName = location.bucketName;
        this.s3ObjectKey = location.objectKey;
        this.s3ObjectUrl = location.s3ObjectUrl;
        this.httpUrl = location.httpUrl;
        this.s3Url = location.httpUrl; // for backwards compatibility
        const kmsKey = location.kmsKeyArn ? kms.Key.fromKeyArn(this, 'Key', location.kmsKeyArn) : undefined;
        this.bucket = s3.Bucket.fromBucketAttributes(this, 'AssetBucket', {
            bucketName: this.s3BucketName,
            encryptionKey: kmsKey,
        });
        for (const reader of ((_d = props.readers) !== null && _d !== void 0 ? _d : [])) {
            this.grantRead(reader);
        }
    }
    /**
     * Adds CloudFormation template metadata to the specified resource with
     * information that indicates which resource property is mapped to this local
     * asset. This can be used by tools such as SAM CLI to provide local
     * experience such as local invocation and debugging of Lambda functions.
     *
     * Asset metadata will only be included if the stack is synthesized with the
     * "aws:cdk:enable-asset-metadata" context key defined, which is the default
     * behavior when synthesizing via the CDK Toolkit.
     *
     * @see https://github.com/aws/aws-cdk/issues/1432
     *
     * @param resource The CloudFormation resource which is using this asset [disable-awslint:ref-via-interface]
     * @param resourceProperty The property name where this asset is referenced
     * (e.g. "Code" for AWS::Lambda::Function)
     */
    addResourceMetadata(resource, resourceProperty) {
        jsiiDeprecationWarnings.monocdk_CfnResource(resource);
        if (!this.node.tryGetContext(cxapi.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT)) {
            return; // not enabled
        }
        // tell tools such as SAM CLI that the "Code" property of this resource
        // points to a local path in order to enable local invocation of this function.
        resource.cfnOptions.metadata = resource.cfnOptions.metadata || {};
        resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_PATH_KEY] = this.assetPath;
        resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY] = this.isBundled;
        resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_PROPERTY_KEY] = resourceProperty;
    }
    /**
     * Grants read permissions to the principal on the assets bucket.
     */
    grantRead(grantee) {
        jsiiDeprecationWarnings.monocdk_aws_iam_IGrantable(grantee);
        // we give permissions on all files in the bucket since we don't want to
        // accidentally revoke permission on old versions when deploying a new
        // version (for example, when using Lambda traffic shifting).
        this.bucket.grantRead(grantee);
    }
}
exports.Asset = Asset;
_a = JSII_RTTI_SYMBOL_1;
Asset[_a] = { fqn: "monocdk.aws_s3_assets.Asset", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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