"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolDomainTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront_target_1 = require("./cloudfront-target");
/**
 * Use a user pool domain as an alias record target
 */
class UserPoolDomainTarget {
    constructor(domain) {
        this.domain = domain;
        jsiiDeprecationWarnings.monocdk_aws_cognito_UserPoolDomain(domain);
    }
    bind(_record, _zone) {
        jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
        jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        return {
            dnsName: this.domain.cloudFrontDomainName,
            hostedZoneId: cloudfront_target_1.CloudFrontTarget.getHostedZoneId(this.domain),
        };
    }
}
exports.UserPoolDomainTarget = UserPoolDomainTarget;
_a = JSII_RTTI_SYMBOL_1;
UserPoolDomainTarget[_a] = { fqn: "monocdk.aws_route53_targets.UserPoolDomainTarget", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlcnBvb2wtZG9tYWluLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXNlcnBvb2wtZG9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLDJEQUF1RDtBQUV2RDs7R0FFRztBQUNILE1BQWEsb0JBQW9CO0lBQy9CLFlBQTZCLE1BQXNCO1FBQXRCLFdBQU0sR0FBTixNQUFNLENBQWdCOztLQUNsRDtJQUVNLElBQUksQ0FBQyxPQUFtQixFQUFFLEtBQW1COzs7UUFDbEQsT0FBTztZQUNMLE9BQU8sRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLG9CQUFvQjtZQUN6QyxZQUFZLEVBQUUsb0NBQWdCLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUM7U0FDNUQsQ0FBQztLQUNIOztBQVRILG9EQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVXNlclBvb2xEb21haW4gfSBmcm9tICcuLi8uLi9hd3MtY29nbml0byc7XG5pbXBvcnQgeyBBbGlhc1JlY29yZFRhcmdldENvbmZpZywgSUFsaWFzUmVjb3JkVGFyZ2V0LCBJSG9zdGVkWm9uZSwgSVJlY29yZFNldCB9IGZyb20gJy4uLy4uL2F3cy1yb3V0ZTUzJztcbmltcG9ydCB7IENsb3VkRnJvbnRUYXJnZXQgfSBmcm9tICcuL2Nsb3VkZnJvbnQtdGFyZ2V0JztcblxuLyoqXG4gKiBVc2UgYSB1c2VyIHBvb2wgZG9tYWluIGFzIGFuIGFsaWFzIHJlY29yZCB0YXJnZXRcbiAqL1xuZXhwb3J0IGNsYXNzIFVzZXJQb29sRG9tYWluVGFyZ2V0IGltcGxlbWVudHMgSUFsaWFzUmVjb3JkVGFyZ2V0IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBkb21haW46IFVzZXJQb29sRG9tYWluKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcmVjb3JkOiBJUmVjb3JkU2V0LCBfem9uZT86IElIb3N0ZWRab25lKTogQWxpYXNSZWNvcmRUYXJnZXRDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBkbnNOYW1lOiB0aGlzLmRvbWFpbi5jbG91ZEZyb250RG9tYWluTmFtZSxcbiAgICAgIGhvc3RlZFpvbmVJZDogQ2xvdWRGcm9udFRhcmdldC5nZXRIb3N0ZWRab25lSWQodGhpcy5kb21haW4pLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==