"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53RecordTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use another Route 53 record as an alias record target
 */
class Route53RecordTarget {
    constructor(record) {
        this.record = record;
        jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(record);
    }
    bind(_record, zone) {
        jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
        jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(zone);
        if (!zone) { // zone introduced as optional to avoid a breaking change
            throw new Error('Cannot bind to record without a zone');
        }
        return {
            dnsName: this.record.domainName,
            hostedZoneId: zone.hostedZoneId,
        };
    }
}
exports.Route53RecordTarget = Route53RecordTarget;
_a = JSII_RTTI_SYMBOL_1;
Route53RecordTarget[_a] = { fqn: "monocdk.aws_route53_targets.Route53RecordTarget", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicm91dGU1My1yZWNvcmQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyb3V0ZTUzLXJlY29yZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFFQTs7R0FFRztBQUNILE1BQWEsbUJBQW1CO0lBQzlCLFlBQTZCLE1BQTBCO1FBQTFCLFdBQU0sR0FBTixNQUFNLENBQW9COztLQUN0RDtJQUVNLElBQUksQ0FBQyxPQUEyQixFQUFFLElBQTBCOzs7UUFDakUsSUFBSSxDQUFDLElBQUksRUFBRSxFQUFFLHlEQUF5RDtZQUNwRSxNQUFNLElBQUksS0FBSyxDQUFDLHNDQUFzQyxDQUFDLENBQUM7U0FDekQ7UUFDRCxPQUFPO1lBQ0wsT0FBTyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVTtZQUMvQixZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7U0FDaEMsQ0FBQztLQUNIOztBQVpILGtEQWFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm91dGU1MyBmcm9tICcuLi8uLi9hd3Mtcm91dGU1Myc7XG5cbi8qKlxuICogVXNlIGFub3RoZXIgUm91dGUgNTMgcmVjb3JkIGFzIGFuIGFsaWFzIHJlY29yZCB0YXJnZXRcbiAqL1xuZXhwb3J0IGNsYXNzIFJvdXRlNTNSZWNvcmRUYXJnZXQgaW1wbGVtZW50cyByb3V0ZTUzLklBbGlhc1JlY29yZFRhcmdldCB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQpIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKF9yZWNvcmQ6IHJvdXRlNTMuSVJlY29yZFNldCwgem9uZT86IHJvdXRlNTMuSUhvc3RlZFpvbmUpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICBpZiAoIXpvbmUpIHsgLy8gem9uZSBpbnRyb2R1Y2VkIGFzIG9wdGlvbmFsIHRvIGF2b2lkIGEgYnJlYWtpbmcgY2hhbmdlXG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0Nhbm5vdCBiaW5kIHRvIHJlY29yZCB3aXRob3V0IGEgem9uZScpO1xuICAgIH1cbiAgICByZXR1cm4ge1xuICAgICAgZG5zTmFtZTogdGhpcy5yZWNvcmQuZG9tYWluTmFtZSxcbiAgICAgIGhvc3RlZFpvbmVJZDogem9uZS5ob3N0ZWRab25lSWQsXG4gICAgfTtcbiAgfVxufVxuIl19