"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an ELBv2 as an alias record target
 */
class LoadBalancerTarget {
    constructor(loadBalancer) {
        this.loadBalancer = loadBalancer;
        jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_ILoadBalancerV2(loadBalancer);
    }
    bind(_record, _zone) {
        jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
        jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        return {
            hostedZoneId: this.loadBalancer.loadBalancerCanonicalHostedZoneId,
            dnsName: `dualstack.${this.loadBalancer.loadBalancerDnsName}`,
        };
    }
}
exports.LoadBalancerTarget = LoadBalancerTarget;
_a = JSII_RTTI_SYMBOL_1;
LoadBalancerTarget[_a] = { fqn: "monocdk.aws_route53_targets.LoadBalancerTarget", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9hZC1iYWxhbmNlci10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb2FkLWJhbGFuY2VyLXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFHQTs7R0FFRztBQUNILE1BQWEsa0JBQWtCO0lBQzdCLFlBQTZCLFlBQW1DO1FBQW5DLGlCQUFZLEdBQVosWUFBWSxDQUF1Qjs7S0FDL0Q7SUFFTSxJQUFJLENBQUMsT0FBMkIsRUFBRSxLQUEyQjs7O1FBQ2xFLE9BQU87WUFDTCxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxpQ0FBaUM7WUFDakUsT0FBTyxFQUFFLGFBQWEsSUFBSSxDQUFDLFlBQVksQ0FBQyxtQkFBbUIsRUFBRTtTQUM5RCxDQUFDO0tBQ0g7O0FBVEgsZ0RBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlbGJ2MiBmcm9tICcuLi8uLi9hd3MtZWxhc3RpY2xvYWRiYWxhbmNpbmd2Mic7XG5pbXBvcnQgKiBhcyByb3V0ZTUzIGZyb20gJy4uLy4uL2F3cy1yb3V0ZTUzJztcblxuLyoqXG4gKiBVc2UgYW4gRUxCdjIgYXMgYW4gYWxpYXMgcmVjb3JkIHRhcmdldFxuICovXG5leHBvcnQgY2xhc3MgTG9hZEJhbGFuY2VyVGFyZ2V0IGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGxvYWRCYWxhbmNlcjogZWxidjIuSUxvYWRCYWxhbmNlclYyKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQsIF96b25lPzogcm91dGU1My5JSG9zdGVkWm9uZSk6IHJvdXRlNTMuQWxpYXNSZWNvcmRUYXJnZXRDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBob3N0ZWRab25lSWQ6IHRoaXMubG9hZEJhbGFuY2VyLmxvYWRCYWxhbmNlckNhbm9uaWNhbEhvc3RlZFpvbmVJZCxcbiAgICAgIGRuc05hbWU6IGBkdWFsc3RhY2suJHt0aGlzLmxvYWRCYWxhbmNlci5sb2FkQmFsYW5jZXJEbnNOYW1lfWAsXG4gICAgfTtcbiAgfVxufVxuIl19