"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InterfaceVpcEndpointTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
/**
 * Set an InterfaceVpcEndpoint as a target for an ARecord
 */
class InterfaceVpcEndpointTarget {
    constructor(vpcEndpoint) {
        this.vpcEndpoint = vpcEndpoint;
        jsiiDeprecationWarnings.monocdk_aws_ec2_IInterfaceVpcEndpoint(vpcEndpoint);
        this.cfnVpcEndpoint = this.vpcEndpoint.node.findChild('Resource');
    }
    bind(_record, _zone) {
        jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
        jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        return {
            dnsName: cdk.Fn.select(1, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
            hostedZoneId: cdk.Fn.select(0, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
        };
    }
}
exports.InterfaceVpcEndpointTarget = InterfaceVpcEndpointTarget;
_a = JSII_RTTI_SYMBOL_1;
InterfaceVpcEndpointTarget[_a] = { fqn: "monocdk.aws_route53_targets.InterfaceVpcEndpointTarget", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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