"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalAcceleratorTarget = exports.GlobalAcceleratorDomainTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use a Global Accelerator domain name as an alias record target.
 */
class GlobalAcceleratorDomainTarget {
    /**
     * Create an Alias Target for a Global Accelerator domain name.
     */
    constructor(acceleratorDomainName) {
        this.acceleratorDomainName = acceleratorDomainName;
    }
    bind(_record, _zone) {
        jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
        jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        return {
            hostedZoneId: GlobalAcceleratorTarget.GLOBAL_ACCELERATOR_ZONE_ID,
            dnsName: this.acceleratorDomainName,
        };
    }
}
exports.GlobalAcceleratorDomainTarget = GlobalAcceleratorDomainTarget;
_a = JSII_RTTI_SYMBOL_1;
GlobalAcceleratorDomainTarget[_a] = { fqn: "monocdk.aws_route53_targets.GlobalAcceleratorDomainTarget", version: "1.149.0" };
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 * Ref: https://docs.aws.amazon.com/general/latest/gr/global_accelerator.html
 */
GlobalAcceleratorDomainTarget.GLOBAL_ACCELERATOR_ZONE_ID = 'Z2BJ6XQ5FK7U4H';
/**
 * Use a Global Accelerator instance domain name as an alias record target.
 */
class GlobalAcceleratorTarget extends GlobalAcceleratorDomainTarget {
    /**
     * Create an Alias Target for a Global Accelerator instance.
     */
    constructor(accelerator) {
        super(accelerator.dnsName);
        jsiiDeprecationWarnings.monocdk_aws_globalaccelerator_IAccelerator(accelerator);
    }
}
exports.GlobalAcceleratorTarget = GlobalAcceleratorTarget;
_b = JSII_RTTI_SYMBOL_1;
GlobalAcceleratorTarget[_b] = { fqn: "monocdk.aws_route53_targets.GlobalAcceleratorTarget", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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