"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
/**
 * Use a CloudFront Distribution as an alias record target
 */
class CloudFrontTarget {
    constructor(distribution) {
        this.distribution = distribution;
        jsiiDeprecationWarnings.monocdk_aws_cloudfront_IDistribution(distribution);
    }
    /**
     * Get the hosted zone id for the current scope.
     *
     * @param scope - scope in which this resource is defined
     */
    static getHostedZoneId(scope) {
        var _b;
        jsiiDeprecationWarnings.monocdk_IConstruct(scope);
        const mappingName = 'AWSCloudFrontPartitionHostedZoneIdMap';
        const scopeStack = core_1.Stack.of(scope);
        let mapping = (_b = scopeStack.node.tryFindChild(mappingName)) !== null && _b !== void 0 ? _b : new core_1.CfnMapping(scopeStack, mappingName, {
            mapping: {
                ['aws']: {
                    zoneId: 'Z2FDTNDATAQYW2',
                },
                ['aws-cn']: {
                    zoneId: 'Z3RFFRIM2A3IF5',
                },
            },
        });
        return mapping.findInMap(core_1.Aws.PARTITION, 'zoneId');
    }
    bind(_record, _zone) {
        jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
        jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        return {
            hostedZoneId: CloudFrontTarget.getHostedZoneId(this.distribution),
            dnsName: this.distribution.distributionDomainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontTarget[_a] = { fqn: "monocdk.aws_route53_targets.CloudFrontTarget", version: "1.149.0" };
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,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