"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BucketWebsiteTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const region_info_1 = require("../../region-info");
/**
 * Use a S3 as an alias record target
 */
class BucketWebsiteTarget {
    constructor(bucket) {
        this.bucket = bucket;
        jsiiDeprecationWarnings.monocdk_aws_s3_IBucket(bucket);
    }
    bind(_record, _zone) {
        jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
        jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        const { region } = core_1.Stack.of(this.bucket.stack);
        if (core_1.Token.isUnresolved(region)) {
            throw new Error([
                'Cannot use an S3 record alias in region-agnostic stacks.',
                'You must specify a specific region when you define the stack',
                '(see https://docs.aws.amazon.com/cdk/latest/guide/environments.html)',
            ].join(' '));
        }
        const { s3StaticWebsiteHostedZoneId: hostedZoneId, s3StaticWebsiteEndpoint: dnsName } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Bucket website target is not supported for the "${region}" region`);
        }
        return { hostedZoneId, dnsName };
    }
}
exports.BucketWebsiteTarget = BucketWebsiteTarget;
_a = JSII_RTTI_SYMBOL_1;
BucketWebsiteTarget[_a] = { fqn: "monocdk.aws_route53_targets.BucketWebsiteTarget", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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