"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = exports.ApiGatewayDomain = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined through the `RestApiProps.domainName` prop.
 */
class ApiGatewayDomain {
    constructor(domainName) {
        this.domainName = domainName;
        jsiiDeprecationWarnings.monocdk_aws_apigateway_IDomainName(domainName);
    }
    bind(_record, _zone) {
        jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
        jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayDomain[_a] = { fqn: "monocdk.aws_route53_targets.ApiGatewayDomain", version: "1.149.0" };
/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain
 * name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 */
class ApiGateway extends ApiGatewayDomain {
    constructor(api) {
        jsiiDeprecationWarnings.monocdk_aws_apigateway_RestApiBase(api);
        if (!api.domainName) {
            throw new Error('API does not define a default domain name');
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
_b = JSII_RTTI_SYMBOL_1;
ApiGateway[_b] = { fqn: "monocdk.aws_route53_targets.ApiGateway", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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