"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterSubnetGroup = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("../../aws-ec2");
const core_1 = require("../../core");
const redshift_generated_1 = require("./redshift.generated");
/**
 * Class for creating a Redshift cluster subnet group
 *
 * @resource AWS::Redshift::ClusterSubnetGroup
 */
class ClusterSubnetGroup extends core_1.Resource {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_redshift_ClusterSubnetGroupProps(props);
        const { subnetIds } = props.vpc.selectSubnets((_b = props.vpcSubnets) !== null && _b !== void 0 ? _b : { subnetType: ec2.SubnetType.PRIVATE });
        const subnetGroup = new redshift_generated_1.CfnClusterSubnetGroup(this, 'Default', {
            description: props.description,
            subnetIds,
        });
        subnetGroup.applyRemovalPolicy((_c = props.removalPolicy) !== null && _c !== void 0 ? _c : core_1.RemovalPolicy.RETAIN, {
            applyToUpdateReplacePolicy: true,
        });
        this.clusterSubnetGroupName = subnetGroup.ref;
    }
    /**
     * Imports an existing subnet group by name.
     */
    static fromClusterSubnetGroupName(scope, id, clusterSubnetGroupName) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.clusterSubnetGroupName = clusterSubnetGroupName;
            }
        }(scope, id);
    }
}
exports.ClusterSubnetGroup = ClusterSubnetGroup;
_a = JSII_RTTI_SYMBOL_1;
ClusterSubnetGroup[_a] = { fqn: "monocdk.aws_redshift.ClusterSubnetGroup", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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