"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnOptionGroup = exports.CfnGlobalCluster = exports.CfnEventSubscription = exports.CfnDBSubnetGroup = exports.CfnDBSecurityGroupIngress = exports.CfnDBSecurityGroup = exports.CfnDBProxyTargetGroup = exports.CfnDBProxyEndpoint = exports.CfnDBProxy = exports.CfnDBParameterGroup = exports.CfnDBInstance = exports.CfnDBClusterParameterGroup = exports.CfnDBCluster = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:44:00.331Z","fingerprint":"CZuWZjUMZv0eSkgX542gmtff0D9nq2T+nb3EmKM69GY="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnDBClusterProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterProps`
 *
 * @returns the result of the validation.
 */
function CfnDBClusterPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('associatedRoles', cdk.listValidator(CfnDBCluster_DBClusterRolePropertyValidator))(properties.associatedRoles));
    errors.collect(cdk.propertyValidator('availabilityZones', cdk.listValidator(cdk.validateString))(properties.availabilityZones));
    errors.collect(cdk.propertyValidator('backtrackWindow', cdk.validateNumber)(properties.backtrackWindow));
    errors.collect(cdk.propertyValidator('backupRetentionPeriod', cdk.validateNumber)(properties.backupRetentionPeriod));
    errors.collect(cdk.propertyValidator('copyTagsToSnapshot', cdk.validateBoolean)(properties.copyTagsToSnapshot));
    errors.collect(cdk.propertyValidator('dbClusterIdentifier', cdk.validateString)(properties.dbClusterIdentifier));
    errors.collect(cdk.propertyValidator('dbClusterParameterGroupName', cdk.validateString)(properties.dbClusterParameterGroupName));
    errors.collect(cdk.propertyValidator('dbSubnetGroupName', cdk.validateString)(properties.dbSubnetGroupName));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('deletionProtection', cdk.validateBoolean)(properties.deletionProtection));
    errors.collect(cdk.propertyValidator('enableCloudwatchLogsExports', cdk.listValidator(cdk.validateString))(properties.enableCloudwatchLogsExports));
    errors.collect(cdk.propertyValidator('enableHttpEndpoint', cdk.validateBoolean)(properties.enableHttpEndpoint));
    errors.collect(cdk.propertyValidator('enableIamDatabaseAuthentication', cdk.validateBoolean)(properties.enableIamDatabaseAuthentication));
    errors.collect(cdk.propertyValidator('engine', cdk.requiredValidator)(properties.engine));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineMode', cdk.validateString)(properties.engineMode));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('globalClusterIdentifier', cdk.validateString)(properties.globalClusterIdentifier));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('masterUserPassword', cdk.validateString)(properties.masterUserPassword));
    errors.collect(cdk.propertyValidator('masterUsername', cdk.validateString)(properties.masterUsername));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('preferredBackupWindow', cdk.validateString)(properties.preferredBackupWindow));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('replicationSourceIdentifier', cdk.validateString)(properties.replicationSourceIdentifier));
    errors.collect(cdk.propertyValidator('restoreType', cdk.validateString)(properties.restoreType));
    errors.collect(cdk.propertyValidator('scalingConfiguration', CfnDBCluster_ScalingConfigurationPropertyValidator)(properties.scalingConfiguration));
    errors.collect(cdk.propertyValidator('snapshotIdentifier', cdk.validateString)(properties.snapshotIdentifier));
    errors.collect(cdk.propertyValidator('sourceDbClusterIdentifier', cdk.validateString)(properties.sourceDbClusterIdentifier));
    errors.collect(cdk.propertyValidator('sourceRegion', cdk.validateString)(properties.sourceRegion));
    errors.collect(cdk.propertyValidator('storageEncrypted', cdk.validateBoolean)(properties.storageEncrypted));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('useLatestRestorableTime', cdk.validateBoolean)(properties.useLatestRestorableTime));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    return errors.wrap('supplied properties not correct for "CfnDBClusterProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBClusterPropsValidator(properties).assertSuccess();
    return {
        Engine: cdk.stringToCloudFormation(properties.engine),
        AssociatedRoles: cdk.listMapper(cfnDBClusterDBClusterRolePropertyToCloudFormation)(properties.associatedRoles),
        AvailabilityZones: cdk.listMapper(cdk.stringToCloudFormation)(properties.availabilityZones),
        BacktrackWindow: cdk.numberToCloudFormation(properties.backtrackWindow),
        BackupRetentionPeriod: cdk.numberToCloudFormation(properties.backupRetentionPeriod),
        CopyTagsToSnapshot: cdk.booleanToCloudFormation(properties.copyTagsToSnapshot),
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        DBClusterIdentifier: cdk.stringToCloudFormation(properties.dbClusterIdentifier),
        DBClusterParameterGroupName: cdk.stringToCloudFormation(properties.dbClusterParameterGroupName),
        DBSubnetGroupName: cdk.stringToCloudFormation(properties.dbSubnetGroupName),
        DeletionProtection: cdk.booleanToCloudFormation(properties.deletionProtection),
        EnableCloudwatchLogsExports: cdk.listMapper(cdk.stringToCloudFormation)(properties.enableCloudwatchLogsExports),
        EnableHttpEndpoint: cdk.booleanToCloudFormation(properties.enableHttpEndpoint),
        EnableIAMDatabaseAuthentication: cdk.booleanToCloudFormation(properties.enableIamDatabaseAuthentication),
        EngineMode: cdk.stringToCloudFormation(properties.engineMode),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        GlobalClusterIdentifier: cdk.stringToCloudFormation(properties.globalClusterIdentifier),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MasterUsername: cdk.stringToCloudFormation(properties.masterUsername),
        MasterUserPassword: cdk.stringToCloudFormation(properties.masterUserPassword),
        Port: cdk.numberToCloudFormation(properties.port),
        PreferredBackupWindow: cdk.stringToCloudFormation(properties.preferredBackupWindow),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        ReplicationSourceIdentifier: cdk.stringToCloudFormation(properties.replicationSourceIdentifier),
        RestoreType: cdk.stringToCloudFormation(properties.restoreType),
        ScalingConfiguration: cfnDBClusterScalingConfigurationPropertyToCloudFormation(properties.scalingConfiguration),
        SnapshotIdentifier: cdk.stringToCloudFormation(properties.snapshotIdentifier),
        SourceDBClusterIdentifier: cdk.stringToCloudFormation(properties.sourceDbClusterIdentifier),
        SourceRegion: cdk.stringToCloudFormation(properties.sourceRegion),
        StorageEncrypted: cdk.booleanToCloudFormation(properties.storageEncrypted),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        UseLatestRestorableTime: cdk.booleanToCloudFormation(properties.useLatestRestorableTime),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnDBClusterPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('engine', 'Engine', cfn_parse.FromCloudFormation.getString(properties.Engine));
    ret.addPropertyResult('associatedRoles', 'AssociatedRoles', properties.AssociatedRoles != null ? cfn_parse.FromCloudFormation.getArray(CfnDBClusterDBClusterRolePropertyFromCloudFormation)(properties.AssociatedRoles) : undefined);
    ret.addPropertyResult('availabilityZones', 'AvailabilityZones', properties.AvailabilityZones != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AvailabilityZones) : undefined);
    ret.addPropertyResult('backtrackWindow', 'BacktrackWindow', properties.BacktrackWindow != null ? cfn_parse.FromCloudFormation.getNumber(properties.BacktrackWindow) : undefined);
    ret.addPropertyResult('backupRetentionPeriod', 'BackupRetentionPeriod', properties.BackupRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.BackupRetentionPeriod) : undefined);
    ret.addPropertyResult('copyTagsToSnapshot', 'CopyTagsToSnapshot', properties.CopyTagsToSnapshot != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToSnapshot) : undefined);
    ret.addPropertyResult('databaseName', 'DatabaseName', properties.DatabaseName != null ? cfn_parse.FromCloudFormation.getString(properties.DatabaseName) : undefined);
    ret.addPropertyResult('dbClusterIdentifier', 'DBClusterIdentifier', properties.DBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterIdentifier) : undefined);
    ret.addPropertyResult('dbClusterParameterGroupName', 'DBClusterParameterGroupName', properties.DBClusterParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterParameterGroupName) : undefined);
    ret.addPropertyResult('dbSubnetGroupName', 'DBSubnetGroupName', properties.DBSubnetGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupName) : undefined);
    ret.addPropertyResult('deletionProtection', 'DeletionProtection', properties.DeletionProtection != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeletionProtection) : undefined);
    ret.addPropertyResult('enableCloudwatchLogsExports', 'EnableCloudwatchLogsExports', properties.EnableCloudwatchLogsExports != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EnableCloudwatchLogsExports) : undefined);
    ret.addPropertyResult('enableHttpEndpoint', 'EnableHttpEndpoint', properties.EnableHttpEndpoint != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableHttpEndpoint) : undefined);
    ret.addPropertyResult('enableIamDatabaseAuthentication', 'EnableIAMDatabaseAuthentication', properties.EnableIAMDatabaseAuthentication != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableIAMDatabaseAuthentication) : undefined);
    ret.addPropertyResult('engineMode', 'EngineMode', properties.EngineMode != null ? cfn_parse.FromCloudFormation.getString(properties.EngineMode) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('globalClusterIdentifier', 'GlobalClusterIdentifier', properties.GlobalClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.GlobalClusterIdentifier) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('masterUsername', 'MasterUsername', properties.MasterUsername != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUsername) : undefined);
    ret.addPropertyResult('masterUserPassword', 'MasterUserPassword', properties.MasterUserPassword != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUserPassword) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('preferredBackupWindow', 'PreferredBackupWindow', properties.PreferredBackupWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredBackupWindow) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('replicationSourceIdentifier', 'ReplicationSourceIdentifier', properties.ReplicationSourceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationSourceIdentifier) : undefined);
    ret.addPropertyResult('restoreType', 'RestoreType', properties.RestoreType != null ? cfn_parse.FromCloudFormation.getString(properties.RestoreType) : undefined);
    ret.addPropertyResult('scalingConfiguration', 'ScalingConfiguration', properties.ScalingConfiguration != null ? CfnDBClusterScalingConfigurationPropertyFromCloudFormation(properties.ScalingConfiguration) : undefined);
    ret.addPropertyResult('snapshotIdentifier', 'SnapshotIdentifier', properties.SnapshotIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SnapshotIdentifier) : undefined);
    ret.addPropertyResult('sourceDbClusterIdentifier', 'SourceDBClusterIdentifier', properties.SourceDBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBClusterIdentifier) : undefined);
    ret.addPropertyResult('sourceRegion', 'SourceRegion', properties.SourceRegion != null ? cfn_parse.FromCloudFormation.getString(properties.SourceRegion) : undefined);
    ret.addPropertyResult('storageEncrypted', 'StorageEncrypted', properties.StorageEncrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.StorageEncrypted) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('useLatestRestorableTime', 'UseLatestRestorableTime', properties.UseLatestRestorableTime != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseLatestRestorableTime) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBCluster`
 *
 * The `AWS::RDS::DBCluster` resource creates an Amazon Aurora DB cluster. For more information, see [Managing an Amazon Aurora DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Aurora.html) in the *Amazon Aurora User Guide* .
 *
 * > You can only create this resource in AWS Regions where Amazon Aurora is supported.
 *
 * This topic covers the resource for Amazon Aurora DB clusters. For the documentation on the resource for Amazon RDS DB instances, see [AWS::RDS::DBInstance](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html) .
 *
 * *Updating DB clusters*
 *
 * When properties labeled " *Update requires:* [Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement) " are updated, AWS CloudFormation first creates a replacement DB cluster, then changes references from other dependent resources to point to the replacement DB cluster, and finally deletes the old DB cluster.
 *
 * > We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB cluster. To preserve your data, perform the following procedure:
 * >
 * > - Deactivate any applications that are using the DB cluster so that there's no activity on the DB instance.
 * > - Create a snapshot of the DB cluster. For more information about creating DB snapshots, see [Creating a DB Cluster Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CreateSnapshotCluster.html) .
 * > - If you want to restore your DB cluster using a DB cluster snapshot, modify the updated template with your DB cluster changes and add the `SnapshotIdentifier` property with the ID of the DB cluster snapshot that you want to use.
 * >
 * > After you restore a DB cluster with a `SnapshotIdentifier` property, you must specify the same `SnapshotIdentifier` property for any future updates to the DB cluster. When you specify this property for an update, the DB cluster is not restored from the DB cluster snapshot again, and the data in the database is not changed. However, if you don't specify the `SnapshotIdentifier` property, an empty DB cluster is created, and the original DB cluster is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB cluster is restored from the specified `SnapshotIdentifier` property, and the original DB cluster is deleted.
 * > - Update the stack.
 *
 * Currently, when you are updating the stack for an Aurora Serverless DB cluster, you can't include changes to any other properties when you specify one of the following properties: `PreferredBackupWindow` , `PreferredMaintenanceWindow` , and `Port` . This limitation doesn't apply to provisioned DB clusters.
 *
 * For more information about updating other properties of this resource, see `[ModifyDBCluster](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_ModifyDBCluster.html)` . For more information about updating stacks, see [AWS CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html) .
 *
 * *Deleting DB clusters*
 *
 * The default `DeletionPolicy` for `AWS::RDS::DBCluster` resources is `Snapshot` . For more information about how AWS CloudFormation deletes resources, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) .
 *
 * @cloudformationResource AWS::RDS::DBCluster
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html
 */
class CfnDBCluster extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBCluster.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBClusterProps(props);
        cdk.requireProperty(props, 'engine', this);
        this.attrEndpointAddress = cdk.Token.asString(this.getAtt('Endpoint.Address'));
        this.attrEndpointPort = cdk.Token.asString(this.getAtt('Endpoint.Port'));
        this.attrReadEndpointAddress = cdk.Token.asString(this.getAtt('ReadEndpoint.Address'));
        this.engine = props.engine;
        this.associatedRoles = props.associatedRoles;
        this.availabilityZones = props.availabilityZones;
        this.backtrackWindow = props.backtrackWindow;
        this.backupRetentionPeriod = props.backupRetentionPeriod;
        this.copyTagsToSnapshot = props.copyTagsToSnapshot;
        this.databaseName = props.databaseName;
        this.dbClusterIdentifier = props.dbClusterIdentifier;
        this.dbClusterParameterGroupName = props.dbClusterParameterGroupName;
        this.dbSubnetGroupName = props.dbSubnetGroupName;
        this.deletionProtection = props.deletionProtection;
        this.enableCloudwatchLogsExports = props.enableCloudwatchLogsExports;
        this.enableHttpEndpoint = props.enableHttpEndpoint;
        this.enableIamDatabaseAuthentication = props.enableIamDatabaseAuthentication;
        this.engineMode = props.engineMode;
        this.engineVersion = props.engineVersion;
        this.globalClusterIdentifier = props.globalClusterIdentifier;
        this.kmsKeyId = props.kmsKeyId;
        this.masterUsername = props.masterUsername;
        this.masterUserPassword = props.masterUserPassword;
        this.port = props.port;
        this.preferredBackupWindow = props.preferredBackupWindow;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = props.replicationSourceIdentifier;
        this.restoreType = props.restoreType;
        this.scalingConfiguration = props.scalingConfiguration;
        this.snapshotIdentifier = props.snapshotIdentifier;
        this.sourceDbClusterIdentifier = props.sourceDbClusterIdentifier;
        this.sourceRegion = props.sourceRegion;
        this.storageEncrypted = props.storageEncrypted;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBCluster", props.tags, { tagPropertyName: 'tags' });
        this.useLatestRestorableTime = props.useLatestRestorableTime;
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::RDS::DBCluster\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBClusterPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBCluster(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBCluster.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            engine: this.engine,
            associatedRoles: this.associatedRoles,
            availabilityZones: this.availabilityZones,
            backtrackWindow: this.backtrackWindow,
            backupRetentionPeriod: this.backupRetentionPeriod,
            copyTagsToSnapshot: this.copyTagsToSnapshot,
            databaseName: this.databaseName,
            dbClusterIdentifier: this.dbClusterIdentifier,
            dbClusterParameterGroupName: this.dbClusterParameterGroupName,
            dbSubnetGroupName: this.dbSubnetGroupName,
            deletionProtection: this.deletionProtection,
            enableCloudwatchLogsExports: this.enableCloudwatchLogsExports,
            enableHttpEndpoint: this.enableHttpEndpoint,
            enableIamDatabaseAuthentication: this.enableIamDatabaseAuthentication,
            engineMode: this.engineMode,
            engineVersion: this.engineVersion,
            globalClusterIdentifier: this.globalClusterIdentifier,
            kmsKeyId: this.kmsKeyId,
            masterUsername: this.masterUsername,
            masterUserPassword: this.masterUserPassword,
            port: this.port,
            preferredBackupWindow: this.preferredBackupWindow,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            replicationSourceIdentifier: this.replicationSourceIdentifier,
            restoreType: this.restoreType,
            scalingConfiguration: this.scalingConfiguration,
            snapshotIdentifier: this.snapshotIdentifier,
            sourceDbClusterIdentifier: this.sourceDbClusterIdentifier,
            sourceRegion: this.sourceRegion,
            storageEncrypted: this.storageEncrypted,
            tags: this.tags.renderTags(),
            useLatestRestorableTime: this.useLatestRestorableTime,
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnDBClusterPropsToCloudFormation(props);
    }
}
exports.CfnDBCluster = CfnDBCluster;
_a = JSII_RTTI_SYMBOL_1;
CfnDBCluster[_a] = { fqn: "monocdk.aws_rds.CfnDBCluster", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBCluster.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBCluster";
/**
 * Determine whether the given properties match those of a `DBClusterRoleProperty`
 *
 * @param properties - the TypeScript properties of a `DBClusterRoleProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_DBClusterRolePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('featureName', cdk.validateString)(properties.featureName));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "DBClusterRoleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.DBClusterRole` resource
 *
 * @param properties - the TypeScript properties of a `DBClusterRoleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.DBClusterRole` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterDBClusterRolePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_DBClusterRolePropertyValidator(properties).assertSuccess();
    return {
        FeatureName: cdk.stringToCloudFormation(properties.featureName),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDBClusterDBClusterRolePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('featureName', 'FeatureName', properties.FeatureName != null ? cfn_parse.FromCloudFormation.getString(properties.FeatureName) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ScalingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ScalingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBCluster_ScalingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoPause', cdk.validateBoolean)(properties.autoPause));
    errors.collect(cdk.propertyValidator('maxCapacity', cdk.validateNumber)(properties.maxCapacity));
    errors.collect(cdk.propertyValidator('minCapacity', cdk.validateNumber)(properties.minCapacity));
    errors.collect(cdk.propertyValidator('secondsUntilAutoPause', cdk.validateNumber)(properties.secondsUntilAutoPause));
    return errors.wrap('supplied properties not correct for "ScalingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ScalingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ScalingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBCluster.ScalingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterScalingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBCluster_ScalingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AutoPause: cdk.booleanToCloudFormation(properties.autoPause),
        MaxCapacity: cdk.numberToCloudFormation(properties.maxCapacity),
        MinCapacity: cdk.numberToCloudFormation(properties.minCapacity),
        SecondsUntilAutoPause: cdk.numberToCloudFormation(properties.secondsUntilAutoPause),
    };
}
// @ts-ignore TS6133
function CfnDBClusterScalingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoPause', 'AutoPause', properties.AutoPause != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AutoPause) : undefined);
    ret.addPropertyResult('maxCapacity', 'MaxCapacity', properties.MaxCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxCapacity) : undefined);
    ret.addPropertyResult('minCapacity', 'MinCapacity', properties.MinCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinCapacity) : undefined);
    ret.addPropertyResult('secondsUntilAutoPause', 'SecondsUntilAutoPause', properties.SecondsUntilAutoPause != null ? cfn_parse.FromCloudFormation.getNumber(properties.SecondsUntilAutoPause) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBClusterParameterGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterParameterGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBClusterParameterGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.requiredValidator)(properties.description));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('family', cdk.requiredValidator)(properties.family));
    errors.collect(cdk.propertyValidator('family', cdk.validateString)(properties.family));
    errors.collect(cdk.propertyValidator('parameters', cdk.requiredValidator)(properties.parameters));
    errors.collect(cdk.propertyValidator('parameters', cdk.validateObject)(properties.parameters));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBClusterParameterGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBClusterParameterGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBClusterParameterGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBClusterParameterGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBClusterParameterGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBClusterParameterGroupPropsValidator(properties).assertSuccess();
    return {
        Description: cdk.stringToCloudFormation(properties.description),
        Family: cdk.stringToCloudFormation(properties.family),
        Parameters: cdk.objectToCloudFormation(properties.parameters),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBClusterParameterGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('description', 'Description', cfn_parse.FromCloudFormation.getString(properties.Description));
    ret.addPropertyResult('family', 'Family', cfn_parse.FromCloudFormation.getString(properties.Family));
    ret.addPropertyResult('parameters', 'Parameters', cfn_parse.FromCloudFormation.getAny(properties.Parameters));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBClusterParameterGroup`
 *
 * The `AWS::RDS::DBClusterParameterGroup` resource creates a new Amazon RDS DB cluster parameter group.
 *
 * For information about configuring parameters for Amazon Aurora DB instances, see [Working with DB parameter groups and DB cluster parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide* .
 *
 * > If you apply a parameter group to a DB cluster, then its DB instances might need to reboot. This can result in an outage while the DB instances are rebooting.
 * >
 * > If you apply a change to parameter group associated with a stopped DB cluster, then the update stack waits until the DB cluster is started.
 *
 * @cloudformationResource AWS::RDS::DBClusterParameterGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbclusterparametergroup.html
 */
class CfnDBClusterParameterGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBClusterParameterGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBClusterParameterGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBClusterParameterGroupProps(props);
        cdk.requireProperty(props, 'description', this);
        cdk.requireProperty(props, 'family', this);
        cdk.requireProperty(props, 'parameters', this);
        this.description = props.description;
        this.family = props.family;
        this.parameters = props.parameters;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBClusterParameterGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBClusterParameterGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBClusterParameterGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBClusterParameterGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            description: this.description,
            family: this.family,
            parameters: this.parameters,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBClusterParameterGroupPropsToCloudFormation(props);
    }
}
exports.CfnDBClusterParameterGroup = CfnDBClusterParameterGroup;
_b = JSII_RTTI_SYMBOL_1;
CfnDBClusterParameterGroup[_b] = { fqn: "monocdk.aws_rds.CfnDBClusterParameterGroup", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBClusterParameterGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBClusterParameterGroup";
/**
 * Determine whether the given properties match those of a `CfnDBInstanceProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBInstanceProps`
 *
 * @returns the result of the validation.
 */
function CfnDBInstancePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allocatedStorage', cdk.validateString)(properties.allocatedStorage));
    errors.collect(cdk.propertyValidator('allowMajorVersionUpgrade', cdk.validateBoolean)(properties.allowMajorVersionUpgrade));
    errors.collect(cdk.propertyValidator('associatedRoles', cdk.listValidator(CfnDBInstance_DBInstanceRolePropertyValidator))(properties.associatedRoles));
    errors.collect(cdk.propertyValidator('autoMinorVersionUpgrade', cdk.validateBoolean)(properties.autoMinorVersionUpgrade));
    errors.collect(cdk.propertyValidator('availabilityZone', cdk.validateString)(properties.availabilityZone));
    errors.collect(cdk.propertyValidator('backupRetentionPeriod', cdk.validateNumber)(properties.backupRetentionPeriod));
    errors.collect(cdk.propertyValidator('caCertificateIdentifier', cdk.validateString)(properties.caCertificateIdentifier));
    errors.collect(cdk.propertyValidator('characterSetName', cdk.validateString)(properties.characterSetName));
    errors.collect(cdk.propertyValidator('copyTagsToSnapshot', cdk.validateBoolean)(properties.copyTagsToSnapshot));
    errors.collect(cdk.propertyValidator('dbClusterIdentifier', cdk.validateString)(properties.dbClusterIdentifier));
    errors.collect(cdk.propertyValidator('dbInstanceClass', cdk.requiredValidator)(properties.dbInstanceClass));
    errors.collect(cdk.propertyValidator('dbInstanceClass', cdk.validateString)(properties.dbInstanceClass));
    errors.collect(cdk.propertyValidator('dbInstanceIdentifier', cdk.validateString)(properties.dbInstanceIdentifier));
    errors.collect(cdk.propertyValidator('dbName', cdk.validateString)(properties.dbName));
    errors.collect(cdk.propertyValidator('dbParameterGroupName', cdk.validateString)(properties.dbParameterGroupName));
    errors.collect(cdk.propertyValidator('dbSecurityGroups', cdk.listValidator(cdk.validateString))(properties.dbSecurityGroups));
    errors.collect(cdk.propertyValidator('dbSnapshotIdentifier', cdk.validateString)(properties.dbSnapshotIdentifier));
    errors.collect(cdk.propertyValidator('dbSubnetGroupName', cdk.validateString)(properties.dbSubnetGroupName));
    errors.collect(cdk.propertyValidator('deleteAutomatedBackups', cdk.validateBoolean)(properties.deleteAutomatedBackups));
    errors.collect(cdk.propertyValidator('deletionProtection', cdk.validateBoolean)(properties.deletionProtection));
    errors.collect(cdk.propertyValidator('domain', cdk.validateString)(properties.domain));
    errors.collect(cdk.propertyValidator('domainIamRoleName', cdk.validateString)(properties.domainIamRoleName));
    errors.collect(cdk.propertyValidator('enableCloudwatchLogsExports', cdk.listValidator(cdk.validateString))(properties.enableCloudwatchLogsExports));
    errors.collect(cdk.propertyValidator('enableIamDatabaseAuthentication', cdk.validateBoolean)(properties.enableIamDatabaseAuthentication));
    errors.collect(cdk.propertyValidator('enablePerformanceInsights', cdk.validateBoolean)(properties.enablePerformanceInsights));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('iops', cdk.validateNumber)(properties.iops));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('licenseModel', cdk.validateString)(properties.licenseModel));
    errors.collect(cdk.propertyValidator('masterUserPassword', cdk.validateString)(properties.masterUserPassword));
    errors.collect(cdk.propertyValidator('masterUsername', cdk.validateString)(properties.masterUsername));
    errors.collect(cdk.propertyValidator('maxAllocatedStorage', cdk.validateNumber)(properties.maxAllocatedStorage));
    errors.collect(cdk.propertyValidator('monitoringInterval', cdk.validateNumber)(properties.monitoringInterval));
    errors.collect(cdk.propertyValidator('monitoringRoleArn', cdk.validateString)(properties.monitoringRoleArn));
    errors.collect(cdk.propertyValidator('multiAz', cdk.validateBoolean)(properties.multiAz));
    errors.collect(cdk.propertyValidator('optionGroupName', cdk.validateString)(properties.optionGroupName));
    errors.collect(cdk.propertyValidator('performanceInsightsKmsKeyId', cdk.validateString)(properties.performanceInsightsKmsKeyId));
    errors.collect(cdk.propertyValidator('performanceInsightsRetentionPeriod', cdk.validateNumber)(properties.performanceInsightsRetentionPeriod));
    errors.collect(cdk.propertyValidator('port', cdk.validateString)(properties.port));
    errors.collect(cdk.propertyValidator('preferredBackupWindow', cdk.validateString)(properties.preferredBackupWindow));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('processorFeatures', cdk.listValidator(CfnDBInstance_ProcessorFeaturePropertyValidator))(properties.processorFeatures));
    errors.collect(cdk.propertyValidator('promotionTier', cdk.validateNumber)(properties.promotionTier));
    errors.collect(cdk.propertyValidator('publiclyAccessible', cdk.validateBoolean)(properties.publiclyAccessible));
    errors.collect(cdk.propertyValidator('sourceDbInstanceIdentifier', cdk.validateString)(properties.sourceDbInstanceIdentifier));
    errors.collect(cdk.propertyValidator('sourceRegion', cdk.validateString)(properties.sourceRegion));
    errors.collect(cdk.propertyValidator('storageEncrypted', cdk.validateBoolean)(properties.storageEncrypted));
    errors.collect(cdk.propertyValidator('storageType', cdk.validateString)(properties.storageType));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('timezone', cdk.validateString)(properties.timezone));
    errors.collect(cdk.propertyValidator('useDefaultProcessorFeatures', cdk.validateBoolean)(properties.useDefaultProcessorFeatures));
    errors.collect(cdk.propertyValidator('vpcSecurityGroups', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroups));
    return errors.wrap('supplied properties not correct for "CfnDBInstanceProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBInstanceProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance` resource.
 */
// @ts-ignore TS6133
function cfnDBInstancePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstancePropsValidator(properties).assertSuccess();
    return {
        DBInstanceClass: cdk.stringToCloudFormation(properties.dbInstanceClass),
        AllocatedStorage: cdk.stringToCloudFormation(properties.allocatedStorage),
        AllowMajorVersionUpgrade: cdk.booleanToCloudFormation(properties.allowMajorVersionUpgrade),
        AssociatedRoles: cdk.listMapper(cfnDBInstanceDBInstanceRolePropertyToCloudFormation)(properties.associatedRoles),
        AutoMinorVersionUpgrade: cdk.booleanToCloudFormation(properties.autoMinorVersionUpgrade),
        AvailabilityZone: cdk.stringToCloudFormation(properties.availabilityZone),
        BackupRetentionPeriod: cdk.numberToCloudFormation(properties.backupRetentionPeriod),
        CACertificateIdentifier: cdk.stringToCloudFormation(properties.caCertificateIdentifier),
        CharacterSetName: cdk.stringToCloudFormation(properties.characterSetName),
        CopyTagsToSnapshot: cdk.booleanToCloudFormation(properties.copyTagsToSnapshot),
        DBClusterIdentifier: cdk.stringToCloudFormation(properties.dbClusterIdentifier),
        DBInstanceIdentifier: cdk.stringToCloudFormation(properties.dbInstanceIdentifier),
        DBName: cdk.stringToCloudFormation(properties.dbName),
        DBParameterGroupName: cdk.stringToCloudFormation(properties.dbParameterGroupName),
        DBSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbSecurityGroups),
        DBSnapshotIdentifier: cdk.stringToCloudFormation(properties.dbSnapshotIdentifier),
        DBSubnetGroupName: cdk.stringToCloudFormation(properties.dbSubnetGroupName),
        DeleteAutomatedBackups: cdk.booleanToCloudFormation(properties.deleteAutomatedBackups),
        DeletionProtection: cdk.booleanToCloudFormation(properties.deletionProtection),
        Domain: cdk.stringToCloudFormation(properties.domain),
        DomainIAMRoleName: cdk.stringToCloudFormation(properties.domainIamRoleName),
        EnableCloudwatchLogsExports: cdk.listMapper(cdk.stringToCloudFormation)(properties.enableCloudwatchLogsExports),
        EnableIAMDatabaseAuthentication: cdk.booleanToCloudFormation(properties.enableIamDatabaseAuthentication),
        EnablePerformanceInsights: cdk.booleanToCloudFormation(properties.enablePerformanceInsights),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        Iops: cdk.numberToCloudFormation(properties.iops),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        LicenseModel: cdk.stringToCloudFormation(properties.licenseModel),
        MasterUsername: cdk.stringToCloudFormation(properties.masterUsername),
        MasterUserPassword: cdk.stringToCloudFormation(properties.masterUserPassword),
        MaxAllocatedStorage: cdk.numberToCloudFormation(properties.maxAllocatedStorage),
        MonitoringInterval: cdk.numberToCloudFormation(properties.monitoringInterval),
        MonitoringRoleArn: cdk.stringToCloudFormation(properties.monitoringRoleArn),
        MultiAZ: cdk.booleanToCloudFormation(properties.multiAz),
        OptionGroupName: cdk.stringToCloudFormation(properties.optionGroupName),
        PerformanceInsightsKMSKeyId: cdk.stringToCloudFormation(properties.performanceInsightsKmsKeyId),
        PerformanceInsightsRetentionPeriod: cdk.numberToCloudFormation(properties.performanceInsightsRetentionPeriod),
        Port: cdk.stringToCloudFormation(properties.port),
        PreferredBackupWindow: cdk.stringToCloudFormation(properties.preferredBackupWindow),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        ProcessorFeatures: cdk.listMapper(cfnDBInstanceProcessorFeaturePropertyToCloudFormation)(properties.processorFeatures),
        PromotionTier: cdk.numberToCloudFormation(properties.promotionTier),
        PubliclyAccessible: cdk.booleanToCloudFormation(properties.publiclyAccessible),
        SourceDBInstanceIdentifier: cdk.stringToCloudFormation(properties.sourceDbInstanceIdentifier),
        SourceRegion: cdk.stringToCloudFormation(properties.sourceRegion),
        StorageEncrypted: cdk.booleanToCloudFormation(properties.storageEncrypted),
        StorageType: cdk.stringToCloudFormation(properties.storageType),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        Timezone: cdk.stringToCloudFormation(properties.timezone),
        UseDefaultProcessorFeatures: cdk.booleanToCloudFormation(properties.useDefaultProcessorFeatures),
        VPCSecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroups),
    };
}
// @ts-ignore TS6133
function CfnDBInstancePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbInstanceClass', 'DBInstanceClass', cfn_parse.FromCloudFormation.getString(properties.DBInstanceClass));
    ret.addPropertyResult('allocatedStorage', 'AllocatedStorage', properties.AllocatedStorage != null ? cfn_parse.FromCloudFormation.getString(properties.AllocatedStorage) : undefined);
    ret.addPropertyResult('allowMajorVersionUpgrade', 'AllowMajorVersionUpgrade', properties.AllowMajorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowMajorVersionUpgrade) : undefined);
    ret.addPropertyResult('associatedRoles', 'AssociatedRoles', properties.AssociatedRoles != null ? cfn_parse.FromCloudFormation.getArray(CfnDBInstanceDBInstanceRolePropertyFromCloudFormation)(properties.AssociatedRoles) : undefined);
    ret.addPropertyResult('autoMinorVersionUpgrade', 'AutoMinorVersionUpgrade', properties.AutoMinorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AutoMinorVersionUpgrade) : undefined);
    ret.addPropertyResult('availabilityZone', 'AvailabilityZone', properties.AvailabilityZone != null ? cfn_parse.FromCloudFormation.getString(properties.AvailabilityZone) : undefined);
    ret.addPropertyResult('backupRetentionPeriod', 'BackupRetentionPeriod', properties.BackupRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.BackupRetentionPeriod) : undefined);
    ret.addPropertyResult('caCertificateIdentifier', 'CACertificateIdentifier', properties.CACertificateIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.CACertificateIdentifier) : undefined);
    ret.addPropertyResult('characterSetName', 'CharacterSetName', properties.CharacterSetName != null ? cfn_parse.FromCloudFormation.getString(properties.CharacterSetName) : undefined);
    ret.addPropertyResult('copyTagsToSnapshot', 'CopyTagsToSnapshot', properties.CopyTagsToSnapshot != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToSnapshot) : undefined);
    ret.addPropertyResult('dbClusterIdentifier', 'DBClusterIdentifier', properties.DBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBClusterIdentifier) : undefined);
    ret.addPropertyResult('dbInstanceIdentifier', 'DBInstanceIdentifier', properties.DBInstanceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBInstanceIdentifier) : undefined);
    ret.addPropertyResult('dbName', 'DBName', properties.DBName != null ? cfn_parse.FromCloudFormation.getString(properties.DBName) : undefined);
    ret.addPropertyResult('dbParameterGroupName', 'DBParameterGroupName', properties.DBParameterGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBParameterGroupName) : undefined);
    ret.addPropertyResult('dbSecurityGroups', 'DBSecurityGroups', properties.DBSecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBSecurityGroups) : undefined);
    ret.addPropertyResult('dbSnapshotIdentifier', 'DBSnapshotIdentifier', properties.DBSnapshotIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.DBSnapshotIdentifier) : undefined);
    ret.addPropertyResult('dbSubnetGroupName', 'DBSubnetGroupName', properties.DBSubnetGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupName) : undefined);
    ret.addPropertyResult('deleteAutomatedBackups', 'DeleteAutomatedBackups', properties.DeleteAutomatedBackups != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteAutomatedBackups) : undefined);
    ret.addPropertyResult('deletionProtection', 'DeletionProtection', properties.DeletionProtection != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeletionProtection) : undefined);
    ret.addPropertyResult('domain', 'Domain', properties.Domain != null ? cfn_parse.FromCloudFormation.getString(properties.Domain) : undefined);
    ret.addPropertyResult('domainIamRoleName', 'DomainIAMRoleName', properties.DomainIAMRoleName != null ? cfn_parse.FromCloudFormation.getString(properties.DomainIAMRoleName) : undefined);
    ret.addPropertyResult('enableCloudwatchLogsExports', 'EnableCloudwatchLogsExports', properties.EnableCloudwatchLogsExports != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EnableCloudwatchLogsExports) : undefined);
    ret.addPropertyResult('enableIamDatabaseAuthentication', 'EnableIAMDatabaseAuthentication', properties.EnableIAMDatabaseAuthentication != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableIAMDatabaseAuthentication) : undefined);
    ret.addPropertyResult('enablePerformanceInsights', 'EnablePerformanceInsights', properties.EnablePerformanceInsights != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnablePerformanceInsights) : undefined);
    ret.addPropertyResult('engine', 'Engine', properties.Engine != null ? cfn_parse.FromCloudFormation.getString(properties.Engine) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('iops', 'Iops', properties.Iops != null ? cfn_parse.FromCloudFormation.getNumber(properties.Iops) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('licenseModel', 'LicenseModel', properties.LicenseModel != null ? cfn_parse.FromCloudFormation.getString(properties.LicenseModel) : undefined);
    ret.addPropertyResult('masterUsername', 'MasterUsername', properties.MasterUsername != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUsername) : undefined);
    ret.addPropertyResult('masterUserPassword', 'MasterUserPassword', properties.MasterUserPassword != null ? cfn_parse.FromCloudFormation.getString(properties.MasterUserPassword) : undefined);
    ret.addPropertyResult('maxAllocatedStorage', 'MaxAllocatedStorage', properties.MaxAllocatedStorage != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxAllocatedStorage) : undefined);
    ret.addPropertyResult('monitoringInterval', 'MonitoringInterval', properties.MonitoringInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.MonitoringInterval) : undefined);
    ret.addPropertyResult('monitoringRoleArn', 'MonitoringRoleArn', properties.MonitoringRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.MonitoringRoleArn) : undefined);
    ret.addPropertyResult('multiAz', 'MultiAZ', properties.MultiAZ != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiAZ) : undefined);
    ret.addPropertyResult('optionGroupName', 'OptionGroupName', properties.OptionGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.OptionGroupName) : undefined);
    ret.addPropertyResult('performanceInsightsKmsKeyId', 'PerformanceInsightsKMSKeyId', properties.PerformanceInsightsKMSKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.PerformanceInsightsKMSKeyId) : undefined);
    ret.addPropertyResult('performanceInsightsRetentionPeriod', 'PerformanceInsightsRetentionPeriod', properties.PerformanceInsightsRetentionPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.PerformanceInsightsRetentionPeriod) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getString(properties.Port) : undefined);
    ret.addPropertyResult('preferredBackupWindow', 'PreferredBackupWindow', properties.PreferredBackupWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredBackupWindow) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('processorFeatures', 'ProcessorFeatures', properties.ProcessorFeatures != null ? cfn_parse.FromCloudFormation.getArray(CfnDBInstanceProcessorFeaturePropertyFromCloudFormation)(properties.ProcessorFeatures) : undefined);
    ret.addPropertyResult('promotionTier', 'PromotionTier', properties.PromotionTier != null ? cfn_parse.FromCloudFormation.getNumber(properties.PromotionTier) : undefined);
    ret.addPropertyResult('publiclyAccessible', 'PubliclyAccessible', properties.PubliclyAccessible != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PubliclyAccessible) : undefined);
    ret.addPropertyResult('sourceDbInstanceIdentifier', 'SourceDBInstanceIdentifier', properties.SourceDBInstanceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBInstanceIdentifier) : undefined);
    ret.addPropertyResult('sourceRegion', 'SourceRegion', properties.SourceRegion != null ? cfn_parse.FromCloudFormation.getString(properties.SourceRegion) : undefined);
    ret.addPropertyResult('storageEncrypted', 'StorageEncrypted', properties.StorageEncrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.StorageEncrypted) : undefined);
    ret.addPropertyResult('storageType', 'StorageType', properties.StorageType != null ? cfn_parse.FromCloudFormation.getString(properties.StorageType) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('timezone', 'Timezone', properties.Timezone != null ? cfn_parse.FromCloudFormation.getString(properties.Timezone) : undefined);
    ret.addPropertyResult('useDefaultProcessorFeatures', 'UseDefaultProcessorFeatures', properties.UseDefaultProcessorFeatures != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseDefaultProcessorFeatures) : undefined);
    ret.addPropertyResult('vpcSecurityGroups', 'VPCSecurityGroups', properties.VPCSecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VPCSecurityGroups) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBInstance`
 *
 * The `AWS::RDS::DBInstance` resource creates an Amazon RDS DB instance.
 *
 * If you import an existing DB instance, and the template configuration doesn't match the actual configuration of the DB instance, AWS CloudFormation applies the changes in the template during the import operation.
 *
 * > If a DB instance is deleted or replaced during an update, AWS CloudFormation deletes all automated snapshots. However, it retains manual DB snapshots. During an update that requires replacement, you can apply a stack policy to prevent DB instances from being replaced. For more information, see [Prevent Updates to Stack Resources](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html) .
 *
 * This topic covers the resource for Amazon RDS DB instances. For the documentation on the resource for Amazon Aurora DB clusters, see [AWS::RDS::DBCluster](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbcluster.html) .
 *
 * *Updating DB instances*
 *
 * When properties labeled " *Update requires:* [Replacement](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement) " are updated, AWS CloudFormation first creates a replacement DB instance, then changes references from other dependent resources to point to the replacement DB instance, and finally deletes the old DB instance.
 *
 * > We highly recommend that you take a snapshot of the database before updating the stack. If you don't, you lose the data when AWS CloudFormation replaces your DB instance. To preserve your data, perform the following procedure:
 * >
 * > - Deactivate any applications that are using the DB instance so that there's no activity on the DB instance.
 * > - Create a snapshot of the DB instance. For more information about creating DB snapshots, see [Creating a DB Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateSnapshot.html) .
 * > - If you want to restore your instance using a DB snapshot, modify the updated template with your DB instance changes and add the `DBSnapshotIdentifier` property with the ID of the DB snapshot that you want to use.
 * >
 * > After you restore a DB instance with a `DBSnapshotIdentifier` property, you must specify the same `DBSnapshotIdentifier` property for any future updates to the DB instance. When you specify this property for an update, the DB instance is not restored from the DB snapshot again, and the data in the database is not changed. However, if you don't specify the `DBSnapshotIdentifier` property, an empty DB instance is created, and the original DB instance is deleted. If you specify a property that is different from the previous snapshot restore property, a new DB instance is restored from the specified `DBSnapshotIdentifier` property, and the original DB instance is deleted.
 * > - Update the stack.
 *
 * For more information about updating other properties of this resource, see `[ModifyDBInstance](https://docs.aws.amazon.com//AmazonRDS/latest/APIReference/API_ModifyDBInstance.html)` . For more information about updating stacks, see [AWS CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html) .
 *
 * *Deleting DB instances*
 *
 * For DB instances that are part of an Aurora DB cluster, you can set a deletion policy for your DB instance to control how AWS CloudFormation handles the DB instance when the stack is deleted. For Amazon RDS DB instances, you can choose to *retain* the DB instance, to *delete* the DB instance, or to *create a snapshot* of the DB instance. The default AWS CloudFormation behavior depends on the `DBClusterIdentifier` property:
 *
 * - For `AWS::RDS::DBInstance` resources that don't specify the `DBClusterIdentifier` property, AWS CloudFormation saves a snapshot of the DB instance.
 * - For `AWS::RDS::DBInstance` resources that do specify the `DBClusterIdentifier` property, AWS CloudFormation deletes the DB instance.
 *
 * For more information, see [DeletionPolicy Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html) .
 *
 * @cloudformationResource AWS::RDS::DBInstance
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html
 */
class CfnDBInstance extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBInstance.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBInstanceProps(props);
        cdk.requireProperty(props, 'dbInstanceClass', this);
        this.attrEndpointAddress = cdk.Token.asString(this.getAtt('Endpoint.Address'));
        this.attrEndpointPort = cdk.Token.asString(this.getAtt('Endpoint.Port'));
        this.dbInstanceClass = props.dbInstanceClass;
        this.allocatedStorage = props.allocatedStorage;
        this.allowMajorVersionUpgrade = props.allowMajorVersionUpgrade;
        this.associatedRoles = props.associatedRoles;
        this.autoMinorVersionUpgrade = props.autoMinorVersionUpgrade;
        this.availabilityZone = props.availabilityZone;
        this.backupRetentionPeriod = props.backupRetentionPeriod;
        this.caCertificateIdentifier = props.caCertificateIdentifier;
        this.characterSetName = props.characterSetName;
        this.copyTagsToSnapshot = props.copyTagsToSnapshot;
        this.dbClusterIdentifier = props.dbClusterIdentifier;
        this.dbInstanceIdentifier = props.dbInstanceIdentifier;
        this.dbName = props.dbName;
        this.dbParameterGroupName = props.dbParameterGroupName;
        this.dbSecurityGroups = props.dbSecurityGroups;
        this.dbSnapshotIdentifier = props.dbSnapshotIdentifier;
        this.dbSubnetGroupName = props.dbSubnetGroupName;
        this.deleteAutomatedBackups = props.deleteAutomatedBackups;
        this.deletionProtection = props.deletionProtection;
        this.domain = props.domain;
        this.domainIamRoleName = props.domainIamRoleName;
        this.enableCloudwatchLogsExports = props.enableCloudwatchLogsExports;
        this.enableIamDatabaseAuthentication = props.enableIamDatabaseAuthentication;
        this.enablePerformanceInsights = props.enablePerformanceInsights;
        this.engine = props.engine;
        this.engineVersion = props.engineVersion;
        this.iops = props.iops;
        this.kmsKeyId = props.kmsKeyId;
        this.licenseModel = props.licenseModel;
        this.masterUsername = props.masterUsername;
        this.masterUserPassword = props.masterUserPassword;
        this.maxAllocatedStorage = props.maxAllocatedStorage;
        this.monitoringInterval = props.monitoringInterval;
        this.monitoringRoleArn = props.monitoringRoleArn;
        this.multiAz = props.multiAz;
        this.optionGroupName = props.optionGroupName;
        this.performanceInsightsKmsKeyId = props.performanceInsightsKmsKeyId;
        this.performanceInsightsRetentionPeriod = props.performanceInsightsRetentionPeriod;
        this.port = props.port;
        this.preferredBackupWindow = props.preferredBackupWindow;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.processorFeatures = props.processorFeatures;
        this.promotionTier = props.promotionTier;
        this.publiclyAccessible = props.publiclyAccessible;
        this.sourceDbInstanceIdentifier = props.sourceDbInstanceIdentifier;
        this.sourceRegion = props.sourceRegion;
        this.storageEncrypted = props.storageEncrypted;
        this.storageType = props.storageType;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBInstance", props.tags, { tagPropertyName: 'tags' });
        this.timezone = props.timezone;
        this.useDefaultProcessorFeatures = props.useDefaultProcessorFeatures;
        this.vpcSecurityGroups = props.vpcSecurityGroups;
        if (this.node.scope && cdk.Resource.isResource(this.node.scope)) {
            this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === undefined
                    ? ['\'AWS::RDS::DBInstance\' is a stateful resource type, and you must specify a Removal Policy for it. Call \'resource.applyRemovalPolicy()\'.']
                    : [] });
        }
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBInstancePropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBInstance(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBInstance.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbInstanceClass: this.dbInstanceClass,
            allocatedStorage: this.allocatedStorage,
            allowMajorVersionUpgrade: this.allowMajorVersionUpgrade,
            associatedRoles: this.associatedRoles,
            autoMinorVersionUpgrade: this.autoMinorVersionUpgrade,
            availabilityZone: this.availabilityZone,
            backupRetentionPeriod: this.backupRetentionPeriod,
            caCertificateIdentifier: this.caCertificateIdentifier,
            characterSetName: this.characterSetName,
            copyTagsToSnapshot: this.copyTagsToSnapshot,
            dbClusterIdentifier: this.dbClusterIdentifier,
            dbInstanceIdentifier: this.dbInstanceIdentifier,
            dbName: this.dbName,
            dbParameterGroupName: this.dbParameterGroupName,
            dbSecurityGroups: this.dbSecurityGroups,
            dbSnapshotIdentifier: this.dbSnapshotIdentifier,
            dbSubnetGroupName: this.dbSubnetGroupName,
            deleteAutomatedBackups: this.deleteAutomatedBackups,
            deletionProtection: this.deletionProtection,
            domain: this.domain,
            domainIamRoleName: this.domainIamRoleName,
            enableCloudwatchLogsExports: this.enableCloudwatchLogsExports,
            enableIamDatabaseAuthentication: this.enableIamDatabaseAuthentication,
            enablePerformanceInsights: this.enablePerformanceInsights,
            engine: this.engine,
            engineVersion: this.engineVersion,
            iops: this.iops,
            kmsKeyId: this.kmsKeyId,
            licenseModel: this.licenseModel,
            masterUsername: this.masterUsername,
            masterUserPassword: this.masterUserPassword,
            maxAllocatedStorage: this.maxAllocatedStorage,
            monitoringInterval: this.monitoringInterval,
            monitoringRoleArn: this.monitoringRoleArn,
            multiAz: this.multiAz,
            optionGroupName: this.optionGroupName,
            performanceInsightsKmsKeyId: this.performanceInsightsKmsKeyId,
            performanceInsightsRetentionPeriod: this.performanceInsightsRetentionPeriod,
            port: this.port,
            preferredBackupWindow: this.preferredBackupWindow,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            processorFeatures: this.processorFeatures,
            promotionTier: this.promotionTier,
            publiclyAccessible: this.publiclyAccessible,
            sourceDbInstanceIdentifier: this.sourceDbInstanceIdentifier,
            sourceRegion: this.sourceRegion,
            storageEncrypted: this.storageEncrypted,
            storageType: this.storageType,
            tags: this.tags.renderTags(),
            timezone: this.timezone,
            useDefaultProcessorFeatures: this.useDefaultProcessorFeatures,
            vpcSecurityGroups: this.vpcSecurityGroups,
        };
    }
    renderProperties(props) {
        return cfnDBInstancePropsToCloudFormation(props);
    }
}
exports.CfnDBInstance = CfnDBInstance;
_c = JSII_RTTI_SYMBOL_1;
CfnDBInstance[_c] = { fqn: "monocdk.aws_rds.CfnDBInstance", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBInstance.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBInstance";
/**
 * Determine whether the given properties match those of a `DBInstanceRoleProperty`
 *
 * @param properties - the TypeScript properties of a `DBInstanceRoleProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_DBInstanceRolePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('featureName', cdk.requiredValidator)(properties.featureName));
    errors.collect(cdk.propertyValidator('featureName', cdk.validateString)(properties.featureName));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "DBInstanceRoleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.DBInstanceRole` resource
 *
 * @param properties - the TypeScript properties of a `DBInstanceRoleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.DBInstanceRole` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceDBInstanceRolePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_DBInstanceRolePropertyValidator(properties).assertSuccess();
    return {
        FeatureName: cdk.stringToCloudFormation(properties.featureName),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceDBInstanceRolePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('featureName', 'FeatureName', cfn_parse.FromCloudFormation.getString(properties.FeatureName));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProcessorFeatureProperty`
 *
 * @param properties - the TypeScript properties of a `ProcessorFeatureProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBInstance_ProcessorFeaturePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ProcessorFeatureProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBInstance.ProcessorFeature` resource
 *
 * @param properties - the TypeScript properties of a `ProcessorFeatureProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBInstance.ProcessorFeature` resource.
 */
// @ts-ignore TS6133
function cfnDBInstanceProcessorFeaturePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBInstance_ProcessorFeaturePropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnDBInstanceProcessorFeaturePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBParameterGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBParameterGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBParameterGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.requiredValidator)(properties.description));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('family', cdk.requiredValidator)(properties.family));
    errors.collect(cdk.propertyValidator('family', cdk.validateString)(properties.family));
    errors.collect(cdk.propertyValidator('parameters', cdk.hashValidator(cdk.validateString))(properties.parameters));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBParameterGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBParameterGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBParameterGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBParameterGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBParameterGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBParameterGroupPropsValidator(properties).assertSuccess();
    return {
        Description: cdk.stringToCloudFormation(properties.description),
        Family: cdk.stringToCloudFormation(properties.family),
        Parameters: cdk.hashMapper(cdk.stringToCloudFormation)(properties.parameters),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBParameterGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('description', 'Description', cfn_parse.FromCloudFormation.getString(properties.Description));
    ret.addPropertyResult('family', 'Family', cfn_parse.FromCloudFormation.getString(properties.Family));
    ret.addPropertyResult('parameters', 'Parameters', properties.Parameters != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Parameters) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBParameterGroup`
 *
 * The `AWS::RDS::DBParameterGroup` resource creates a custom parameter group for an RDS database family.
 *
 * This type can be declared in a template and referenced in the `DBParameterGroupName` property of an `[AWS::RDS::DBInstance](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-database-instance.html)` resource.
 *
 * For information about configuring parameters for Amazon RDS DB instances, see [Working with DB parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithParamGroups.html) in the *Amazon RDS User Guide* .
 *
 * For information about configuring parameters for Amazon Aurora DB instances, see [Working with DB parameter groups and DB cluster parameter groups](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_WorkingWithParamGroups.html) in the *Amazon Aurora User Guide* .
 *
 * > Applying a parameter group to a DB instance may require the DB instance to reboot, resulting in a database outage for the duration of the reboot.
 *
 * @cloudformationResource AWS::RDS::DBParameterGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-dbparametergroup.html
 */
class CfnDBParameterGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBParameterGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBParameterGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBParameterGroupProps(props);
        cdk.requireProperty(props, 'description', this);
        cdk.requireProperty(props, 'family', this);
        this.description = props.description;
        this.family = props.family;
        this.parameters = props.parameters;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBParameterGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBParameterGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBParameterGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBParameterGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            description: this.description,
            family: this.family,
            parameters: this.parameters,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBParameterGroupPropsToCloudFormation(props);
    }
}
exports.CfnDBParameterGroup = CfnDBParameterGroup;
_d = JSII_RTTI_SYMBOL_1;
CfnDBParameterGroup[_d] = { fqn: "monocdk.aws_rds.CfnDBParameterGroup", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBParameterGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBParameterGroup";
/**
 * Determine whether the given properties match those of a `CfnDBProxyProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyProps`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('auth', cdk.requiredValidator)(properties.auth));
    errors.collect(cdk.propertyValidator('auth', cdk.listValidator(CfnDBProxy_AuthFormatPropertyValidator))(properties.auth));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.requiredValidator)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.validateString)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('debugLogging', cdk.validateBoolean)(properties.debugLogging));
    errors.collect(cdk.propertyValidator('engineFamily', cdk.requiredValidator)(properties.engineFamily));
    errors.collect(cdk.propertyValidator('engineFamily', cdk.validateString)(properties.engineFamily));
    errors.collect(cdk.propertyValidator('idleClientTimeout', cdk.validateNumber)(properties.idleClientTimeout));
    errors.collect(cdk.propertyValidator('requireTls', cdk.validateBoolean)(properties.requireTls));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnDBProxy_TagFormatPropertyValidator))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.requiredValidator)(properties.vpcSubnetIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.listValidator(cdk.validateString))(properties.vpcSubnetIds));
    return errors.wrap('supplied properties not correct for "CfnDBProxyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxy` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxy` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyPropsValidator(properties).assertSuccess();
    return {
        Auth: cdk.listMapper(cfnDBProxyAuthFormatPropertyToCloudFormation)(properties.auth),
        DBProxyName: cdk.stringToCloudFormation(properties.dbProxyName),
        EngineFamily: cdk.stringToCloudFormation(properties.engineFamily),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        VpcSubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSubnetIds),
        DebugLogging: cdk.booleanToCloudFormation(properties.debugLogging),
        IdleClientTimeout: cdk.numberToCloudFormation(properties.idleClientTimeout),
        RequireTLS: cdk.booleanToCloudFormation(properties.requireTls),
        Tags: cdk.listMapper(cfnDBProxyTagFormatPropertyToCloudFormation)(properties.tags),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnDBProxyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('auth', 'Auth', cfn_parse.FromCloudFormation.getArray(CfnDBProxyAuthFormatPropertyFromCloudFormation)(properties.Auth));
    ret.addPropertyResult('dbProxyName', 'DBProxyName', cfn_parse.FromCloudFormation.getString(properties.DBProxyName));
    ret.addPropertyResult('engineFamily', 'EngineFamily', cfn_parse.FromCloudFormation.getString(properties.EngineFamily));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('vpcSubnetIds', 'VpcSubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.VpcSubnetIds));
    ret.addPropertyResult('debugLogging', 'DebugLogging', properties.DebugLogging != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DebugLogging) : undefined);
    ret.addPropertyResult('idleClientTimeout', 'IdleClientTimeout', properties.IdleClientTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.IdleClientTimeout) : undefined);
    ret.addPropertyResult('requireTls', 'RequireTLS', properties.RequireTLS != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RequireTLS) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnDBProxyTagFormatPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBProxy`
 *
 * The `AWS::RDS::DBProxy` resource creates or updates a DB proxy.
 *
 * For information about RDS Proxy for Amazon RDS, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html) in the *Amazon RDS User Guide* .
 *
 * For information about RDS Proxy for Amazon Aurora, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html) in the *Amazon Aurora User Guide* .
 *
 * > Limitations apply to RDS Proxy, including DB engine version limitations and AWS Region limitations.
 * >
 * > For information about limitations that apply to RDS Proxy for Amazon RDS, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon RDS User Guide* .
 * >
 * > For information about that apply to RDS Proxy for Amazon Aurora, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon Aurora User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBProxy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html
 */
class CfnDBProxy extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBProxy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBProxy.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBProxyProps(props);
        cdk.requireProperty(props, 'auth', this);
        cdk.requireProperty(props, 'dbProxyName', this);
        cdk.requireProperty(props, 'engineFamily', this);
        cdk.requireProperty(props, 'roleArn', this);
        cdk.requireProperty(props, 'vpcSubnetIds', this);
        this.attrDbProxyArn = cdk.Token.asString(this.getAtt('DBProxyArn'));
        this.attrEndpoint = cdk.Token.asString(this.getAtt('Endpoint'));
        this.auth = props.auth;
        this.dbProxyName = props.dbProxyName;
        this.engineFamily = props.engineFamily;
        this.roleArn = props.roleArn;
        this.vpcSubnetIds = props.vpcSubnetIds;
        this.debugLogging = props.debugLogging;
        this.idleClientTimeout = props.idleClientTimeout;
        this.requireTls = props.requireTls;
        this.tags = props.tags;
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBProxyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBProxy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBProxy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            auth: this.auth,
            dbProxyName: this.dbProxyName,
            engineFamily: this.engineFamily,
            roleArn: this.roleArn,
            vpcSubnetIds: this.vpcSubnetIds,
            debugLogging: this.debugLogging,
            idleClientTimeout: this.idleClientTimeout,
            requireTls: this.requireTls,
            tags: this.tags,
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnDBProxyPropsToCloudFormation(props);
    }
}
exports.CfnDBProxy = CfnDBProxy;
_e = JSII_RTTI_SYMBOL_1;
CfnDBProxy[_e] = { fqn: "monocdk.aws_rds.CfnDBProxy", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBProxy.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxy";
/**
 * Determine whether the given properties match those of a `AuthFormatProperty`
 *
 * @param properties - the TypeScript properties of a `AuthFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxy_AuthFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('authScheme', cdk.validateString)(properties.authScheme));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('iamAuth', cdk.validateString)(properties.iamAuth));
    errors.collect(cdk.propertyValidator('secretArn', cdk.validateString)(properties.secretArn));
    errors.collect(cdk.propertyValidator('userName', cdk.validateString)(properties.userName));
    return errors.wrap('supplied properties not correct for "AuthFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxy.AuthFormat` resource
 *
 * @param properties - the TypeScript properties of a `AuthFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxy.AuthFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyAuthFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxy_AuthFormatPropertyValidator(properties).assertSuccess();
    return {
        AuthScheme: cdk.stringToCloudFormation(properties.authScheme),
        Description: cdk.stringToCloudFormation(properties.description),
        IAMAuth: cdk.stringToCloudFormation(properties.iamAuth),
        SecretArn: cdk.stringToCloudFormation(properties.secretArn),
        UserName: cdk.stringToCloudFormation(properties.userName),
    };
}
// @ts-ignore TS6133
function CfnDBProxyAuthFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('authScheme', 'AuthScheme', properties.AuthScheme != null ? cfn_parse.FromCloudFormation.getString(properties.AuthScheme) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('iamAuth', 'IAMAuth', properties.IAMAuth != null ? cfn_parse.FromCloudFormation.getString(properties.IAMAuth) : undefined);
    ret.addPropertyResult('secretArn', 'SecretArn', properties.SecretArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretArn) : undefined);
    ret.addPropertyResult('userName', 'UserName', properties.UserName != null ? cfn_parse.FromCloudFormation.getString(properties.UserName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TagFormatProperty`
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxy_TagFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxy.TagFormat` resource
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxy.TagFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyTagFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxy_TagFormatPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnDBProxyTagFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBProxyEndpointProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyEndpointProps`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyEndpointPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbProxyEndpointName', cdk.requiredValidator)(properties.dbProxyEndpointName));
    errors.collect(cdk.propertyValidator('dbProxyEndpointName', cdk.validateString)(properties.dbProxyEndpointName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.requiredValidator)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.validateString)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnDBProxyEndpoint_TagFormatPropertyValidator))(properties.tags));
    errors.collect(cdk.propertyValidator('targetRole', cdk.validateString)(properties.targetRole));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.requiredValidator)(properties.vpcSubnetIds));
    errors.collect(cdk.propertyValidator('vpcSubnetIds', cdk.listValidator(cdk.validateString))(properties.vpcSubnetIds));
    return errors.wrap('supplied properties not correct for "CfnDBProxyEndpointProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyEndpointProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyEndpointPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyEndpointPropsValidator(properties).assertSuccess();
    return {
        DBProxyEndpointName: cdk.stringToCloudFormation(properties.dbProxyEndpointName),
        DBProxyName: cdk.stringToCloudFormation(properties.dbProxyName),
        VpcSubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSubnetIds),
        Tags: cdk.listMapper(cfnDBProxyEndpointTagFormatPropertyToCloudFormation)(properties.tags),
        TargetRole: cdk.stringToCloudFormation(properties.targetRole),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnDBProxyEndpointPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbProxyEndpointName', 'DBProxyEndpointName', cfn_parse.FromCloudFormation.getString(properties.DBProxyEndpointName));
    ret.addPropertyResult('dbProxyName', 'DBProxyName', cfn_parse.FromCloudFormation.getString(properties.DBProxyName));
    ret.addPropertyResult('vpcSubnetIds', 'VpcSubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.VpcSubnetIds));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnDBProxyEndpointTagFormatPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addPropertyResult('targetRole', 'TargetRole', properties.TargetRole != null ? cfn_parse.FromCloudFormation.getString(properties.TargetRole) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBProxyEndpoint`
 *
 * The `AWS::RDS::DBProxyEndpoint` resource creates or updates a DB proxy endpoint. You can use custom proxy endpoints to access a proxy through a different VPC than the proxy's default VPC.
 *
 * For more information about RDS Proxy, see [AWS::RDS::DBProxy](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html) .
 *
 * @cloudformationResource AWS::RDS::DBProxyEndpoint
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxyendpoint.html
 */
class CfnDBProxyEndpoint extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBProxyEndpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBProxyEndpoint.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBProxyEndpointProps(props);
        cdk.requireProperty(props, 'dbProxyEndpointName', this);
        cdk.requireProperty(props, 'dbProxyName', this);
        cdk.requireProperty(props, 'vpcSubnetIds', this);
        this.attrDbProxyEndpointArn = cdk.Token.asString(this.getAtt('DBProxyEndpointArn'));
        this.attrEndpoint = cdk.Token.asString(this.getAtt('Endpoint'));
        this.attrIsDefault = this.getAtt('IsDefault');
        this.attrVpcId = cdk.Token.asString(this.getAtt('VpcId'));
        this.dbProxyEndpointName = props.dbProxyEndpointName;
        this.dbProxyName = props.dbProxyName;
        this.vpcSubnetIds = props.vpcSubnetIds;
        this.tags = props.tags;
        this.targetRole = props.targetRole;
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBProxyEndpointPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBProxyEndpoint(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBProxyEndpoint.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbProxyEndpointName: this.dbProxyEndpointName,
            dbProxyName: this.dbProxyName,
            vpcSubnetIds: this.vpcSubnetIds,
            tags: this.tags,
            targetRole: this.targetRole,
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnDBProxyEndpointPropsToCloudFormation(props);
    }
}
exports.CfnDBProxyEndpoint = CfnDBProxyEndpoint;
_f = JSII_RTTI_SYMBOL_1;
CfnDBProxyEndpoint[_f] = { fqn: "monocdk.aws_rds.CfnDBProxyEndpoint", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBProxyEndpoint.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxyEndpoint";
/**
 * Determine whether the given properties match those of a `TagFormatProperty`
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyEndpoint_TagFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "TagFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint.TagFormat` resource
 *
 * @param properties - the TypeScript properties of a `TagFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyEndpoint.TagFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyEndpointTagFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyEndpoint_TagFormatPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnDBProxyEndpointTagFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBProxyTargetGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyTargetGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyTargetGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('connectionPoolConfigurationInfo', CfnDBProxyTargetGroup_ConnectionPoolConfigurationInfoFormatPropertyValidator)(properties.connectionPoolConfigurationInfo));
    errors.collect(cdk.propertyValidator('dbClusterIdentifiers', cdk.listValidator(cdk.validateString))(properties.dbClusterIdentifiers));
    errors.collect(cdk.propertyValidator('dbInstanceIdentifiers', cdk.listValidator(cdk.validateString))(properties.dbInstanceIdentifiers));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.requiredValidator)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('dbProxyName', cdk.validateString)(properties.dbProxyName));
    errors.collect(cdk.propertyValidator('targetGroupName', cdk.requiredValidator)(properties.targetGroupName));
    errors.collect(cdk.propertyValidator('targetGroupName', cdk.validateString)(properties.targetGroupName));
    return errors.wrap('supplied properties not correct for "CfnDBProxyTargetGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBProxyTargetGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyTargetGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyTargetGroupPropsValidator(properties).assertSuccess();
    return {
        DBProxyName: cdk.stringToCloudFormation(properties.dbProxyName),
        TargetGroupName: cdk.stringToCloudFormation(properties.targetGroupName),
        ConnectionPoolConfigurationInfo: cfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyToCloudFormation(properties.connectionPoolConfigurationInfo),
        DBClusterIdentifiers: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbClusterIdentifiers),
        DBInstanceIdentifiers: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbInstanceIdentifiers),
    };
}
// @ts-ignore TS6133
function CfnDBProxyTargetGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbProxyName', 'DBProxyName', cfn_parse.FromCloudFormation.getString(properties.DBProxyName));
    ret.addPropertyResult('targetGroupName', 'TargetGroupName', cfn_parse.FromCloudFormation.getString(properties.TargetGroupName));
    ret.addPropertyResult('connectionPoolConfigurationInfo', 'ConnectionPoolConfigurationInfo', properties.ConnectionPoolConfigurationInfo != null ? CfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyFromCloudFormation(properties.ConnectionPoolConfigurationInfo) : undefined);
    ret.addPropertyResult('dbClusterIdentifiers', 'DBClusterIdentifiers', properties.DBClusterIdentifiers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBClusterIdentifiers) : undefined);
    ret.addPropertyResult('dbInstanceIdentifiers', 'DBInstanceIdentifiers', properties.DBInstanceIdentifiers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBInstanceIdentifiers) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBProxyTargetGroup`
 *
 * The `AWS::RDS::DBProxyTargetGroup` resource represents a set of RDS DB instances, Aurora DB clusters, or both that a proxy can connect to. Currently, each target group is associated with exactly one RDS DB instance or Aurora DB cluster.
 *
 * This data type is used as a response element in the `DescribeDBProxyTargetGroups` action.
 *
 * For information about RDS Proxy for Amazon RDS, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html) in the *Amazon RDS User Guide* .
 *
 * For information about RDS Proxy for Amazon Aurora, see [Managing Connections with Amazon RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html) in the *Amazon Aurora User Guide* .
 *
 * For a sample template that creates a DB proxy and registers a DB instance, see [Examples](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxy.html#aws-resource-rds-dbproxy--examples) in AWS::RDS::DBProxy.
 *
 * > Limitations apply to RDS Proxy, including DB engine version limitations and AWS Region limitations.
 * >
 * > For information about limitations that apply to RDS Proxy for Amazon RDS, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon RDS User Guide* .
 * >
 * > For information about that apply to RDS Proxy for Amazon Aurora, see [Limitations for RDS Proxy](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/rds-proxy.html#rds-proxy.limitations) in the *Amazon Aurora User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBProxyTargetGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbproxytargetgroup.html
 */
class CfnDBProxyTargetGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBProxyTargetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBProxyTargetGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBProxyTargetGroupProps(props);
        cdk.requireProperty(props, 'dbProxyName', this);
        cdk.requireProperty(props, 'targetGroupName', this);
        this.attrTargetGroupArn = cdk.Token.asString(this.getAtt('TargetGroupArn'));
        this.dbProxyName = props.dbProxyName;
        this.targetGroupName = props.targetGroupName;
        this.connectionPoolConfigurationInfo = props.connectionPoolConfigurationInfo;
        this.dbClusterIdentifiers = props.dbClusterIdentifiers;
        this.dbInstanceIdentifiers = props.dbInstanceIdentifiers;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBProxyTargetGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBProxyTargetGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBProxyTargetGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbProxyName: this.dbProxyName,
            targetGroupName: this.targetGroupName,
            connectionPoolConfigurationInfo: this.connectionPoolConfigurationInfo,
            dbClusterIdentifiers: this.dbClusterIdentifiers,
            dbInstanceIdentifiers: this.dbInstanceIdentifiers,
        };
    }
    renderProperties(props) {
        return cfnDBProxyTargetGroupPropsToCloudFormation(props);
    }
}
exports.CfnDBProxyTargetGroup = CfnDBProxyTargetGroup;
_g = JSII_RTTI_SYMBOL_1;
CfnDBProxyTargetGroup[_g] = { fqn: "monocdk.aws_rds.CfnDBProxyTargetGroup", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBProxyTargetGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBProxyTargetGroup";
/**
 * Determine whether the given properties match those of a `ConnectionPoolConfigurationInfoFormatProperty`
 *
 * @param properties - the TypeScript properties of a `ConnectionPoolConfigurationInfoFormatProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBProxyTargetGroup_ConnectionPoolConfigurationInfoFormatPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('connectionBorrowTimeout', cdk.validateNumber)(properties.connectionBorrowTimeout));
    errors.collect(cdk.propertyValidator('initQuery', cdk.validateString)(properties.initQuery));
    errors.collect(cdk.propertyValidator('maxConnectionsPercent', cdk.validateNumber)(properties.maxConnectionsPercent));
    errors.collect(cdk.propertyValidator('maxIdleConnectionsPercent', cdk.validateNumber)(properties.maxIdleConnectionsPercent));
    errors.collect(cdk.propertyValidator('sessionPinningFilters', cdk.listValidator(cdk.validateString))(properties.sessionPinningFilters));
    return errors.wrap('supplied properties not correct for "ConnectionPoolConfigurationInfoFormatProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfoFormat` resource
 *
 * @param properties - the TypeScript properties of a `ConnectionPoolConfigurationInfoFormatProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBProxyTargetGroup.ConnectionPoolConfigurationInfoFormat` resource.
 */
// @ts-ignore TS6133
function cfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBProxyTargetGroup_ConnectionPoolConfigurationInfoFormatPropertyValidator(properties).assertSuccess();
    return {
        ConnectionBorrowTimeout: cdk.numberToCloudFormation(properties.connectionBorrowTimeout),
        InitQuery: cdk.stringToCloudFormation(properties.initQuery),
        MaxConnectionsPercent: cdk.numberToCloudFormation(properties.maxConnectionsPercent),
        MaxIdleConnectionsPercent: cdk.numberToCloudFormation(properties.maxIdleConnectionsPercent),
        SessionPinningFilters: cdk.listMapper(cdk.stringToCloudFormation)(properties.sessionPinningFilters),
    };
}
// @ts-ignore TS6133
function CfnDBProxyTargetGroupConnectionPoolConfigurationInfoFormatPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('connectionBorrowTimeout', 'ConnectionBorrowTimeout', properties.ConnectionBorrowTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.ConnectionBorrowTimeout) : undefined);
    ret.addPropertyResult('initQuery', 'InitQuery', properties.InitQuery != null ? cfn_parse.FromCloudFormation.getString(properties.InitQuery) : undefined);
    ret.addPropertyResult('maxConnectionsPercent', 'MaxConnectionsPercent', properties.MaxConnectionsPercent != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxConnectionsPercent) : undefined);
    ret.addPropertyResult('maxIdleConnectionsPercent', 'MaxIdleConnectionsPercent', properties.MaxIdleConnectionsPercent != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxIdleConnectionsPercent) : undefined);
    ret.addPropertyResult('sessionPinningFilters', 'SessionPinningFilters', properties.SessionPinningFilters != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SessionPinningFilters) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBSecurityGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBSecurityGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbSecurityGroupIngress', cdk.requiredValidator)(properties.dbSecurityGroupIngress));
    errors.collect(cdk.propertyValidator('dbSecurityGroupIngress', cdk.listValidator(CfnDBSecurityGroup_IngressPropertyValidator))(properties.dbSecurityGroupIngress));
    errors.collect(cdk.propertyValidator('ec2VpcId', cdk.validateString)(properties.ec2VpcId));
    errors.collect(cdk.propertyValidator('groupDescription', cdk.requiredValidator)(properties.groupDescription));
    errors.collect(cdk.propertyValidator('groupDescription', cdk.validateString)(properties.groupDescription));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBSecurityGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBSecurityGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSecurityGroupPropsValidator(properties).assertSuccess();
    return {
        DBSecurityGroupIngress: cdk.listMapper(cfnDBSecurityGroupIngressPropertyToCloudFormation)(properties.dbSecurityGroupIngress),
        GroupDescription: cdk.stringToCloudFormation(properties.groupDescription),
        EC2VpcId: cdk.stringToCloudFormation(properties.ec2VpcId),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBSecurityGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSecurityGroupIngress', 'DBSecurityGroupIngress', cfn_parse.FromCloudFormation.getArray(CfnDBSecurityGroupIngressPropertyFromCloudFormation)(properties.DBSecurityGroupIngress));
    ret.addPropertyResult('groupDescription', 'GroupDescription', cfn_parse.FromCloudFormation.getString(properties.GroupDescription));
    ret.addPropertyResult('ec2VpcId', 'EC2VpcId', properties.EC2VpcId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2VpcId) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroup`
 *
 * The `AWS::RDS::DBSecurityGroup` resource creates or updates an Amazon RDS DB security group.
 *
 * > DB security groups are a part of the EC2-Classic Platform and as such are not supported in all regions. It is advised to use the `AWS::EC2::SecurityGroup` resource in those regions instead. To determine which platform you are on, see [Determining Whether You Are Using the EC2-VPC or EC2-Classic Platform](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.FindDefaultVPC.html) . For more information on the `AWS::EC2::SecurityGroup` , see the documentation for [EC2 security groups](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html) .
 *
 * @cloudformationResource AWS::RDS::DBSecurityGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-rds-security-group.html
 */
class CfnDBSecurityGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBSecurityGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBSecurityGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBSecurityGroupProps(props);
        cdk.requireProperty(props, 'dbSecurityGroupIngress', this);
        cdk.requireProperty(props, 'groupDescription', this);
        this.dbSecurityGroupIngress = props.dbSecurityGroupIngress;
        this.groupDescription = props.groupDescription;
        this.ec2VpcId = props.ec2VpcId;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBSecurityGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBSecurityGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBSecurityGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBSecurityGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbSecurityGroupIngress: this.dbSecurityGroupIngress,
            groupDescription: this.groupDescription,
            ec2VpcId: this.ec2VpcId,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBSecurityGroupPropsToCloudFormation(props);
    }
}
exports.CfnDBSecurityGroup = CfnDBSecurityGroup;
_h = JSII_RTTI_SYMBOL_1;
CfnDBSecurityGroup[_h] = { fqn: "monocdk.aws_rds.CfnDBSecurityGroup", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBSecurityGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroup";
/**
 * Determine whether the given properties match those of a `IngressProperty`
 *
 * @param properties - the TypeScript properties of a `IngressProperty`
 *
 * @returns the result of the validation.
 */
function CfnDBSecurityGroup_IngressPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cidrip', cdk.validateString)(properties.cidrip));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupId', cdk.validateString)(properties.ec2SecurityGroupId));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupName', cdk.validateString)(properties.ec2SecurityGroupName));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupOwnerId', cdk.validateString)(properties.ec2SecurityGroupOwnerId));
    return errors.wrap('supplied properties not correct for "IngressProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup.Ingress` resource
 *
 * @param properties - the TypeScript properties of a `IngressProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroup.Ingress` resource.
 */
// @ts-ignore TS6133
function cfnDBSecurityGroupIngressPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSecurityGroup_IngressPropertyValidator(properties).assertSuccess();
    return {
        CIDRIP: cdk.stringToCloudFormation(properties.cidrip),
        EC2SecurityGroupId: cdk.stringToCloudFormation(properties.ec2SecurityGroupId),
        EC2SecurityGroupName: cdk.stringToCloudFormation(properties.ec2SecurityGroupName),
        EC2SecurityGroupOwnerId: cdk.stringToCloudFormation(properties.ec2SecurityGroupOwnerId),
    };
}
// @ts-ignore TS6133
function CfnDBSecurityGroupIngressPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cidrip', 'CIDRIP', properties.CIDRIP != null ? cfn_parse.FromCloudFormation.getString(properties.CIDRIP) : undefined);
    ret.addPropertyResult('ec2SecurityGroupId', 'EC2SecurityGroupId', properties.EC2SecurityGroupId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupId) : undefined);
    ret.addPropertyResult('ec2SecurityGroupName', 'EC2SecurityGroupName', properties.EC2SecurityGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupName) : undefined);
    ret.addPropertyResult('ec2SecurityGroupOwnerId', 'EC2SecurityGroupOwnerId', properties.EC2SecurityGroupOwnerId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupOwnerId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnDBSecurityGroupIngressProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupIngressProps`
 *
 * @returns the result of the validation.
 */
function CfnDBSecurityGroupIngressPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cidrip', cdk.validateString)(properties.cidrip));
    errors.collect(cdk.propertyValidator('dbSecurityGroupName', cdk.requiredValidator)(properties.dbSecurityGroupName));
    errors.collect(cdk.propertyValidator('dbSecurityGroupName', cdk.validateString)(properties.dbSecurityGroupName));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupId', cdk.validateString)(properties.ec2SecurityGroupId));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupName', cdk.validateString)(properties.ec2SecurityGroupName));
    errors.collect(cdk.propertyValidator('ec2SecurityGroupOwnerId', cdk.validateString)(properties.ec2SecurityGroupOwnerId));
    return errors.wrap('supplied properties not correct for "CfnDBSecurityGroupIngressProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroupIngress` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBSecurityGroupIngressProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSecurityGroupIngress` resource.
 */
// @ts-ignore TS6133
function cfnDBSecurityGroupIngressPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSecurityGroupIngressPropsValidator(properties).assertSuccess();
    return {
        DBSecurityGroupName: cdk.stringToCloudFormation(properties.dbSecurityGroupName),
        CIDRIP: cdk.stringToCloudFormation(properties.cidrip),
        EC2SecurityGroupId: cdk.stringToCloudFormation(properties.ec2SecurityGroupId),
        EC2SecurityGroupName: cdk.stringToCloudFormation(properties.ec2SecurityGroupName),
        EC2SecurityGroupOwnerId: cdk.stringToCloudFormation(properties.ec2SecurityGroupOwnerId),
    };
}
// @ts-ignore TS6133
function CfnDBSecurityGroupIngressPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSecurityGroupName', 'DBSecurityGroupName', cfn_parse.FromCloudFormation.getString(properties.DBSecurityGroupName));
    ret.addPropertyResult('cidrip', 'CIDRIP', properties.CIDRIP != null ? cfn_parse.FromCloudFormation.getString(properties.CIDRIP) : undefined);
    ret.addPropertyResult('ec2SecurityGroupId', 'EC2SecurityGroupId', properties.EC2SecurityGroupId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupId) : undefined);
    ret.addPropertyResult('ec2SecurityGroupName', 'EC2SecurityGroupName', properties.EC2SecurityGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupName) : undefined);
    ret.addPropertyResult('ec2SecurityGroupOwnerId', 'EC2SecurityGroupOwnerId', properties.EC2SecurityGroupOwnerId != null ? cfn_parse.FromCloudFormation.getString(properties.EC2SecurityGroupOwnerId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBSecurityGroupIngress`
 *
 * The `AWS::RDS::DBSecurityGroupIngress` resource enables ingress to a DB security group using one of two forms of authorization. First, you can add EC2 or VPC security groups to the DB security group if the application using the database is running on EC2 or VPC instances. Second, IP ranges are available if the application accessing your database is running on the Internet.
 *
 * This type supports updates. For more information about updating stacks, see [AWS CloudFormation Stacks Updates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html) .
 *
 * For details about the settings for DB security group ingress, see [AuthorizeDBSecurityGroupIngress](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_AuthorizeDBSecurityGroupIngress.html) .
 *
 * @cloudformationResource AWS::RDS::DBSecurityGroupIngress
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-security-group-ingress.html
 */
class CfnDBSecurityGroupIngress extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBSecurityGroupIngress`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBSecurityGroupIngress.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBSecurityGroupIngressProps(props);
        cdk.requireProperty(props, 'dbSecurityGroupName', this);
        this.dbSecurityGroupName = props.dbSecurityGroupName;
        this.cidrip = props.cidrip;
        this.ec2SecurityGroupId = props.ec2SecurityGroupId;
        this.ec2SecurityGroupName = props.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = props.ec2SecurityGroupOwnerId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBSecurityGroupIngressPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBSecurityGroupIngress(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBSecurityGroupIngress.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbSecurityGroupName: this.dbSecurityGroupName,
            cidrip: this.cidrip,
            ec2SecurityGroupId: this.ec2SecurityGroupId,
            ec2SecurityGroupName: this.ec2SecurityGroupName,
            ec2SecurityGroupOwnerId: this.ec2SecurityGroupOwnerId,
        };
    }
    renderProperties(props) {
        return cfnDBSecurityGroupIngressPropsToCloudFormation(props);
    }
}
exports.CfnDBSecurityGroupIngress = CfnDBSecurityGroupIngress;
_j = JSII_RTTI_SYMBOL_1;
CfnDBSecurityGroupIngress[_j] = { fqn: "monocdk.aws_rds.CfnDBSecurityGroupIngress", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBSecurityGroupIngress.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSecurityGroupIngress";
/**
 * Determine whether the given properties match those of a `CfnDBSubnetGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnDBSubnetGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnDBSubnetGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbSubnetGroupDescription', cdk.requiredValidator)(properties.dbSubnetGroupDescription));
    errors.collect(cdk.propertyValidator('dbSubnetGroupDescription', cdk.validateString)(properties.dbSubnetGroupDescription));
    errors.collect(cdk.propertyValidator('dbSubnetGroupName', cdk.validateString)(properties.dbSubnetGroupName));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnDBSubnetGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::DBSubnetGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnDBSubnetGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::DBSubnetGroup` resource.
 */
// @ts-ignore TS6133
function cfnDBSubnetGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDBSubnetGroupPropsValidator(properties).assertSuccess();
    return {
        DBSubnetGroupDescription: cdk.stringToCloudFormation(properties.dbSubnetGroupDescription),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        DBSubnetGroupName: cdk.stringToCloudFormation(properties.dbSubnetGroupName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnDBSubnetGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSubnetGroupDescription', 'DBSubnetGroupDescription', cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupDescription));
    ret.addPropertyResult('subnetIds', 'SubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds));
    ret.addPropertyResult('dbSubnetGroupName', 'DBSubnetGroupName', properties.DBSubnetGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.DBSubnetGroupName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::DBSubnetGroup`
 *
 * The `AWS::RDS::DBSubnetGroup` resource creates a database subnet group. Subnet groups must contain at least two subnets in two different Availability Zones in the same region.
 *
 * For more information, see [Working with DB subnet groups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Subnets) in the *Amazon RDS User Guide* .
 *
 * @cloudformationResource AWS::RDS::DBSubnetGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-dbsubnet-group.html
 */
class CfnDBSubnetGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::DBSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDBSubnetGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnDBSubnetGroupProps(props);
        cdk.requireProperty(props, 'dbSubnetGroupDescription', this);
        cdk.requireProperty(props, 'subnetIds', this);
        this.dbSubnetGroupDescription = props.dbSubnetGroupDescription;
        this.subnetIds = props.subnetIds;
        this.dbSubnetGroupName = props.dbSubnetGroupName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::DBSubnetGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnDBSubnetGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDBSubnetGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDBSubnetGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dbSubnetGroupDescription: this.dbSubnetGroupDescription,
            subnetIds: this.subnetIds,
            dbSubnetGroupName: this.dbSubnetGroupName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnDBSubnetGroupPropsToCloudFormation(props);
    }
}
exports.CfnDBSubnetGroup = CfnDBSubnetGroup;
_k = JSII_RTTI_SYMBOL_1;
CfnDBSubnetGroup[_k] = { fqn: "monocdk.aws_rds.CfnDBSubnetGroup", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDBSubnetGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::DBSubnetGroup";
/**
 * Determine whether the given properties match those of a `CfnEventSubscriptionProps`
 *
 * @param properties - the TypeScript properties of a `CfnEventSubscriptionProps`
 *
 * @returns the result of the validation.
 */
function CfnEventSubscriptionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('eventCategories', cdk.listValidator(cdk.validateString))(properties.eventCategories));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('sourceIds', cdk.listValidator(cdk.validateString))(properties.sourceIds));
    errors.collect(cdk.propertyValidator('sourceType', cdk.validateString)(properties.sourceType));
    return errors.wrap('supplied properties not correct for "CfnEventSubscriptionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::EventSubscription` resource
 *
 * @param properties - the TypeScript properties of a `CfnEventSubscriptionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::EventSubscription` resource.
 */
// @ts-ignore TS6133
function cfnEventSubscriptionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventSubscriptionPropsValidator(properties).assertSuccess();
    return {
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        EventCategories: cdk.listMapper(cdk.stringToCloudFormation)(properties.eventCategories),
        SourceIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.sourceIds),
        SourceType: cdk.stringToCloudFormation(properties.sourceType),
    };
}
// @ts-ignore TS6133
function CfnEventSubscriptionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('eventCategories', 'EventCategories', properties.EventCategories != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EventCategories) : undefined);
    ret.addPropertyResult('sourceIds', 'SourceIds', properties.SourceIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SourceIds) : undefined);
    ret.addPropertyResult('sourceType', 'SourceType', properties.SourceType != null ? cfn_parse.FromCloudFormation.getString(properties.SourceType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::EventSubscription`
 *
 * The `AWS::RDS::EventSubscription` resource allows you to receive notifications for Amazon Relational Database Service events through the Amazon Simple Notification Service (Amazon SNS). For more information, see [Using Amazon RDS Event Notification](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html) in the *Amazon RDS User Guide* .
 *
 * @cloudformationResource AWS::RDS::EventSubscription
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-eventsubscription.html
 */
class CfnEventSubscription extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::EventSubscription`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnEventSubscription.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnEventSubscriptionProps(props);
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsTopicArn = props.snsTopicArn;
        this.enabled = props.enabled;
        this.eventCategories = props.eventCategories;
        this.sourceIds = props.sourceIds;
        this.sourceType = props.sourceType;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEventSubscriptionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnEventSubscription(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEventSubscription.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsTopicArn: this.snsTopicArn,
            enabled: this.enabled,
            eventCategories: this.eventCategories,
            sourceIds: this.sourceIds,
            sourceType: this.sourceType,
        };
    }
    renderProperties(props) {
        return cfnEventSubscriptionPropsToCloudFormation(props);
    }
}
exports.CfnEventSubscription = CfnEventSubscription;
_l = JSII_RTTI_SYMBOL_1;
CfnEventSubscription[_l] = { fqn: "monocdk.aws_rds.CfnEventSubscription", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEventSubscription.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::EventSubscription";
/**
 * Determine whether the given properties match those of a `CfnGlobalClusterProps`
 *
 * @param properties - the TypeScript properties of a `CfnGlobalClusterProps`
 *
 * @returns the result of the validation.
 */
function CfnGlobalClusterPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deletionProtection', cdk.validateBoolean)(properties.deletionProtection));
    errors.collect(cdk.propertyValidator('engine', cdk.validateString)(properties.engine));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('globalClusterIdentifier', cdk.validateString)(properties.globalClusterIdentifier));
    errors.collect(cdk.propertyValidator('sourceDbClusterIdentifier', cdk.validateString)(properties.sourceDbClusterIdentifier));
    errors.collect(cdk.propertyValidator('storageEncrypted', cdk.validateBoolean)(properties.storageEncrypted));
    return errors.wrap('supplied properties not correct for "CfnGlobalClusterProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::GlobalCluster` resource
 *
 * @param properties - the TypeScript properties of a `CfnGlobalClusterProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::GlobalCluster` resource.
 */
// @ts-ignore TS6133
function cfnGlobalClusterPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnGlobalClusterPropsValidator(properties).assertSuccess();
    return {
        DeletionProtection: cdk.booleanToCloudFormation(properties.deletionProtection),
        Engine: cdk.stringToCloudFormation(properties.engine),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        GlobalClusterIdentifier: cdk.stringToCloudFormation(properties.globalClusterIdentifier),
        SourceDBClusterIdentifier: cdk.stringToCloudFormation(properties.sourceDbClusterIdentifier),
        StorageEncrypted: cdk.booleanToCloudFormation(properties.storageEncrypted),
    };
}
// @ts-ignore TS6133
function CfnGlobalClusterPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deletionProtection', 'DeletionProtection', properties.DeletionProtection != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeletionProtection) : undefined);
    ret.addPropertyResult('engine', 'Engine', properties.Engine != null ? cfn_parse.FromCloudFormation.getString(properties.Engine) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('globalClusterIdentifier', 'GlobalClusterIdentifier', properties.GlobalClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.GlobalClusterIdentifier) : undefined);
    ret.addPropertyResult('sourceDbClusterIdentifier', 'SourceDBClusterIdentifier', properties.SourceDBClusterIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.SourceDBClusterIdentifier) : undefined);
    ret.addPropertyResult('storageEncrypted', 'StorageEncrypted', properties.StorageEncrypted != null ? cfn_parse.FromCloudFormation.getBoolean(properties.StorageEncrypted) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::GlobalCluster`
 *
 * The `AWS::RDS::GlobalCluster` resource creates or updates an Amazon Aurora global database spread across multiple AWS Regions.
 *
 * The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
 *
 * You can create a global database that is initially empty, and then add a primary cluster and a secondary cluster to it.
 *
 * For information about Aurora global databases, see [Working with Amazon Aurora Global Databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) in the *Amazon Aurora User Guide* .
 *
 * @cloudformationResource AWS::RDS::GlobalCluster
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-globalcluster.html
 */
class CfnGlobalCluster extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::GlobalCluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnGlobalCluster.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnGlobalClusterProps(props);
        this.deletionProtection = props.deletionProtection;
        this.engine = props.engine;
        this.engineVersion = props.engineVersion;
        this.globalClusterIdentifier = props.globalClusterIdentifier;
        this.sourceDbClusterIdentifier = props.sourceDbClusterIdentifier;
        this.storageEncrypted = props.storageEncrypted;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnGlobalClusterPropsFromCloudFormation(resourceProperties);
        const ret = new CfnGlobalCluster(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnGlobalCluster.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            deletionProtection: this.deletionProtection,
            engine: this.engine,
            engineVersion: this.engineVersion,
            globalClusterIdentifier: this.globalClusterIdentifier,
            sourceDbClusterIdentifier: this.sourceDbClusterIdentifier,
            storageEncrypted: this.storageEncrypted,
        };
    }
    renderProperties(props) {
        return cfnGlobalClusterPropsToCloudFormation(props);
    }
}
exports.CfnGlobalCluster = CfnGlobalCluster;
_m = JSII_RTTI_SYMBOL_1;
CfnGlobalCluster[_m] = { fqn: "monocdk.aws_rds.CfnGlobalCluster", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnGlobalCluster.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::GlobalCluster";
/**
 * Determine whether the given properties match those of a `CfnOptionGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnOptionGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnOptionGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('engineName', cdk.requiredValidator)(properties.engineName));
    errors.collect(cdk.propertyValidator('engineName', cdk.validateString)(properties.engineName));
    errors.collect(cdk.propertyValidator('majorEngineVersion', cdk.requiredValidator)(properties.majorEngineVersion));
    errors.collect(cdk.propertyValidator('majorEngineVersion', cdk.validateString)(properties.majorEngineVersion));
    errors.collect(cdk.propertyValidator('optionConfigurations', cdk.requiredValidator)(properties.optionConfigurations));
    errors.collect(cdk.propertyValidator('optionConfigurations', cdk.listValidator(CfnOptionGroup_OptionConfigurationPropertyValidator))(properties.optionConfigurations));
    errors.collect(cdk.propertyValidator('optionGroupDescription', cdk.requiredValidator)(properties.optionGroupDescription));
    errors.collect(cdk.propertyValidator('optionGroupDescription', cdk.validateString)(properties.optionGroupDescription));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnOptionGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::OptionGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnOptionGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::OptionGroup` resource.
 */
// @ts-ignore TS6133
function cfnOptionGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOptionGroupPropsValidator(properties).assertSuccess();
    return {
        EngineName: cdk.stringToCloudFormation(properties.engineName),
        MajorEngineVersion: cdk.stringToCloudFormation(properties.majorEngineVersion),
        OptionConfigurations: cdk.listMapper(cfnOptionGroupOptionConfigurationPropertyToCloudFormation)(properties.optionConfigurations),
        OptionGroupDescription: cdk.stringToCloudFormation(properties.optionGroupDescription),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnOptionGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('engineName', 'EngineName', cfn_parse.FromCloudFormation.getString(properties.EngineName));
    ret.addPropertyResult('majorEngineVersion', 'MajorEngineVersion', cfn_parse.FromCloudFormation.getString(properties.MajorEngineVersion));
    ret.addPropertyResult('optionConfigurations', 'OptionConfigurations', cfn_parse.FromCloudFormation.getArray(CfnOptionGroupOptionConfigurationPropertyFromCloudFormation)(properties.OptionConfigurations));
    ret.addPropertyResult('optionGroupDescription', 'OptionGroupDescription', cfn_parse.FromCloudFormation.getString(properties.OptionGroupDescription));
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::RDS::OptionGroup`
 *
 * The `AWS::RDS::OptionGroup` resource creates or updates an option group, to enable and configure features that are specific to a particular DB engine.
 *
 * @cloudformationResource AWS::RDS::OptionGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-optiongroup.html
 */
class CfnOptionGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::RDS::OptionGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnOptionGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_rds_CfnOptionGroupProps(props);
        cdk.requireProperty(props, 'engineName', this);
        cdk.requireProperty(props, 'majorEngineVersion', this);
        cdk.requireProperty(props, 'optionConfigurations', this);
        cdk.requireProperty(props, 'optionGroupDescription', this);
        this.engineName = props.engineName;
        this.majorEngineVersion = props.majorEngineVersion;
        this.optionConfigurations = props.optionConfigurations;
        this.optionGroupDescription = props.optionGroupDescription;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::RDS::OptionGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnOptionGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnOptionGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnOptionGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            engineName: this.engineName,
            majorEngineVersion: this.majorEngineVersion,
            optionConfigurations: this.optionConfigurations,
            optionGroupDescription: this.optionGroupDescription,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnOptionGroupPropsToCloudFormation(props);
    }
}
exports.CfnOptionGroup = CfnOptionGroup;
_o = JSII_RTTI_SYMBOL_1;
CfnOptionGroup[_o] = { fqn: "monocdk.aws_rds.CfnOptionGroup", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnOptionGroup.CFN_RESOURCE_TYPE_NAME = "AWS::RDS::OptionGroup";
/**
 * Determine whether the given properties match those of a `OptionConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `OptionConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnOptionGroup_OptionConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dbSecurityGroupMemberships', cdk.listValidator(cdk.validateString))(properties.dbSecurityGroupMemberships));
    errors.collect(cdk.propertyValidator('optionName', cdk.requiredValidator)(properties.optionName));
    errors.collect(cdk.propertyValidator('optionName', cdk.validateString)(properties.optionName));
    errors.collect(cdk.propertyValidator('optionSettings', cdk.listValidator(CfnOptionGroup_OptionSettingPropertyValidator))(properties.optionSettings));
    errors.collect(cdk.propertyValidator('optionVersion', cdk.validateString)(properties.optionVersion));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupMemberships', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupMemberships));
    return errors.wrap('supplied properties not correct for "OptionConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `OptionConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnOptionGroupOptionConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOptionGroup_OptionConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DBSecurityGroupMemberships: cdk.listMapper(cdk.stringToCloudFormation)(properties.dbSecurityGroupMemberships),
        OptionName: cdk.stringToCloudFormation(properties.optionName),
        OptionSettings: cdk.listMapper(cfnOptionGroupOptionSettingPropertyToCloudFormation)(properties.optionSettings),
        OptionVersion: cdk.stringToCloudFormation(properties.optionVersion),
        Port: cdk.numberToCloudFormation(properties.port),
        VpcSecurityGroupMemberships: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupMemberships),
    };
}
// @ts-ignore TS6133
function CfnOptionGroupOptionConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dbSecurityGroupMemberships', 'DBSecurityGroupMemberships', properties.DBSecurityGroupMemberships != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DBSecurityGroupMemberships) : undefined);
    ret.addPropertyResult('optionName', 'OptionName', cfn_parse.FromCloudFormation.getString(properties.OptionName));
    ret.addPropertyResult('optionSettings', 'OptionSettings', properties.OptionSettings != null ? cfn_parse.FromCloudFormation.getArray(CfnOptionGroupOptionSettingPropertyFromCloudFormation)(properties.OptionSettings) : undefined);
    ret.addPropertyResult('optionVersion', 'OptionVersion', properties.OptionVersion != null ? cfn_parse.FromCloudFormation.getString(properties.OptionVersion) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('vpcSecurityGroupMemberships', 'VpcSecurityGroupMemberships', properties.VpcSecurityGroupMemberships != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupMemberships) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OptionSettingProperty`
 *
 * @param properties - the TypeScript properties of a `OptionSettingProperty`
 *
 * @returns the result of the validation.
 */
function CfnOptionGroup_OptionSettingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "OptionSettingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionSetting` resource
 *
 * @param properties - the TypeScript properties of a `OptionSettingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::RDS::OptionGroup.OptionSetting` resource.
 */
// @ts-ignore TS6133
function cfnOptionGroupOptionSettingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOptionGroup_OptionSettingPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnOptionGroupOptionSettingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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