"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PerformanceInsightRetention = exports.SnapshotCredentials = exports.Credentials = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Username and password combination
 */
class Credentials {
    /**
     * Creates Credentials with a password generated and stored in Secrets Manager.
     */
    static fromGeneratedSecret(username, options = {}) {
        jsiiDeprecationWarnings.monocdk_aws_rds_CredentialsBaseOptions(options);
        return {
            ...options,
            username,
            usernameAsString: true,
        };
    }
    /**
     * Creates Credentials from a password
     *
     * Do not put passwords in your CDK code directly.
     */
    static fromPassword(username, password) {
        jsiiDeprecationWarnings.monocdk_SecretValue(password);
        return {
            username,
            password,
            usernameAsString: true,
        };
    }
    /**
     * Creates Credentials for the given username, and optional password and key.
     * If no password is provided, one will be generated and stored in Secrets Manager.
     */
    static fromUsername(username, options = {}) {
        jsiiDeprecationWarnings.monocdk_aws_rds_CredentialsFromUsernameOptions(options);
        return {
            ...options,
            username,
        };
    }
    /**
     * Creates Credentials from an existing Secrets Manager ``Secret`` (or ``DatabaseSecret``)
     *
     * The Secret must be a JSON string with a ``username`` and ``password`` field:
     * ```
     * {
     *   ...
     *   "username": <required: username>,
     *   "password": <required: password>,
     * }
     * ```
     *
     * @param secret The secret where the credentials are stored
     * @param username The username defined in the secret. If specified the username
     *   will be referenced as a string and not a dynamic reference to the username
     *   field in the secret. This allows to replace the secret without replacing the
     *   instance or cluster.
     */
    static fromSecret(secret, username) {
        jsiiDeprecationWarnings.monocdk_aws_secretsmanager_ISecret(secret);
        return {
            username: username !== null && username !== void 0 ? username : secret.secretValueFromJson('username').toString(),
            password: secret.secretValueFromJson('password'),
            encryptionKey: secret.encryptionKey,
            secret,
        };
    }
}
exports.Credentials = Credentials;
_a = JSII_RTTI_SYMBOL_1;
Credentials[_a] = { fqn: "monocdk.aws_rds.Credentials", version: "1.149.0" };
/**
 * Credentials to update the password for a ``DatabaseInstanceFromSnapshot``.
 */
class SnapshotCredentials {
    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     * The new credentials are stored in Secrets Manager.
     *
     * Note - The username must match the existing master username of the snapshot.
     */
    static fromGeneratedSecret(username, options = {}) {
        jsiiDeprecationWarnings.monocdk_aws_rds_SnapshotCredentialsFromGeneratedPasswordOptions(options);
        return {
            ...options,
            generatePassword: true,
            replaceOnPasswordCriteriaChanges: true,
            username,
        };
    }
    /**
     * Generate a new password for the snapshot, using the existing username and an optional encryption key.
     *
     * Note - The username must match the existing master username of the snapshot.
     *
     * NOTE: use `fromGeneratedSecret()` for new Clusters and Instances.
     */
    static fromGeneratedPassword(username, options = {}) {
        jsiiDeprecationWarnings.monocdk_aws_rds_SnapshotCredentialsFromGeneratedPasswordOptions(options);
        return {
            ...options,
            generatePassword: true,
            username,
        };
    }
    /**
     * Update the snapshot login with an existing password.
     */
    static fromPassword(password) {
        jsiiDeprecationWarnings.monocdk_SecretValue(password);
        return { generatePassword: false, password };
    }
    /**
     * Update the snapshot login with an existing password from a Secret.
     *
     * The Secret must be a JSON string with a ``password`` field:
     * ```
     * {
     *   ...
     *   "password": <required: password>,
     * }
     * ```
     */
    static fromSecret(secret) {
        jsiiDeprecationWarnings.monocdk_aws_secretsmanager_Secret(secret);
        return {
            generatePassword: false,
            password: secret.secretValueFromJson('password'),
            secret,
        };
    }
}
exports.SnapshotCredentials = SnapshotCredentials;
_b = JSII_RTTI_SYMBOL_1;
SnapshotCredentials[_b] = { fqn: "monocdk.aws_rds.SnapshotCredentials", version: "1.149.0" };
/**
 * The retention period for Performance Insight.
 */
var PerformanceInsightRetention;
(function (PerformanceInsightRetention) {
    /**
     * Default retention period of 7 days.
     */
    PerformanceInsightRetention[PerformanceInsightRetention["DEFAULT"] = 7] = "DEFAULT";
    /**
     * Long term retention period of 2 years.
     */
    PerformanceInsightRetention[PerformanceInsightRetention["LONG_TERM"] = 731] = "LONG_TERM";
})(PerformanceInsightRetention = exports.PerformanceInsightRetention || (exports.PerformanceInsightRetention = {}));
//# sourceMappingURL=data:application/json;base64,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