"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseInstanceEngine = exports.SqlServerEngineVersion = exports.OracleEngineVersion = exports.OracleLegacyEngineVersion = exports.PostgresEngineVersion = exports.MysqlEngineVersion = exports.MariaDbEngineVersion = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const secretsmanager = require("../../aws-secretsmanager");
const option_group_1 = require("./option-group");
class InstanceEngineBase {
    constructor(props) {
        var _h;
        this.engineType = props.engineType;
        this.features = props.features;
        this.singleUserRotationApplication = props.singleUserRotationApplication;
        this.multiUserRotationApplication = props.multiUserRotationApplication;
        this.engineVersion = props.version;
        this.parameterGroupFamily = (_h = props.parameterGroupFamily) !== null && _h !== void 0 ? _h : (this.engineVersion ? `${this.engineType}${this.engineVersion.majorVersion}` : undefined);
        this.engineFamily = props.engineFamily;
    }
    bindToInstance(_scope, options) {
        if (options.timezone && !this.supportsTimezone) {
            throw new Error(`timezone property can not be configured for ${this.engineType}`);
        }
        return {
            features: this.features,
            optionGroup: options.optionGroup,
        };
    }
    /** Defines whether this Instance Engine can support timezone properties. */
    get supportsTimezone() { return false; }
}
/**
 * The versions for the MariaDB instance engines
 * (those returned by {@link DatabaseInstanceEngine.mariaDb}).
 */
class MariaDbEngineVersion {
    constructor(mariaDbFullVersion, mariaDbMajorVersion) {
        this.mariaDbFullVersion = mariaDbFullVersion;
        this.mariaDbMajorVersion = mariaDbMajorVersion;
    }
    /**
     * Create a new MariaDbEngineVersion with an arbitrary version.
     *
     * @param mariaDbFullVersion the full version string,
     *   for example "10.5.28"
     * @param mariaDbMajorVersion the major version of the engine,
     *   for example "10.5"
     */
    static of(mariaDbFullVersion, mariaDbMajorVersion) {
        return new MariaDbEngineVersion(mariaDbFullVersion, mariaDbMajorVersion);
    }
}
exports.MariaDbEngineVersion = MariaDbEngineVersion;
_a = JSII_RTTI_SYMBOL_1;
MariaDbEngineVersion[_a] = { fqn: "monocdk.aws_rds.MariaDbEngineVersion", version: "1.149.0" };
/**
 * Version "10.0" (only a major version, without a specific minor version).
 * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_0 = MariaDbEngineVersion.of('10.0', '10.0');
/**
 * Version "10.0.17".
 * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_0_17 = MariaDbEngineVersion.of('10.0.17', '10.0');
/**
 * Version "10.0.24".
 * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_0_24 = MariaDbEngineVersion.of('10.0.24', '10.0');
/**
 * Version "10.0.28".
 * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_0_28 = MariaDbEngineVersion.of('10.0.28', '10.0');
/**
 * Version "10.0.31".
 * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_0_31 = MariaDbEngineVersion.of('10.0.31', '10.0');
/**
 * Version "10.0.32".
 * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_0_32 = MariaDbEngineVersion.of('10.0.32', '10.0');
/**
 * Version "10.0.34".
 * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_0_34 = MariaDbEngineVersion.of('10.0.34', '10.0');
/**
 * Version "10.0.35".
 * @deprecated MariaDB 10.0 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_0_35 = MariaDbEngineVersion.of('10.0.35', '10.0');
/**
 * Version "10.1" (only a major version, without a specific minor version).
 * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_1 = MariaDbEngineVersion.of('10.1', '10.1');
/**
 * Version "10.1.14".
 * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_1_14 = MariaDbEngineVersion.of('10.1.14', '10.1');
/**
 * Version "10.1.19".
 * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_1_19 = MariaDbEngineVersion.of('10.1.19', '10.1');
/**
 * Version "10.1.23".
 * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_1_23 = MariaDbEngineVersion.of('10.1.23', '10.1');
/**
 * Version "10.1.26".
 * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_1_26 = MariaDbEngineVersion.of('10.1.26', '10.1');
/**
 * Version "10.1.31".
 * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_1_31 = MariaDbEngineVersion.of('10.1.31', '10.1');
/**
 * Version "10.1.34".
 * @deprecated MariaDB 10.1 will reach end of life on May 18, 2021
*/
MariaDbEngineVersion.VER_10_1_34 = MariaDbEngineVersion.of('10.1.34', '10.1');
/** Version "10.2" (only a major version, without a specific minor version). */
MariaDbEngineVersion.VER_10_2 = MariaDbEngineVersion.of('10.2', '10.2');
/** Version "10.2.11". */
MariaDbEngineVersion.VER_10_2_11 = MariaDbEngineVersion.of('10.2.11', '10.2');
/** Version "10.2.12". */
MariaDbEngineVersion.VER_10_2_12 = MariaDbEngineVersion.of('10.2.12', '10.2');
/** Version "10.2.15". */
MariaDbEngineVersion.VER_10_2_15 = MariaDbEngineVersion.of('10.2.15', '10.2');
/** Version "10.2.21". */
MariaDbEngineVersion.VER_10_2_21 = MariaDbEngineVersion.of('10.2.21', '10.2');
/** Version "10.2.32". */
MariaDbEngineVersion.VER_10_2_32 = MariaDbEngineVersion.of('10.2.32', '10.2');
/** Version "10.2.37". */
MariaDbEngineVersion.VER_10_2_37 = MariaDbEngineVersion.of('10.2.37', '10.2');
/** Version "10.2.39". */
MariaDbEngineVersion.VER_10_2_39 = MariaDbEngineVersion.of('10.2.39', '10.2');
/** Version "10.2.40". */
MariaDbEngineVersion.VER_10_2_40 = MariaDbEngineVersion.of('10.2.40', '10.2');
/** Version "10.2.41". */
MariaDbEngineVersion.VER_10_2_41 = MariaDbEngineVersion.of('10.2.41', '10.2');
/** Version "10.3" (only a major version, without a specific minor version). */
MariaDbEngineVersion.VER_10_3 = MariaDbEngineVersion.of('10.3', '10.3');
/** Version "10.3.8". */
MariaDbEngineVersion.VER_10_3_8 = MariaDbEngineVersion.of('10.3.8', '10.3');
/** Version "10.3.13". */
MariaDbEngineVersion.VER_10_3_13 = MariaDbEngineVersion.of('10.3.13', '10.3');
/** Version "10.3.20". */
MariaDbEngineVersion.VER_10_3_20 = MariaDbEngineVersion.of('10.3.20', '10.3');
/** Version "10.3.23". */
MariaDbEngineVersion.VER_10_3_23 = MariaDbEngineVersion.of('10.3.23', '10.3');
/** Version "10.3.28". */
MariaDbEngineVersion.VER_10_3_28 = MariaDbEngineVersion.of('10.3.28', '10.3');
/** Version "10.3.31". */
MariaDbEngineVersion.VER_10_3_31 = MariaDbEngineVersion.of('10.3.31', '10.3');
/** Version "10.3.32". */
MariaDbEngineVersion.VER_10_3_32 = MariaDbEngineVersion.of('10.3.32', '10.3');
/** Version "10.4" (only a major version, without a specific minor version). */
MariaDbEngineVersion.VER_10_4 = MariaDbEngineVersion.of('10.4', '10.4');
/** Version "10.4.8". */
MariaDbEngineVersion.VER_10_4_8 = MariaDbEngineVersion.of('10.4.8', '10.4');
/** Version "10.4.13". */
MariaDbEngineVersion.VER_10_4_13 = MariaDbEngineVersion.of('10.4.13', '10.4');
/** Version "10.4.18". */
MariaDbEngineVersion.VER_10_4_18 = MariaDbEngineVersion.of('10.4.18', '10.4');
/** Version "10.4.21". */
MariaDbEngineVersion.VER_10_4_21 = MariaDbEngineVersion.of('10.4.21', '10.4');
/** Version "10.4.22". */
MariaDbEngineVersion.VER_10_4_22 = MariaDbEngineVersion.of('10.4.22', '10.4');
/** Version "10.5" (only a major version, without a specific minor version). */
MariaDbEngineVersion.VER_10_5 = MariaDbEngineVersion.of('10.5', '10.5');
/** Version "10.5.8". */
MariaDbEngineVersion.VER_10_5_8 = MariaDbEngineVersion.of('10.5.8', '10.5');
/** Version "10.5.9". */
MariaDbEngineVersion.VER_10_5_9 = MariaDbEngineVersion.of('10.5.9', '10.5');
/** Version "10.5.12". */
MariaDbEngineVersion.VER_10_5_12 = MariaDbEngineVersion.of('10.5.12', '10.5');
/** Version "10.5.13". */
MariaDbEngineVersion.VER_10_5_13 = MariaDbEngineVersion.of('10.5.13', '10.5');
class MariaDbInstanceEngine extends InstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'mariadb',
            singleUserRotationApplication: secretsmanager.SecretRotationApplication.MARIADB_ROTATION_SINGLE_USER,
            multiUserRotationApplication: secretsmanager.SecretRotationApplication.MARIADB_ROTATION_MULTI_USER,
            version: version
                ? {
                    fullVersion: version.mariaDbFullVersion,
                    majorVersion: version.mariaDbMajorVersion,
                }
                : undefined,
        });
        this.supportsReadReplicaBackups = true;
    }
    bindToInstance(scope, options) {
        if (options.domain) {
            throw new Error(`domain property cannot be configured for ${this.engineType}`);
        }
        return super.bindToInstance(scope, options);
    }
}
/**
 * The versions for the MySQL instance engines
 * (those returned by {@link DatabaseInstanceEngine.mysql}).
 */
class MysqlEngineVersion {
    constructor(mysqlFullVersion, mysqlMajorVersion) {
        this.mysqlFullVersion = mysqlFullVersion;
        this.mysqlMajorVersion = mysqlMajorVersion;
    }
    /**
     * Create a new MysqlEngineVersion with an arbitrary version.
     *
     * @param mysqlFullVersion the full version string,
     *   for example "8.1.43"
     * @param mysqlMajorVersion the major version of the engine,
     *   for example "8.1"
     */
    static of(mysqlFullVersion, mysqlMajorVersion) {
        return new MysqlEngineVersion(mysqlFullVersion, mysqlMajorVersion);
    }
}
exports.MysqlEngineVersion = MysqlEngineVersion;
_b = JSII_RTTI_SYMBOL_1;
MysqlEngineVersion[_b] = { fqn: "monocdk.aws_rds.MysqlEngineVersion", version: "1.149.0" };
/**
 * Version "5.5" (only a major version, without a specific minor version).
 * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
*/
MysqlEngineVersion.VER_5_5 = MysqlEngineVersion.of('5.5', '5.5');
/**
 * Version "5.5.46".
 * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
*/
MysqlEngineVersion.VER_5_5_46 = MysqlEngineVersion.of('5.5.46', '5.5');
/**
 * Version "5.5.53".
 * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
*/
MysqlEngineVersion.VER_5_5_53 = MysqlEngineVersion.of('5.5.53', '5.5');
/**
 * Version "5.5.57".
 * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
*/
MysqlEngineVersion.VER_5_5_57 = MysqlEngineVersion.of('5.5.57', '5.5');
/**
 * Version "5.5.59".
 * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
*/
MysqlEngineVersion.VER_5_5_59 = MysqlEngineVersion.of('5.5.59', '5.5');
/**
 * Version "5.5.61".
 * @deprecated MySQL 5.5 will reach end of life on May 25, 2021
*/
MysqlEngineVersion.VER_5_5_61 = MysqlEngineVersion.of('5.5.61', '5.5');
/**
 * Version "5.6" (only a major version, without a specific minor version).
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6 = MysqlEngineVersion.of('5.6', '5.6');
/**
 * Version "5.6.34".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_34 = MysqlEngineVersion.of('5.6.34', '5.6');
/**
 * Version "5.6.35".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_35 = MysqlEngineVersion.of('5.6.35', '5.6');
/**
 * Version "5.6.37".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_37 = MysqlEngineVersion.of('5.6.37', '5.6');
/**
 * Version "5.6.39".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_39 = MysqlEngineVersion.of('5.6.39', '5.6');
/**
 * Version "5.6.40".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_40 = MysqlEngineVersion.of('5.6.40', '5.6');
/**
 * Version "5.6.41".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_41 = MysqlEngineVersion.of('5.6.41', '5.6');
/**
 * Version "5.6.43".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_43 = MysqlEngineVersion.of('5.6.43', '5.6');
/**
 * Version "5.6.44".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_44 = MysqlEngineVersion.of('5.6.44', '5.6');
/**
 * Version "5.6.46".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_46 = MysqlEngineVersion.of('5.6.46', '5.6');
/**
 * Version "5.6.48".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_48 = MysqlEngineVersion.of('5.6.48', '5.6');
/**
 * Version "5.6.49".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_49 = MysqlEngineVersion.of('5.6.49', '5.6');
/**
 * Version "5.6.51".
 * @deprecated MySQL 5.6 will reach end of life on August 3, 2021
*/
MysqlEngineVersion.VER_5_6_51 = MysqlEngineVersion.of('5.6.51', '5.6');
/** Version "5.7" (only a major version, without a specific minor version). */
MysqlEngineVersion.VER_5_7 = MysqlEngineVersion.of('5.7', '5.7');
/** Version "5.7.16". */
MysqlEngineVersion.VER_5_7_16 = MysqlEngineVersion.of('5.7.16', '5.7');
/** Version "5.7.17". */
MysqlEngineVersion.VER_5_7_17 = MysqlEngineVersion.of('5.7.17', '5.7');
/** Version "5.7.19". */
MysqlEngineVersion.VER_5_7_19 = MysqlEngineVersion.of('5.7.19', '5.7');
/** Version "5.7.21". */
MysqlEngineVersion.VER_5_7_21 = MysqlEngineVersion.of('5.7.21', '5.7');
/** Version "5.7.22". */
MysqlEngineVersion.VER_5_7_22 = MysqlEngineVersion.of('5.7.22', '5.7');
/** Version "5.7.23". */
MysqlEngineVersion.VER_5_7_23 = MysqlEngineVersion.of('5.7.23', '5.7');
/** Version "5.7.24". */
MysqlEngineVersion.VER_5_7_24 = MysqlEngineVersion.of('5.7.24', '5.7');
/** Version "5.7.25". */
MysqlEngineVersion.VER_5_7_25 = MysqlEngineVersion.of('5.7.25', '5.7');
/** Version "5.7.26". */
MysqlEngineVersion.VER_5_7_26 = MysqlEngineVersion.of('5.7.26', '5.7');
/** Version "5.7.28". */
MysqlEngineVersion.VER_5_7_28 = MysqlEngineVersion.of('5.7.28', '5.7');
/** Version "5.7.30". */
MysqlEngineVersion.VER_5_7_30 = MysqlEngineVersion.of('5.7.30', '5.7');
/** Version "5.7.31". */
MysqlEngineVersion.VER_5_7_31 = MysqlEngineVersion.of('5.7.31', '5.7');
/** Version "5.7.33". */
MysqlEngineVersion.VER_5_7_33 = MysqlEngineVersion.of('5.7.33', '5.7');
/** Version "5.7.34". */
MysqlEngineVersion.VER_5_7_34 = MysqlEngineVersion.of('5.7.34', '5.7');
/** Version "8.0" (only a major version, without a specific minor version). */
MysqlEngineVersion.VER_8_0 = MysqlEngineVersion.of('8.0', '8.0');
/** Version "8.0.11". */
MysqlEngineVersion.VER_8_0_11 = MysqlEngineVersion.of('8.0.11', '8.0');
/** Version "8.0.13". */
MysqlEngineVersion.VER_8_0_13 = MysqlEngineVersion.of('8.0.13', '8.0');
/** Version "8.0.15". */
MysqlEngineVersion.VER_8_0_15 = MysqlEngineVersion.of('8.0.15', '8.0');
/** Version "8.0.16". */
MysqlEngineVersion.VER_8_0_16 = MysqlEngineVersion.of('8.0.16', '8.0');
/** Version "8.0.17". */
MysqlEngineVersion.VER_8_0_17 = MysqlEngineVersion.of('8.0.17', '8.0');
/** Version "8.0.19". */
MysqlEngineVersion.VER_8_0_19 = MysqlEngineVersion.of('8.0.19', '8.0');
/** Version "8.0.20 ". */
MysqlEngineVersion.VER_8_0_20 = MysqlEngineVersion.of('8.0.20', '8.0');
/** Version "8.0.21 ". */
MysqlEngineVersion.VER_8_0_21 = MysqlEngineVersion.of('8.0.21', '8.0');
/** Version "8.0.23". */
MysqlEngineVersion.VER_8_0_23 = MysqlEngineVersion.of('8.0.23', '8.0');
/** Version "8.0.25". */
MysqlEngineVersion.VER_8_0_25 = MysqlEngineVersion.of('8.0.25', '8.0');
/** Version "8.0.26". */
MysqlEngineVersion.VER_8_0_26 = MysqlEngineVersion.of('8.0.26', '8.0');
class MySqlInstanceEngine extends InstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'mysql',
            singleUserRotationApplication: secretsmanager.SecretRotationApplication.MYSQL_ROTATION_SINGLE_USER,
            multiUserRotationApplication: secretsmanager.SecretRotationApplication.MYSQL_ROTATION_MULTI_USER,
            version: version
                ? {
                    fullVersion: version.mysqlFullVersion,
                    majorVersion: version.mysqlMajorVersion,
                }
                : undefined,
            engineFamily: 'MYSQL',
        });
        this.supportsReadReplicaBackups = true;
    }
}
/**
 * The versions for the PostgreSQL instance engines
 * (those returned by {@link DatabaseInstanceEngine.postgres}).
 */
class PostgresEngineVersion {
    constructor(postgresFullVersion, postgresMajorVersion, postgresFeatures) {
        this.postgresFullVersion = postgresFullVersion;
        this.postgresMajorVersion = postgresMajorVersion;
        this._features = {
            s3Import: (postgresFeatures === null || postgresFeatures === void 0 ? void 0 : postgresFeatures.s3Import) ? 's3Import' : undefined,
            s3Export: (postgresFeatures === null || postgresFeatures === void 0 ? void 0 : postgresFeatures.s3Export) ? 's3Export' : undefined,
        };
    }
    /**
     * Create a new PostgresEngineVersion with an arbitrary version.
     *
     * @param postgresFullVersion the full version string,
     *   for example "13.11"
     * @param postgresMajorVersion the major version of the engine,
     *   for example "13"
     */
    static of(postgresFullVersion, postgresMajorVersion, postgresFeatures) {
        jsiiDeprecationWarnings.monocdk_aws_rds_PostgresEngineFeatures(postgresFeatures);
        return new PostgresEngineVersion(postgresFullVersion, postgresMajorVersion, postgresFeatures);
    }
}
exports.PostgresEngineVersion = PostgresEngineVersion;
_c = JSII_RTTI_SYMBOL_1;
PostgresEngineVersion[_c] = { fqn: "monocdk.aws_rds.PostgresEngineVersion", version: "1.149.0" };
/**
 * Version "9.5" (only a major version, without a specific minor version).
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5 = PostgresEngineVersion.of('9.5', '9.5');
/**
 * Version "9.5.2".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_2 = PostgresEngineVersion.of('9.5.2', '9.5');
/**
 * Version "9.5.4".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_4 = PostgresEngineVersion.of('9.5.4', '9.5');
/**
 * Version "9.5.6".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_6 = PostgresEngineVersion.of('9.5.6', '9.5');
/**
 * Version "9.5.7".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_7 = PostgresEngineVersion.of('9.5.7', '9.5');
/**
 * Version "9.5.9".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_9 = PostgresEngineVersion.of('9.5.9', '9.5');
/**
 * Version "9.5.10".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_10 = PostgresEngineVersion.of('9.5.10', '9.5');
/**
 * Version "9.5.12".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_12 = PostgresEngineVersion.of('9.5.12', '9.5');
/**
 * Version "9.5.13".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_13 = PostgresEngineVersion.of('9.5.13', '9.5');
/**
 * Version "9.5.14".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_14 = PostgresEngineVersion.of('9.5.14', '9.5');
/**
 * Version "9.5.15".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_15 = PostgresEngineVersion.of('9.5.15', '9.5');
/**
 * Version "9.5.16".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_16 = PostgresEngineVersion.of('9.5.16', '9.5');
/**
 * Version "9.5.18".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_18 = PostgresEngineVersion.of('9.5.18', '9.5');
/**
 * Version "9.5.19".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_19 = PostgresEngineVersion.of('9.5.19', '9.5');
/**
 * Version "9.5.20".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_20 = PostgresEngineVersion.of('9.5.20', '9.5');
/**
 * Version "9.5.21".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_21 = PostgresEngineVersion.of('9.5.21', '9.5');
/**
 * Version "9.5.22".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_22 = PostgresEngineVersion.of('9.5.22', '9.5');
/**
 * Version "9.5.23".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_23 = PostgresEngineVersion.of('9.5.23', '9.5');
/**
 * Version "9.5.24".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_24 = PostgresEngineVersion.of('9.5.24', '9.5');
/**
 * Version "9.5.25".
 * @deprecated PostgreSQL 9.5 will reach end of life on February 16, 2021
*/
PostgresEngineVersion.VER_9_5_25 = PostgresEngineVersion.of('9.5.25', '9.5');
/**
 * Version "9.6" (only a major version, without a specific minor version).
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6 = PostgresEngineVersion.of('9.6', '9.6');
/**
 * Version "9.6.1".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_1 = PostgresEngineVersion.of('9.6.1', '9.6');
/**
 * Version "9.6.2".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_2 = PostgresEngineVersion.of('9.6.2', '9.6');
/**
 * Version "9.6.3".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_3 = PostgresEngineVersion.of('9.6.3', '9.6');
/**
 * Version "9.6.5".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_5 = PostgresEngineVersion.of('9.6.5', '9.6');
/**
 * Version "9.6.6".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_6 = PostgresEngineVersion.of('9.6.6', '9.6');
/**
 * Version "9.6.8".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_8 = PostgresEngineVersion.of('9.6.8', '9.6');
/**
 * Version "9.6.9".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_9 = PostgresEngineVersion.of('9.6.9', '9.6');
/**
 * Version "9.6.10".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_10 = PostgresEngineVersion.of('9.6.10', '9.6');
/**
 * Version "9.6.11".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_11 = PostgresEngineVersion.of('9.6.11', '9.6');
/**
 * Version "9.6.12".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_12 = PostgresEngineVersion.of('9.6.12', '9.6');
/**
 * Version "9.6.14".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_14 = PostgresEngineVersion.of('9.6.14', '9.6');
/**
 * Version "9.6.15".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_15 = PostgresEngineVersion.of('9.6.15', '9.6');
/**
 * Version "9.6.16".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_16 = PostgresEngineVersion.of('9.6.16', '9.6');
/**
 * Version "9.6.17".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_17 = PostgresEngineVersion.of('9.6.17', '9.6');
/**
 * Version "9.6.18".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_18 = PostgresEngineVersion.of('9.6.18', '9.6');
/**
 * Version "9.6.19".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_19 = PostgresEngineVersion.of('9.6.19', '9.6');
/**
 * Version "9.6.20".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_20 = PostgresEngineVersion.of('9.6.20', '9.6');
/**
 * Version "9.6.21".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_21 = PostgresEngineVersion.of('9.6.21', '9.6');
/**
 * Version "9.6.22".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_22 = PostgresEngineVersion.of('9.6.22', '9.6');
/**
 * Version "9.6.23".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_23 = PostgresEngineVersion.of('9.6.23', '9.6');
/**
 * Version "9.6.24".
 * @deprecated PostgreSQL 9.6 will reach end of life in November 2021
*/
PostgresEngineVersion.VER_9_6_24 = PostgresEngineVersion.of('9.6.24', '9.6');
/** Version "10" (only a major version, without a specific minor version). */
PostgresEngineVersion.VER_10 = PostgresEngineVersion.of('10', '10');
/** Version "10.1". */
PostgresEngineVersion.VER_10_1 = PostgresEngineVersion.of('10.1', '10');
/** Version "10.3". */
PostgresEngineVersion.VER_10_3 = PostgresEngineVersion.of('10.3', '10');
/** Version "10.4". */
PostgresEngineVersion.VER_10_4 = PostgresEngineVersion.of('10.4', '10');
/** Version "10.5". */
PostgresEngineVersion.VER_10_5 = PostgresEngineVersion.of('10.5', '10');
/** Version "10.6". */
PostgresEngineVersion.VER_10_6 = PostgresEngineVersion.of('10.6', '10');
/** Version "10.7". */
PostgresEngineVersion.VER_10_7 = PostgresEngineVersion.of('10.7', '10', { s3Import: true });
/** Version "10.9". */
PostgresEngineVersion.VER_10_9 = PostgresEngineVersion.of('10.9', '10', { s3Import: true });
/** Version "10.10". */
PostgresEngineVersion.VER_10_10 = PostgresEngineVersion.of('10.10', '10', { s3Import: true });
/** Version "10.11". */
PostgresEngineVersion.VER_10_11 = PostgresEngineVersion.of('10.11', '10', { s3Import: true });
/** Version "10.12". */
PostgresEngineVersion.VER_10_12 = PostgresEngineVersion.of('10.12', '10', { s3Import: true });
/** Version "10.13". */
PostgresEngineVersion.VER_10_13 = PostgresEngineVersion.of('10.13', '10', { s3Import: true });
/** Version "10.14". */
PostgresEngineVersion.VER_10_14 = PostgresEngineVersion.of('10.14', '10', { s3Import: true, s3Export: true });
/** Version "10.15". */
PostgresEngineVersion.VER_10_15 = PostgresEngineVersion.of('10.15', '10', { s3Import: true, s3Export: true });
/** Version "10.16". */
PostgresEngineVersion.VER_10_16 = PostgresEngineVersion.of('10.16', '10', { s3Import: true, s3Export: true });
/** Version "10.17". */
PostgresEngineVersion.VER_10_17 = PostgresEngineVersion.of('10.17', '10', { s3Import: true, s3Export: true });
/** Version "10.18". */
PostgresEngineVersion.VER_10_18 = PostgresEngineVersion.of('10.18', '10', { s3Import: true, s3Export: true });
/** Version "10.19". */
PostgresEngineVersion.VER_10_19 = PostgresEngineVersion.of('10.19', '10', { s3Import: true, s3Export: true });
/** Version "11" (only a major version, without a specific minor version). */
PostgresEngineVersion.VER_11 = PostgresEngineVersion.of('11', '11', { s3Import: true });
/** Version "11.1". */
PostgresEngineVersion.VER_11_1 = PostgresEngineVersion.of('11.1', '11', { s3Import: true });
/** Version "11.2". */
PostgresEngineVersion.VER_11_2 = PostgresEngineVersion.of('11.2', '11', { s3Import: true });
/** Version "11.4". */
PostgresEngineVersion.VER_11_4 = PostgresEngineVersion.of('11.4', '11', { s3Import: true });
/** Version "11.5". */
PostgresEngineVersion.VER_11_5 = PostgresEngineVersion.of('11.5', '11', { s3Import: true });
/** Version "11.6". */
PostgresEngineVersion.VER_11_6 = PostgresEngineVersion.of('11.6', '11', { s3Import: true });
/** Version "11.7". */
PostgresEngineVersion.VER_11_7 = PostgresEngineVersion.of('11.7', '11', { s3Import: true });
/** Version "11.8". */
PostgresEngineVersion.VER_11_8 = PostgresEngineVersion.of('11.8', '11', { s3Import: true });
/** Version "11.9". */
PostgresEngineVersion.VER_11_9 = PostgresEngineVersion.of('11.9', '11', { s3Import: true, s3Export: true });
/** Version "11.10". */
PostgresEngineVersion.VER_11_10 = PostgresEngineVersion.of('11.10', '11', { s3Import: true, s3Export: true });
/** Version "11.11". */
PostgresEngineVersion.VER_11_11 = PostgresEngineVersion.of('11.11', '11', { s3Import: true, s3Export: true });
/** Version "11.12". */
PostgresEngineVersion.VER_11_12 = PostgresEngineVersion.of('11.12', '11', { s3Import: true, s3Export: true });
/** Version "11.13". */
PostgresEngineVersion.VER_11_13 = PostgresEngineVersion.of('11.13', '11', { s3Import: true, s3Export: true });
/** Version "11.14". */
PostgresEngineVersion.VER_11_14 = PostgresEngineVersion.of('11.14', '11', { s3Import: true, s3Export: true });
/** Version "12" (only a major version, without a specific minor version). */
PostgresEngineVersion.VER_12 = PostgresEngineVersion.of('12', '12', { s3Import: true });
/** Version "12.2". */
PostgresEngineVersion.VER_12_2 = PostgresEngineVersion.of('12.2', '12', { s3Import: true });
/** Version "12.3". */
PostgresEngineVersion.VER_12_3 = PostgresEngineVersion.of('12.3', '12', { s3Import: true });
/** Version "12.4". */
PostgresEngineVersion.VER_12_4 = PostgresEngineVersion.of('12.4', '12', { s3Import: true, s3Export: true });
/** Version "12.5". */
PostgresEngineVersion.VER_12_5 = PostgresEngineVersion.of('12.5', '12', { s3Import: true, s3Export: true });
/** Version "12.6". */
PostgresEngineVersion.VER_12_6 = PostgresEngineVersion.of('12.6', '12', { s3Import: true, s3Export: true });
/** Version "12.7". */
PostgresEngineVersion.VER_12_7 = PostgresEngineVersion.of('12.7', '12', { s3Import: true, s3Export: true });
/** Version "12.8". */
PostgresEngineVersion.VER_12_8 = PostgresEngineVersion.of('12.8', '12', { s3Import: true, s3Export: true });
/** Version "12.9". */
PostgresEngineVersion.VER_12_9 = PostgresEngineVersion.of('12.9', '12', { s3Import: true, s3Export: true });
/** Version "13" (only a major version, without a specific minor version). */
PostgresEngineVersion.VER_13 = PostgresEngineVersion.of('13', '13', { s3Import: true, s3Export: true });
/** Version "13.1". */
PostgresEngineVersion.VER_13_1 = PostgresEngineVersion.of('13.1', '13', { s3Import: true, s3Export: true });
/** Version "13.2". */
PostgresEngineVersion.VER_13_2 = PostgresEngineVersion.of('13.2', '13', { s3Import: true, s3Export: true });
/** Version "13.3". */
PostgresEngineVersion.VER_13_3 = PostgresEngineVersion.of('13.3', '13', { s3Import: true, s3Export: true });
/** Version "13.4". */
PostgresEngineVersion.VER_13_4 = PostgresEngineVersion.of('13.4', '13', { s3Import: true, s3Export: true });
/** Version "13.5". */
PostgresEngineVersion.VER_13_5 = PostgresEngineVersion.of('13.5', '13', { s3Import: true, s3Export: true });
/** Version "14" (only a major version, without a specific minor version). */
PostgresEngineVersion.VER_14 = PostgresEngineVersion.of('14', '14', { s3Import: true, s3Export: true });
/** Version "14.1". */
PostgresEngineVersion.VER_14_1 = PostgresEngineVersion.of('14.1', '14', { s3Import: true, s3Export: true });
/**
 * The instance engine for PostgreSQL.
 */
class PostgresInstanceEngine extends InstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'postgres',
            singleUserRotationApplication: secretsmanager.SecretRotationApplication.POSTGRES_ROTATION_SINGLE_USER,
            multiUserRotationApplication: secretsmanager.SecretRotationApplication.POSTGRES_ROTATION_MULTI_USER,
            version: version
                ? {
                    fullVersion: version.postgresFullVersion,
                    majorVersion: version.postgresMajorVersion,
                }
                : undefined,
            features: version ? version === null || version === void 0 ? void 0 : version._features : { s3Import: 's3Import' },
            engineFamily: 'POSTGRESQL',
        });
        this.defaultUsername = 'postgres';
    }
}
/**
 * The versions for the legacy Oracle instance engines
 * (those returned by {@link DatabaseInstanceEngine.oracleSe}
 * and {@link DatabaseInstanceEngine.oracleSe1}).
 * Note: RDS will stop allowing creating new databases with this version in August 2020.
 *
 * @deprecated instances can no longer be created with these engine versions. See https://forums.aws.amazon.com/ann.jspa?annID=7341
 */
class OracleLegacyEngineVersion {
    constructor(oracleLegacyFullVersion, oracleLegacyMajorVersion) {
        this.oracleLegacyFullVersion = oracleLegacyFullVersion;
        this.oracleLegacyMajorVersion = oracleLegacyMajorVersion;
    }
    static of(oracleLegacyFullVersion, oracleLegacyMajorVersion) {
        return new OracleLegacyEngineVersion(oracleLegacyFullVersion, oracleLegacyMajorVersion);
    }
}
exports.OracleLegacyEngineVersion = OracleLegacyEngineVersion;
_d = JSII_RTTI_SYMBOL_1;
OracleLegacyEngineVersion[_d] = { fqn: "monocdk.aws_rds.OracleLegacyEngineVersion", version: "1.149.0" };
/** Version "11.2" (only a major version, without a specific minor version). */
OracleLegacyEngineVersion.VER_11_2 = OracleLegacyEngineVersion.of('11.2', '11.2');
/** Version "11.2.0.2.v2". */
OracleLegacyEngineVersion.VER_11_2_0_2_V2 = OracleLegacyEngineVersion.of('11.2.0.2.v2', '11.2');
/** Version "11.2.0.4.v1". */
OracleLegacyEngineVersion.VER_11_2_0_4_V1 = OracleLegacyEngineVersion.of('11.2.0.4.v1', '11.2');
/** Version "11.2.0.4.v3". */
OracleLegacyEngineVersion.VER_11_2_0_4_V3 = OracleLegacyEngineVersion.of('11.2.0.4.v3', '11.2');
/** Version "11.2.0.4.v4". */
OracleLegacyEngineVersion.VER_11_2_0_4_V4 = OracleLegacyEngineVersion.of('11.2.0.4.v4', '11.2');
/** Version "11.2.0.4.v5". */
OracleLegacyEngineVersion.VER_11_2_0_4_V5 = OracleLegacyEngineVersion.of('11.2.0.4.v5', '11.2');
/** Version "11.2.0.4.v6". */
OracleLegacyEngineVersion.VER_11_2_0_4_V6 = OracleLegacyEngineVersion.of('11.2.0.4.v6', '11.2');
/** Version "11.2.0.4.v7". */
OracleLegacyEngineVersion.VER_11_2_0_4_V7 = OracleLegacyEngineVersion.of('11.2.0.4.v7', '11.2');
/** Version "11.2.0.4.v8". */
OracleLegacyEngineVersion.VER_11_2_0_4_V8 = OracleLegacyEngineVersion.of('11.2.0.4.v8', '11.2');
/** Version "11.2.0.4.v9". */
OracleLegacyEngineVersion.VER_11_2_0_4_V9 = OracleLegacyEngineVersion.of('11.2.0.4.v9', '11.2');
/** Version "11.2.0.4.v10". */
OracleLegacyEngineVersion.VER_11_2_0_4_V10 = OracleLegacyEngineVersion.of('11.2.0.4.v10', '11.2');
/** Version "11.2.0.4.v11". */
OracleLegacyEngineVersion.VER_11_2_0_4_V11 = OracleLegacyEngineVersion.of('11.2.0.4.v11', '11.2');
/** Version "11.2.0.4.v12". */
OracleLegacyEngineVersion.VER_11_2_0_4_V12 = OracleLegacyEngineVersion.of('11.2.0.4.v12', '11.2');
/** Version "11.2.0.4.v13". */
OracleLegacyEngineVersion.VER_11_2_0_4_V13 = OracleLegacyEngineVersion.of('11.2.0.4.v13', '11.2');
/** Version "11.2.0.4.v14". */
OracleLegacyEngineVersion.VER_11_2_0_4_V14 = OracleLegacyEngineVersion.of('11.2.0.4.v14', '11.2');
/** Version "11.2.0.4.v15". */
OracleLegacyEngineVersion.VER_11_2_0_4_V15 = OracleLegacyEngineVersion.of('11.2.0.4.v15', '11.2');
/** Version "11.2.0.4.v16". */
OracleLegacyEngineVersion.VER_11_2_0_4_V16 = OracleLegacyEngineVersion.of('11.2.0.4.v16', '11.2');
/** Version "11.2.0.4.v17". */
OracleLegacyEngineVersion.VER_11_2_0_4_V17 = OracleLegacyEngineVersion.of('11.2.0.4.v17', '11.2');
/** Version "11.2.0.4.v18". */
OracleLegacyEngineVersion.VER_11_2_0_4_V18 = OracleLegacyEngineVersion.of('11.2.0.4.v18', '11.2');
/** Version "11.2.0.4.v19". */
OracleLegacyEngineVersion.VER_11_2_0_4_V19 = OracleLegacyEngineVersion.of('11.2.0.4.v19', '11.2');
/** Version "11.2.0.4.v20". */
OracleLegacyEngineVersion.VER_11_2_0_4_V20 = OracleLegacyEngineVersion.of('11.2.0.4.v20', '11.2');
/** Version "11.2.0.4.v21". */
OracleLegacyEngineVersion.VER_11_2_0_4_V21 = OracleLegacyEngineVersion.of('11.2.0.4.v21', '11.2');
/** Version "11.2.0.4.v22". */
OracleLegacyEngineVersion.VER_11_2_0_4_V22 = OracleLegacyEngineVersion.of('11.2.0.4.v22', '11.2');
/** Version "11.2.0.4.v23". */
OracleLegacyEngineVersion.VER_11_2_0_4_V23 = OracleLegacyEngineVersion.of('11.2.0.4.v23', '11.2');
/** Version "11.2.0.4.v24". */
OracleLegacyEngineVersion.VER_11_2_0_4_V24 = OracleLegacyEngineVersion.of('11.2.0.4.v24', '11.2');
/** Version "11.2.0.4.v25". */
OracleLegacyEngineVersion.VER_11_2_0_4_V25 = OracleLegacyEngineVersion.of('11.2.0.4.v25', '11.2');
/**
 * The versions for the Oracle instance engines
 * (those returned by {@link DatabaseInstanceEngine.oracleSe2} and
 * {@link DatabaseInstanceEngine.oracleEe}).
 */
class OracleEngineVersion {
    constructor(oracleFullVersion, oracleMajorVersion) {
        this.oracleFullVersion = oracleFullVersion;
        this.oracleMajorVersion = oracleMajorVersion;
    }
    /**
     * Creates a new OracleEngineVersion with an arbitrary version.
     *
     * @param oracleFullVersion the full version string,
     *   for example "19.0.0.0.ru-2019-10.rur-2019-10.r1"
     * @param oracleMajorVersion the major version of the engine,
     *   for example "19"
     */
    static of(oracleFullVersion, oracleMajorVersion) {
        return new OracleEngineVersion(oracleFullVersion, oracleMajorVersion);
    }
}
exports.OracleEngineVersion = OracleEngineVersion;
_e = JSII_RTTI_SYMBOL_1;
OracleEngineVersion[_e] = { fqn: "monocdk.aws_rds.OracleEngineVersion", version: "1.149.0" };
/** Version "12.1" (only a major version, without a specific minor version). */
OracleEngineVersion.VER_12_1 = OracleEngineVersion.of('12.1', '12.1');
/** Version "12.1.0.2.v1". */
OracleEngineVersion.VER_12_1_0_2_V1 = OracleEngineVersion.of('12.1.0.2.v1', '12.1');
/** Version "12.1.0.2.v2". */
OracleEngineVersion.VER_12_1_0_2_V2 = OracleEngineVersion.of('12.1.0.2.v2', '12.1');
/** Version "12.1.0.2.v3". */
OracleEngineVersion.VER_12_1_0_2_V3 = OracleEngineVersion.of('12.1.0.2.v3', '12.1');
/** Version "12.1.0.2.v4". */
OracleEngineVersion.VER_12_1_0_2_V4 = OracleEngineVersion.of('12.1.0.2.v4', '12.1');
/** Version "12.1.0.2.v5". */
OracleEngineVersion.VER_12_1_0_2_V5 = OracleEngineVersion.of('12.1.0.2.v5', '12.1');
/** Version "12.1.0.2.v6". */
OracleEngineVersion.VER_12_1_0_2_V6 = OracleEngineVersion.of('12.1.0.2.v6', '12.1');
/** Version "12.1.0.2.v7". */
OracleEngineVersion.VER_12_1_0_2_V7 = OracleEngineVersion.of('12.1.0.2.v7', '12.1');
/** Version "12.1.0.2.v8". */
OracleEngineVersion.VER_12_1_0_2_V8 = OracleEngineVersion.of('12.1.0.2.v8', '12.1');
/** Version "12.1.0.2.v9". */
OracleEngineVersion.VER_12_1_0_2_V9 = OracleEngineVersion.of('12.1.0.2.v9', '12.1');
/** Version "12.1.0.2.v10". */
OracleEngineVersion.VER_12_1_0_2_V10 = OracleEngineVersion.of('12.1.0.2.v10', '12.1');
/** Version "12.1.0.2.v11". */
OracleEngineVersion.VER_12_1_0_2_V11 = OracleEngineVersion.of('12.1.0.2.v11', '12.1');
/** Version "12.1.0.2.v12". */
OracleEngineVersion.VER_12_1_0_2_V12 = OracleEngineVersion.of('12.1.0.2.v12', '12.1');
/** Version "12.1.0.2.v13". */
OracleEngineVersion.VER_12_1_0_2_V13 = OracleEngineVersion.of('12.1.0.2.v13', '12.1');
/** Version "12.1.0.2.v14". */
OracleEngineVersion.VER_12_1_0_2_V14 = OracleEngineVersion.of('12.1.0.2.v14', '12.1');
/** Version "12.1.0.2.v15". */
OracleEngineVersion.VER_12_1_0_2_V15 = OracleEngineVersion.of('12.1.0.2.v15', '12.1');
/** Version "12.1.0.2.v16". */
OracleEngineVersion.VER_12_1_0_2_V16 = OracleEngineVersion.of('12.1.0.2.v16', '12.1');
/** Version "12.1.0.2.v17". */
OracleEngineVersion.VER_12_1_0_2_V17 = OracleEngineVersion.of('12.1.0.2.v17', '12.1');
/** Version "12.1.0.2.v18". */
OracleEngineVersion.VER_12_1_0_2_V18 = OracleEngineVersion.of('12.1.0.2.v18', '12.1');
/** Version "12.1.0.2.v19". */
OracleEngineVersion.VER_12_1_0_2_V19 = OracleEngineVersion.of('12.1.0.2.v19', '12.1');
/** Version "12.1.0.2.v20". */
OracleEngineVersion.VER_12_1_0_2_V20 = OracleEngineVersion.of('12.1.0.2.v20', '12.1');
/** Version "12.1.0.2.v21". */
OracleEngineVersion.VER_12_1_0_2_V21 = OracleEngineVersion.of('12.1.0.2.v21', '12.1');
/** Version "12.1.0.2.v22". */
OracleEngineVersion.VER_12_1_0_2_V22 = OracleEngineVersion.of('12.1.0.2.v22', '12.1');
/** Version "12.1.0.2.v23". */
OracleEngineVersion.VER_12_1_0_2_V23 = OracleEngineVersion.of('12.1.0.2.v23', '12.1');
/** Version "12.1.0.2.v24". */
OracleEngineVersion.VER_12_1_0_2_V24 = OracleEngineVersion.of('12.1.0.2.v24', '12.1');
/** Version "12.2" (only a major version, without a specific minor version). */
OracleEngineVersion.VER_12_2 = OracleEngineVersion.of('12.2', '12.2');
/** Version "12.2.0.1.ru-2018-10.rur-2018-10.r1". */
OracleEngineVersion.VER_12_2_0_1_2018_10_R1 = OracleEngineVersion.of('12.2.0.1.ru-2018-10.rur-2018-10.r1', '12.2');
/** Version "12.2.0.1.ru-2019-01.rur-2019-01.r1". */
OracleEngineVersion.VER_12_2_0_1_2019_01_R1 = OracleEngineVersion.of('12.2.0.1.ru-2019-01.rur-2019-01.r1', '12.2');
/** Version "12.2.0.1.ru-2019-04.rur-2019-04.r1". */
OracleEngineVersion.VER_12_2_0_1_2019_04_R1 = OracleEngineVersion.of('12.2.0.1.ru-2019-04.rur-2019-04.r1', '12.2');
/** Version "12.2.0.1.ru-2019-07.rur-2019-07.r1". */
OracleEngineVersion.VER_12_2_0_1_2019_07_R1 = OracleEngineVersion.of('12.2.0.1.ru-2019-07.rur-2019-07.r1', '12.2');
/** Version "12.2.0.1.ru-2019-10.rur-2019-10.r1". */
OracleEngineVersion.VER_12_2_0_1_2019_10_R1 = OracleEngineVersion.of('12.2.0.1.ru-2019-10.rur-2019-10.r1', '12.2');
/** Version "12.2.0.1.ru-2020-01.rur-2020-01.r1". */
OracleEngineVersion.VER_12_2_0_1_2020_01_R1 = OracleEngineVersion.of('12.2.0.1.ru-2020-01.rur-2020-01.r1', '12.2');
/** Version "12.2.0.1.ru-2020-04.rur-2020-04.r1". */
OracleEngineVersion.VER_12_2_0_1_2020_04_R1 = OracleEngineVersion.of('12.2.0.1.ru-2020-04.rur-2020-04.r1', '12.2');
/** Version "12.2.0.1.ru-2020-07.rur-2020-07.r1". */
OracleEngineVersion.VER_12_2_0_1_2020_07_R1 = OracleEngineVersion.of('12.2.0.1.ru-2020-07.rur-2020-07.r1', '12.2');
/** Version "12.2.0.1.ru-2021-10.rur-2020-10.r1". */
OracleEngineVersion.VER_12_2_0_1_2020_10_R1 = OracleEngineVersion.of('12.2.0.1.ru-2020-10.rur-2020-10.r1', '12.2');
/** Version "12.2.0.1.ru-2021-01.rur-2021-01.r1". */
OracleEngineVersion.VER_12_2_0_1_2021_01_R1 = OracleEngineVersion.of('12.2.0.1.ru-2021-01.rur-2021-01.r1', '12.2');
/** Version "12.2.0.1.ru-2021-04.rur-2021-04.r1". */
OracleEngineVersion.VER_12_2_0_1_2021_04_R1 = OracleEngineVersion.of('12.2.0.1.ru-2021-04.rur-2021-04.r1', '12.2');
/** Version "18" (only a major version, without a specific minor version). */
OracleEngineVersion.VER_18 = OracleEngineVersion.of('18', '18');
/** Version "18.0.0.0.ru-2019-07.rur-2019-07.r1". */
OracleEngineVersion.VER_18_0_0_0_2019_07_R1 = OracleEngineVersion.of('18.0.0.0.ru-2019-07.rur-2019-07.r1', '18');
/** Version "18.0.0.0.ru-2019-10.rur-2019-10.r1". */
OracleEngineVersion.VER_18_0_0_0_2019_10_R1 = OracleEngineVersion.of('18.0.0.0.ru-2019-10.rur-2019-10.r1', '18');
/** Version "18.0.0.0.ru-2020-01.rur-2020-01.r1". */
OracleEngineVersion.VER_18_0_0_0_2020_01_R1 = OracleEngineVersion.of('18.0.0.0.ru-2020-01.rur-2020-01.r1', '18');
/** Version "18.0.0.0.ru-2020-04.rur-2020-04.r1". */
OracleEngineVersion.VER_18_0_0_0_2020_04_R1 = OracleEngineVersion.of('18.0.0.0.ru-2020-04.rur-2020-04.r1', '18');
/** Version "18.0.0.0.ru-2020-07.rur-2020-07.r1". */
OracleEngineVersion.VER_18_0_0_0_2020_07_R1 = OracleEngineVersion.of('18.0.0.0.ru-2020-07.rur-2020-07.r1', '18');
/** Version "19" (only a major version, without a specific minor version). */
OracleEngineVersion.VER_19 = OracleEngineVersion.of('19', '19');
/** Version "19.0.0.0.ru-2019-07.rur-2019-07.r1". */
OracleEngineVersion.VER_19_0_0_0_2019_07_R1 = OracleEngineVersion.of('19.0.0.0.ru-2019-07.rur-2019-07.r1', '19');
/** Version "19.0.0.0.ru-2019-10.rur-2019-10.r1". */
OracleEngineVersion.VER_19_0_0_0_2019_10_R1 = OracleEngineVersion.of('19.0.0.0.ru-2019-10.rur-2019-10.r1', '19');
/** Version "19.0.0.0.ru-2020-01.rur-2020-01.r1". */
OracleEngineVersion.VER_19_0_0_0_2020_01_R1 = OracleEngineVersion.of('19.0.0.0.ru-2020-01.rur-2020-01.r1', '19');
/** Version "19.0.0.0.ru-2020-04.rur-2020-04.r1". */
OracleEngineVersion.VER_19_0_0_0_2020_04_R1 = OracleEngineVersion.of('19.0.0.0.ru-2020-04.rur-2020-04.r1', '19');
/** Version "19.0.0.0.ru-2020-07.rur-2020-07.r1". */
OracleEngineVersion.VER_19_0_0_0_2020_07_R1 = OracleEngineVersion.of('19.0.0.0.ru-2020-07.rur-2020-07.r1', '19');
/** Version "19.0.0.0.ru-2020-07.rur-2020-10.r1". */
OracleEngineVersion.VER_19_0_0_0_2020_10_R1 = OracleEngineVersion.of('19.0.0.0.ru-2020-10.rur-2020-10.r1', '19');
/** Version "19.0.0.0.ru-2021-01.rur-2021-01.r1". */
OracleEngineVersion.VER_19_0_0_0_2021_01_R1 = OracleEngineVersion.of('19.0.0.0.ru-2021-01.rur-2021-01.r1', '19');
/** Version "19.0.0.0.ru-2021-01.rur-2021-01.r2". */
OracleEngineVersion.VER_19_0_0_0_2021_01_R2 = OracleEngineVersion.of('19.0.0.0.ru-2021-01.rur-2021-01.r2', '19');
/** Version "19.0.0.0.ru-2021-01.rur-2021-04.r1". */
OracleEngineVersion.VER_19_0_0_0_2021_04_R1 = OracleEngineVersion.of('19.0.0.0.ru-2021-04.rur-2021-04.r1', '19');
class OracleInstanceEngineBase extends InstanceEngineBase {
    constructor(props) {
        super({
            ...props,
            singleUserRotationApplication: secretsmanager.SecretRotationApplication.ORACLE_ROTATION_SINGLE_USER,
            multiUserRotationApplication: secretsmanager.SecretRotationApplication.ORACLE_ROTATION_MULTI_USER,
            parameterGroupFamily: props.version ? `${props.engineType}-${props.version.majorVersion}` : undefined,
            features: {
                s3Import: 'S3_INTEGRATION',
                s3Export: 'S3_INTEGRATION',
            },
        });
    }
    bindToInstance(scope, options) {
        const config = super.bindToInstance(scope, options);
        let optionGroup = options.optionGroup;
        if (options.s3ImportRole || options.s3ExportRole) {
            if (!optionGroup) {
                optionGroup = new option_group_1.OptionGroup(scope, 'InstanceOptionGroup', {
                    engine: this,
                    configurations: [],
                });
            }
            // https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-s3-integration.html
            optionGroup.addConfiguration({
                name: 'S3_INTEGRATION',
                version: '1.0',
            });
        }
        return {
            ...config,
            optionGroup,
        };
    }
}
/** @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341 */
class OracleSeInstanceEngine extends OracleInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'oracle-se',
            version: version
                ? {
                    fullVersion: version.oracleLegacyFullVersion,
                    majorVersion: version.oracleLegacyMajorVersion,
                }
                : {
                    majorVersion: '11.2',
                },
        });
    }
}
/** @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341 */
class OracleSe1InstanceEngine extends OracleInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'oracle-se1',
            version: version
                ? {
                    fullVersion: version.oracleLegacyFullVersion,
                    majorVersion: version.oracleLegacyMajorVersion,
                }
                : {
                    majorVersion: '11.2',
                },
        });
    }
}
class OracleSe2InstanceEngine extends OracleInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'oracle-se2',
            version: version
                ? {
                    fullVersion: version.oracleFullVersion,
                    majorVersion: version.oracleMajorVersion,
                }
                : undefined,
        });
    }
}
class OracleEeInstanceEngine extends OracleInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'oracle-ee',
            version: version
                ? {
                    fullVersion: version.oracleFullVersion,
                    majorVersion: version.oracleMajorVersion,
                }
                : undefined,
        });
    }
}
/**
 * The versions for the SQL Server instance engines
 * (those returned by {@link DatabaseInstanceEngine.sqlServerSe},
 * {@link DatabaseInstanceEngine.sqlServerEx}, {@link DatabaseInstanceEngine.sqlServerWeb}
 * and {@link DatabaseInstanceEngine.sqlServerEe}).
 */
class SqlServerEngineVersion {
    constructor(sqlServerFullVersion, sqlServerMajorVersion) {
        this.sqlServerFullVersion = sqlServerFullVersion;
        this.sqlServerMajorVersion = sqlServerMajorVersion;
    }
    /**
     * Create a new SqlServerEngineVersion with an arbitrary version.
     *
     * @param sqlServerFullVersion the full version string,
     *   for example "15.00.3049.1.v1"
     * @param sqlServerMajorVersion the major version of the engine,
     *   for example "15.00"
     */
    static of(sqlServerFullVersion, sqlServerMajorVersion) {
        return new SqlServerEngineVersion(sqlServerFullVersion, sqlServerMajorVersion);
    }
}
exports.SqlServerEngineVersion = SqlServerEngineVersion;
_f = JSII_RTTI_SYMBOL_1;
SqlServerEngineVersion[_f] = { fqn: "monocdk.aws_rds.SqlServerEngineVersion", version: "1.149.0" };
/** Version "11.00" (only a major version, without a specific minor version). */
SqlServerEngineVersion.VER_11 = SqlServerEngineVersion.of('11.00', '11.00');
/** Version "11.00.5058.0.v1". */
SqlServerEngineVersion.VER_11_00_5058_0_V1 = SqlServerEngineVersion.of('11.00.5058.0.v1', '11.00');
/** Version "11.00.6020.0.v1". */
SqlServerEngineVersion.VER_11_00_6020_0_V1 = SqlServerEngineVersion.of('11.00.6020.0.v1', '11.00');
/** Version "11.00.6594.0.v1". */
SqlServerEngineVersion.VER_11_00_6594_0_V1 = SqlServerEngineVersion.of('11.00.6594.0.v1', '11.00');
/** Version "11.00.7462.6.v1". */
SqlServerEngineVersion.VER_11_00_7462_6_V1 = SqlServerEngineVersion.of('11.00.7462.6.v1', '11.00');
/** Version "11.00.7493.4.v1". */
SqlServerEngineVersion.VER_11_00_7493_4_V1 = SqlServerEngineVersion.of('11.00.7493.4.v1', '11.00');
/** Version "12.00" (only a major version, without a specific minor version). */
SqlServerEngineVersion.VER_12 = SqlServerEngineVersion.of('12.00', '12.00');
/** Version "12.00.5000.0.v1". */
SqlServerEngineVersion.VER_12_00_5000_0_V1 = SqlServerEngineVersion.of('12.00.5000.0.v1', '12.00');
/** Version "12.00.5546.0.v1". */
SqlServerEngineVersion.VER_12_00_5546_0_V1 = SqlServerEngineVersion.of('12.00.5546.0.v1', '12.00');
/** Version "12.00.5571.0.v1". */
SqlServerEngineVersion.VER_12_00_5571_0_V1 = SqlServerEngineVersion.of('12.00.5571.0.v1', '12.00');
/** Version "12.00.6293.0.v1". */
SqlServerEngineVersion.VER_12_00_6293_0_V1 = SqlServerEngineVersion.of('12.00.6293.0.v1', '12.00');
/** Version "12.00.6329.1.v1". */
SqlServerEngineVersion.VER_12_00_6329_1_V1 = SqlServerEngineVersion.of('12.00.6329.1.v1', '12.00');
/** Version "13.00" (only a major version, without a specific minor version). */
SqlServerEngineVersion.VER_13 = SqlServerEngineVersion.of('13.00', '13.00');
/** Version "13.00.2164.0.v1". */
SqlServerEngineVersion.VER_13_00_2164_0_V1 = SqlServerEngineVersion.of('13.00.2164.0.v1', '13.00');
/** Version "13.00.4422.0.v1". */
SqlServerEngineVersion.VER_13_00_4422_0_V1 = SqlServerEngineVersion.of('13.00.4422.0.v1', '13.00');
/** Version "13.00.4451.0.v1". */
SqlServerEngineVersion.VER_13_00_4451_0_V1 = SqlServerEngineVersion.of('13.00.4451.0.v1', '13.00');
/** Version "13.00.4466.4.v1". */
SqlServerEngineVersion.VER_13_00_4466_4_V1 = SqlServerEngineVersion.of('13.00.4466.4.v1', '13.00');
/** Version "13.00.4522.0.v1". */
SqlServerEngineVersion.VER_13_00_4522_0_V1 = SqlServerEngineVersion.of('13.00.4522.0.v1', '13.00');
/** Version "13.00.5216.0.v1". */
SqlServerEngineVersion.VER_13_00_5216_0_V1 = SqlServerEngineVersion.of('13.00.5216.0.v1', '13.00');
/** Version "13.00.5292.0.v1". */
SqlServerEngineVersion.VER_13_00_5292_0_V1 = SqlServerEngineVersion.of('13.00.5292.0.v1', '13.00');
/** Version "13.00.5366.0.v1". */
SqlServerEngineVersion.VER_13_00_5366_0_V1 = SqlServerEngineVersion.of('13.00.5366.0.v1', '13.00');
/** Version "13.00.5426.0.v1". */
SqlServerEngineVersion.VER_13_00_5426_0_V1 = SqlServerEngineVersion.of('13.00.5426.0.v1', '13.00');
/** Version "13.00.5598.27.v1". */
SqlServerEngineVersion.VER_13_00_5598_27_V1 = SqlServerEngineVersion.of('13.00.5598.27.v1', '13.00');
/** Version "13.00.5820.21.v1". */
SqlServerEngineVersion.VER_13_00_5820_21_V1 = SqlServerEngineVersion.of('13.00.5820.21.v1', '13.00');
/** Version "13.00.5850.14.v1". */
SqlServerEngineVersion.VER_13_00_5850_14_V1 = SqlServerEngineVersion.of('13.00.5850.14.v1', '13.00');
/** Version "13.00.5882.1.v1". */
SqlServerEngineVersion.VER_13_00_5882_1_V1 = SqlServerEngineVersion.of('13.00.5882.1.v1', '13.00');
/** Version "14.00" (only a major version, without a specific minor version). */
SqlServerEngineVersion.VER_14 = SqlServerEngineVersion.of('14.00', '14.00');
/** Version "14.00.1000.169.v1". */
SqlServerEngineVersion.VER_14_00_1000_169_V1 = SqlServerEngineVersion.of('14.00.1000.169.v1', '14.00');
/** Version "14.00.3015.40.v1". */
SqlServerEngineVersion.VER_14_00_3015_40_V1 = SqlServerEngineVersion.of('14.00.3015.40.v1', '14.00');
/** Version "14.00.3035.2.v1". */
SqlServerEngineVersion.VER_14_00_3035_2_V1 = SqlServerEngineVersion.of('14.00.3035.2.v1', '14.00');
/** Version "14.00.3049.1.v1". */
SqlServerEngineVersion.VER_14_00_3049_1_V1 = SqlServerEngineVersion.of('14.00.3049.1.v1', '14.00');
/**
 * Version "14.00.3192.2.v1".
 * @deprecated SQL Server version 14.00.3192.2.v1 reached end of life
*/
SqlServerEngineVersion.VER_14_00_3192_2_V1 = SqlServerEngineVersion.of('14.00.3192.2.v1', '14.00');
/** Version "14.00.3223.3.v1". */
SqlServerEngineVersion.VER_14_00_3223_3_V1 = SqlServerEngineVersion.of('14.00.3223.3.v1', '14.00');
/** Version "14.00.3281.6.v1". */
SqlServerEngineVersion.VER_14_00_3281_6_V1 = SqlServerEngineVersion.of('14.00.3281.6.v1', '14.00');
/** Version "14.00.3294.2.v1". */
SqlServerEngineVersion.VER_14_00_3294_2_V1 = SqlServerEngineVersion.of('14.00.3294.2.v1', '14.00');
/** Version "14.00.3356.20.v1". */
SqlServerEngineVersion.VER_14_00_3356_20_V1 = SqlServerEngineVersion.of('14.00.3356.20.v1', '14.00');
/** Version "14.00.3381.3.v1". */
SqlServerEngineVersion.VER_14_00_3381_3_V1 = SqlServerEngineVersion.of('14.00.3381.3.v1', '14.00');
/** Version "15.00" (only a major version, without a specific minor version). */
SqlServerEngineVersion.VER_15 = SqlServerEngineVersion.of('15.00', '15.00');
/** Version "15.00.4043.16.v1". */
SqlServerEngineVersion.VER_15_00_4043_16_V1 = SqlServerEngineVersion.of('15.00.4043.16.v1', '15.00');
/**
 * Version "15.00.4043.23.v1".
 * @deprecated This version is erroneous. You might be looking for {@link SqlServerEngineVersion.VER_15_00_4073_23_V1}, instead.
 */
SqlServerEngineVersion.VER_15_00_4043_23_V1 = SqlServerEngineVersion.of('15.00.4043.23.v1', '15.00');
/** Version "15.00.4073.23.v1". */
SqlServerEngineVersion.VER_15_00_4073_23_V1 = SqlServerEngineVersion.of('15.00.4073.23.v1', '15.00');
class SqlServerInstanceEngineBase extends InstanceEngineBase {
    constructor(props) {
        super({
            ...props,
            singleUserRotationApplication: secretsmanager.SecretRotationApplication.SQLSERVER_ROTATION_SINGLE_USER,
            multiUserRotationApplication: secretsmanager.SecretRotationApplication.SQLSERVER_ROTATION_MULTI_USER,
            version: props.version
                ? {
                    fullVersion: props.version.sqlServerFullVersion,
                    majorVersion: props.version.sqlServerMajorVersion,
                }
                : undefined,
            parameterGroupFamily: props.version
                // for some reason, even though SQL Server major versions usually end in '.00',
                // the ParameterGroup family has to end in '.0'
                ? `${props.engineType}-${props.version.sqlServerMajorVersion.endsWith('.00')
                    ? props.version.sqlServerMajorVersion.slice(0, -1)
                    : props.version.sqlServerMajorVersion}`
                : undefined,
            features: {
                s3Import: 'S3_INTEGRATION',
                s3Export: 'S3_INTEGRATION',
            },
        });
    }
    bindToInstance(scope, options) {
        var _h;
        const config = super.bindToInstance(scope, options);
        let optionGroup = options.optionGroup;
        const s3Role = (_h = options.s3ImportRole) !== null && _h !== void 0 ? _h : options.s3ExportRole;
        if (s3Role) {
            if (options.s3ImportRole && options.s3ExportRole && options.s3ImportRole !== options.s3ExportRole) {
                throw new Error('S3 import and export roles must be the same for SQL Server engines');
            }
            if (!optionGroup) {
                optionGroup = new option_group_1.OptionGroup(scope, 'InstanceOptionGroup', {
                    engine: this,
                    configurations: [],
                });
            }
            // https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.Options.BackupRestore.html
            optionGroup.addConfiguration({
                name: 'SQLSERVER_BACKUP_RESTORE',
                settings: { IAM_ROLE_ARN: s3Role.roleArn },
            });
        }
        return {
            ...config,
            optionGroup,
        };
    }
    get supportsTimezone() { return true; }
}
class SqlServerSeInstanceEngine extends SqlServerInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'sqlserver-se',
            version,
        });
    }
}
class SqlServerExInstanceEngine extends SqlServerInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'sqlserver-ex',
            version,
        });
    }
}
class SqlServerWebInstanceEngine extends SqlServerInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'sqlserver-web',
            version,
        });
    }
}
class SqlServerEeInstanceEngine extends SqlServerInstanceEngineBase {
    constructor(version) {
        super({
            engineType: 'sqlserver-ee',
            version,
        });
    }
}
/**
 * A database instance engine. Provides mapping to DatabaseEngine used for
 * secret rotation.
 */
class DatabaseInstanceEngine {
    /** Creates a new MariaDB instance engine. */
    static mariaDb(props) {
        jsiiDeprecationWarnings.monocdk_aws_rds_MariaDbInstanceEngineProps(props);
        return new MariaDbInstanceEngine(props.version);
    }
    /** Creates a new MySQL instance engine. */
    static mysql(props) {
        jsiiDeprecationWarnings.monocdk_aws_rds_MySqlInstanceEngineProps(props);
        return new MySqlInstanceEngine(props.version);
    }
    /** Creates a new PostgreSQL instance engine. */
    static postgres(props) {
        jsiiDeprecationWarnings.monocdk_aws_rds_PostgresInstanceEngineProps(props);
        return new PostgresInstanceEngine(props.version);
    }
    /**
     * Creates a new Oracle Standard Edition instance engine.
     * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
     */
    static oracleSe(props) {
        jsiiDeprecationWarnings.print("monocdk.aws_rds.DatabaseInstanceEngine#oracleSe", "instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341");
        jsiiDeprecationWarnings.monocdk_aws_rds_OracleSeInstanceEngineProps(props);
        return new OracleSeInstanceEngine(props.version);
    }
    /**
     * Creates a new Oracle Standard Edition 1 instance engine.
     * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
     */
    static oracleSe1(props) {
        jsiiDeprecationWarnings.print("monocdk.aws_rds.DatabaseInstanceEngine#oracleSe1", "instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341");
        jsiiDeprecationWarnings.monocdk_aws_rds_OracleSe1InstanceEngineProps(props);
        return new OracleSe1InstanceEngine(props.version);
    }
    /** Creates a new Oracle Standard Edition 1 instance engine. */
    static oracleSe2(props) {
        jsiiDeprecationWarnings.monocdk_aws_rds_OracleSe2InstanceEngineProps(props);
        return new OracleSe2InstanceEngine(props.version);
    }
    /** Creates a new Oracle Enterprise Edition instance engine. */
    static oracleEe(props) {
        jsiiDeprecationWarnings.monocdk_aws_rds_OracleEeInstanceEngineProps(props);
        return new OracleEeInstanceEngine(props.version);
    }
    /** Creates a new SQL Server Standard Edition instance engine. */
    static sqlServerSe(props) {
        jsiiDeprecationWarnings.monocdk_aws_rds_SqlServerSeInstanceEngineProps(props);
        return new SqlServerSeInstanceEngine(props.version);
    }
    /** Creates a new SQL Server Express Edition instance engine. */
    static sqlServerEx(props) {
        jsiiDeprecationWarnings.monocdk_aws_rds_SqlServerExInstanceEngineProps(props);
        return new SqlServerExInstanceEngine(props.version);
    }
    /** Creates a new SQL Server Web Edition instance engine. */
    static sqlServerWeb(props) {
        jsiiDeprecationWarnings.monocdk_aws_rds_SqlServerWebInstanceEngineProps(props);
        return new SqlServerWebInstanceEngine(props.version);
    }
    /** Creates a new SQL Server Enterprise Edition instance engine. */
    static sqlServerEe(props) {
        jsiiDeprecationWarnings.monocdk_aws_rds_SqlServerEeInstanceEngineProps(props);
        return new SqlServerEeInstanceEngine(props.version);
    }
}
exports.DatabaseInstanceEngine = DatabaseInstanceEngine;
_g = JSII_RTTI_SYMBOL_1;
DatabaseInstanceEngine[_g] = { fqn: "monocdk.aws_rds.DatabaseInstanceEngine", version: "1.149.0" };
/**
 * The unversioned 'mariadb' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the {@link mariaDb()} method
 */
DatabaseInstanceEngine.MARIADB = new MariaDbInstanceEngine();
/**
 * The unversioned 'mysql' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the {@link mysql()} method
 */
DatabaseInstanceEngine.MYSQL = new MySqlInstanceEngine();
/**
 * The unversioned 'oracle-ee' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the {@link oracleEe()} method
 */
DatabaseInstanceEngine.ORACLE_EE = new OracleEeInstanceEngine();
/**
 * The unversioned 'oracle-se2' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the {@link oracleSe2()} method
 */
DatabaseInstanceEngine.ORACLE_SE2 = new OracleSe2InstanceEngine();
/**
 * The unversioned 'oracle-se1' instance engine.
 *
 * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
 */
DatabaseInstanceEngine.ORACLE_SE1 = new OracleSe1InstanceEngine();
/**
 * The unversioned 'oracle-se' instance engine.
 *
 * @deprecated instances can no longer be created with this engine. See https://forums.aws.amazon.com/ann.jspa?annID=7341
 */
DatabaseInstanceEngine.ORACLE_SE = new OracleSeInstanceEngine();
/**
 * The unversioned 'postgres' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the {@link postgres()} method
 */
DatabaseInstanceEngine.POSTGRES = new PostgresInstanceEngine();
/**
 * The unversioned 'sqlserver-ee' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the {@link sqlServerEe()} method
 */
DatabaseInstanceEngine.SQL_SERVER_EE = new SqlServerEeInstanceEngine();
/**
 * The unversioned 'sqlserver-se' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the {@link sqlServerSe()} method
 */
DatabaseInstanceEngine.SQL_SERVER_SE = new SqlServerSeInstanceEngine();
/**
 * The unversioned 'sqlserver-ex' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the {@link sqlServerEx()} method
 */
DatabaseInstanceEngine.SQL_SERVER_EX = new SqlServerExInstanceEngine();
/**
 * The unversioned 'sqlserver-web' instance engine.
 *
 * NOTE: using unversioned engines is an availability risk.
 *   We recommend using versioned engines created using the {@link sqlServerWeb()} method
 */
DatabaseInstanceEngine.SQL_SERVER_WEB = new SqlServerWebInstanceEngine();
//# sourceMappingURL=data:application/json;base64,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