"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const secretsmanager = require("../../aws-secretsmanager");
const core_1 = require("../../core");
const util_1 = require("./private/util");
/**
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends secretsmanager.Secret {
    constructor(scope, id, props) {
        var _b, _c;
        jsiiDeprecationWarnings.monocdk_aws_rds_DatabaseSecretProps(props);
        const excludeCharacters = (_b = props.excludeCharacters) !== null && _b !== void 0 ? _b : util_1.DEFAULT_PASSWORD_EXCLUDE_CHARS;
        super(scope, id, {
            encryptionKey: props.encryptionKey,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            secretName: props.secretName,
            generateSecretString: {
                passwordLength: 30,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: (_c = props.masterSecret) === null || _c === void 0 ? void 0 : _c.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters,
            },
            replicaRegions: props.replicaRegions,
        });
        if (props.replaceOnPasswordCriteriaChanges) {
            const hash = crypto.createHash('md5');
            hash.update(JSON.stringify({
                // Use here the options that influence the password generation.
                // If at some point we add other password customization options
                // they sould be added here below (e.g. `passwordLength`).
                excludeCharacters,
            }));
            const logicalId = `${core_1.Names.uniqueId(this)}${hash.digest('hex')}`;
            const secret = this.node.defaultChild;
            secret.overrideLogicalId(logicalId.slice(-255)); // Take last 255 chars
        }
    }
}
exports.DatabaseSecret = DatabaseSecret;
_a = JSII_RTTI_SYMBOL_1;
DatabaseSecret[_a] = { fqn: "monocdk.aws_rds.DatabaseSecret", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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