"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EngineVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * OpenSearch version
 */
class EngineVersion {
    /**
     * @param version engine version identifier
     */
    constructor(version) {
        this.version = version;
    }
    /**
     * Custom ElasticSearch version
     * @param version custom version number
     */
    static elasticsearch(version) { return new EngineVersion(`Elasticsearch_${version}`); }
    /**
     * Custom OpenSearch version
     * @param version custom version number
     */
    static openSearch(version) { return new EngineVersion(`OpenSearch_${version}`); }
}
exports.EngineVersion = EngineVersion;
_a = JSII_RTTI_SYMBOL_1;
EngineVersion[_a] = { fqn: "monocdk.aws_opensearchservice.EngineVersion", version: "1.149.0" };
/** AWS Elasticsearch 1.5 */
EngineVersion.ELASTICSEARCH_1_5 = EngineVersion.elasticsearch('1.5');
/** AWS Elasticsearch 2.3 */
EngineVersion.ELASTICSEARCH_2_3 = EngineVersion.elasticsearch('2.3');
/** AWS Elasticsearch 5.1 */
EngineVersion.ELASTICSEARCH_5_1 = EngineVersion.elasticsearch('5.1');
/** AWS Elasticsearch 5.3 */
EngineVersion.ELASTICSEARCH_5_3 = EngineVersion.elasticsearch('5.3');
/** AWS Elasticsearch 5.5 */
EngineVersion.ELASTICSEARCH_5_5 = EngineVersion.elasticsearch('5.5');
/** AWS Elasticsearch 5.6 */
EngineVersion.ELASTICSEARCH_5_6 = EngineVersion.elasticsearch('5.6');
/** AWS Elasticsearch 6.0 */
EngineVersion.ELASTICSEARCH_6_0 = EngineVersion.elasticsearch('6.0');
/** AWS Elasticsearch 6.2 */
EngineVersion.ELASTICSEARCH_6_2 = EngineVersion.elasticsearch('6.2');
/** AWS Elasticsearch 6.3 */
EngineVersion.ELASTICSEARCH_6_3 = EngineVersion.elasticsearch('6.3');
/** AWS Elasticsearch 6.4 */
EngineVersion.ELASTICSEARCH_6_4 = EngineVersion.elasticsearch('6.4');
/** AWS Elasticsearch 6.5 */
EngineVersion.ELASTICSEARCH_6_5 = EngineVersion.elasticsearch('6.5');
/** AWS Elasticsearch 6.7 */
EngineVersion.ELASTICSEARCH_6_7 = EngineVersion.elasticsearch('6.7');
/** AWS Elasticsearch 6.8 */
EngineVersion.ELASTICSEARCH_6_8 = EngineVersion.elasticsearch('6.8');
/** AWS Elasticsearch 7.1 */
EngineVersion.ELASTICSEARCH_7_1 = EngineVersion.elasticsearch('7.1');
/** AWS Elasticsearch 7.4 */
EngineVersion.ELASTICSEARCH_7_4 = EngineVersion.elasticsearch('7.4');
/** AWS Elasticsearch 7.7 */
EngineVersion.ELASTICSEARCH_7_7 = EngineVersion.elasticsearch('7.7');
/** AWS Elasticsearch 7.8 */
EngineVersion.ELASTICSEARCH_7_8 = EngineVersion.elasticsearch('7.8');
/** AWS Elasticsearch 7.9 */
EngineVersion.ELASTICSEARCH_7_9 = EngineVersion.elasticsearch('7.9');
/** AWS Elasticsearch 7.10 */
EngineVersion.ELASTICSEARCH_7_10 = EngineVersion.elasticsearch('7.10');
/** AWS OpenSearch 1.0 */
EngineVersion.OPENSEARCH_1_0 = EngineVersion.openSearch('1.0');
/** AWS OpenSearch 1.1 */
EngineVersion.OPENSEARCH_1_1 = EngineVersion.openSearch('1.1');
//# sourceMappingURL=data:application/json;base64,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