"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseInstance = exports.InstanceType = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("../../aws-ec2");
const cdk = require("../../core");
const endpoint_1 = require("./endpoint");
const neptune_generated_1 = require("./neptune.generated");
/**
 * Possible Instances Types to use in Neptune cluster
 * used for defining {@link DatabaseInstanceProps.instanceType}.
 */
class InstanceType {
    constructor(instanceType) {
        if (cdk.Token.isUnresolved(instanceType) || instanceType.startsWith('db.')) {
            this._instanceType = instanceType;
        }
        else {
            throw new Error(`instance type must start with 'db.'; (got ${instanceType})`);
        }
    }
    /**
     * Build an InstanceType from given string or token, such as CfnParameter.
     */
    static of(instanceType) {
        return new InstanceType(instanceType);
    }
}
exports.InstanceType = InstanceType;
_a = JSII_RTTI_SYMBOL_1;
InstanceType[_a] = { fqn: "monocdk.aws_neptune.InstanceType", version: "1.149.0" };
/**
 * db.r6g.large
 */
InstanceType.R6G_LARGE = InstanceType.of('db.r6g.large');
/**
 * db.r6g.xlarge
 */
InstanceType.R6G_XLARGE = InstanceType.of('db.r6g.xlarge');
/**
 * db.r6g.2xlarge
 */
InstanceType.R6G_2XLARGE = InstanceType.of('db.r6g.2xlarge');
/**
 * db.r6g.4xlarge
 */
InstanceType.R6G_4XLARGE = InstanceType.of('db.r6g.4xlarge');
/**
 * db.r6g.8xlarge
 */
InstanceType.R6G_8XLARGE = InstanceType.of('db.r6g.8xlarge');
/**
* db.r6g.12xlarge
*/
InstanceType.R6G_12XLARGE = InstanceType.of('db.r6g.12xlarge');
/**
 * db.r6g.16xlarge
 */
InstanceType.R6G_16XLARGE = InstanceType.of('db.r6g.16xlarge');
/**
 * db.t4g.medium
 */
InstanceType.T4G_MEDIUM = InstanceType.of('db.t4g.medium');
/**
 * db.r5.large
 */
InstanceType.R5_LARGE = InstanceType.of('db.r5.large');
/**
 * db.r5.xlarge
 */
InstanceType.R5_XLARGE = InstanceType.of('db.r5.xlarge');
/**
 * db.r5.2xlarge
 */
InstanceType.R5_2XLARGE = InstanceType.of('db.r5.2xlarge');
/**
 * db.r5.4xlarge
 */
InstanceType.R5_4XLARGE = InstanceType.of('db.r5.4xlarge');
/**
 * db.r5.8xlarge
 */
InstanceType.R5_8XLARGE = InstanceType.of('db.r5.8xlarge');
/**
 * db.r5.12xlarge
 */
InstanceType.R5_12XLARGE = InstanceType.of('db.r5.12xlarge');
/**
 * db.r5.24xlarge
 */
InstanceType.R5_24XLARGE = InstanceType.of('db.r5.24xlarge');
/**
 * db.r4.large
 */
InstanceType.R4_LARGE = InstanceType.of('db.r4.large');
/**
 * db.r4.xlarge
 */
InstanceType.R4_XLARGE = InstanceType.of('db.r4.xlarge');
/**
 * db.r4.2xlarge
 */
InstanceType.R4_2XLARGE = InstanceType.of('db.r4.2xlarge');
/**
 * db.r4.4xlarge
 */
InstanceType.R4_4XLARGE = InstanceType.of('db.r4.4xlarge');
/**
 * db.r4.8xlarge
 */
InstanceType.R4_8XLARGE = InstanceType.of('db.r4.8xlarge');
/**
 * db.t3.medium
 */
InstanceType.T3_MEDIUM = InstanceType.of('db.t3.medium');
/**
 * A database instance
 *
 * @resource AWS::Neptune::DBInstance
 */
class DatabaseInstance extends cdk.Resource {
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_neptune_DatabaseInstanceProps(props);
        const instance = new neptune_generated_1.CfnDBInstance(this, 'Resource', {
            dbClusterIdentifier: props.cluster.clusterIdentifier,
            dbInstanceClass: props.instanceType._instanceType,
            availabilityZone: props.availabilityZone,
            dbInstanceIdentifier: props.dbInstanceName,
            dbParameterGroupName: (_c = props.parameterGroup) === null || _c === void 0 ? void 0 : _c.parameterGroupName,
        });
        this.cluster = props.cluster;
        this.instanceIdentifier = instance.ref;
        this.dbInstanceEndpointAddress = instance.attrEndpoint;
        this.dbInstanceEndpointPort = instance.attrPort;
        // create a number token that represents the port of the instance
        const portAttribute = cdk.Token.asNumber(instance.attrPort);
        this.instanceEndpoint = new endpoint_1.Endpoint(instance.attrEndpoint, portAttribute);
        instance.applyRemovalPolicy(props.removalPolicy, {
            applyToUpdateReplacePolicy: true,
        });
    }
    /**
     * Import an existing database instance.
     */
    static fromDatabaseInstanceAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings.monocdk_aws_neptune_DatabaseInstanceAttributes(attrs);
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.defaultPort = ec2.Port.tcp(attrs.port);
                this.instanceIdentifier = attrs.instanceIdentifier;
                this.dbInstanceEndpointAddress = attrs.instanceEndpointAddress;
                this.dbInstanceEndpointPort = attrs.port.toString();
                this.instanceEndpoint = new endpoint_1.Endpoint(attrs.instanceEndpointAddress, attrs.port);
            }
        }
        return new Import(scope, id);
    }
}
exports.DatabaseInstance = DatabaseInstance;
_b = JSII_RTTI_SYMBOL_1;
DatabaseInstance[_b] = { fqn: "monocdk.aws_neptune.DatabaseInstance", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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