"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnEnvironment = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:32:06.807Z","fingerprint":"+MItD5f2J250UBgaP3YryLMOfzwZ/EH69HC9gZD06j4="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnEnvironmentProps`
 *
 * @param properties - the TypeScript properties of a `CfnEnvironmentProps`
 *
 * @returns the result of the validation.
 */
function CfnEnvironmentPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('airflowConfigurationOptions', cdk.validateObject)(properties.airflowConfigurationOptions));
    errors.collect(cdk.propertyValidator('airflowVersion', cdk.validateString)(properties.airflowVersion));
    errors.collect(cdk.propertyValidator('dagS3Path', cdk.validateString)(properties.dagS3Path));
    errors.collect(cdk.propertyValidator('environmentClass', cdk.validateString)(properties.environmentClass));
    errors.collect(cdk.propertyValidator('executionRoleArn', cdk.validateString)(properties.executionRoleArn));
    errors.collect(cdk.propertyValidator('kmsKey', cdk.validateString)(properties.kmsKey));
    errors.collect(cdk.propertyValidator('loggingConfiguration', CfnEnvironment_LoggingConfigurationPropertyValidator)(properties.loggingConfiguration));
    errors.collect(cdk.propertyValidator('maxWorkers', cdk.validateNumber)(properties.maxWorkers));
    errors.collect(cdk.propertyValidator('minWorkers', cdk.validateNumber)(properties.minWorkers));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('networkConfiguration', CfnEnvironment_NetworkConfigurationPropertyValidator)(properties.networkConfiguration));
    errors.collect(cdk.propertyValidator('pluginsS3ObjectVersion', cdk.validateString)(properties.pluginsS3ObjectVersion));
    errors.collect(cdk.propertyValidator('pluginsS3Path', cdk.validateString)(properties.pluginsS3Path));
    errors.collect(cdk.propertyValidator('requirementsS3ObjectVersion', cdk.validateString)(properties.requirementsS3ObjectVersion));
    errors.collect(cdk.propertyValidator('requirementsS3Path', cdk.validateString)(properties.requirementsS3Path));
    errors.collect(cdk.propertyValidator('schedulers', cdk.validateNumber)(properties.schedulers));
    errors.collect(cdk.propertyValidator('sourceBucketArn', cdk.validateString)(properties.sourceBucketArn));
    errors.collect(cdk.propertyValidator('tags', cdk.validateObject)(properties.tags));
    errors.collect(cdk.propertyValidator('webserverAccessMode', cdk.validateString)(properties.webserverAccessMode));
    errors.collect(cdk.propertyValidator('weeklyMaintenanceWindowStart', cdk.validateString)(properties.weeklyMaintenanceWindowStart));
    return errors.wrap('supplied properties not correct for "CfnEnvironmentProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MWAA::Environment` resource
 *
 * @param properties - the TypeScript properties of a `CfnEnvironmentProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MWAA::Environment` resource.
 */
// @ts-ignore TS6133
function cfnEnvironmentPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEnvironmentPropsValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        AirflowConfigurationOptions: cdk.objectToCloudFormation(properties.airflowConfigurationOptions),
        AirflowVersion: cdk.stringToCloudFormation(properties.airflowVersion),
        DagS3Path: cdk.stringToCloudFormation(properties.dagS3Path),
        EnvironmentClass: cdk.stringToCloudFormation(properties.environmentClass),
        ExecutionRoleArn: cdk.stringToCloudFormation(properties.executionRoleArn),
        KmsKey: cdk.stringToCloudFormation(properties.kmsKey),
        LoggingConfiguration: cfnEnvironmentLoggingConfigurationPropertyToCloudFormation(properties.loggingConfiguration),
        MaxWorkers: cdk.numberToCloudFormation(properties.maxWorkers),
        MinWorkers: cdk.numberToCloudFormation(properties.minWorkers),
        NetworkConfiguration: cfnEnvironmentNetworkConfigurationPropertyToCloudFormation(properties.networkConfiguration),
        PluginsS3ObjectVersion: cdk.stringToCloudFormation(properties.pluginsS3ObjectVersion),
        PluginsS3Path: cdk.stringToCloudFormation(properties.pluginsS3Path),
        RequirementsS3ObjectVersion: cdk.stringToCloudFormation(properties.requirementsS3ObjectVersion),
        RequirementsS3Path: cdk.stringToCloudFormation(properties.requirementsS3Path),
        Schedulers: cdk.numberToCloudFormation(properties.schedulers),
        SourceBucketArn: cdk.stringToCloudFormation(properties.sourceBucketArn),
        Tags: cdk.objectToCloudFormation(properties.tags),
        WebserverAccessMode: cdk.stringToCloudFormation(properties.webserverAccessMode),
        WeeklyMaintenanceWindowStart: cdk.stringToCloudFormation(properties.weeklyMaintenanceWindowStart),
    };
}
// @ts-ignore TS6133
function CfnEnvironmentPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('airflowConfigurationOptions', 'AirflowConfigurationOptions', properties.AirflowConfigurationOptions != null ? cfn_parse.FromCloudFormation.getAny(properties.AirflowConfigurationOptions) : undefined);
    ret.addPropertyResult('airflowVersion', 'AirflowVersion', properties.AirflowVersion != null ? cfn_parse.FromCloudFormation.getString(properties.AirflowVersion) : undefined);
    ret.addPropertyResult('dagS3Path', 'DagS3Path', properties.DagS3Path != null ? cfn_parse.FromCloudFormation.getString(properties.DagS3Path) : undefined);
    ret.addPropertyResult('environmentClass', 'EnvironmentClass', properties.EnvironmentClass != null ? cfn_parse.FromCloudFormation.getString(properties.EnvironmentClass) : undefined);
    ret.addPropertyResult('executionRoleArn', 'ExecutionRoleArn', properties.ExecutionRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ExecutionRoleArn) : undefined);
    ret.addPropertyResult('kmsKey', 'KmsKey', properties.KmsKey != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKey) : undefined);
    ret.addPropertyResult('loggingConfiguration', 'LoggingConfiguration', properties.LoggingConfiguration != null ? CfnEnvironmentLoggingConfigurationPropertyFromCloudFormation(properties.LoggingConfiguration) : undefined);
    ret.addPropertyResult('maxWorkers', 'MaxWorkers', properties.MaxWorkers != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxWorkers) : undefined);
    ret.addPropertyResult('minWorkers', 'MinWorkers', properties.MinWorkers != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinWorkers) : undefined);
    ret.addPropertyResult('networkConfiguration', 'NetworkConfiguration', properties.NetworkConfiguration != null ? CfnEnvironmentNetworkConfigurationPropertyFromCloudFormation(properties.NetworkConfiguration) : undefined);
    ret.addPropertyResult('pluginsS3ObjectVersion', 'PluginsS3ObjectVersion', properties.PluginsS3ObjectVersion != null ? cfn_parse.FromCloudFormation.getString(properties.PluginsS3ObjectVersion) : undefined);
    ret.addPropertyResult('pluginsS3Path', 'PluginsS3Path', properties.PluginsS3Path != null ? cfn_parse.FromCloudFormation.getString(properties.PluginsS3Path) : undefined);
    ret.addPropertyResult('requirementsS3ObjectVersion', 'RequirementsS3ObjectVersion', properties.RequirementsS3ObjectVersion != null ? cfn_parse.FromCloudFormation.getString(properties.RequirementsS3ObjectVersion) : undefined);
    ret.addPropertyResult('requirementsS3Path', 'RequirementsS3Path', properties.RequirementsS3Path != null ? cfn_parse.FromCloudFormation.getString(properties.RequirementsS3Path) : undefined);
    ret.addPropertyResult('schedulers', 'Schedulers', properties.Schedulers != null ? cfn_parse.FromCloudFormation.getNumber(properties.Schedulers) : undefined);
    ret.addPropertyResult('sourceBucketArn', 'SourceBucketArn', properties.SourceBucketArn != null ? cfn_parse.FromCloudFormation.getString(properties.SourceBucketArn) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getAny(properties.Tags) : undefined);
    ret.addPropertyResult('webserverAccessMode', 'WebserverAccessMode', properties.WebserverAccessMode != null ? cfn_parse.FromCloudFormation.getString(properties.WebserverAccessMode) : undefined);
    ret.addPropertyResult('weeklyMaintenanceWindowStart', 'WeeklyMaintenanceWindowStart', properties.WeeklyMaintenanceWindowStart != null ? cfn_parse.FromCloudFormation.getString(properties.WeeklyMaintenanceWindowStart) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::MWAA::Environment`
 *
 * The `AWS::MWAA::Environment` resource creates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 *
 * @cloudformationResource AWS::MWAA::Environment
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html
 */
class CfnEnvironment extends cdk.CfnResource {
    /**
     * Create a new `AWS::MWAA::Environment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnEnvironment.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_mwaa_CfnEnvironmentProps(props);
        cdk.requireProperty(props, 'name', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrLoggingConfigurationDagProcessingLogsCloudWatchLogGroupArn = cdk.Token.asString(this.getAtt('LoggingConfiguration.DagProcessingLogs.CloudWatchLogGroupArn'));
        this.attrLoggingConfigurationSchedulerLogsCloudWatchLogGroupArn = cdk.Token.asString(this.getAtt('LoggingConfiguration.SchedulerLogs.CloudWatchLogGroupArn'));
        this.attrLoggingConfigurationTaskLogsCloudWatchLogGroupArn = cdk.Token.asString(this.getAtt('LoggingConfiguration.TaskLogs.CloudWatchLogGroupArn'));
        this.attrLoggingConfigurationWebserverLogsCloudWatchLogGroupArn = cdk.Token.asString(this.getAtt('LoggingConfiguration.WebserverLogs.CloudWatchLogGroupArn'));
        this.attrLoggingConfigurationWorkerLogsCloudWatchLogGroupArn = cdk.Token.asString(this.getAtt('LoggingConfiguration.WorkerLogs.CloudWatchLogGroupArn'));
        this.attrWebserverUrl = cdk.Token.asString(this.getAtt('WebserverUrl'));
        this.name = props.name;
        this.airflowConfigurationOptions = props.airflowConfigurationOptions;
        this.airflowVersion = props.airflowVersion;
        this.dagS3Path = props.dagS3Path;
        this.environmentClass = props.environmentClass;
        this.executionRoleArn = props.executionRoleArn;
        this.kmsKey = props.kmsKey;
        this.loggingConfiguration = props.loggingConfiguration;
        this.maxWorkers = props.maxWorkers;
        this.minWorkers = props.minWorkers;
        this.networkConfiguration = props.networkConfiguration;
        this.pluginsS3ObjectVersion = props.pluginsS3ObjectVersion;
        this.pluginsS3Path = props.pluginsS3Path;
        this.requirementsS3ObjectVersion = props.requirementsS3ObjectVersion;
        this.requirementsS3Path = props.requirementsS3Path;
        this.schedulers = props.schedulers;
        this.sourceBucketArn = props.sourceBucketArn;
        this.tags = new cdk.TagManager(cdk.TagType.MAP, "AWS::MWAA::Environment", props.tags, { tagPropertyName: 'tags' });
        this.webserverAccessMode = props.webserverAccessMode;
        this.weeklyMaintenanceWindowStart = props.weeklyMaintenanceWindowStart;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEnvironmentPropsFromCloudFormation(resourceProperties);
        const ret = new CfnEnvironment(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEnvironment.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            name: this.name,
            airflowConfigurationOptions: this.airflowConfigurationOptions,
            airflowVersion: this.airflowVersion,
            dagS3Path: this.dagS3Path,
            environmentClass: this.environmentClass,
            executionRoleArn: this.executionRoleArn,
            kmsKey: this.kmsKey,
            loggingConfiguration: this.loggingConfiguration,
            maxWorkers: this.maxWorkers,
            minWorkers: this.minWorkers,
            networkConfiguration: this.networkConfiguration,
            pluginsS3ObjectVersion: this.pluginsS3ObjectVersion,
            pluginsS3Path: this.pluginsS3Path,
            requirementsS3ObjectVersion: this.requirementsS3ObjectVersion,
            requirementsS3Path: this.requirementsS3Path,
            schedulers: this.schedulers,
            sourceBucketArn: this.sourceBucketArn,
            tags: this.tags.renderTags(),
            webserverAccessMode: this.webserverAccessMode,
            weeklyMaintenanceWindowStart: this.weeklyMaintenanceWindowStart,
        };
    }
    renderProperties(props) {
        return cfnEnvironmentPropsToCloudFormation(props);
    }
}
exports.CfnEnvironment = CfnEnvironment;
_a = JSII_RTTI_SYMBOL_1;
CfnEnvironment[_a] = { fqn: "monocdk.aws_mwaa.CfnEnvironment", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEnvironment.CFN_RESOURCE_TYPE_NAME = "AWS::MWAA::Environment";
/**
 * Determine whether the given properties match those of a `LoggingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LoggingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnEnvironment_LoggingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dagProcessingLogs', CfnEnvironment_ModuleLoggingConfigurationPropertyValidator)(properties.dagProcessingLogs));
    errors.collect(cdk.propertyValidator('schedulerLogs', CfnEnvironment_ModuleLoggingConfigurationPropertyValidator)(properties.schedulerLogs));
    errors.collect(cdk.propertyValidator('taskLogs', CfnEnvironment_ModuleLoggingConfigurationPropertyValidator)(properties.taskLogs));
    errors.collect(cdk.propertyValidator('webserverLogs', CfnEnvironment_ModuleLoggingConfigurationPropertyValidator)(properties.webserverLogs));
    errors.collect(cdk.propertyValidator('workerLogs', CfnEnvironment_ModuleLoggingConfigurationPropertyValidator)(properties.workerLogs));
    return errors.wrap('supplied properties not correct for "LoggingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MWAA::Environment.LoggingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LoggingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MWAA::Environment.LoggingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnEnvironmentLoggingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEnvironment_LoggingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DagProcessingLogs: cfnEnvironmentModuleLoggingConfigurationPropertyToCloudFormation(properties.dagProcessingLogs),
        SchedulerLogs: cfnEnvironmentModuleLoggingConfigurationPropertyToCloudFormation(properties.schedulerLogs),
        TaskLogs: cfnEnvironmentModuleLoggingConfigurationPropertyToCloudFormation(properties.taskLogs),
        WebserverLogs: cfnEnvironmentModuleLoggingConfigurationPropertyToCloudFormation(properties.webserverLogs),
        WorkerLogs: cfnEnvironmentModuleLoggingConfigurationPropertyToCloudFormation(properties.workerLogs),
    };
}
// @ts-ignore TS6133
function CfnEnvironmentLoggingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dagProcessingLogs', 'DagProcessingLogs', properties.DagProcessingLogs != null ? CfnEnvironmentModuleLoggingConfigurationPropertyFromCloudFormation(properties.DagProcessingLogs) : undefined);
    ret.addPropertyResult('schedulerLogs', 'SchedulerLogs', properties.SchedulerLogs != null ? CfnEnvironmentModuleLoggingConfigurationPropertyFromCloudFormation(properties.SchedulerLogs) : undefined);
    ret.addPropertyResult('taskLogs', 'TaskLogs', properties.TaskLogs != null ? CfnEnvironmentModuleLoggingConfigurationPropertyFromCloudFormation(properties.TaskLogs) : undefined);
    ret.addPropertyResult('webserverLogs', 'WebserverLogs', properties.WebserverLogs != null ? CfnEnvironmentModuleLoggingConfigurationPropertyFromCloudFormation(properties.WebserverLogs) : undefined);
    ret.addPropertyResult('workerLogs', 'WorkerLogs', properties.WorkerLogs != null ? CfnEnvironmentModuleLoggingConfigurationPropertyFromCloudFormation(properties.WorkerLogs) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ModuleLoggingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ModuleLoggingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnEnvironment_ModuleLoggingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchLogGroupArn', cdk.validateString)(properties.cloudWatchLogGroupArn));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('logLevel', cdk.validateString)(properties.logLevel));
    return errors.wrap('supplied properties not correct for "ModuleLoggingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MWAA::Environment.ModuleLoggingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ModuleLoggingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MWAA::Environment.ModuleLoggingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnEnvironmentModuleLoggingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEnvironment_ModuleLoggingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchLogGroupArn: cdk.stringToCloudFormation(properties.cloudWatchLogGroupArn),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        LogLevel: cdk.stringToCloudFormation(properties.logLevel),
    };
}
// @ts-ignore TS6133
function CfnEnvironmentModuleLoggingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cloudWatchLogGroupArn', 'CloudWatchLogGroupArn', properties.CloudWatchLogGroupArn != null ? cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogGroupArn) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('logLevel', 'LogLevel', properties.LogLevel != null ? cfn_parse.FromCloudFormation.getString(properties.LogLevel) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnEnvironment_NetworkConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    return errors.wrap('supplied properties not correct for "NetworkConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MWAA::Environment.NetworkConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NetworkConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MWAA::Environment.NetworkConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnEnvironmentNetworkConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEnvironment_NetworkConfigurationPropertyValidator(properties).assertSuccess();
    return {
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
    };
}
// @ts-ignore TS6133
function CfnEnvironmentNetworkConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('securityGroupIds', 'SecurityGroupIds', properties.SecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds) : undefined);
    ret.addPropertyResult('subnetIds', 'SubnetIds', properties.SubnetIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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