"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnInferenceScheduler = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:31:27.131Z","fingerprint":"eC5oJSk/nN7ZfN2xgVOXQJnxOKGC1iW9293D63WanUo="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnInferenceSchedulerProps`
 *
 * @param properties - the TypeScript properties of a `CfnInferenceSchedulerProps`
 *
 * @returns the result of the validation.
 */
function CfnInferenceSchedulerPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dataDelayOffsetInMinutes', cdk.validateNumber)(properties.dataDelayOffsetInMinutes));
    errors.collect(cdk.propertyValidator('dataInputConfiguration', cdk.requiredValidator)(properties.dataInputConfiguration));
    errors.collect(cdk.propertyValidator('dataInputConfiguration', cdk.validateObject)(properties.dataInputConfiguration));
    errors.collect(cdk.propertyValidator('dataOutputConfiguration', cdk.requiredValidator)(properties.dataOutputConfiguration));
    errors.collect(cdk.propertyValidator('dataOutputConfiguration', cdk.validateObject)(properties.dataOutputConfiguration));
    errors.collect(cdk.propertyValidator('dataUploadFrequency', cdk.requiredValidator)(properties.dataUploadFrequency));
    errors.collect(cdk.propertyValidator('dataUploadFrequency', cdk.validateString)(properties.dataUploadFrequency));
    errors.collect(cdk.propertyValidator('inferenceSchedulerName', cdk.validateString)(properties.inferenceSchedulerName));
    errors.collect(cdk.propertyValidator('modelName', cdk.requiredValidator)(properties.modelName));
    errors.collect(cdk.propertyValidator('modelName', cdk.validateString)(properties.modelName));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('serverSideKmsKeyId', cdk.validateString)(properties.serverSideKmsKeyId));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnInferenceSchedulerProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::LookoutEquipment::InferenceScheduler` resource
 *
 * @param properties - the TypeScript properties of a `CfnInferenceSchedulerProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::LookoutEquipment::InferenceScheduler` resource.
 */
// @ts-ignore TS6133
function cfnInferenceSchedulerPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnInferenceSchedulerPropsValidator(properties).assertSuccess();
    return {
        DataInputConfiguration: cdk.objectToCloudFormation(properties.dataInputConfiguration),
        DataOutputConfiguration: cdk.objectToCloudFormation(properties.dataOutputConfiguration),
        DataUploadFrequency: cdk.stringToCloudFormation(properties.dataUploadFrequency),
        ModelName: cdk.stringToCloudFormation(properties.modelName),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        DataDelayOffsetInMinutes: cdk.numberToCloudFormation(properties.dataDelayOffsetInMinutes),
        InferenceSchedulerName: cdk.stringToCloudFormation(properties.inferenceSchedulerName),
        ServerSideKmsKeyId: cdk.stringToCloudFormation(properties.serverSideKmsKeyId),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnInferenceSchedulerPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dataInputConfiguration', 'DataInputConfiguration', cfn_parse.FromCloudFormation.getAny(properties.DataInputConfiguration));
    ret.addPropertyResult('dataOutputConfiguration', 'DataOutputConfiguration', cfn_parse.FromCloudFormation.getAny(properties.DataOutputConfiguration));
    ret.addPropertyResult('dataUploadFrequency', 'DataUploadFrequency', cfn_parse.FromCloudFormation.getString(properties.DataUploadFrequency));
    ret.addPropertyResult('modelName', 'ModelName', cfn_parse.FromCloudFormation.getString(properties.ModelName));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('dataDelayOffsetInMinutes', 'DataDelayOffsetInMinutes', properties.DataDelayOffsetInMinutes != null ? cfn_parse.FromCloudFormation.getNumber(properties.DataDelayOffsetInMinutes) : undefined);
    ret.addPropertyResult('inferenceSchedulerName', 'InferenceSchedulerName', properties.InferenceSchedulerName != null ? cfn_parse.FromCloudFormation.getString(properties.InferenceSchedulerName) : undefined);
    ret.addPropertyResult('serverSideKmsKeyId', 'ServerSideKmsKeyId', properties.ServerSideKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.ServerSideKmsKeyId) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::LookoutEquipment::InferenceScheduler`
 *
 * Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to analyze new measurement data. When setting up the schedule, you provide an Amazon S3 bucket location for the input data, assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency of inferencing. You must also provide an Amazon S3 bucket location for the output data.
 *
 * > Updating some properties below (for example, InferenceSchedulerName and ServerSideKmsKeyId) triggers a resource replacement, which requires a new model. To replace such a property using AWS CloudFormation , but without creating a completely new stack, you must replace ModelName. If you need to replace the property, but want to use the same model, delete the current stack and create a new one with the updated properties.
 *
 * @cloudformationResource AWS::LookoutEquipment::InferenceScheduler
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html
 */
class CfnInferenceScheduler extends cdk.CfnResource {
    /**
     * Create a new `AWS::LookoutEquipment::InferenceScheduler`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnInferenceScheduler.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_lookoutequipment_CfnInferenceSchedulerProps(props);
        cdk.requireProperty(props, 'dataInputConfiguration', this);
        cdk.requireProperty(props, 'dataOutputConfiguration', this);
        cdk.requireProperty(props, 'dataUploadFrequency', this);
        cdk.requireProperty(props, 'modelName', this);
        cdk.requireProperty(props, 'roleArn', this);
        this.attrInferenceSchedulerArn = cdk.Token.asString(this.getAtt('InferenceSchedulerArn'));
        this.dataInputConfiguration = props.dataInputConfiguration;
        this.dataOutputConfiguration = props.dataOutputConfiguration;
        this.dataUploadFrequency = props.dataUploadFrequency;
        this.modelName = props.modelName;
        this.roleArn = props.roleArn;
        this.dataDelayOffsetInMinutes = props.dataDelayOffsetInMinutes;
        this.inferenceSchedulerName = props.inferenceSchedulerName;
        this.serverSideKmsKeyId = props.serverSideKmsKeyId;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::LookoutEquipment::InferenceScheduler", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnInferenceSchedulerPropsFromCloudFormation(resourceProperties);
        const ret = new CfnInferenceScheduler(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnInferenceScheduler.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            dataInputConfiguration: this.dataInputConfiguration,
            dataOutputConfiguration: this.dataOutputConfiguration,
            dataUploadFrequency: this.dataUploadFrequency,
            modelName: this.modelName,
            roleArn: this.roleArn,
            dataDelayOffsetInMinutes: this.dataDelayOffsetInMinutes,
            inferenceSchedulerName: this.inferenceSchedulerName,
            serverSideKmsKeyId: this.serverSideKmsKeyId,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnInferenceSchedulerPropsToCloudFormation(props);
    }
}
exports.CfnInferenceScheduler = CfnInferenceScheduler;
_a = JSII_RTTI_SYMBOL_1;
CfnInferenceScheduler[_a] = { fqn: "monocdk.aws_lookoutequipment.CfnInferenceScheduler", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnInferenceScheduler.CFN_RESOURCE_TYPE_NAME = "AWS::LookoutEquipment::InferenceScheduler";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9va291dGVxdWlwbWVudC5nZW5lcmF0ZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb29rb3V0ZXF1aXBtZW50LmdlbmVyYXRlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSwrRUFBK0U7QUFDL0UsK0RBQStEO0FBQy9ELDhGQUE4RjtBQUM5RixzSEFBc0g7QUFFdEgsNEJBQTRCLENBQUMsaUVBQWlFO0FBRTlGLGtDQUFrQztBQUNsQyxzREFBc0Q7QUE4RXREOzs7Ozs7R0FNRztBQUNILFNBQVMsbUNBQW1DLENBQUMsVUFBZTtJQUN4RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUM7SUFDM0gsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsd0JBQXdCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQztJQUMxSCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx3QkFBd0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQztJQUN2SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx5QkFBeUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxDQUFDO0lBQzVILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxDQUFDO0lBQ3pILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDcEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMscUJBQXFCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDakgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsd0JBQXdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLENBQUM7SUFDdkgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDO0lBQ2hHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDN0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzVGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7SUFDekYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDL0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDdEcsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLGtFQUFrRSxDQUFDLENBQUM7QUFDM0YsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDBDQUEwQyxDQUFDLFVBQWU7SUFDL0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELG1DQUFtQyxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2hFLE9BQU87UUFDSCxzQkFBc0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDO1FBQ3JGLHVCQUF1QixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUM7UUFDdkYsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQztRQUMvRSxTQUFTLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUM7UUFDM0QsT0FBTyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO1FBQ3ZELHdCQUF3QixFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUM7UUFDekYsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxzQkFBc0IsQ0FBQztRQUNyRixrQkFBa0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDO1FBQzdFLElBQUksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEUsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw0Q0FBNEMsQ0FBQyxVQUFlO0lBQ2pFLFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQThCLENBQUM7SUFDekYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHdCQUF3QixFQUFFLHdCQUF3QixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLENBQUMsQ0FBQztJQUNsSixHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUseUJBQXlCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxDQUFDO0lBQ3JKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUM7SUFDNUksR0FBRyxDQUFDLGlCQUFpQixDQUFDLFdBQVcsRUFBRSxXQUFXLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztJQUM5RyxHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ3hHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywwQkFBMEIsRUFBRSwwQkFBMEIsRUFBRSxVQUFVLENBQUMsd0JBQXdCLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNyTixHQUFHLENBQUMsaUJBQWlCLENBQUMsd0JBQXdCLEVBQUUsd0JBQXdCLEVBQUUsVUFBVSxDQUFDLHNCQUFzQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN00sR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLFVBQVUsQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUNuTCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7Ozs7O0dBV0c7QUFDSCxNQUFhLHFCQUFzQixTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBZ0d0RDs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQWlDO1FBQzNFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLHFCQUFxQixDQUFDLHNCQUFzQixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUUsQ0FBQyxDQUFDOzs7UUFDNUYsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDM0QsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUseUJBQXlCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDNUQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUscUJBQXFCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDeEQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsV0FBVyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzlDLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFNBQVMsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM1QyxJQUFJLENBQUMseUJBQXlCLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUM7UUFFMUYsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxzQkFBc0IsQ0FBQztRQUMzRCxJQUFJLENBQUMsdUJBQXVCLEdBQUcsS0FBSyxDQUFDLHVCQUF1QixDQUFDO1FBQzdELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxLQUFLLENBQUMsbUJBQW1CLENBQUM7UUFDckQsSUFBSSxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ2pDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDLHdCQUF3QixDQUFDO1FBQy9ELElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUMsc0JBQXNCLENBQUM7UUFDM0QsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQztRQUNuRCxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSwyQ0FBMkMsRUFBRSxLQUFLLENBQUMsSUFBSSxFQUFFLEVBQUUsZUFBZSxFQUFFLE1BQU0sRUFBRSxDQUFDLENBQUM7S0FDOUk7SUFuSEQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLDRDQUE0QyxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDckYsTUFBTSxHQUFHLEdBQUcsSUFBSSxxQkFBcUIsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLFdBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNwRSxLQUFLLE1BQU0sQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEVBQUc7WUFDM0UsR0FBRyxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztTQUM3QztRQUNELE9BQU8sQ0FBQyxNQUFNLENBQUMsZ0JBQWdCLENBQUMsR0FBRyxFQUFFLGtCQUFrQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQzdELE9BQU8sR0FBRyxDQUFDO0tBQ2Q7SUFvR0Q7Ozs7O09BS0c7SUFDSSxPQUFPLENBQUMsU0FBNEI7O1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUscUJBQXFCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNwRyxTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsc0JBQXNCLEVBQUUsSUFBSSxDQUFDLHNCQUFzQjtZQUNuRCx1QkFBdUIsRUFBRSxJQUFJLENBQUMsdUJBQXVCO1lBQ3JELG1CQUFtQixFQUFFLElBQUksQ0FBQyxtQkFBbUI7WUFDN0MsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQ3pCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQix3QkFBd0IsRUFBRSxJQUFJLENBQUMsd0JBQXdCO1lBQ3ZELHNCQUFzQixFQUFFLElBQUksQ0FBQyxzQkFBc0I7WUFDbkQsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtZQUMzQyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7U0FDL0IsQ0FBQztLQUNMO0lBRVMsZ0JBQWdCLENBQUMsS0FBMkI7UUFDbEQsT0FBTywwQ0FBMEMsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUM1RDs7QUF0Skwsc0RBdUpDOzs7QUF0Skc7O0dBRUc7QUFDb0IsNENBQXNCLEdBQUcsMkNBQTJDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxMi0yMDIyIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIFJlc291cmNlIFNwZWNpZmljYXRpb25cbi8vIFNlZTogZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1yZXNvdXJjZS1zcGVjaWZpY2F0aW9uLmh0bWxcbi8vIEBjZm4ydHM6bWV0YUAge1wiZ2VuZXJhdGVkXCI6XCIyMDIyLTAzLTE3VDExOjMxOjI3LjEzMVpcIixcImZpbmdlcnByaW50XCI6XCJlQzVvSlNrL25ON1pmTjJ4Z1ZPWFFKbnhPS0dDMWlXOTI5M0Q2M1dhblVvPVwifVxuXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuICovIC8vIFRoaXMgaXMgZ2VuZXJhdGVkIGNvZGUgLSBsaW5lIGxlbmd0aHMgYXJlIGRpZmZpY3VsdCB0byBjb250cm9sXG5cbmltcG9ydCAqIGFzIGNkayBmcm9tICcuLi8uLi9jb3JlJztcbmltcG9ydCAqIGFzIGNmbl9wYXJzZSBmcm9tICcuLi8uLi9jb3JlL2xpYi9jZm4tcGFyc2UnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgYENmbkluZmVyZW5jZVNjaGVkdWxlcmBcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXIuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmbkluZmVyZW5jZVNjaGVkdWxlclByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyBjb25maWd1cmF0aW9uIGluZm9ybWF0aW9uIGZvciB0aGUgaW5wdXQgZGF0YSBmb3IgdGhlIGluZmVyZW5jZSBzY2hlZHVsZXIsIGluY2x1ZGluZyBkZWxpbWl0ZXIsIGZvcm1hdCwgYW5kIGRhdGFzZXQgbG9jYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci5odG1sI2Nmbi1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci1kYXRhaW5wdXRjb25maWd1cmF0aW9uXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGF0YUlucHV0Q29uZmlndXJhdGlvbjogYW55IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIGNvbmZpZ3VyYXRpb24gaW5mb3JtYXRpb24gZm9yIHRoZSBvdXRwdXQgcmVzdWx0cyBmb3IgdGhlIGluZmVyZW5jZSBzY2hlZHVsZXIsIGluY2x1ZGluZyB0aGUgQW1hem9uIFMzIGxvY2F0aW9uIGZvciB0aGUgb3V0cHV0LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXIuaHRtbCNjZm4tbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXItZGF0YW91dHB1dGNvbmZpZ3VyYXRpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBkYXRhT3V0cHV0Q29uZmlndXJhdGlvbjogYW55IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogSG93IG9mdGVuIGRhdGEgaXMgdXBsb2FkZWQgdG8gdGhlIHNvdXJjZSBTMyBidWNrZXQgZm9yIHRoZSBpbnB1dCBkYXRhLiBUaGlzIHZhbHVlIGlzIHRoZSBsZW5ndGggb2YgdGltZSBiZXR3ZWVuIGRhdGEgdXBsb2Fkcy4gRm9yIGluc3RhbmNlLCBpZiB5b3Ugc2VsZWN0IDUgbWludXRlcywgQW1hem9uIExvb2tvdXQgZm9yIEVxdWlwbWVudCB3aWxsIHVwbG9hZCB0aGUgcmVhbC10aW1lIGRhdGEgdG8gdGhlIHNvdXJjZSBidWNrZXQgb25jZSBldmVyeSA1IG1pbnV0ZXMuIFRoaXMgZnJlcXVlbmN5IGFsc28gZGV0ZXJtaW5lcyBob3cgb2Z0ZW4gQW1hem9uIExvb2tvdXQgZm9yIEVxdWlwbWVudCBzdGFydHMgYSBzY2hlZHVsZWQgaW5mZXJlbmNlIG9uIHlvdXIgZGF0YS4gSW4gdGhpcyBleGFtcGxlLCBpdCBzdGFydHMgb25jZSBldmVyeSA1IG1pbnV0ZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci5odG1sI2Nmbi1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci1kYXRhdXBsb2FkZnJlcXVlbmN5XG4gICAgICovXG4gICAgcmVhZG9ubHkgZGF0YVVwbG9hZEZyZXF1ZW5jeTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIE1MIG1vZGVsIHVzZWQgZm9yIHRoZSBpbmZlcmVuY2Ugc2NoZWR1bGVyLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXIuaHRtbCNjZm4tbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXItbW9kZWxuYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkgbW9kZWxOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgYSByb2xlIHdpdGggcGVybWlzc2lvbiB0byBhY2Nlc3MgdGhlIGRhdGEgc291cmNlIGJlaW5nIHVzZWQgZm9yIHRoZSBpbmZlcmVuY2UuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci5odG1sI2Nmbi1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci1yb2xlYXJuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcm9sZUFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBwZXJpb2Qgb2YgdGltZSAoaW4gbWludXRlcykgYnkgd2hpY2ggaW5mZXJlbmNlIG9uIHRoZSBkYXRhIGlzIGRlbGF5ZWQgYWZ0ZXIgdGhlIGRhdGEgc3RhcnRzLiBGb3IgaW5zdGFuY2UsIGlmIGFuIG9mZnNldCBkZWxheSB0aW1lIG9mIGZpdmUgbWludXRlcyB3YXMgc2VsZWN0ZWQsIGluZmVyZW5jZSB3aWxsIG5vdCBiZWdpbiBvbiB0aGUgZGF0YSB1bnRpbCB0aGUgZmlyc3QgZGF0YSBtZWFzdXJlbWVudCBhZnRlciB0aGUgZml2ZSBtaW51dGUgbWFyay4gRm9yIGV4YW1wbGUsIGlmIGZpdmUgbWludXRlcyBpcyBzZWxlY3RlZCwgdGhlIGluZmVyZW5jZSBzY2hlZHVsZXIgd2lsbCB3YWtlIHVwIGF0IHRoZSBjb25maWd1cmVkIGZyZXF1ZW5jeSB3aXRoIHRoZSBhZGRpdGlvbmFsIGZpdmUgbWludXRlIGRlbGF5IHRpbWUgdG8gY2hlY2sgdGhlIGN1c3RvbWVyIFMzIGJ1Y2tldC4gVGhlIGN1c3RvbWVyIGNhbiB1cGxvYWQgZGF0YSBhdCB0aGUgc2FtZSBmcmVxdWVuY3kgYW5kIHRoZXkgZG9uJ3QgbmVlZCB0byBzdG9wIGFuZCByZXN0YXJ0IHRoZSBzY2hlZHVsZXIgd2hlbiB1cGxvYWRpbmcgbmV3IGRhdGEuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci5odG1sI2Nmbi1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci1kYXRhZGVsYXlvZmZzZXRpbm1pbnV0ZXNcbiAgICAgKi9cbiAgICByZWFkb25seSBkYXRhRGVsYXlPZmZzZXRJbk1pbnV0ZXM/OiBudW1iZXI7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgaW5mZXJlbmNlIHNjaGVkdWxlci5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWxvb2tvdXRlcXVpcG1lbnQtaW5mZXJlbmNlc2NoZWR1bGVyLmh0bWwjY2ZuLWxvb2tvdXRlcXVpcG1lbnQtaW5mZXJlbmNlc2NoZWR1bGVyLWluZmVyZW5jZXNjaGVkdWxlcm5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBpbmZlcmVuY2VTY2hlZHVsZXJOYW1lPzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogUHJvdmlkZXMgdGhlIGlkZW50aWZpZXIgb2YgdGhlIEFXUyBLTVMga2V5IHVzZWQgdG8gZW5jcnlwdCBpbmZlcmVuY2Ugc2NoZWR1bGVyIGRhdGEgYnkgQW1hem9uIExvb2tvdXQgZm9yIEVxdWlwbWVudCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci5odG1sI2Nmbi1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci1zZXJ2ZXJzaWRla21za2V5aWRcbiAgICAgKi9cbiAgICByZWFkb25seSBzZXJ2ZXJTaWRlS21zS2V5SWQ/OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBbnkgdGFncyBhc3NvY2lhdGVkIHdpdGggdGhlIGluZmVyZW5jZSBzY2hlZHVsZXIuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtUYWddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXJlc291cmNlLXRhZ3MuaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXIuaHRtbCNjZm4tbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXItdGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhZ3M/OiBjZGsuQ2ZuVGFnW107XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuSW5mZXJlbmNlU2NoZWR1bGVyUHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbkluZmVyZW5jZVNjaGVkdWxlclByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmbkluZmVyZW5jZVNjaGVkdWxlclByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGF0YURlbGF5T2Zmc2V0SW5NaW51dGVzJywgY2RrLnZhbGlkYXRlTnVtYmVyKShwcm9wZXJ0aWVzLmRhdGFEZWxheU9mZnNldEluTWludXRlcykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGF0YUlucHV0Q29uZmlndXJhdGlvbicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5kYXRhSW5wdXRDb25maWd1cmF0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkYXRhSW5wdXRDb25maWd1cmF0aW9uJywgY2RrLnZhbGlkYXRlT2JqZWN0KShwcm9wZXJ0aWVzLmRhdGFJbnB1dENvbmZpZ3VyYXRpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2RhdGFPdXRwdXRDb25maWd1cmF0aW9uJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmRhdGFPdXRwdXRDb25maWd1cmF0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkYXRhT3V0cHV0Q29uZmlndXJhdGlvbicsIGNkay52YWxpZGF0ZU9iamVjdCkocHJvcGVydGllcy5kYXRhT3V0cHV0Q29uZmlndXJhdGlvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGF0YVVwbG9hZEZyZXF1ZW5jeScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5kYXRhVXBsb2FkRnJlcXVlbmN5KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdkYXRhVXBsb2FkRnJlcXVlbmN5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmRhdGFVcGxvYWRGcmVxdWVuY3kpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2luZmVyZW5jZVNjaGVkdWxlck5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuaW5mZXJlbmNlU2NoZWR1bGVyTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbW9kZWxOYW1lJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLm1vZGVsTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbW9kZWxOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLm1vZGVsTmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncm9sZUFybicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5yb2xlQXJuKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyb2xlQXJuJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnJvbGVBcm4pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NlcnZlclNpZGVLbXNLZXlJZCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zZXJ2ZXJTaWRlS21zS2V5SWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RhZ3MnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVDZm5UYWcpKShwcm9wZXJ0aWVzLnRhZ3MpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuSW5mZXJlbmNlU2NoZWR1bGVyUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6Okxvb2tvdXRFcXVpcG1lbnQ6OkluZmVyZW5jZVNjaGVkdWxlcmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuSW5mZXJlbmNlU2NoZWR1bGVyUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6Okxvb2tvdXRFcXVpcG1lbnQ6OkluZmVyZW5jZVNjaGVkdWxlcmAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5JbmZlcmVuY2VTY2hlZHVsZXJQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuSW5mZXJlbmNlU2NoZWR1bGVyUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIERhdGFJbnB1dENvbmZpZ3VyYXRpb246IGNkay5vYmplY3RUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGF0YUlucHV0Q29uZmlndXJhdGlvbiksXG4gICAgICAgIERhdGFPdXRwdXRDb25maWd1cmF0aW9uOiBjZGsub2JqZWN0VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmRhdGFPdXRwdXRDb25maWd1cmF0aW9uKSxcbiAgICAgICAgRGF0YVVwbG9hZEZyZXF1ZW5jeTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5kYXRhVXBsb2FkRnJlcXVlbmN5KSxcbiAgICAgICAgTW9kZWxOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLm1vZGVsTmFtZSksXG4gICAgICAgIFJvbGVBcm46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucm9sZUFybiksXG4gICAgICAgIERhdGFEZWxheU9mZnNldEluTWludXRlczogY2RrLm51bWJlclRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5kYXRhRGVsYXlPZmZzZXRJbk1pbnV0ZXMpLFxuICAgICAgICBJbmZlcmVuY2VTY2hlZHVsZXJOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmluZmVyZW5jZVNjaGVkdWxlck5hbWUpLFxuICAgICAgICBTZXJ2ZXJTaWRlS21zS2V5SWQ6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc2VydmVyU2lkZUttc0tleUlkKSxcbiAgICAgICAgVGFnczogY2RrLmxpc3RNYXBwZXIoY2RrLmNmblRhZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMudGFncyksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmbkluZmVyZW5jZVNjaGVkdWxlclByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuSW5mZXJlbmNlU2NoZWR1bGVyUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmbkluZmVyZW5jZVNjaGVkdWxlclByb3BzPigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZGF0YUlucHV0Q29uZmlndXJhdGlvbicsICdEYXRhSW5wdXRDb25maWd1cmF0aW9uJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRBbnkocHJvcGVydGllcy5EYXRhSW5wdXRDb25maWd1cmF0aW9uKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdkYXRhT3V0cHV0Q29uZmlndXJhdGlvbicsICdEYXRhT3V0cHV0Q29uZmlndXJhdGlvbicsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QW55KHByb3BlcnRpZXMuRGF0YU91dHB1dENvbmZpZ3VyYXRpb24pKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2RhdGFVcGxvYWRGcmVxdWVuY3knLCAnRGF0YVVwbG9hZEZyZXF1ZW5jeScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRGF0YVVwbG9hZEZyZXF1ZW5jeSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnbW9kZWxOYW1lJywgJ01vZGVsTmFtZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuTW9kZWxOYW1lKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdyb2xlQXJuJywgJ1JvbGVBcm4nLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJvbGVBcm4pKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2RhdGFEZWxheU9mZnNldEluTWludXRlcycsICdEYXRhRGVsYXlPZmZzZXRJbk1pbnV0ZXMnLCBwcm9wZXJ0aWVzLkRhdGFEZWxheU9mZnNldEluTWludXRlcyAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXROdW1iZXIocHJvcGVydGllcy5EYXRhRGVsYXlPZmZzZXRJbk1pbnV0ZXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2luZmVyZW5jZVNjaGVkdWxlck5hbWUnLCAnSW5mZXJlbmNlU2NoZWR1bGVyTmFtZScsIHByb3BlcnRpZXMuSW5mZXJlbmNlU2NoZWR1bGVyTmFtZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5JbmZlcmVuY2VTY2hlZHVsZXJOYW1lKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzZXJ2ZXJTaWRlS21zS2V5SWQnLCAnU2VydmVyU2lkZUttc0tleUlkJywgcHJvcGVydGllcy5TZXJ2ZXJTaWRlS21zS2V5SWQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU2VydmVyU2lkZUttc0tleUlkKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0YWdzJywgJ1RhZ3MnLCBwcm9wZXJ0aWVzLlRhZ3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRDZm5UYWcpKHByb3BlcnRpZXMuVGFncykgOiB1bmRlZmluZWQgYXMgYW55KTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6Okxvb2tvdXRFcXVpcG1lbnQ6OkluZmVyZW5jZVNjaGVkdWxlcmBcbiAqXG4gKiBDcmVhdGVzIGEgc2NoZWR1bGVkIGluZmVyZW5jZS4gU2NoZWR1bGluZyBhbiBpbmZlcmVuY2UgaXMgc2V0dGluZyB1cCBhIGNvbnRpbnVvdXMgcmVhbC10aW1lIGluZmVyZW5jZSBwbGFuIHRvIGFuYWx5emUgbmV3IG1lYXN1cmVtZW50IGRhdGEuIFdoZW4gc2V0dGluZyB1cCB0aGUgc2NoZWR1bGUsIHlvdSBwcm92aWRlIGFuIEFtYXpvbiBTMyBidWNrZXQgbG9jYXRpb24gZm9yIHRoZSBpbnB1dCBkYXRhLCBhc3NpZ24gaXQgYSBkZWxpbWl0ZXIgYmV0d2VlbiBzZXBhcmF0ZSBlbnRyaWVzIGluIHRoZSBkYXRhLCBzZXQgYW4gb2Zmc2V0IGRlbGF5IGlmIGRlc2lyZWQsIGFuZCBzZXQgdGhlIGZyZXF1ZW5jeSBvZiBpbmZlcmVuY2luZy4gWW91IG11c3QgYWxzbyBwcm92aWRlIGFuIEFtYXpvbiBTMyBidWNrZXQgbG9jYXRpb24gZm9yIHRoZSBvdXRwdXQgZGF0YS5cbiAqXG4gKiA+IFVwZGF0aW5nIHNvbWUgcHJvcGVydGllcyBiZWxvdyAoZm9yIGV4YW1wbGUsIEluZmVyZW5jZVNjaGVkdWxlck5hbWUgYW5kIFNlcnZlclNpZGVLbXNLZXlJZCkgdHJpZ2dlcnMgYSByZXNvdXJjZSByZXBsYWNlbWVudCwgd2hpY2ggcmVxdWlyZXMgYSBuZXcgbW9kZWwuIFRvIHJlcGxhY2Ugc3VjaCBhIHByb3BlcnR5IHVzaW5nIEFXUyBDbG91ZEZvcm1hdGlvbiAsIGJ1dCB3aXRob3V0IGNyZWF0aW5nIGEgY29tcGxldGVseSBuZXcgc3RhY2ssIHlvdSBtdXN0IHJlcGxhY2UgTW9kZWxOYW1lLiBJZiB5b3UgbmVlZCB0byByZXBsYWNlIHRoZSBwcm9wZXJ0eSwgYnV0IHdhbnQgdG8gdXNlIHRoZSBzYW1lIG1vZGVsLCBkZWxldGUgdGhlIGN1cnJlbnQgc3RhY2sgYW5kIGNyZWF0ZSBhIG5ldyBvbmUgd2l0aCB0aGUgdXBkYXRlZCBwcm9wZXJ0aWVzLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6TG9va291dEVxdWlwbWVudDo6SW5mZXJlbmNlU2NoZWR1bGVyXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXIuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuSW5mZXJlbmNlU2NoZWR1bGVyIGV4dGVuZHMgY2RrLkNmblJlc291cmNlIGltcGxlbWVudHMgY2RrLklJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFXUzo6TG9va291dEVxdWlwbWVudDo6SW5mZXJlbmNlU2NoZWR1bGVyXCI7XG5cbiAgICAvKipcbiAgICAgKiBBIGZhY3RvcnkgbWV0aG9kIHRoYXQgY3JlYXRlcyBhIG5ldyBpbnN0YW5jZSBvZiB0aGlzIGNsYXNzIGZyb20gYW4gb2JqZWN0XG4gICAgICogY29udGFpbmluZyB0aGUgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiB0aGlzIHJlc291cmNlLlxuICAgICAqIFVzZWQgaW4gdGhlIEBhd3MtY2RrL2Nsb3VkZm9ybWF0aW9uLWluY2x1ZGUgbW9kdWxlLlxuICAgICAqXG4gICAgICogQGludGVybmFsXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyBfZnJvbUNsb3VkRm9ybWF0aW9uKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCByZXNvdXJjZUF0dHJpYnV0ZXM6IGFueSwgb3B0aW9uczogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbk9wdGlvbnMpOiBDZm5JbmZlcmVuY2VTY2hlZHVsZXIge1xuICAgICAgICByZXNvdXJjZUF0dHJpYnV0ZXMgPSByZXNvdXJjZUF0dHJpYnV0ZXMgfHwge307XG4gICAgICAgIGNvbnN0IHJlc291cmNlUHJvcGVydGllcyA9IG9wdGlvbnMucGFyc2VyLnBhcnNlVmFsdWUocmVzb3VyY2VBdHRyaWJ1dGVzLlByb3BlcnRpZXMpO1xuICAgICAgICBjb25zdCBwcm9wc1Jlc3VsdCA9IENmbkluZmVyZW5jZVNjaGVkdWxlclByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5JbmZlcmVuY2VTY2hlZHVsZXIoc2NvcGUsIGlkLCBwcm9wc1Jlc3VsdC52YWx1ZSk7XG4gICAgICAgIGZvciAoY29uc3QgW3Byb3BLZXksIHByb3BWYWxdIG9mIE9iamVjdC5lbnRyaWVzKHByb3BzUmVzdWx0LmV4dHJhUHJvcGVydGllcykpICB7XG4gICAgICAgICAgICByZXQuYWRkUHJvcGVydHlPdmVycmlkZShwcm9wS2V5LCBwcm9wVmFsKTtcbiAgICAgICAgfVxuICAgICAgICBvcHRpb25zLnBhcnNlci5oYW5kbGVBdHRyaWJ1dGVzKHJldCwgcmVzb3VyY2VBdHRyaWJ1dGVzLCBpZCk7XG4gICAgICAgIHJldHVybiByZXQ7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBpbmZlcmVuY2Ugc2NoZWR1bGVyIGJlaW5nIGNyZWF0ZWQuXG4gICAgICogQGNsb3VkZm9ybWF0aW9uQXR0cmlidXRlIEluZmVyZW5jZVNjaGVkdWxlckFyblxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRySW5mZXJlbmNlU2NoZWR1bGVyQXJuOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgY29uZmlndXJhdGlvbiBpbmZvcm1hdGlvbiBmb3IgdGhlIGlucHV0IGRhdGEgZm9yIHRoZSBpbmZlcmVuY2Ugc2NoZWR1bGVyLCBpbmNsdWRpbmcgZGVsaW1pdGVyLCBmb3JtYXQsIGFuZCBkYXRhc2V0IGxvY2F0aW9uLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXIuaHRtbCNjZm4tbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXItZGF0YWlucHV0Y29uZmlndXJhdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBkYXRhSW5wdXRDb25maWd1cmF0aW9uOiBhbnkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgY29uZmlndXJhdGlvbiBpbmZvcm1hdGlvbiBmb3IgdGhlIG91dHB1dCByZXN1bHRzIGZvciB0aGUgaW5mZXJlbmNlIHNjaGVkdWxlciwgaW5jbHVkaW5nIHRoZSBBbWF6b24gUzMgbG9jYXRpb24gZm9yIHRoZSBvdXRwdXQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci5odG1sI2Nmbi1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci1kYXRhb3V0cHV0Y29uZmlndXJhdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBkYXRhT3V0cHV0Q29uZmlndXJhdGlvbjogYW55IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogSG93IG9mdGVuIGRhdGEgaXMgdXBsb2FkZWQgdG8gdGhlIHNvdXJjZSBTMyBidWNrZXQgZm9yIHRoZSBpbnB1dCBkYXRhLiBUaGlzIHZhbHVlIGlzIHRoZSBsZW5ndGggb2YgdGltZSBiZXR3ZWVuIGRhdGEgdXBsb2Fkcy4gRm9yIGluc3RhbmNlLCBpZiB5b3Ugc2VsZWN0IDUgbWludXRlcywgQW1hem9uIExvb2tvdXQgZm9yIEVxdWlwbWVudCB3aWxsIHVwbG9hZCB0aGUgcmVhbC10aW1lIGRhdGEgdG8gdGhlIHNvdXJjZSBidWNrZXQgb25jZSBldmVyeSA1IG1pbnV0ZXMuIFRoaXMgZnJlcXVlbmN5IGFsc28gZGV0ZXJtaW5lcyBob3cgb2Z0ZW4gQW1hem9uIExvb2tvdXQgZm9yIEVxdWlwbWVudCBzdGFydHMgYSBzY2hlZHVsZWQgaW5mZXJlbmNlIG9uIHlvdXIgZGF0YS4gSW4gdGhpcyBleGFtcGxlLCBpdCBzdGFydHMgb25jZSBldmVyeSA1IG1pbnV0ZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci5odG1sI2Nmbi1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci1kYXRhdXBsb2FkZnJlcXVlbmN5XG4gICAgICovXG4gICAgcHVibGljIGRhdGFVcGxvYWRGcmVxdWVuY3k6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBNTCBtb2RlbCB1c2VkIGZvciB0aGUgaW5mZXJlbmNlIHNjaGVkdWxlci5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWxvb2tvdXRlcXVpcG1lbnQtaW5mZXJlbmNlc2NoZWR1bGVyLmh0bWwjY2ZuLWxvb2tvdXRlcXVpcG1lbnQtaW5mZXJlbmNlc2NoZWR1bGVyLW1vZGVsbmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyBtb2RlbE5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiBhIHJvbGUgd2l0aCBwZXJtaXNzaW9uIHRvIGFjY2VzcyB0aGUgZGF0YSBzb3VyY2UgYmVpbmcgdXNlZCBmb3IgdGhlIGluZmVyZW5jZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWxvb2tvdXRlcXVpcG1lbnQtaW5mZXJlbmNlc2NoZWR1bGVyLmh0bWwjY2ZuLWxvb2tvdXRlcXVpcG1lbnQtaW5mZXJlbmNlc2NoZWR1bGVyLXJvbGVhcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgcm9sZUFybjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogQSBwZXJpb2Qgb2YgdGltZSAoaW4gbWludXRlcykgYnkgd2hpY2ggaW5mZXJlbmNlIG9uIHRoZSBkYXRhIGlzIGRlbGF5ZWQgYWZ0ZXIgdGhlIGRhdGEgc3RhcnRzLiBGb3IgaW5zdGFuY2UsIGlmIGFuIG9mZnNldCBkZWxheSB0aW1lIG9mIGZpdmUgbWludXRlcyB3YXMgc2VsZWN0ZWQsIGluZmVyZW5jZSB3aWxsIG5vdCBiZWdpbiBvbiB0aGUgZGF0YSB1bnRpbCB0aGUgZmlyc3QgZGF0YSBtZWFzdXJlbWVudCBhZnRlciB0aGUgZml2ZSBtaW51dGUgbWFyay4gRm9yIGV4YW1wbGUsIGlmIGZpdmUgbWludXRlcyBpcyBzZWxlY3RlZCwgdGhlIGluZmVyZW5jZSBzY2hlZHVsZXIgd2lsbCB3YWtlIHVwIGF0IHRoZSBjb25maWd1cmVkIGZyZXF1ZW5jeSB3aXRoIHRoZSBhZGRpdGlvbmFsIGZpdmUgbWludXRlIGRlbGF5IHRpbWUgdG8gY2hlY2sgdGhlIGN1c3RvbWVyIFMzIGJ1Y2tldC4gVGhlIGN1c3RvbWVyIGNhbiB1cGxvYWQgZGF0YSBhdCB0aGUgc2FtZSBmcmVxdWVuY3kgYW5kIHRoZXkgZG9uJ3QgbmVlZCB0byBzdG9wIGFuZCByZXN0YXJ0IHRoZSBzY2hlZHVsZXIgd2hlbiB1cGxvYWRpbmcgbmV3IGRhdGEuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci5odG1sI2Nmbi1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci1kYXRhZGVsYXlvZmZzZXRpbm1pbnV0ZXNcbiAgICAgKi9cbiAgICBwdWJsaWMgZGF0YURlbGF5T2Zmc2V0SW5NaW51dGVzOiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgbmFtZSBvZiB0aGUgaW5mZXJlbmNlIHNjaGVkdWxlci5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWxvb2tvdXRlcXVpcG1lbnQtaW5mZXJlbmNlc2NoZWR1bGVyLmh0bWwjY2ZuLWxvb2tvdXRlcXVpcG1lbnQtaW5mZXJlbmNlc2NoZWR1bGVyLWluZmVyZW5jZXNjaGVkdWxlcm5hbWVcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5mZXJlbmNlU2NoZWR1bGVyTmFtZTogc3RyaW5nIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogUHJvdmlkZXMgdGhlIGlkZW50aWZpZXIgb2YgdGhlIEFXUyBLTVMga2V5IHVzZWQgdG8gZW5jcnlwdCBpbmZlcmVuY2Ugc2NoZWR1bGVyIGRhdGEgYnkgQW1hem9uIExvb2tvdXQgZm9yIEVxdWlwbWVudCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci5odG1sI2Nmbi1sb29rb3V0ZXF1aXBtZW50LWluZmVyZW5jZXNjaGVkdWxlci1zZXJ2ZXJzaWRla21za2V5aWRcbiAgICAgKi9cbiAgICBwdWJsaWMgc2VydmVyU2lkZUttc0tleUlkOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBbnkgdGFncyBhc3NvY2lhdGVkIHdpdGggdGhlIGluZmVyZW5jZSBzY2hlZHVsZXIuXG4gICAgICpcbiAgICAgKiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtUYWddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLXJlc291cmNlLXRhZ3MuaHRtbCkgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXIuaHRtbCNjZm4tbG9va291dGVxdWlwbWVudC1pbmZlcmVuY2VzY2hlZHVsZXItdGFnc1xuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSB0YWdzOiBjZGsuVGFnTWFuYWdlcjtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpMb29rb3V0RXF1aXBtZW50OjpJbmZlcmVuY2VTY2hlZHVsZXJgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbkluZmVyZW5jZVNjaGVkdWxlclByb3BzKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCwgeyB0eXBlOiBDZm5JbmZlcmVuY2VTY2hlZHVsZXIuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdkYXRhSW5wdXRDb25maWd1cmF0aW9uJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdkYXRhT3V0cHV0Q29uZmlndXJhdGlvbicsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnZGF0YVVwbG9hZEZyZXF1ZW5jeScsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnbW9kZWxOYW1lJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdyb2xlQXJuJywgdGhpcyk7XG4gICAgICAgIHRoaXMuYXR0ckluZmVyZW5jZVNjaGVkdWxlckFybiA9IGNkay5Ub2tlbi5hc1N0cmluZyh0aGlzLmdldEF0dCgnSW5mZXJlbmNlU2NoZWR1bGVyQXJuJykpO1xuXG4gICAgICAgIHRoaXMuZGF0YUlucHV0Q29uZmlndXJhdGlvbiA9IHByb3BzLmRhdGFJbnB1dENvbmZpZ3VyYXRpb247XG4gICAgICAgIHRoaXMuZGF0YU91dHB1dENvbmZpZ3VyYXRpb24gPSBwcm9wcy5kYXRhT3V0cHV0Q29uZmlndXJhdGlvbjtcbiAgICAgICAgdGhpcy5kYXRhVXBsb2FkRnJlcXVlbmN5ID0gcHJvcHMuZGF0YVVwbG9hZEZyZXF1ZW5jeTtcbiAgICAgICAgdGhpcy5tb2RlbE5hbWUgPSBwcm9wcy5tb2RlbE5hbWU7XG4gICAgICAgIHRoaXMucm9sZUFybiA9IHByb3BzLnJvbGVBcm47XG4gICAgICAgIHRoaXMuZGF0YURlbGF5T2Zmc2V0SW5NaW51dGVzID0gcHJvcHMuZGF0YURlbGF5T2Zmc2V0SW5NaW51dGVzO1xuICAgICAgICB0aGlzLmluZmVyZW5jZVNjaGVkdWxlck5hbWUgPSBwcm9wcy5pbmZlcmVuY2VTY2hlZHVsZXJOYW1lO1xuICAgICAgICB0aGlzLnNlcnZlclNpZGVLbXNLZXlJZCA9IHByb3BzLnNlcnZlclNpZGVLbXNLZXlJZDtcbiAgICAgICAgdGhpcy50YWdzID0gbmV3IGNkay5UYWdNYW5hZ2VyKGNkay5UYWdUeXBlLlNUQU5EQVJELCBcIkFXUzo6TG9va291dEVxdWlwbWVudDo6SW5mZXJlbmNlU2NoZWR1bGVyXCIsIHByb3BzLnRhZ3MsIHsgdGFnUHJvcGVydHlOYW1lOiAndGFncycgfSk7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogRXhhbWluZXMgdGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIGFuZCBkaXNjbG9zZXMgYXR0cmlidXRlcy5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBpbnNwZWN0b3IgLSB0cmVlIGluc3BlY3RvciB0byBjb2xsZWN0IGFuZCBwcm9jZXNzIGF0dHJpYnV0ZXNcbiAgICAgKlxuICAgICAqL1xuICAgIHB1YmxpYyBpbnNwZWN0KGluc3BlY3RvcjogY2RrLlRyZWVJbnNwZWN0b3IpIHtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246dHlwZVwiLCBDZm5JbmZlcmVuY2VTY2hlZHVsZXIuQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGRhdGFJbnB1dENvbmZpZ3VyYXRpb246IHRoaXMuZGF0YUlucHV0Q29uZmlndXJhdGlvbixcbiAgICAgICAgICAgIGRhdGFPdXRwdXRDb25maWd1cmF0aW9uOiB0aGlzLmRhdGFPdXRwdXRDb25maWd1cmF0aW9uLFxuICAgICAgICAgICAgZGF0YVVwbG9hZEZyZXF1ZW5jeTogdGhpcy5kYXRhVXBsb2FkRnJlcXVlbmN5LFxuICAgICAgICAgICAgbW9kZWxOYW1lOiB0aGlzLm1vZGVsTmFtZSxcbiAgICAgICAgICAgIHJvbGVBcm46IHRoaXMucm9sZUFybixcbiAgICAgICAgICAgIGRhdGFEZWxheU9mZnNldEluTWludXRlczogdGhpcy5kYXRhRGVsYXlPZmZzZXRJbk1pbnV0ZXMsXG4gICAgICAgICAgICBpbmZlcmVuY2VTY2hlZHVsZXJOYW1lOiB0aGlzLmluZmVyZW5jZVNjaGVkdWxlck5hbWUsXG4gICAgICAgICAgICBzZXJ2ZXJTaWRlS21zS2V5SWQ6IHRoaXMuc2VydmVyU2lkZUttc0tleUlkLFxuICAgICAgICAgICAgdGFnczogdGhpcy50YWdzLnJlbmRlclRhZ3MoKSxcbiAgICAgICAgfTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiBjZm5JbmZlcmVuY2VTY2hlZHVsZXJQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcHMpO1xuICAgIH1cbn1cbiJdfQ==