"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const appscaling = require("../../aws-applicationautoscaling");
const cdk = require("../../core");
const lambda = require("../lib");
/**
* Stack verification steps:
* aws application-autoscaling describe-scalable-targets --service-namespace lambda --resource-ids function:<function name>:prod
* has a minCapacity of 3 and maxCapacity of 50
*/
class TestStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const fn = new lambda.Function(this, 'MyLambda', {
            code: new lambda.InlineCode('exports.handler = async () => { console.log(\'hello world\'); };'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS_10_X,
        });
        const version = fn.currentVersion;
        const alias = new lambda.Alias(this, 'Alias', {
            aliasName: 'prod',
            version,
        });
        const scalingTarget = alias.addAutoScaling({ minCapacity: 3, maxCapacity: 50 });
        scalingTarget.scaleOnUtilization({
            utilizationTarget: 0.5,
        });
        scalingTarget.scaleOnSchedule('ScaleUpInTheMorning', {
            schedule: appscaling.Schedule.cron({ hour: '8', minute: '0' }),
            minCapacity: 20,
        });
        scalingTarget.scaleOnSchedule('ScaleDownAtNight', {
            schedule: appscaling.Schedule.cron({ hour: '20', minute: '0' }),
            maxCapacity: 20,
        });
        new cdk.CfnOutput(this, 'FunctionName', {
            value: fn.functionName,
        });
    }
}
const app = new cdk.App();
new TestStack(app, 'aws-lambda-autoscaling');
app.synth();
//# sourceMappingURL=data:application/json;base64,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