"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetImageCode = exports.EcrImageCode = exports.CfnParametersCode = exports.AssetCode = exports.InlineCode = exports.S3Code = exports.Code = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ecr_assets = require("../../aws-ecr-assets");
const iam = require("../../aws-iam");
const s3_assets = require("../../aws-s3-assets");
const cdk = require("../../core");
/**
 * Represents the Lambda Handler Code.
 */
class Code {
    /**
     * Lambda handler code as an S3 object.
     * @param bucket The S3 bucket
     * @param key The object key
     * @param objectVersion Optional S3 object version
     */
    static fromBucket(bucket, key, objectVersion) {
        jsiiDeprecationWarnings.monocdk_aws_s3_IBucket(bucket);
        return new S3Code(bucket, key, objectVersion);
    }
    /**
     * DEPRECATED
     * @deprecated use `fromBucket`
     */
    static bucket(bucket, key, objectVersion) {
        jsiiDeprecationWarnings.print("monocdk.aws_lambda.Code#bucket", "use `fromBucket`");
        jsiiDeprecationWarnings.monocdk_aws_s3_IBucket(bucket);
        return this.fromBucket(bucket, key, objectVersion);
    }
    /**
     * Inline code for Lambda handler
     * @returns `LambdaInlineCode` with inline code.
     * @param code The actual handler code (limited to 4KiB)
     */
    static fromInline(code) {
        return new InlineCode(code);
    }
    /**
     * DEPRECATED
     * @deprecated use `fromInline`
     */
    static inline(code) {
        jsiiDeprecationWarnings.print("monocdk.aws_lambda.Code#inline", "use `fromInline`");
        return this.fromInline(code);
    }
    /**
     * Loads the function code from a local disk path.
     *
     * @param path Either a directory with the Lambda code bundle or a .zip file
     */
    static fromAsset(path, options) {
        jsiiDeprecationWarnings.monocdk_aws_s3_assets_AssetOptions(options);
        return new AssetCode(path, options);
    }
    /**
     * Loads the function code from an asset created by a Docker build.
     *
     * By default, the asset is expected to be located at `/asset` in the
     * image.
     *
     * @param path The path to the directory containing the Docker file
     * @param options Docker build options
     */
    static fromDockerBuild(path, options = {}) {
        var _h;
        jsiiDeprecationWarnings.monocdk_aws_lambda_DockerBuildAssetOptions(options);
        let imagePath = (_h = options.imagePath) !== null && _h !== void 0 ? _h : '/asset/.';
        // ensure imagePath ends with /. to copy the **content** at this path
        if (imagePath.endsWith('/')) {
            imagePath = `${imagePath}.`;
        }
        else if (!imagePath.endsWith('/.')) {
            imagePath = `${imagePath}/.`;
        }
        const assetPath = cdk.DockerImage
            .fromBuild(path, options)
            .cp(imagePath, options.outputPath);
        return new AssetCode(assetPath);
    }
    /**
     * DEPRECATED
     * @deprecated use `fromAsset`
     */
    static asset(path) {
        jsiiDeprecationWarnings.print("monocdk.aws_lambda.Code#asset", "use `fromAsset`");
        return this.fromAsset(path);
    }
    /**
     * Creates a new Lambda source defined using CloudFormation parameters.
     *
     * @returns a new instance of `CfnParametersCode`
     * @param props optional construction properties of {@link CfnParametersCode}
     */
    static fromCfnParameters(props) {
        jsiiDeprecationWarnings.monocdk_aws_lambda_CfnParametersCodeProps(props);
        return new CfnParametersCode(props);
    }
    /**
     * DEPRECATED
     * @deprecated use `fromCfnParameters`
     */
    static cfnParameters(props) {
        jsiiDeprecationWarnings.print("monocdk.aws_lambda.Code#cfnParameters", "use `fromCfnParameters`");
        jsiiDeprecationWarnings.monocdk_aws_lambda_CfnParametersCodeProps(props);
        return this.fromCfnParameters(props);
    }
    /**
     * Use an existing ECR image as the Lambda code.
     * @param repository the ECR repository that the image is in
     * @param props properties to further configure the selected image
     */
    static fromEcrImage(repository, props) {
        jsiiDeprecationWarnings.monocdk_aws_ecr_IRepository(repository);
        jsiiDeprecationWarnings.monocdk_aws_lambda_EcrImageCodeProps(props);
        return new EcrImageCode(repository, props);
    }
    /**
     * Create an ECR image from the specified asset and bind it as the Lambda code.
     * @param directory the directory from which the asset must be created
     * @param props properties to further configure the selected image
     */
    static fromAssetImage(directory, props = {}) {
        jsiiDeprecationWarnings.monocdk_aws_lambda_AssetImageCodeProps(props);
        return new AssetImageCode(directory, props);
    }
    /**
     * Called after the CFN function resource has been created to allow the code
     * class to bind to it. Specifically it's required to allow assets to add
     * metadata for tooling like SAM CLI to be able to find their origins.
     */
    bindToResource(_resource, _options) {
        jsiiDeprecationWarnings.monocdk_CfnResource(_resource);
        jsiiDeprecationWarnings.monocdk_aws_lambda_ResourceBindOptions(_options);
        return;
    }
}
exports.Code = Code;
_a = JSII_RTTI_SYMBOL_1;
Code[_a] = { fqn: "monocdk.aws_lambda.Code", version: "1.149.0" };
/**
 * Lambda code from an S3 archive.
 */
class S3Code extends Code {
    constructor(bucket, key, objectVersion) {
        super();
        this.key = key;
        this.objectVersion = objectVersion;
        this.isInline = false;
        jsiiDeprecationWarnings.monocdk_aws_s3_IBucket(bucket);
        if (!bucket.bucketName) {
            throw new Error('bucketName is undefined for the provided bucket');
        }
        this.bucketName = bucket.bucketName;
    }
    bind(_scope) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        return {
            s3Location: {
                bucketName: this.bucketName,
                objectKey: this.key,
                objectVersion: this.objectVersion,
            },
        };
    }
}
exports.S3Code = S3Code;
_b = JSII_RTTI_SYMBOL_1;
S3Code[_b] = { fqn: "monocdk.aws_lambda.S3Code", version: "1.149.0" };
/**
 * Lambda code from an inline string (limited to 4KiB).
 */
class InlineCode extends Code {
    constructor(code) {
        super();
        this.code = code;
        this.isInline = true;
        if (code.length === 0) {
            throw new Error('Lambda inline code cannot be empty');
        }
        if (code.length > 4096) {
            throw new Error('Lambda source is too large, must be <= 4096 but is ' + code.length);
        }
    }
    bind(_scope) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        return {
            inlineCode: this.code,
        };
    }
}
exports.InlineCode = InlineCode;
_c = JSII_RTTI_SYMBOL_1;
InlineCode[_c] = { fqn: "monocdk.aws_lambda.InlineCode", version: "1.149.0" };
/**
 * Lambda code from a local directory.
 */
class AssetCode extends Code {
    /**
     * @param path The path to the asset file or directory.
     */
    constructor(path, options = {}) {
        super();
        this.path = path;
        this.options = options;
        this.isInline = false;
        jsiiDeprecationWarnings.monocdk_aws_s3_assets_AssetOptions(options);
    }
    bind(scope) {
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new s3_assets.Asset(scope, 'Code', {
                path: this.path,
                ...this.options,
            });
        }
        else if (cdk.Stack.of(this.asset) !== cdk.Stack.of(scope)) {
            throw new Error(`Asset is already associated with another stack '${cdk.Stack.of(this.asset).stackName}'. ` +
                'Create a new Code instance for every stack.');
        }
        if (!this.asset.isZipArchive) {
            throw new Error(`Asset must be a .zip file or a directory (${this.path})`);
        }
        return {
            s3Location: {
                bucketName: this.asset.s3BucketName,
                objectKey: this.asset.s3ObjectKey,
            },
        };
    }
    bindToResource(resource, options = {}) {
        jsiiDeprecationWarnings.monocdk_CfnResource(resource);
        jsiiDeprecationWarnings.monocdk_aws_lambda_ResourceBindOptions(options);
        if (!this.asset) {
            throw new Error('bindToResource() must be called after bind()');
        }
        const resourceProperty = options.resourceProperty || 'Code';
        // https://github.com/aws/aws-cdk/issues/1432
        this.asset.addResourceMetadata(resource, resourceProperty);
    }
}
exports.AssetCode = AssetCode;
_d = JSII_RTTI_SYMBOL_1;
AssetCode[_d] = { fqn: "monocdk.aws_lambda.AssetCode", version: "1.149.0" };
/**
 * Lambda code defined using 2 CloudFormation parameters.
 * Useful when you don't have access to the code of your Lambda from your CDK code, so you can't use Assets,
 * and you want to deploy the Lambda in a CodePipeline, using CloudFormation Actions -
 * you can fill the parameters using the {@link #assign} method.
 */
class CfnParametersCode extends Code {
    constructor(props = {}) {
        super();
        this.isInline = false;
        jsiiDeprecationWarnings.monocdk_aws_lambda_CfnParametersCodeProps(props);
        this._bucketNameParam = props.bucketNameParam;
        this._objectKeyParam = props.objectKeyParam;
    }
    bind(scope) {
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        if (!this._bucketNameParam) {
            this._bucketNameParam = new cdk.CfnParameter(scope, 'LambdaSourceBucketNameParameter', {
                type: 'String',
            });
        }
        if (!this._objectKeyParam) {
            this._objectKeyParam = new cdk.CfnParameter(scope, 'LambdaSourceObjectKeyParameter', {
                type: 'String',
            });
        }
        return {
            s3Location: {
                bucketName: this._bucketNameParam.valueAsString,
                objectKey: this._objectKeyParam.valueAsString,
            },
        };
    }
    /**
     * Create a parameters map from this instance's CloudFormation parameters.
     *
     * It returns a map with 2 keys that correspond to the names of the parameters defined in this Lambda code,
     * and as values it contains the appropriate expressions pointing at the provided S3 location
     * (most likely, obtained from a CodePipeline Artifact by calling the `artifact.s3Location` method).
     * The result should be provided to the CloudFormation Action
     * that is deploying the Stack that the Lambda with this code is part of,
     * in the `parameterOverrides` property.
     *
     * @param location the location of the object in S3 that represents the Lambda code
     */
    assign(location) {
        jsiiDeprecationWarnings.monocdk_aws_s3_Location(location);
        const ret = {};
        ret[this.bucketNameParam] = location.bucketName;
        ret[this.objectKeyParam] = location.objectKey;
        return ret;
    }
    get bucketNameParam() {
        if (this._bucketNameParam) {
            return this._bucketNameParam.logicalId;
        }
        else {
            throw new Error('Pass CfnParametersCode to a Lambda Function before accessing the bucketNameParam property');
        }
    }
    get objectKeyParam() {
        if (this._objectKeyParam) {
            return this._objectKeyParam.logicalId;
        }
        else {
            throw new Error('Pass CfnParametersCode to a Lambda Function before accessing the objectKeyParam property');
        }
    }
}
exports.CfnParametersCode = CfnParametersCode;
_e = JSII_RTTI_SYMBOL_1;
CfnParametersCode[_e] = { fqn: "monocdk.aws_lambda.CfnParametersCode", version: "1.149.0" };
/**
 * Represents a Docker image in ECR that can be bound as Lambda Code.
 */
class EcrImageCode extends Code {
    constructor(repository, props = {}) {
        super();
        this.repository = repository;
        this.props = props;
        this.isInline = false;
        jsiiDeprecationWarnings.monocdk_aws_ecr_IRepository(repository);
        jsiiDeprecationWarnings.monocdk_aws_lambda_EcrImageCodeProps(props);
    }
    bind(_) {
        var _h, _j;
        jsiiDeprecationWarnings.monocdk_Construct(_);
        this.repository.grantPull(new iam.ServicePrincipal('lambda.amazonaws.com'));
        return {
            image: {
                imageUri: this.repository.repositoryUriForTag((_j = (_h = this.props) === null || _h === void 0 ? void 0 : _h.tag) !== null && _j !== void 0 ? _j : 'latest'),
                cmd: this.props.cmd,
                entrypoint: this.props.entrypoint,
                workingDirectory: this.props.workingDirectory,
            },
        };
    }
}
exports.EcrImageCode = EcrImageCode;
_f = JSII_RTTI_SYMBOL_1;
EcrImageCode[_f] = { fqn: "monocdk.aws_lambda.EcrImageCode", version: "1.149.0" };
/**
 * Represents an ECR image that will be constructed from the specified asset and can be bound as Lambda code.
 */
class AssetImageCode extends Code {
    constructor(directory, props) {
        super();
        this.directory = directory;
        this.props = props;
        this.isInline = false;
        jsiiDeprecationWarnings.monocdk_aws_lambda_AssetImageCodeProps(props);
    }
    bind(scope) {
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        // If the same AssetImageCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new ecr_assets.DockerImageAsset(scope, 'AssetImage', {
                directory: this.directory,
                ...this.props,
            });
            this.asset.repository.grantPull(new iam.ServicePrincipal('lambda.amazonaws.com'));
        }
        else if (cdk.Stack.of(this.asset) !== cdk.Stack.of(scope)) {
            throw new Error(`Asset is already associated with another stack '${cdk.Stack.of(this.asset).stackName}'. ` +
                'Create a new Code instance for every stack.');
        }
        return {
            image: {
                imageUri: this.asset.imageUri,
                entrypoint: this.props.entrypoint,
                cmd: this.props.cmd,
                workingDirectory: this.props.workingDirectory,
            },
        };
    }
    bindToResource(resource, options = {}) {
        jsiiDeprecationWarnings.monocdk_CfnResource(resource);
        jsiiDeprecationWarnings.monocdk_aws_lambda_ResourceBindOptions(options);
        if (!this.asset) {
            throw new Error('bindToResource() must be called after bind()');
        }
        const resourceProperty = options.resourceProperty || 'Code.ImageUri';
        // https://github.com/aws/aws-cdk/issues/14593
        this.asset.addResourceMetadata(resource, resourceProperty);
    }
}
exports.AssetImageCode = AssetImageCode;
_g = JSII_RTTI_SYMBOL_1;
AssetImageCode[_g] = { fqn: "monocdk.aws_lambda.AssetImageCode", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29kZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNvZGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0EsbURBQW1EO0FBQ25ELHFDQUFxQztBQUVyQyxpREFBaUQ7QUFDakQsa0NBQWtDO0FBTWxDOztHQUVHO0FBQ0gsTUFBc0IsSUFBSTtJQUN4Qjs7Ozs7T0FLRztJQUNJLE1BQU0sQ0FBQyxVQUFVLENBQUMsTUFBa0IsRUFBRSxHQUFXLEVBQUUsYUFBc0I7O1FBQzlFLE9BQU8sSUFBSSxNQUFNLENBQUMsTUFBTSxFQUFFLEdBQUcsRUFBRSxhQUFhLENBQUMsQ0FBQztLQUMvQztJQUVEOzs7T0FHRztJQUNJLE1BQU0sQ0FBQyxNQUFNLENBQUMsTUFBa0IsRUFBRSxHQUFXLEVBQUUsYUFBc0I7OztRQUMxRSxPQUFPLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxFQUFFLEdBQUcsRUFBRSxhQUFhLENBQUMsQ0FBQztLQUNwRDtJQUVEOzs7O09BSUc7SUFDSSxNQUFNLENBQUMsVUFBVSxDQUFDLElBQVk7UUFDbkMsT0FBTyxJQUFJLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQztLQUM3QjtJQUVEOzs7T0FHRztJQUNJLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBWTs7UUFDL0IsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDO0tBQzlCO0lBRUQ7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyxTQUFTLENBQUMsSUFBWSxFQUFFLE9BQWdDOztRQUNwRSxPQUFPLElBQUksU0FBUyxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQztLQUNyQztJQUVEOzs7Ozs7OztPQVFHO0lBQ0ksTUFBTSxDQUFDLGVBQWUsQ0FBQyxJQUFZLEVBQUUsVUFBbUMsRUFBRTs7O1FBQy9FLElBQUksU0FBUyxTQUFHLE9BQU8sQ0FBQyxTQUFTLG1DQUFJLFVBQVUsQ0FBQztRQUVoRCxxRUFBcUU7UUFDckUsSUFBSSxTQUFTLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQzNCLFNBQVMsR0FBRyxHQUFHLFNBQVMsR0FBRyxDQUFDO1NBQzdCO2FBQU0sSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQUU7WUFDcEMsU0FBUyxHQUFHLEdBQUcsU0FBUyxJQUFJLENBQUM7U0FDOUI7UUFFRCxNQUFNLFNBQVMsR0FBRyxHQUFHLENBQUMsV0FBVzthQUM5QixTQUFTLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQzthQUN4QixFQUFFLENBQUMsU0FBUyxFQUFFLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUVyQyxPQUFPLElBQUksU0FBUyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0tBQ2pDO0lBRUQ7OztPQUdHO0lBQ0ksTUFBTSxDQUFDLEtBQUssQ0FBQyxJQUFZOztRQUM5QixPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUM7S0FDN0I7SUFFRDs7Ozs7T0FLRztJQUNJLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxLQUE4Qjs7UUFDNUQsT0FBTyxJQUFJLGlCQUFpQixDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQ3JDO0lBRUQ7OztPQUdHO0lBQ0ksTUFBTSxDQUFDLGFBQWEsQ0FBQyxLQUE4Qjs7O1FBQ3hELE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQ3RDO0lBRUQ7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyxZQUFZLENBQUMsVUFBMkIsRUFBRSxLQUF5Qjs7O1FBQy9FLE9BQU8sSUFBSSxZQUFZLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxDQUFDO0tBQzVDO0lBRUQ7Ozs7T0FJRztJQUNJLE1BQU0sQ0FBQyxjQUFjLENBQUMsU0FBaUIsRUFBRSxRQUE2QixFQUFFOztRQUM3RSxPQUFPLElBQUksY0FBYyxDQUFDLFNBQVMsRUFBRSxLQUFLLENBQUMsQ0FBQztLQUM3QztJQW1CRDs7OztPQUlHO0lBQ0ksY0FBYyxDQUFDLFNBQTBCLEVBQUUsUUFBOEI7OztRQUM5RSxPQUFPO0tBQ1I7O0FBM0lILG9CQTRJQzs7O0FBNEREOztHQUVHO0FBQ0gsTUFBYSxNQUFPLFNBQVEsSUFBSTtJQUk5QixZQUFZLE1BQWtCLEVBQVUsR0FBVyxFQUFVLGFBQXNCO1FBQ2pGLEtBQUssRUFBRSxDQUFDO1FBRDhCLFFBQUcsR0FBSCxHQUFHLENBQVE7UUFBVSxrQkFBYSxHQUFiLGFBQWEsQ0FBUztRQUhuRSxhQUFRLEdBQUcsS0FBSyxDQUFDOztRQU0vQixJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFBRTtZQUN0QixNQUFNLElBQUksS0FBSyxDQUFDLGlEQUFpRCxDQUFDLENBQUM7U0FDcEU7UUFFRCxJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7S0FDckM7SUFFTSxJQUFJLENBQUMsTUFBaUI7O1FBQzNCLE9BQU87WUFDTCxVQUFVLEVBQUU7Z0JBQ1YsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO2dCQUMzQixTQUFTLEVBQUUsSUFBSSxDQUFDLEdBQUc7Z0JBQ25CLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTthQUNsQztTQUNGLENBQUM7S0FDSDs7QUF0Qkgsd0JBdUJDOzs7QUFFRDs7R0FFRztBQUNILE1BQWEsVUFBVyxTQUFRLElBQUk7SUFHbEMsWUFBb0IsSUFBWTtRQUM5QixLQUFLLEVBQUUsQ0FBQztRQURVLFNBQUksR0FBSixJQUFJLENBQVE7UUFGaEIsYUFBUSxHQUFHLElBQUksQ0FBQztRQUs5QixJQUFJLElBQUksQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQ3JCLE1BQU0sSUFBSSxLQUFLLENBQUMsb0NBQW9DLENBQUMsQ0FBQztTQUN2RDtRQUVELElBQUksSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLEVBQUU7WUFDdEIsTUFBTSxJQUFJLEtBQUssQ0FBQyxxREFBcUQsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUM7U0FDdEY7S0FDRjtJQUVNLElBQUksQ0FBQyxNQUFpQjs7UUFDM0IsT0FBTztZQUNMLFVBQVUsRUFBRSxJQUFJLENBQUMsSUFBSTtTQUN0QixDQUFDO0tBQ0g7O0FBbkJILGdDQW9CQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFhLFNBQVUsU0FBUSxJQUFJO0lBSWpDOztPQUVHO0lBQ0gsWUFBNEIsSUFBWSxFQUFtQixVQUFrQyxFQUFHO1FBQzlGLEtBQUssRUFBRSxDQUFDO1FBRGtCLFNBQUksR0FBSixJQUFJLENBQVE7UUFBbUIsWUFBTyxHQUFQLE9BQU8sQ0FBOEI7UUFOaEYsYUFBUSxHQUFHLEtBQUssQ0FBQzs7S0FRaEM7SUFFTSxJQUFJLENBQUMsS0FBZ0I7O1FBQzFCLHFGQUFxRjtRQUNyRixJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRTtZQUNmLElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSxTQUFTLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxNQUFNLEVBQUU7Z0JBQzlDLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtnQkFDZixHQUFHLElBQUksQ0FBQyxPQUFPO2FBQ2hCLENBQUMsQ0FBQztTQUNKO2FBQU0sSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDM0QsTUFBTSxJQUFJLEtBQUssQ0FBQyxtREFBbUQsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLFNBQVMsS0FBSztnQkFDeEcsNkNBQTZDLENBQUMsQ0FBQztTQUNsRDtRQUVELElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRTtZQUM1QixNQUFNLElBQUksS0FBSyxDQUFDLDZDQUE2QyxJQUFJLENBQUMsSUFBSSxHQUFHLENBQUMsQ0FBQztTQUM1RTtRQUVELE9BQU87WUFDTCxVQUFVLEVBQUU7Z0JBQ1YsVUFBVSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWTtnQkFDbkMsU0FBUyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVzthQUNsQztTQUNGLENBQUM7S0FDSDtJQUVNLGNBQWMsQ0FBQyxRQUF5QixFQUFFLFVBQStCLEVBQUc7OztRQUNqRixJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRTtZQUNmLE1BQU0sSUFBSSxLQUFLLENBQUMsOENBQThDLENBQUMsQ0FBQztTQUNqRTtRQUVELE1BQU0sZ0JBQWdCLEdBQUcsT0FBTyxDQUFDLGdCQUFnQixJQUFJLE1BQU0sQ0FBQztRQUU1RCw2Q0FBNkM7UUFDN0MsSUFBSSxDQUFDLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQyxRQUFRLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztLQUM1RDs7QUE1Q0gsOEJBNkNDOzs7QUFrQ0Q7Ozs7O0dBS0c7QUFDSCxNQUFhLGlCQUFrQixTQUFRLElBQUk7SUFLekMsWUFBWSxRQUFnQyxFQUFFO1FBQzVDLEtBQUssRUFBRSxDQUFDO1FBTE0sYUFBUSxHQUFHLEtBQUssQ0FBQzs7UUFPL0IsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7UUFDOUMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO0tBQzdDO0lBRU0sSUFBSSxDQUFDLEtBQWdCOztRQUMxQixJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixFQUFFO1lBQzFCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLEdBQUcsQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLGlDQUFpQyxFQUFFO2dCQUNyRixJQUFJLEVBQUUsUUFBUTthQUNmLENBQUMsQ0FBQztTQUNKO1FBRUQsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUU7WUFDekIsSUFBSSxDQUFDLGVBQWUsR0FBRyxJQUFJLEdBQUcsQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLGdDQUFnQyxFQUFFO2dCQUNuRixJQUFJLEVBQUUsUUFBUTthQUNmLENBQUMsQ0FBQztTQUNKO1FBRUQsT0FBTztZQUNMLFVBQVUsRUFBRTtnQkFDVixVQUFVLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGFBQWE7Z0JBQy9DLFNBQVMsRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLGFBQWE7YUFDOUM7U0FDRixDQUFDO0tBQ0g7SUFFRDs7Ozs7Ozs7Ozs7T0FXRztJQUNJLE1BQU0sQ0FBQyxRQUFxQjs7UUFDakMsTUFBTSxHQUFHLEdBQTRCLEVBQUUsQ0FBQztRQUN4QyxHQUFHLENBQUMsSUFBSSxDQUFDLGVBQWUsQ0FBQyxHQUFHLFFBQVEsQ0FBQyxVQUFVLENBQUM7UUFDaEQsR0FBRyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsR0FBRyxRQUFRLENBQUMsU0FBUyxDQUFDO1FBQzlDLE9BQU8sR0FBRyxDQUFDO0tBQ1o7SUFFRCxJQUFXLGVBQWU7UUFDeEIsSUFBSSxJQUFJLENBQUMsZ0JBQWdCLEVBQUU7WUFDekIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsU0FBUyxDQUFDO1NBQ3hDO2FBQU07WUFDTCxNQUFNLElBQUksS0FBSyxDQUFDLDJGQUEyRixDQUFDLENBQUM7U0FDOUc7S0FDRjtJQUVELElBQVcsY0FBYztRQUN2QixJQUFJLElBQUksQ0FBQyxlQUFlLEVBQUU7WUFDeEIsT0FBTyxJQUFJLENBQUMsZUFBZSxDQUFDLFNBQVMsQ0FBQztTQUN2QzthQUFNO1lBQ0wsTUFBTSxJQUFJLEtBQUssQ0FBQywwRkFBMEYsQ0FBQyxDQUFDO1NBQzdHO0tBQ0Y7O0FBbEVILDhDQW1FQzs7O0FBc0NEOztHQUVHO0FBQ0gsTUFBYSxZQUFhLFNBQVEsSUFBSTtJQUdwQyxZQUE2QixVQUEyQixFQUFtQixRQUEyQixFQUFFO1FBQ3RHLEtBQUssRUFBRSxDQUFDO1FBRG1CLGVBQVUsR0FBVixVQUFVLENBQWlCO1FBQW1CLFVBQUssR0FBTCxLQUFLLENBQXdCO1FBRnhGLGFBQVEsR0FBWSxLQUFLLENBQUM7OztLQUl6QztJQUVNLElBQUksQ0FBQyxDQUFZOzs7UUFDdEIsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxDQUFDO1FBRTVFLE9BQU87WUFDTCxLQUFLLEVBQUU7Z0JBQ0wsUUFBUSxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsbUJBQW1CLGFBQUMsSUFBSSxDQUFDLEtBQUssMENBQUUsR0FBRyxtQ0FBSSxRQUFRLENBQUM7Z0JBQzFFLEdBQUcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUc7Z0JBQ25CLFVBQVUsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVU7Z0JBQ2pDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCO2FBQzlDO1NBQ0YsQ0FBQztLQUNIOztBQWxCSCxvQ0FtQkM7OztBQWdDRDs7R0FFRztBQUNILE1BQWEsY0FBZSxTQUFRLElBQUk7SUFJdEMsWUFBNkIsU0FBaUIsRUFBbUIsS0FBMEI7UUFDekYsS0FBSyxFQUFFLENBQUM7UUFEbUIsY0FBUyxHQUFULFNBQVMsQ0FBUTtRQUFtQixVQUFLLEdBQUwsS0FBSyxDQUFxQjtRQUgzRSxhQUFRLEdBQVksS0FBSyxDQUFDOztLQUt6QztJQUVNLElBQUksQ0FBQyxLQUFnQjs7UUFDMUIsMEZBQTBGO1FBQzFGLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFO1lBQ2YsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxLQUFLLEVBQUUsWUFBWSxFQUFFO2dCQUNoRSxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVM7Z0JBQ3pCLEdBQUcsSUFBSSxDQUFDLEtBQUs7YUFDZCxDQUFDLENBQUM7WUFDSCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxDQUFDO1NBQ25GO2FBQU0sSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDM0QsTUFBTSxJQUFJLEtBQUssQ0FBQyxtREFBbUQsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLFNBQVMsS0FBSztnQkFDeEcsNkNBQTZDLENBQUMsQ0FBQztTQUNsRDtRQUVELE9BQU87WUFDTCxLQUFLLEVBQUU7Z0JBQ0wsUUFBUSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUTtnQkFDN0IsVUFBVSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVTtnQkFDakMsR0FBRyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRztnQkFDbkIsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0I7YUFDOUM7U0FDRixDQUFDO0tBQ0g7SUFFTSxjQUFjLENBQUMsUUFBeUIsRUFBRSxVQUErQixFQUFHOzs7UUFDakYsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUU7WUFDZixNQUFNLElBQUksS0FBSyxDQUFDLDhDQUE4QyxDQUFDLENBQUM7U0FDakU7UUFFRCxNQUFNLGdCQUFnQixHQUFHLE9BQU8sQ0FBQyxnQkFBZ0IsSUFBSSxlQUFlLENBQUM7UUFFckUsOENBQThDO1FBQzlDLElBQUksQ0FBQyxLQUFLLENBQUMsbUJBQW1CLENBQUMsUUFBUSxFQUFFLGdCQUFnQixDQUFDLENBQUM7S0FDNUQ7O0FBeENILHdDQXlDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjciBmcm9tICcuLi8uLi9hd3MtZWNyJztcbmltcG9ydCAqIGFzIGVjcl9hc3NldHMgZnJvbSAnLi4vLi4vYXdzLWVjci1hc3NldHMnO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJy4uLy4uL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgczMgZnJvbSAnLi4vLi4vYXdzLXMzJztcbmltcG9ydCAqIGFzIHMzX2Fzc2V0cyBmcm9tICcuLi8uLi9hd3MtczMtYXNzZXRzJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICcuLi8uLi9jb3JlJztcblxuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJy4uLy4uL2NvcmUnO1xuXG4vKipcbiAqIFJlcHJlc2VudHMgdGhlIExhbWJkYSBIYW5kbGVyIENvZGUuXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBDb2RlIHtcbiAgLyoqXG4gICAqIExhbWJkYSBoYW5kbGVyIGNvZGUgYXMgYW4gUzMgb2JqZWN0LlxuICAgKiBAcGFyYW0gYnVja2V0IFRoZSBTMyBidWNrZXRcbiAgICogQHBhcmFtIGtleSBUaGUgb2JqZWN0IGtleVxuICAgKiBAcGFyYW0gb2JqZWN0VmVyc2lvbiBPcHRpb25hbCBTMyBvYmplY3QgdmVyc2lvblxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tQnVja2V0KGJ1Y2tldDogczMuSUJ1Y2tldCwga2V5OiBzdHJpbmcsIG9iamVjdFZlcnNpb24/OiBzdHJpbmcpOiBTM0NvZGUge1xuICAgIHJldHVybiBuZXcgUzNDb2RlKGJ1Y2tldCwga2V5LCBvYmplY3RWZXJzaW9uKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBERVBSRUNBVEVEXG4gICAqIEBkZXByZWNhdGVkIHVzZSBgZnJvbUJ1Y2tldGBcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgYnVja2V0KGJ1Y2tldDogczMuSUJ1Y2tldCwga2V5OiBzdHJpbmcsIG9iamVjdFZlcnNpb24/OiBzdHJpbmcpOiBTM0NvZGUge1xuICAgIHJldHVybiB0aGlzLmZyb21CdWNrZXQoYnVja2V0LCBrZXksIG9iamVjdFZlcnNpb24pO1xuICB9XG5cbiAgLyoqXG4gICAqIElubGluZSBjb2RlIGZvciBMYW1iZGEgaGFuZGxlclxuICAgKiBAcmV0dXJucyBgTGFtYmRhSW5saW5lQ29kZWAgd2l0aCBpbmxpbmUgY29kZS5cbiAgICogQHBhcmFtIGNvZGUgVGhlIGFjdHVhbCBoYW5kbGVyIGNvZGUgKGxpbWl0ZWQgdG8gNEtpQilcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUlubGluZShjb2RlOiBzdHJpbmcpOiBJbmxpbmVDb2RlIHtcbiAgICByZXR1cm4gbmV3IElubGluZUNvZGUoY29kZSk7XG4gIH1cblxuICAvKipcbiAgICogREVQUkVDQVRFRFxuICAgKiBAZGVwcmVjYXRlZCB1c2UgYGZyb21JbmxpbmVgXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGlubGluZShjb2RlOiBzdHJpbmcpOiBJbmxpbmVDb2RlIHtcbiAgICByZXR1cm4gdGhpcy5mcm9tSW5saW5lKGNvZGUpO1xuICB9XG5cbiAgLyoqXG4gICAqIExvYWRzIHRoZSBmdW5jdGlvbiBjb2RlIGZyb20gYSBsb2NhbCBkaXNrIHBhdGguXG4gICAqXG4gICAqIEBwYXJhbSBwYXRoIEVpdGhlciBhIGRpcmVjdG9yeSB3aXRoIHRoZSBMYW1iZGEgY29kZSBidW5kbGUgb3IgYSAuemlwIGZpbGVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUFzc2V0KHBhdGg6IHN0cmluZywgb3B0aW9ucz86IHMzX2Fzc2V0cy5Bc3NldE9wdGlvbnMpOiBBc3NldENvZGUge1xuICAgIHJldHVybiBuZXcgQXNzZXRDb2RlKHBhdGgsIG9wdGlvbnMpO1xuICB9XG5cbiAgLyoqXG4gICAqIExvYWRzIHRoZSBmdW5jdGlvbiBjb2RlIGZyb20gYW4gYXNzZXQgY3JlYXRlZCBieSBhIERvY2tlciBidWlsZC5cbiAgICpcbiAgICogQnkgZGVmYXVsdCwgdGhlIGFzc2V0IGlzIGV4cGVjdGVkIHRvIGJlIGxvY2F0ZWQgYXQgYC9hc3NldGAgaW4gdGhlXG4gICAqIGltYWdlLlxuICAgKlxuICAgKiBAcGFyYW0gcGF0aCBUaGUgcGF0aCB0byB0aGUgZGlyZWN0b3J5IGNvbnRhaW5pbmcgdGhlIERvY2tlciBmaWxlXG4gICAqIEBwYXJhbSBvcHRpb25zIERvY2tlciBidWlsZCBvcHRpb25zXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Eb2NrZXJCdWlsZChwYXRoOiBzdHJpbmcsIG9wdGlvbnM6IERvY2tlckJ1aWxkQXNzZXRPcHRpb25zID0ge30pOiBBc3NldENvZGUge1xuICAgIGxldCBpbWFnZVBhdGggPSBvcHRpb25zLmltYWdlUGF0aCA/PyAnL2Fzc2V0Ly4nO1xuXG4gICAgLy8gZW5zdXJlIGltYWdlUGF0aCBlbmRzIHdpdGggLy4gdG8gY29weSB0aGUgKipjb250ZW50KiogYXQgdGhpcyBwYXRoXG4gICAgaWYgKGltYWdlUGF0aC5lbmRzV2l0aCgnLycpKSB7XG4gICAgICBpbWFnZVBhdGggPSBgJHtpbWFnZVBhdGh9LmA7XG4gICAgfSBlbHNlIGlmICghaW1hZ2VQYXRoLmVuZHNXaXRoKCcvLicpKSB7XG4gICAgICBpbWFnZVBhdGggPSBgJHtpbWFnZVBhdGh9Ly5gO1xuICAgIH1cblxuICAgIGNvbnN0IGFzc2V0UGF0aCA9IGNkay5Eb2NrZXJJbWFnZVxuICAgICAgLmZyb21CdWlsZChwYXRoLCBvcHRpb25zKVxuICAgICAgLmNwKGltYWdlUGF0aCwgb3B0aW9ucy5vdXRwdXRQYXRoKTtcblxuICAgIHJldHVybiBuZXcgQXNzZXRDb2RlKGFzc2V0UGF0aCk7XG4gIH1cblxuICAvKipcbiAgICogREVQUkVDQVRFRFxuICAgKiBAZGVwcmVjYXRlZCB1c2UgYGZyb21Bc3NldGBcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgYXNzZXQocGF0aDogc3RyaW5nKTogQXNzZXRDb2RlIHtcbiAgICByZXR1cm4gdGhpcy5mcm9tQXNzZXQocGF0aCk7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhIG5ldyBMYW1iZGEgc291cmNlIGRlZmluZWQgdXNpbmcgQ2xvdWRGb3JtYXRpb24gcGFyYW1ldGVycy5cbiAgICpcbiAgICogQHJldHVybnMgYSBuZXcgaW5zdGFuY2Ugb2YgYENmblBhcmFtZXRlcnNDb2RlYFxuICAgKiBAcGFyYW0gcHJvcHMgb3B0aW9uYWwgY29uc3RydWN0aW9uIHByb3BlcnRpZXMgb2Yge0BsaW5rIENmblBhcmFtZXRlcnNDb2RlfVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tQ2ZuUGFyYW1ldGVycyhwcm9wcz86IENmblBhcmFtZXRlcnNDb2RlUHJvcHMpOiBDZm5QYXJhbWV0ZXJzQ29kZSB7XG4gICAgcmV0dXJuIG5ldyBDZm5QYXJhbWV0ZXJzQ29kZShwcm9wcyk7XG4gIH1cblxuICAvKipcbiAgICogREVQUkVDQVRFRFxuICAgKiBAZGVwcmVjYXRlZCB1c2UgYGZyb21DZm5QYXJhbWV0ZXJzYFxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBjZm5QYXJhbWV0ZXJzKHByb3BzPzogQ2ZuUGFyYW1ldGVyc0NvZGVQcm9wcyk6IENmblBhcmFtZXRlcnNDb2RlIHtcbiAgICByZXR1cm4gdGhpcy5mcm9tQ2ZuUGFyYW1ldGVycyhwcm9wcyk7XG4gIH1cblxuICAvKipcbiAgICogVXNlIGFuIGV4aXN0aW5nIEVDUiBpbWFnZSBhcyB0aGUgTGFtYmRhIGNvZGUuXG4gICAqIEBwYXJhbSByZXBvc2l0b3J5IHRoZSBFQ1IgcmVwb3NpdG9yeSB0aGF0IHRoZSBpbWFnZSBpcyBpblxuICAgKiBAcGFyYW0gcHJvcHMgcHJvcGVydGllcyB0byBmdXJ0aGVyIGNvbmZpZ3VyZSB0aGUgc2VsZWN0ZWQgaW1hZ2VcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUVjckltYWdlKHJlcG9zaXRvcnk6IGVjci5JUmVwb3NpdG9yeSwgcHJvcHM/OiBFY3JJbWFnZUNvZGVQcm9wcykge1xuICAgIHJldHVybiBuZXcgRWNySW1hZ2VDb2RlKHJlcG9zaXRvcnksIHByb3BzKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGUgYW4gRUNSIGltYWdlIGZyb20gdGhlIHNwZWNpZmllZCBhc3NldCBhbmQgYmluZCBpdCBhcyB0aGUgTGFtYmRhIGNvZGUuXG4gICAqIEBwYXJhbSBkaXJlY3RvcnkgdGhlIGRpcmVjdG9yeSBmcm9tIHdoaWNoIHRoZSBhc3NldCBtdXN0IGJlIGNyZWF0ZWRcbiAgICogQHBhcmFtIHByb3BzIHByb3BlcnRpZXMgdG8gZnVydGhlciBjb25maWd1cmUgdGhlIHNlbGVjdGVkIGltYWdlXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Bc3NldEltYWdlKGRpcmVjdG9yeTogc3RyaW5nLCBwcm9wczogQXNzZXRJbWFnZUNvZGVQcm9wcyA9IHt9KSB7XG4gICAgcmV0dXJuIG5ldyBBc3NldEltYWdlQ29kZShkaXJlY3RvcnksIHByb3BzKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZXRlcm1pbmVzIHdoZXRoZXIgdGhpcyBDb2RlIGlzIGlubGluZSBjb2RlIG9yIG5vdC5cbiAgICpcbiAgICogQGRlcHJlY2F0ZWQgdGhpcyB2YWx1ZSBpcyBpZ25vcmVkIHNpbmNlIGlubGluZSBpcyBub3cgZGV0ZXJtaW5lZCBiYXNlZCBvbiB0aGVcbiAgICogdGhlIGBpbmxpbmVDb2RlYCBmaWVsZCBvZiBgQ29kZUNvbmZpZ2AgcmV0dXJuZWQgZnJvbSBgYmluZCgpYC5cbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBpc0lubGluZTogYm9vbGVhbjtcblxuICAvKipcbiAgICogQ2FsbGVkIHdoZW4gdGhlIGxhbWJkYSBvciBsYXllciBpcyBpbml0aWFsaXplZCB0byBhbGxvdyB0aGlzIG9iamVjdCB0byBiaW5kXG4gICAqIHRvIHRoZSBzdGFjaywgYWRkIHJlc291cmNlcyBhbmQgaGF2ZSBmdW4uXG4gICAqXG4gICAqIEBwYXJhbSBzY29wZSBUaGUgYmluZGluZyBzY29wZS4gRG9uJ3QgYmUgc21hcnQgYWJvdXQgdHJ5aW5nIHRvIGRvd24tY2FzdCBvclxuICAgKiBhc3N1bWUgaXQncyBpbml0aWFsaXplZC4gWW91IG1heSBqdXN0IHVzZSBpdCBhcyBhIGNvbnN0cnVjdCBzY29wZS5cbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QpOiBDb2RlQ29uZmlnO1xuXG4gIC8qKlxuICAgKiBDYWxsZWQgYWZ0ZXIgdGhlIENGTiBmdW5jdGlvbiByZXNvdXJjZSBoYXMgYmVlbiBjcmVhdGVkIHRvIGFsbG93IHRoZSBjb2RlXG4gICAqIGNsYXNzIHRvIGJpbmQgdG8gaXQuIFNwZWNpZmljYWxseSBpdCdzIHJlcXVpcmVkIHRvIGFsbG93IGFzc2V0cyB0byBhZGRcbiAgICogbWV0YWRhdGEgZm9yIHRvb2xpbmcgbGlrZSBTQU0gQ0xJIHRvIGJlIGFibGUgdG8gZmluZCB0aGVpciBvcmlnaW5zLlxuICAgKi9cbiAgcHVibGljIGJpbmRUb1Jlc291cmNlKF9yZXNvdXJjZTogY2RrLkNmblJlc291cmNlLCBfb3B0aW9ucz86IFJlc291cmNlQmluZE9wdGlvbnMpIHtcbiAgICByZXR1cm47XG4gIH1cbn1cblxuLyoqXG4gKiBSZXN1bHQgb2YgYmluZGluZyBgQ29kZWAgaW50byBhIGBGdW5jdGlvbmAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZUNvbmZpZyB7XG4gIC8qKlxuICAgKiBUaGUgbG9jYXRpb24gb2YgdGhlIGNvZGUgaW4gUzMgKG11dHVhbGx5IGV4Y2x1c2l2ZSB3aXRoIGBpbmxpbmVDb2RlYCBhbmQgYGltYWdlYCkuXG4gICAqIEBkZWZhdWx0IC0gY29kZSBpcyBub3QgYW4gczMgbG9jYXRpb25cbiAgICovXG4gIHJlYWRvbmx5IHMzTG9jYXRpb24/OiBzMy5Mb2NhdGlvbjtcblxuICAvKipcbiAgICogSW5saW5lIGNvZGUgKG11dHVhbGx5IGV4Y2x1c2l2ZSB3aXRoIGBzM0xvY2F0aW9uYCBhbmQgYGltYWdlYCkuXG4gICAqIEBkZWZhdWx0IC0gY29kZSBpcyBub3QgaW5saW5lIGNvZGVcbiAgICovXG4gIHJlYWRvbmx5IGlubGluZUNvZGU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIERvY2tlciBpbWFnZSBjb25maWd1cmF0aW9uIChtdXR1YWxseSBleGNsdXNpdmUgd2l0aCBgczNMb2NhdGlvbmAgYW5kIGBpbmxpbmVDb2RlYCkuXG4gICAqIEBkZWZhdWx0IC0gY29kZSBpcyBub3QgYW4gRUNSIGNvbnRhaW5lciBpbWFnZVxuICAgKi9cbiAgcmVhZG9ubHkgaW1hZ2U/OiBDb2RlSW1hZ2VDb25maWc7XG59XG5cbi8qKlxuICogUmVzdWx0IG9mIHRoZSBiaW5kIHdoZW4gYW4gRUNSIGltYWdlIGlzIHVzZWQuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ29kZUltYWdlQ29uZmlnIHtcbiAgLyoqXG4gICAqIFVSSSB0byB0aGUgRG9ja2VyIGltYWdlLlxuICAgKi9cbiAgcmVhZG9ubHkgaW1hZ2VVcmk6IHN0cmluZztcblxuICAvKipcbiAgICogU3BlY2lmeSBvciBvdmVycmlkZSB0aGUgQ01EIG9uIHRoZSBzcGVjaWZpZWQgRG9ja2VyIGltYWdlIG9yIERvY2tlcmZpbGUuXG4gICAqIFRoaXMgbmVlZHMgdG8gYmUgaW4gdGhlICdleGVjIGZvcm0nLCB2aXouLCBgWyAnZXhlY3V0YWJsZScsICdwYXJhbTEnLCAncGFyYW0yJyBdYC5cbiAgICogQHNlZSBodHRwczovL2RvY3MuZG9ja2VyLmNvbS9lbmdpbmUvcmVmZXJlbmNlL2J1aWxkZXIvI2NtZFxuICAgKiBAZGVmYXVsdCAtIHVzZSB0aGUgQ01EIHNwZWNpZmllZCBpbiB0aGUgZG9ja2VyIGltYWdlIG9yIERvY2tlcmZpbGUuXG4gICAqL1xuICByZWFkb25seSBjbWQ/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogU3BlY2lmeSBvciBvdmVycmlkZSB0aGUgRU5UUllQT0lOVCBvbiB0aGUgc3BlY2lmaWVkIERvY2tlciBpbWFnZSBvciBEb2NrZXJmaWxlLlxuICAgKiBBbiBFTlRSWVBPSU5UIGFsbG93cyB5b3UgdG8gY29uZmlndXJlIGEgY29udGFpbmVyIHRoYXQgd2lsbCBydW4gYXMgYW4gZXhlY3V0YWJsZS5cbiAgICogVGhpcyBuZWVkcyB0byBiZSBpbiB0aGUgJ2V4ZWMgZm9ybScsIHZpei4sIGBbICdleGVjdXRhYmxlJywgJ3BhcmFtMScsICdwYXJhbTInIF1gLlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5kb2NrZXIuY29tL2VuZ2luZS9yZWZlcmVuY2UvYnVpbGRlci8jZW50cnlwb2ludFxuICAgKiBAZGVmYXVsdCAtIHVzZSB0aGUgRU5UUllQT0lOVCBpbiB0aGUgZG9ja2VyIGltYWdlIG9yIERvY2tlcmZpbGUuXG4gICAqL1xuICByZWFkb25seSBlbnRyeXBvaW50Pzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIFNwZWNpZnkgb3Igb3ZlcnJpZGUgdGhlIFdPUktESVIgb24gdGhlIHNwZWNpZmllZCBEb2NrZXIgaW1hZ2Ugb3IgRG9ja2VyZmlsZS5cbiAgICogQSBXT1JLRElSIGFsbG93cyB5b3UgdG8gY29uZmlndXJlIHRoZSB3b3JraW5nIGRpcmVjdG9yeSB0aGUgY29udGFpbmVyIHdpbGwgdXNlLlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5kb2NrZXIuY29tL2VuZ2luZS9yZWZlcmVuY2UvYnVpbGRlci8jd29ya2RpclxuICAgKiBAZGVmYXVsdCAtIHVzZSB0aGUgV09SS0RJUiBpbiB0aGUgZG9ja2VyIGltYWdlIG9yIERvY2tlcmZpbGUuXG4gICAqL1xuICByZWFkb25seSB3b3JraW5nRGlyZWN0b3J5Pzogc3RyaW5nO1xufVxuXG4vKipcbiAqIExhbWJkYSBjb2RlIGZyb20gYW4gUzMgYXJjaGl2ZS5cbiAqL1xuZXhwb3J0IGNsYXNzIFMzQ29kZSBleHRlbmRzIENvZGUge1xuICBwdWJsaWMgcmVhZG9ubHkgaXNJbmxpbmUgPSBmYWxzZTtcbiAgcHJpdmF0ZSBidWNrZXROYW1lOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3IoYnVja2V0OiBzMy5JQnVja2V0LCBwcml2YXRlIGtleTogc3RyaW5nLCBwcml2YXRlIG9iamVjdFZlcnNpb24/OiBzdHJpbmcpIHtcbiAgICBzdXBlcigpO1xuXG4gICAgaWYgKCFidWNrZXQuYnVja2V0TmFtZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdidWNrZXROYW1lIGlzIHVuZGVmaW5lZCBmb3IgdGhlIHByb3ZpZGVkIGJ1Y2tldCcpO1xuICAgIH1cblxuICAgIHRoaXMuYnVja2V0TmFtZSA9IGJ1Y2tldC5idWNrZXROYW1lO1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QpOiBDb2RlQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgczNMb2NhdGlvbjoge1xuICAgICAgICBidWNrZXROYW1lOiB0aGlzLmJ1Y2tldE5hbWUsXG4gICAgICAgIG9iamVjdEtleTogdGhpcy5rZXksXG4gICAgICAgIG9iamVjdFZlcnNpb246IHRoaXMub2JqZWN0VmVyc2lvbixcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIExhbWJkYSBjb2RlIGZyb20gYW4gaW5saW5lIHN0cmluZyAobGltaXRlZCB0byA0S2lCKS5cbiAqL1xuZXhwb3J0IGNsYXNzIElubGluZUNvZGUgZXh0ZW5kcyBDb2RlIHtcbiAgcHVibGljIHJlYWRvbmx5IGlzSW5saW5lID0gdHJ1ZTtcblxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIGNvZGU6IHN0cmluZykge1xuICAgIHN1cGVyKCk7XG5cbiAgICBpZiAoY29kZS5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignTGFtYmRhIGlubGluZSBjb2RlIGNhbm5vdCBiZSBlbXB0eScpO1xuICAgIH1cblxuICAgIGlmIChjb2RlLmxlbmd0aCA+IDQwOTYpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignTGFtYmRhIHNvdXJjZSBpcyB0b28gbGFyZ2UsIG11c3QgYmUgPD0gNDA5NiBidXQgaXMgJyArIGNvZGUubGVuZ3RoKTtcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCk6IENvZGVDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBpbmxpbmVDb2RlOiB0aGlzLmNvZGUsXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIExhbWJkYSBjb2RlIGZyb20gYSBsb2NhbCBkaXJlY3RvcnkuXG4gKi9cbmV4cG9ydCBjbGFzcyBBc3NldENvZGUgZXh0ZW5kcyBDb2RlIHtcbiAgcHVibGljIHJlYWRvbmx5IGlzSW5saW5lID0gZmFsc2U7XG4gIHByaXZhdGUgYXNzZXQ/OiBzM19hc3NldHMuQXNzZXQ7XG5cbiAgLyoqXG4gICAqIEBwYXJhbSBwYXRoIFRoZSBwYXRoIHRvIHRoZSBhc3NldCBmaWxlIG9yIGRpcmVjdG9yeS5cbiAgICovXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyByZWFkb25seSBwYXRoOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgb3B0aW9uczogczNfYXNzZXRzLkFzc2V0T3B0aW9ucyA9IHsgfSkge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICBwdWJsaWMgYmluZChzY29wZTogQ29uc3RydWN0KTogQ29kZUNvbmZpZyB7XG4gICAgLy8gSWYgdGhlIHNhbWUgQXNzZXRDb2RlIGlzIHVzZWQgbXVsdGlwbGUgdGltZXMsIHJldGFpbiBvbmx5IHRoZSBmaXJzdCBpbnN0YW50aWF0aW9uLlxuICAgIGlmICghdGhpcy5hc3NldCkge1xuICAgICAgdGhpcy5hc3NldCA9IG5ldyBzM19hc3NldHMuQXNzZXQoc2NvcGUsICdDb2RlJywge1xuICAgICAgICBwYXRoOiB0aGlzLnBhdGgsXG4gICAgICAgIC4uLnRoaXMub3B0aW9ucyxcbiAgICAgIH0pO1xuICAgIH0gZWxzZSBpZiAoY2RrLlN0YWNrLm9mKHRoaXMuYXNzZXQpICE9PSBjZGsuU3RhY2sub2Yoc2NvcGUpKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYEFzc2V0IGlzIGFscmVhZHkgYXNzb2NpYXRlZCB3aXRoIGFub3RoZXIgc3RhY2sgJyR7Y2RrLlN0YWNrLm9mKHRoaXMuYXNzZXQpLnN0YWNrTmFtZX0nLiBgICtcbiAgICAgICAgJ0NyZWF0ZSBhIG5ldyBDb2RlIGluc3RhbmNlIGZvciBldmVyeSBzdGFjay4nKTtcbiAgICB9XG5cbiAgICBpZiAoIXRoaXMuYXNzZXQuaXNaaXBBcmNoaXZlKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYEFzc2V0IG11c3QgYmUgYSAuemlwIGZpbGUgb3IgYSBkaXJlY3RvcnkgKCR7dGhpcy5wYXRofSlgKTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgczNMb2NhdGlvbjoge1xuICAgICAgICBidWNrZXROYW1lOiB0aGlzLmFzc2V0LnMzQnVja2V0TmFtZSxcbiAgICAgICAgb2JqZWN0S2V5OiB0aGlzLmFzc2V0LnMzT2JqZWN0S2V5LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgcHVibGljIGJpbmRUb1Jlc291cmNlKHJlc291cmNlOiBjZGsuQ2ZuUmVzb3VyY2UsIG9wdGlvbnM6IFJlc291cmNlQmluZE9wdGlvbnMgPSB7IH0pIHtcbiAgICBpZiAoIXRoaXMuYXNzZXQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignYmluZFRvUmVzb3VyY2UoKSBtdXN0IGJlIGNhbGxlZCBhZnRlciBiaW5kKCknKTtcbiAgICB9XG5cbiAgICBjb25zdCByZXNvdXJjZVByb3BlcnR5ID0gb3B0aW9ucy5yZXNvdXJjZVByb3BlcnR5IHx8ICdDb2RlJztcblxuICAgIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9hd3MvYXdzLWNkay9pc3N1ZXMvMTQzMlxuICAgIHRoaXMuYXNzZXQuYWRkUmVzb3VyY2VNZXRhZGF0YShyZXNvdXJjZSwgcmVzb3VyY2VQcm9wZXJ0eSk7XG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBSZXNvdXJjZUJpbmRPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0eSB0byBhbm5vdGF0ZSB3aXRoIGFzc2V0IG1ldGFkYXRhLlxuICAgKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9hd3MvYXdzLWNkay9pc3N1ZXMvMTQzMlxuICAgKiBAZGVmYXVsdCBDb2RlXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZVByb3BlcnR5Pzogc3RyaW5nO1xufVxuXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciB7QGxpbmsgQ2ZuUGFyYW1ldGVyc0NvZGV9LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmblBhcmFtZXRlcnNDb2RlUHJvcHMge1xuICAvKipcbiAgICogVGhlIENsb3VkRm9ybWF0aW9uIHBhcmFtZXRlciB0aGF0IHJlcHJlc2VudHMgdGhlIG5hbWUgb2YgdGhlIFMzIEJ1Y2tldFxuICAgKiB3aGVyZSB0aGUgTGFtYmRhIGNvZGUgd2lsbCBiZSBsb2NhdGVkIGluLlxuICAgKiBNdXN0IGJlIG9mIHR5cGUgJ1N0cmluZycuXG4gICAqXG4gICAqIEBkZWZhdWx0IGEgbmV3IHBhcmFtZXRlciB3aWxsIGJlIGNyZWF0ZWRcbiAgICovXG4gIHJlYWRvbmx5IGJ1Y2tldE5hbWVQYXJhbT86IGNkay5DZm5QYXJhbWV0ZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBDbG91ZEZvcm1hdGlvbiBwYXJhbWV0ZXIgdGhhdCByZXByZXNlbnRzIHRoZSBwYXRoIGluc2lkZSB0aGUgUzMgQnVja2V0XG4gICAqIHdoZXJlIHRoZSBMYW1iZGEgY29kZSB3aWxsIGJlIGxvY2F0ZWQgYXQuXG4gICAqIE11c3QgYmUgb2YgdHlwZSAnU3RyaW5nJy5cbiAgICpcbiAgICogQGRlZmF1bHQgYSBuZXcgcGFyYW1ldGVyIHdpbGwgYmUgY3JlYXRlZFxuICAgKi9cbiAgcmVhZG9ubHkgb2JqZWN0S2V5UGFyYW0/OiBjZGsuQ2ZuUGFyYW1ldGVyO1xufVxuXG4vKipcbiAqIExhbWJkYSBjb2RlIGRlZmluZWQgdXNpbmcgMiBDbG91ZEZvcm1hdGlvbiBwYXJhbWV0ZXJzLlxuICogVXNlZnVsIHdoZW4geW91IGRvbid0IGhhdmUgYWNjZXNzIHRvIHRoZSBjb2RlIG9mIHlvdXIgTGFtYmRhIGZyb20geW91ciBDREsgY29kZSwgc28geW91IGNhbid0IHVzZSBBc3NldHMsXG4gKiBhbmQgeW91IHdhbnQgdG8gZGVwbG95IHRoZSBMYW1iZGEgaW4gYSBDb2RlUGlwZWxpbmUsIHVzaW5nIENsb3VkRm9ybWF0aW9uIEFjdGlvbnMgLVxuICogeW91IGNhbiBmaWxsIHRoZSBwYXJhbWV0ZXJzIHVzaW5nIHRoZSB7QGxpbmsgI2Fzc2lnbn0gbWV0aG9kLlxuICovXG5leHBvcnQgY2xhc3MgQ2ZuUGFyYW1ldGVyc0NvZGUgZXh0ZW5kcyBDb2RlIHtcbiAgcHVibGljIHJlYWRvbmx5IGlzSW5saW5lID0gZmFsc2U7XG4gIHByaXZhdGUgX2J1Y2tldE5hbWVQYXJhbT86IGNkay5DZm5QYXJhbWV0ZXI7XG4gIHByaXZhdGUgX29iamVjdEtleVBhcmFtPzogY2RrLkNmblBhcmFtZXRlcjtcblxuICBjb25zdHJ1Y3Rvcihwcm9wczogQ2ZuUGFyYW1ldGVyc0NvZGVQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoKTtcblxuICAgIHRoaXMuX2J1Y2tldE5hbWVQYXJhbSA9IHByb3BzLmJ1Y2tldE5hbWVQYXJhbTtcbiAgICB0aGlzLl9vYmplY3RLZXlQYXJhbSA9IHByb3BzLm9iamVjdEtleVBhcmFtO1xuICB9XG5cbiAgcHVibGljIGJpbmQoc2NvcGU6IENvbnN0cnVjdCk6IENvZGVDb25maWcge1xuICAgIGlmICghdGhpcy5fYnVja2V0TmFtZVBhcmFtKSB7XG4gICAgICB0aGlzLl9idWNrZXROYW1lUGFyYW0gPSBuZXcgY2RrLkNmblBhcmFtZXRlcihzY29wZSwgJ0xhbWJkYVNvdXJjZUJ1Y2tldE5hbWVQYXJhbWV0ZXInLCB7XG4gICAgICAgIHR5cGU6ICdTdHJpbmcnLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgaWYgKCF0aGlzLl9vYmplY3RLZXlQYXJhbSkge1xuICAgICAgdGhpcy5fb2JqZWN0S2V5UGFyYW0gPSBuZXcgY2RrLkNmblBhcmFtZXRlcihzY29wZSwgJ0xhbWJkYVNvdXJjZU9iamVjdEtleVBhcmFtZXRlcicsIHtcbiAgICAgICAgdHlwZTogJ1N0cmluZycsXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgczNMb2NhdGlvbjoge1xuICAgICAgICBidWNrZXROYW1lOiB0aGlzLl9idWNrZXROYW1lUGFyYW0udmFsdWVBc1N0cmluZyxcbiAgICAgICAgb2JqZWN0S2V5OiB0aGlzLl9vYmplY3RLZXlQYXJhbS52YWx1ZUFzU3RyaW5nLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZSBhIHBhcmFtZXRlcnMgbWFwIGZyb20gdGhpcyBpbnN0YW5jZSdzIENsb3VkRm9ybWF0aW9uIHBhcmFtZXRlcnMuXG4gICAqXG4gICAqIEl0IHJldHVybnMgYSBtYXAgd2l0aCAyIGtleXMgdGhhdCBjb3JyZXNwb25kIHRvIHRoZSBuYW1lcyBvZiB0aGUgcGFyYW1ldGVycyBkZWZpbmVkIGluIHRoaXMgTGFtYmRhIGNvZGUsXG4gICAqIGFuZCBhcyB2YWx1ZXMgaXQgY29udGFpbnMgdGhlIGFwcHJvcHJpYXRlIGV4cHJlc3Npb25zIHBvaW50aW5nIGF0IHRoZSBwcm92aWRlZCBTMyBsb2NhdGlvblxuICAgKiAobW9zdCBsaWtlbHksIG9idGFpbmVkIGZyb20gYSBDb2RlUGlwZWxpbmUgQXJ0aWZhY3QgYnkgY2FsbGluZyB0aGUgYGFydGlmYWN0LnMzTG9jYXRpb25gIG1ldGhvZCkuXG4gICAqIFRoZSByZXN1bHQgc2hvdWxkIGJlIHByb3ZpZGVkIHRvIHRoZSBDbG91ZEZvcm1hdGlvbiBBY3Rpb25cbiAgICogdGhhdCBpcyBkZXBsb3lpbmcgdGhlIFN0YWNrIHRoYXQgdGhlIExhbWJkYSB3aXRoIHRoaXMgY29kZSBpcyBwYXJ0IG9mLFxuICAgKiBpbiB0aGUgYHBhcmFtZXRlck92ZXJyaWRlc2AgcHJvcGVydHkuXG4gICAqXG4gICAqIEBwYXJhbSBsb2NhdGlvbiB0aGUgbG9jYXRpb24gb2YgdGhlIG9iamVjdCBpbiBTMyB0aGF0IHJlcHJlc2VudHMgdGhlIExhbWJkYSBjb2RlXG4gICAqL1xuICBwdWJsaWMgYXNzaWduKGxvY2F0aW9uOiBzMy5Mb2NhdGlvbik6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICBjb25zdCByZXQ6IHsgW25hbWU6IHN0cmluZ106IGFueSB9ID0ge307XG4gICAgcmV0W3RoaXMuYnVja2V0TmFtZVBhcmFtXSA9IGxvY2F0aW9uLmJ1Y2tldE5hbWU7XG4gICAgcmV0W3RoaXMub2JqZWN0S2V5UGFyYW1dID0gbG9jYXRpb24ub2JqZWN0S2V5O1xuICAgIHJldHVybiByZXQ7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGJ1Y2tldE5hbWVQYXJhbSgpOiBzdHJpbmcge1xuICAgIGlmICh0aGlzLl9idWNrZXROYW1lUGFyYW0pIHtcbiAgICAgIHJldHVybiB0aGlzLl9idWNrZXROYW1lUGFyYW0ubG9naWNhbElkO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1Bhc3MgQ2ZuUGFyYW1ldGVyc0NvZGUgdG8gYSBMYW1iZGEgRnVuY3Rpb24gYmVmb3JlIGFjY2Vzc2luZyB0aGUgYnVja2V0TmFtZVBhcmFtIHByb3BlcnR5Jyk7XG4gICAgfVxuICB9XG5cbiAgcHVibGljIGdldCBvYmplY3RLZXlQYXJhbSgpOiBzdHJpbmcge1xuICAgIGlmICh0aGlzLl9vYmplY3RLZXlQYXJhbSkge1xuICAgICAgcmV0dXJuIHRoaXMuX29iamVjdEtleVBhcmFtLmxvZ2ljYWxJZDtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdQYXNzIENmblBhcmFtZXRlcnNDb2RlIHRvIGEgTGFtYmRhIEZ1bmN0aW9uIGJlZm9yZSBhY2Nlc3NpbmcgdGhlIG9iamVjdEtleVBhcmFtIHByb3BlcnR5Jyk7XG4gICAgfVxuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyB0byBpbml0aWFsaXplIGEgbmV3IEVjckltYWdlQ29kZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIEVjckltYWdlQ29kZVByb3BzIHtcbiAgLyoqXG4gICAqIFNwZWNpZnkgb3Igb3ZlcnJpZGUgdGhlIENNRCBvbiB0aGUgc3BlY2lmaWVkIERvY2tlciBpbWFnZSBvciBEb2NrZXJmaWxlLlxuICAgKiBUaGlzIG5lZWRzIHRvIGJlIGluIHRoZSAnZXhlYyBmb3JtJywgdml6LiwgYFsgJ2V4ZWN1dGFibGUnLCAncGFyYW0xJywgJ3BhcmFtMicgXWAuXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmRvY2tlci5jb20vZW5naW5lL3JlZmVyZW5jZS9idWlsZGVyLyNjbWRcbiAgICogQGRlZmF1bHQgLSB1c2UgdGhlIENNRCBzcGVjaWZpZWQgaW4gdGhlIGRvY2tlciBpbWFnZSBvciBEb2NrZXJmaWxlLlxuICAgKi9cbiAgcmVhZG9ubHkgY21kPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIFNwZWNpZnkgb3Igb3ZlcnJpZGUgdGhlIEVOVFJZUE9JTlQgb24gdGhlIHNwZWNpZmllZCBEb2NrZXIgaW1hZ2Ugb3IgRG9ja2VyZmlsZS5cbiAgICogQW4gRU5UUllQT0lOVCBhbGxvd3MgeW91IHRvIGNvbmZpZ3VyZSBhIGNvbnRhaW5lciB0aGF0IHdpbGwgcnVuIGFzIGFuIGV4ZWN1dGFibGUuXG4gICAqIFRoaXMgbmVlZHMgdG8gYmUgaW4gdGhlICdleGVjIGZvcm0nLCB2aXouLCBgWyAnZXhlY3V0YWJsZScsICdwYXJhbTEnLCAncGFyYW0yJyBdYC5cbiAgICogQHNlZSBodHRwczovL2RvY3MuZG9ja2VyLmNvbS9lbmdpbmUvcmVmZXJlbmNlL2J1aWxkZXIvI2VudHJ5cG9pbnRcbiAgICogQGRlZmF1bHQgLSB1c2UgdGhlIEVOVFJZUE9JTlQgaW4gdGhlIGRvY2tlciBpbWFnZSBvciBEb2NrZXJmaWxlLlxuICAgKi9cbiAgcmVhZG9ubHkgZW50cnlwb2ludD86IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZ5IG9yIG92ZXJyaWRlIHRoZSBXT1JLRElSIG9uIHRoZSBzcGVjaWZpZWQgRG9ja2VyIGltYWdlIG9yIERvY2tlcmZpbGUuXG4gICAqIEEgV09SS0RJUiBhbGxvd3MgeW91IHRvIGNvbmZpZ3VyZSB0aGUgd29ya2luZyBkaXJlY3RvcnkgdGhlIGNvbnRhaW5lciB3aWxsIHVzZS5cbiAgICogQHNlZSBodHRwczovL2RvY3MuZG9ja2VyLmNvbS9lbmdpbmUvcmVmZXJlbmNlL2J1aWxkZXIvI3dvcmtkaXJcbiAgICogQGRlZmF1bHQgLSB1c2UgdGhlIFdPUktESVIgaW4gdGhlIGRvY2tlciBpbWFnZSBvciBEb2NrZXJmaWxlLlxuICAgKi9cbiAgcmVhZG9ubHkgd29ya2luZ0RpcmVjdG9yeT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGltYWdlIHRhZyB0byB1c2Ugd2hlbiBwdWxsaW5nIHRoZSBpbWFnZSBmcm9tIEVDUi5cbiAgICogQGRlZmF1bHQgJ2xhdGVzdCdcbiAgICovXG4gIHJlYWRvbmx5IHRhZz86IHN0cmluZztcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIGEgRG9ja2VyIGltYWdlIGluIEVDUiB0aGF0IGNhbiBiZSBib3VuZCBhcyBMYW1iZGEgQ29kZS5cbiAqL1xuZXhwb3J0IGNsYXNzIEVjckltYWdlQ29kZSBleHRlbmRzIENvZGUge1xuICBwdWJsaWMgcmVhZG9ubHkgaXNJbmxpbmU6IGJvb2xlYW4gPSBmYWxzZTtcblxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHJlcG9zaXRvcnk6IGVjci5JUmVwb3NpdG9yeSwgcHJpdmF0ZSByZWFkb25seSBwcm9wczogRWNySW1hZ2VDb2RlUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICBwdWJsaWMgYmluZChfOiBDb25zdHJ1Y3QpOiBDb2RlQ29uZmlnIHtcbiAgICB0aGlzLnJlcG9zaXRvcnkuZ3JhbnRQdWxsKG5ldyBpYW0uU2VydmljZVByaW5jaXBhbCgnbGFtYmRhLmFtYXpvbmF3cy5jb20nKSk7XG5cbiAgICByZXR1cm4ge1xuICAgICAgaW1hZ2U6IHtcbiAgICAgICAgaW1hZ2VVcmk6IHRoaXMucmVwb3NpdG9yeS5yZXBvc2l0b3J5VXJpRm9yVGFnKHRoaXMucHJvcHM/LnRhZyA/PyAnbGF0ZXN0JyksXG4gICAgICAgIGNtZDogdGhpcy5wcm9wcy5jbWQsXG4gICAgICAgIGVudHJ5cG9pbnQ6IHRoaXMucHJvcHMuZW50cnlwb2ludCxcbiAgICAgICAgd29ya2luZ0RpcmVjdG9yeTogdGhpcy5wcm9wcy53b3JraW5nRGlyZWN0b3J5LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyB0byBpbml0aWFsaXplIGEgbmV3IEFzc2V0SW1hZ2VcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBc3NldEltYWdlQ29kZVByb3BzIGV4dGVuZHMgZWNyX2Fzc2V0cy5Eb2NrZXJJbWFnZUFzc2V0T3B0aW9ucyB7XG4gIC8qKlxuICAgKiBTcGVjaWZ5IG9yIG92ZXJyaWRlIHRoZSBDTUQgb24gdGhlIHNwZWNpZmllZCBEb2NrZXIgaW1hZ2Ugb3IgRG9ja2VyZmlsZS5cbiAgICogVGhpcyBuZWVkcyB0byBiZSBpbiB0aGUgJ2V4ZWMgZm9ybScsIHZpei4sIGBbICdleGVjdXRhYmxlJywgJ3BhcmFtMScsICdwYXJhbTInIF1gLlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5kb2NrZXIuY29tL2VuZ2luZS9yZWZlcmVuY2UvYnVpbGRlci8jY21kXG4gICAqIEBkZWZhdWx0IC0gdXNlIHRoZSBDTUQgc3BlY2lmaWVkIGluIHRoZSBkb2NrZXIgaW1hZ2Ugb3IgRG9ja2VyZmlsZS5cbiAgICovXG4gIHJlYWRvbmx5IGNtZD86IHN0cmluZ1tdO1xuXG4gIC8qKlxuICAgKiBTcGVjaWZ5IG9yIG92ZXJyaWRlIHRoZSBFTlRSWVBPSU5UIG9uIHRoZSBzcGVjaWZpZWQgRG9ja2VyIGltYWdlIG9yIERvY2tlcmZpbGUuXG4gICAqIEFuIEVOVFJZUE9JTlQgYWxsb3dzIHlvdSB0byBjb25maWd1cmUgYSBjb250YWluZXIgdGhhdCB3aWxsIHJ1biBhcyBhbiBleGVjdXRhYmxlLlxuICAgKiBUaGlzIG5lZWRzIHRvIGJlIGluIHRoZSAnZXhlYyBmb3JtJywgdml6LiwgYFsgJ2V4ZWN1dGFibGUnLCAncGFyYW0xJywgJ3BhcmFtMicgXWAuXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmRvY2tlci5jb20vZW5naW5lL3JlZmVyZW5jZS9idWlsZGVyLyNlbnRyeXBvaW50XG4gICAqIEBkZWZhdWx0IC0gdXNlIHRoZSBFTlRSWVBPSU5UIGluIHRoZSBkb2NrZXIgaW1hZ2Ugb3IgRG9ja2VyZmlsZS5cbiAgICovXG4gIHJlYWRvbmx5IGVudHJ5cG9pbnQ/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogU3BlY2lmeSBvciBvdmVycmlkZSB0aGUgV09SS0RJUiBvbiB0aGUgc3BlY2lmaWVkIERvY2tlciBpbWFnZSBvciBEb2NrZXJmaWxlLlxuICAgKiBBIFdPUktESVIgYWxsb3dzIHlvdSB0byBjb25maWd1cmUgdGhlIHdvcmtpbmcgZGlyZWN0b3J5IHRoZSBjb250YWluZXIgd2lsbCB1c2UuXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmRvY2tlci5jb20vZW5naW5lL3JlZmVyZW5jZS9idWlsZGVyLyN3b3JrZGlyXG4gICAqIEBkZWZhdWx0IC0gdXNlIHRoZSBXT1JLRElSIGluIHRoZSBkb2NrZXIgaW1hZ2Ugb3IgRG9ja2VyZmlsZS5cbiAgICovXG4gIHJlYWRvbmx5IHdvcmtpbmdEaXJlY3Rvcnk/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogUmVwcmVzZW50cyBhbiBFQ1IgaW1hZ2UgdGhhdCB3aWxsIGJlIGNvbnN0cnVjdGVkIGZyb20gdGhlIHNwZWNpZmllZCBhc3NldCBhbmQgY2FuIGJlIGJvdW5kIGFzIExhbWJkYSBjb2RlLlxuICovXG5leHBvcnQgY2xhc3MgQXNzZXRJbWFnZUNvZGUgZXh0ZW5kcyBDb2RlIHtcbiAgcHVibGljIHJlYWRvbmx5IGlzSW5saW5lOiBib29sZWFuID0gZmFsc2U7XG4gIHByaXZhdGUgYXNzZXQ/OiBlY3JfYXNzZXRzLkRvY2tlckltYWdlQXNzZXQ7XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBkaXJlY3Rvcnk6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSBwcm9wczogQXNzZXRJbWFnZUNvZGVQcm9wcykge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICBwdWJsaWMgYmluZChzY29wZTogQ29uc3RydWN0KTogQ29kZUNvbmZpZyB7XG4gICAgLy8gSWYgdGhlIHNhbWUgQXNzZXRJbWFnZUNvZGUgaXMgdXNlZCBtdWx0aXBsZSB0aW1lcywgcmV0YWluIG9ubHkgdGhlIGZpcnN0IGluc3RhbnRpYXRpb24uXG4gICAgaWYgKCF0aGlzLmFzc2V0KSB7XG4gICAgICB0aGlzLmFzc2V0ID0gbmV3IGVjcl9hc3NldHMuRG9ja2VySW1hZ2VBc3NldChzY29wZSwgJ0Fzc2V0SW1hZ2UnLCB7XG4gICAgICAgIGRpcmVjdG9yeTogdGhpcy5kaXJlY3RvcnksXG4gICAgICAgIC4uLnRoaXMucHJvcHMsXG4gICAgICB9KTtcbiAgICAgIHRoaXMuYXNzZXQucmVwb3NpdG9yeS5ncmFudFB1bGwobmV3IGlhbS5TZXJ2aWNlUHJpbmNpcGFsKCdsYW1iZGEuYW1hem9uYXdzLmNvbScpKTtcbiAgICB9IGVsc2UgaWYgKGNkay5TdGFjay5vZih0aGlzLmFzc2V0KSAhPT0gY2RrLlN0YWNrLm9mKHNjb3BlKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBBc3NldCBpcyBhbHJlYWR5IGFzc29jaWF0ZWQgd2l0aCBhbm90aGVyIHN0YWNrICcke2Nkay5TdGFjay5vZih0aGlzLmFzc2V0KS5zdGFja05hbWV9Jy4gYCArXG4gICAgICAgICdDcmVhdGUgYSBuZXcgQ29kZSBpbnN0YW5jZSBmb3IgZXZlcnkgc3RhY2suJyk7XG4gICAgfVxuXG4gICAgcmV0dXJuIHtcbiAgICAgIGltYWdlOiB7XG4gICAgICAgIGltYWdlVXJpOiB0aGlzLmFzc2V0LmltYWdlVXJpLFxuICAgICAgICBlbnRyeXBvaW50OiB0aGlzLnByb3BzLmVudHJ5cG9pbnQsXG4gICAgICAgIGNtZDogdGhpcy5wcm9wcy5jbWQsXG4gICAgICAgIHdvcmtpbmdEaXJlY3Rvcnk6IHRoaXMucHJvcHMud29ya2luZ0RpcmVjdG9yeSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kVG9SZXNvdXJjZShyZXNvdXJjZTogY2RrLkNmblJlc291cmNlLCBvcHRpb25zOiBSZXNvdXJjZUJpbmRPcHRpb25zID0geyB9KSB7XG4gICAgaWYgKCF0aGlzLmFzc2V0KSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ2JpbmRUb1Jlc291cmNlKCkgbXVzdCBiZSBjYWxsZWQgYWZ0ZXIgYmluZCgpJyk7XG4gICAgfVxuXG4gICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0eSA9IG9wdGlvbnMucmVzb3VyY2VQcm9wZXJ0eSB8fCAnQ29kZS5JbWFnZVVyaSc7XG5cbiAgICAvLyBodHRwczovL2dpdGh1Yi5jb20vYXdzL2F3cy1jZGsvaXNzdWVzLzE0NTkzXG4gICAgdGhpcy5hc3NldC5hZGRSZXNvdXJjZU1ldGFkYXRhKHJlc291cmNlLCByZXNvdXJjZVByb3BlcnR5KTtcbiAgfVxufVxuXG4vKipcbiAqIE9wdGlvbnMgd2hlbiBjcmVhdGluZyBhbiBhc3NldCBmcm9tIGEgRG9ja2VyIGJ1aWxkLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIERvY2tlckJ1aWxkQXNzZXRPcHRpb25zIGV4dGVuZHMgY2RrLkRvY2tlckJ1aWxkT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgcGF0aCBpbiB0aGUgRG9ja2VyIGltYWdlIHdoZXJlIHRoZSBhc3NldCBpcyBsb2NhdGVkIGFmdGVyIHRoZSBidWlsZFxuICAgKiBvcGVyYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IC9hc3NldFxuICAgKi9cbiAgcmVhZG9ubHkgaW1hZ2VQYXRoPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcGF0aCBvbiB0aGUgbG9jYWwgZmlsZXN5c3RlbSB3aGVyZSB0aGUgYXNzZXQgd2lsbCBiZSBjb3BpZWRcbiAgICogdXNpbmcgYGRvY2tlciBjcGAuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gYSB1bmlxdWUgdGVtcG9yYXJ5IGRpcmVjdG9yeSBpbiB0aGUgc3lzdGVtIHRlbXAgZGlyZWN0b3J5XG4gICAqL1xuICByZWFkb25seSBvdXRwdXRQYXRoPzogc3RyaW5nO1xufVxuIl19