"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Architecture = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Architectures supported by AWS Lambda
 */
class Architecture {
    constructor(archName, dockerPlatform) {
        this.name = archName;
        this.dockerPlatform = dockerPlatform;
    }
    /**
     * Used to specify a custom architecture name.
     * Use this if the architecture name is not yet supported by the CDK.
     * @param name the architecture name as recognized by AWS Lambda.
     * @param [dockerPlatform=linux/amd64] the platform to use for this architecture when building with Docker
     */
    static custom(name, dockerPlatform) {
        return new Architecture(name, dockerPlatform !== null && dockerPlatform !== void 0 ? dockerPlatform : 'linux/amd64');
    }
}
exports.Architecture = Architecture;
_a = JSII_RTTI_SYMBOL_1;
Architecture[_a] = { fqn: "monocdk.aws_lambda.Architecture", version: "1.149.0" };
/**
 * 64 bit architecture with x86 instruction set.
 */
Architecture.X86_64 = new Architecture('x86_64', 'linux/amd64');
/**
 * 64 bit architecture with the ARM instruction set.
 */
Architecture.ARM_64 = new Architecture('arm64', 'linux/arm64');
//# sourceMappingURL=data:application/json;base64,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