"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamEventSource = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an stream as an event source for AWS Lambda.
 */
class StreamEventSource {
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_lambda_event_sources_StreamEventSourceProps(props);
    }
    enrichMappingOptions(options) {
        jsiiDeprecationWarnings.monocdk_aws_lambda_EventSourceMappingOptions(options);
        return {
            ...options,
            batchSize: this.props.batchSize || 100,
            bisectBatchOnError: this.props.bisectBatchOnError,
            startingPosition: this.props.startingPosition,
            reportBatchItemFailures: this.props.reportBatchItemFailures,
            maxBatchingWindow: this.props.maxBatchingWindow,
            maxRecordAge: this.props.maxRecordAge,
            retryAttempts: this.props.retryAttempts,
            parallelizationFactor: this.props.parallelizationFactor,
            onFailure: this.props.onFailure,
            tumblingWindow: this.props.tumblingWindow,
            enabled: this.props.enabled,
        };
    }
}
exports.StreamEventSource = StreamEventSource;
_a = JSII_RTTI_SYMBOL_1;
StreamEventSource[_a] = { fqn: "monocdk.aws_lambda_event_sources.StreamEventSource", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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