"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsDlq = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An SNS dead letter queue destination configuration for a Lambda event source
 */
class SnsDlq {
    constructor(topic) {
        this.topic = topic;
        jsiiDeprecationWarnings.monocdk_aws_sns_ITopic(topic);
    }
    /**
     * Returns a destination configuration for the DLQ
     */
    bind(_target, targetHandler) {
        jsiiDeprecationWarnings.monocdk_aws_lambda_IEventSourceMapping(_target);
        jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(targetHandler);
        this.topic.grantPublish(targetHandler);
        return {
            destination: this.topic.topicArn,
        };
    }
}
exports.SnsDlq = SnsDlq;
_a = JSII_RTTI_SYMBOL_1;
SnsDlq[_a] = { fqn: "monocdk.aws_lambda_event_sources.SnsDlq", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLWRscS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNucy1kbHEudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLE1BQU07SUFDakIsWUFBNkIsS0FBaUI7UUFBakIsVUFBSyxHQUFMLEtBQUssQ0FBWTs7S0FDN0M7SUFFRDs7T0FFRztJQUNJLElBQUksQ0FBQyxPQUE0QixFQUFFLGFBQXdCOzs7UUFDaEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLENBQUM7UUFFdkMsT0FBTztZQUNMLFdBQVcsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVE7U0FDakMsQ0FBQztLQUNIOztBQWJILHdCQWNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGxxRGVzdGluYXRpb25Db25maWcsIElFdmVudFNvdXJjZURscSwgSUV2ZW50U291cmNlTWFwcGluZywgSUZ1bmN0aW9uIH0gZnJvbSAnLi4vLi4vYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzbnMgZnJvbSAnLi4vLi4vYXdzLXNucyc7XG5cbi8qKlxuICogQW4gU05TIGRlYWQgbGV0dGVyIHF1ZXVlIGRlc3RpbmF0aW9uIGNvbmZpZ3VyYXRpb24gZm9yIGEgTGFtYmRhIGV2ZW50IHNvdXJjZVxuICovXG5leHBvcnQgY2xhc3MgU25zRGxxIGltcGxlbWVudHMgSUV2ZW50U291cmNlRGxxIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB0b3BpYzogc25zLklUb3BpYykge1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYSBkZXN0aW5hdGlvbiBjb25maWd1cmF0aW9uIGZvciB0aGUgRExRXG4gICAqL1xuICBwdWJsaWMgYmluZChfdGFyZ2V0OiBJRXZlbnRTb3VyY2VNYXBwaW5nLCB0YXJnZXRIYW5kbGVyOiBJRnVuY3Rpb24pOiBEbHFEZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgdGhpcy50b3BpYy5ncmFudFB1Ymxpc2godGFyZ2V0SGFuZGxlcik7XG5cbiAgICByZXR1cm4ge1xuICAgICAgZGVzdGluYXRpb246IHRoaXMudG9waWMudG9waWNBcm4sXG4gICAgfTtcbiAgfVxufVxuIl19