"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiEventSource = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigw = require("../../aws-apigateway");
const core_1 = require("../../core");
class ApiEventSource {
    constructor(method, path, options) {
        this.method = method;
        this.path = path;
        this.options = options;
        jsiiDeprecationWarnings.monocdk_aws_apigateway_MethodOptions(options);
        if (!path.startsWith('/')) {
            throw new Error(`Path must start with "/": ${path}`);
        }
    }
    bind(target) {
        jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(target);
        const id = `${core_1.Names.nodeUniqueId(target.node)}:ApiEventSourceA7A86A4F`;
        const stack = core_1.Stack.of(target);
        let api = stack.node.tryFindChild(id);
        if (!api) {
            api = new apigw.RestApi(stack, id, {
                defaultIntegration: new apigw.LambdaIntegration(target),
            });
        }
        const resource = api.root.resourceForPath(this.path);
        resource.addMethod(this.method, undefined, this.options);
    }
}
exports.ApiEventSource = ApiEventSource;
_a = JSII_RTTI_SYMBOL_1;
ApiEventSource[_a] = { fqn: "monocdk.aws_lambda_event_sources.ApiEventSource", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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