"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("../../aws-events");
const targets = require("../../aws-events-targets");
const event_bridge_1 = require("./event-bridge");
/**
 * Use a Lambda function as a Lambda destination
 */
class LambdaDestination {
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
        jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
        jsiiDeprecationWarnings.monocdk_aws_lambda_destinations_LambdaDestinationOptions(options);
    }
    /**
     * Returns a destination configuration
     */
    bind(scope, fn, options) {
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
        jsiiDeprecationWarnings.monocdk_aws_lambda_DestinationOptions(options);
        // Normal Lambda destination (full invocation record)
        if (!this.options.responseOnly) {
            // deduplicated automatically
            this.fn.grantInvoke(fn);
            return {
                destination: this.fn.functionArn,
            };
        }
        // Otherwise add rule to extract the response payload and use EventBridge
        // as destination
        if (!options) { // `options` added to bind() as optionnal to avoid breaking change
            throw new Error('Options must be defined when using `responseOnly`.');
        }
        // Match invocation result of the source function (`fn`) and use it
        // to trigger the destination function (`this.fn`).
        new events.Rule(scope, options.type, {
            eventPattern: {
                detailType: [`Lambda Function Invocation Result - ${options.type}`],
                resources: [`${fn.functionArn}:$LATEST`],
                source: ['lambda'],
            },
            targets: [
                new targets.LambdaFunction(this.fn, {
                    event: events.RuleTargetInput.fromEventPath('$.detail.responsePayload'),
                }),
            ],
        });
        const destination = new event_bridge_1.EventBridgeDestination(); // Use default event bus here
        return destination.bind(scope, fn);
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "monocdk.aws_lambda_destinations.LambdaDestination", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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