"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("../../aws-events");
const core_1 = require("../../core");
/**
 * Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 */
class EventBridgeDestination {
    /**
     * @default - use the default event bus
     */
    constructor(eventBus) {
        this.eventBus = eventBus;
        jsiiDeprecationWarnings.monocdk_aws_events_IEventBus(eventBus);
    }
    /**
     * Returns a destination configuration
     */
    bind(_scope, fn, _options) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
        jsiiDeprecationWarnings.monocdk_aws_lambda_DestinationOptions(_options);
        if (this.eventBus) {
            this.eventBus.grantPutEventsTo(fn);
            return {
                destination: this.eventBus.eventBusArn,
            };
        }
        const existingDefaultEventBus = _scope.node.tryFindChild('DefaultEventBus');
        let eventBus = existingDefaultEventBus || events.EventBus.fromEventBusArn(_scope, 'DefaultEventBus', core_1.Stack.of(fn).formatArn({
            service: 'events',
            resource: 'event-bus',
            resourceName: 'default',
        }));
        eventBus.grantPutEventsTo(fn);
        return {
            destination: eventBus.eventBusArn,
        };
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
_a = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_a] = { fqn: "monocdk.aws_lambda_destinations.EventBridgeDestination", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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