"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViaServicePrincipal = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
/**
 * A principal to allow access to a key if it's being used through another AWS service
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        jsiiDeprecationWarnings.monocdk_aws_iam_IPrincipal(basePrincipal);
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
}
exports.ViaServicePrincipal = ViaServicePrincipal;
_a = JSII_RTTI_SYMBOL_1;
ViaServicePrincipal[_a] = { fqn: "monocdk.aws_kms.ViaServicePrincipal", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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