"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionProcessor = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an AWS Lambda function to transform records.
 */
class LambdaFunctionProcessor {
    constructor(lambdaFunction, props = {}) {
        this.lambdaFunction = lambdaFunction;
        jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(lambdaFunction);
        jsiiDeprecationWarnings.monocdk_aws_kinesisfirehose_DataProcessorProps(props);
        this.props = props;
    }
    bind(_scope, options) {
        jsiiDeprecationWarnings.monocdk_aws_kinesisfirehose_DataProcessorBindOptions(options);
        this.lambdaFunction.grantInvoke(options.role);
        return {
            processorType: 'Lambda',
            processorIdentifier: {
                parameterName: 'LambdaArn',
                parameterValue: this.lambdaFunction.functionArn,
            },
        };
    }
}
exports.LambdaFunctionProcessor = LambdaFunctionProcessor;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionProcessor[_a] = { fqn: "monocdk.aws_kinesisfirehose.LambdaFunctionProcessor", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWZ1bmN0aW9uLXByb2Nlc3Nvci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxhbWJkYS1mdW5jdGlvbi1wcm9jZXNzb3IudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBSUE7O0dBRUc7QUFDSCxNQUFhLHVCQUF1QjtJQU1sQyxZQUE2QixjQUFnQyxFQUFFLFFBQTRCLEVBQUU7UUFBaEUsbUJBQWMsR0FBZCxjQUFjLENBQWtCOzs7UUFDM0QsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7S0FDcEI7SUFFTSxJQUFJLENBQUMsTUFBaUIsRUFBRSxPQUFpQzs7UUFDOUQsSUFBSSxDQUFDLGNBQWMsQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRTlDLE9BQU87WUFDTCxhQUFhLEVBQUUsUUFBUTtZQUN2QixtQkFBbUIsRUFBRTtnQkFDbkIsYUFBYSxFQUFFLFdBQVc7Z0JBQzFCLGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVc7YUFDaEQ7U0FDRixDQUFDO0tBQ0g7O0FBcEJILDBEQXFCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICcuLi8uLi9hd3MtbGFtYmRhJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgRGF0YVByb2Nlc3NvckJpbmRPcHRpb25zLCBEYXRhUHJvY2Vzc29yQ29uZmlnLCBEYXRhUHJvY2Vzc29yUHJvcHMsIElEYXRhUHJvY2Vzc29yIH0gZnJvbSAnLi9wcm9jZXNzb3InO1xuXG4vKipcbiAqIFVzZSBhbiBBV1MgTGFtYmRhIGZ1bmN0aW9uIHRvIHRyYW5zZm9ybSByZWNvcmRzLlxuICovXG5leHBvcnQgY2xhc3MgTGFtYmRhRnVuY3Rpb25Qcm9jZXNzb3IgaW1wbGVtZW50cyBJRGF0YVByb2Nlc3NvciB7XG4gIC8qKlxuICAgKiBUaGUgY29uc3RydWN0b3IgcHJvcHMgb2YgdGhlIExhbWJkYUZ1bmN0aW9uUHJvY2Vzc29yLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHByb3BzOiBEYXRhUHJvY2Vzc29yUHJvcHM7XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBsYW1iZGFGdW5jdGlvbjogbGFtYmRhLklGdW5jdGlvbiwgcHJvcHM6IERhdGFQcm9jZXNzb3JQcm9wcyA9IHt9KSB7XG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QsIG9wdGlvbnM6IERhdGFQcm9jZXNzb3JCaW5kT3B0aW9ucyk6IERhdGFQcm9jZXNzb3JDb25maWcge1xuICAgIHRoaXMubGFtYmRhRnVuY3Rpb24uZ3JhbnRJbnZva2Uob3B0aW9ucy5yb2xlKTtcblxuICAgIHJldHVybiB7XG4gICAgICBwcm9jZXNzb3JUeXBlOiAnTGFtYmRhJyxcbiAgICAgIHByb2Nlc3NvcklkZW50aWZpZXI6IHtcbiAgICAgICAgcGFyYW1ldGVyTmFtZTogJ0xhbWJkYUFybicsXG4gICAgICAgIHBhcmFtZXRlclZhbHVlOiB0aGlzLmxhbWJkYUZ1bmN0aW9uLmZ1bmN0aW9uQXJuLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG4iXX0=