"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Input = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const core_1 = require("../../core");
const iotevents_generated_1 = require("./iotevents.generated");
class InputBase extends core_1.Resource {
    grantWrite(grantee) {
        return this.grant(grantee, 'iotevents:BatchPutMessage');
    }
    grant(grantee, ...actions) {
        return iam.Grant.addToPrincipal({
            grantee,
            actions,
            resourceArns: [this.inputArn],
        });
    }
}
/**
 * Defines an AWS IoT Events input in this stack.
 */
class Input extends InputBase {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.inputName,
        });
        jsiiDeprecationWarnings.monocdk_aws_iotevents_InputProps(props);
        if (props.attributeJsonPaths.length === 0) {
            throw new Error('attributeJsonPaths property cannot be empty');
        }
        const resource = new iotevents_generated_1.CfnInput(this, 'Resource', {
            inputName: this.physicalName,
            inputDefinition: {
                attributes: props.attributeJsonPaths.map(path => ({ jsonPath: path })),
            },
        });
        this.inputName = this.getResourceNameAttribute(resource.ref);
        this.inputArn = this.getResourceArnAttribute(arnForInput(resource.ref), {
            service: 'iotevents',
            resource: 'input',
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing input.
     */
    static fromInputName(scope, id, inputName) {
        return new class Import extends InputBase {
            constructor() {
                super(...arguments);
                this.inputName = inputName;
                this.inputArn = this.stack.formatArn({
                    service: 'iotevents',
                    resource: 'input',
                    resourceName: inputName,
                });
            }
        }(scope, id);
    }
}
exports.Input = Input;
_a = JSII_RTTI_SYMBOL_1;
Input[_a] = { fqn: "monocdk.aws_iotevents.Input", version: "1.149.0" };
function arnForInput(inputName) {
    return `arn:${core_1.Aws.PARTITION}:iotevents:${core_1.Aws.REGION}:${core_1.Aws.ACCOUNT_ID}:input/${inputName}`;
}
//# sourceMappingURL=data:application/json;base64,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