"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Expression = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Expression for events in Detector Model state.
 * @see https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
 */
class Expression {
    constructor() {
    }
    /**
     * Create a expression from the given string.
     */
    static fromString(value) {
        return new StringExpression(value);
    }
    /**
     * Create a expression for function `currentInput()`.
     * It is evaluated to true if the specified input message was received.
     */
    static currentInput(input) {
        jsiiDeprecationWarnings.monocdk_aws_iotevents_IInput(input);
        return this.fromString(`currentInput("${input.inputName}")`);
    }
    /**
     * Create a expression for get an input attribute as `$input.TemperatureInput.temperatures[2]`.
     */
    static inputAttribute(input, path) {
        jsiiDeprecationWarnings.monocdk_aws_iotevents_IInput(input);
        return this.fromString(`$input.${input.inputName}.${path}`);
    }
    /**
     * Create a expression for the Equal operator.
     */
    static eq(left, right) {
        jsiiDeprecationWarnings.monocdk_aws_iotevents_Expression(left);
        jsiiDeprecationWarnings.monocdk_aws_iotevents_Expression(right);
        return new BinaryOperationExpression(left, '==', right);
    }
    /**
     * Create a expression for the AND operator.
     */
    static and(left, right) {
        jsiiDeprecationWarnings.monocdk_aws_iotevents_Expression(left);
        jsiiDeprecationWarnings.monocdk_aws_iotevents_Expression(right);
        return new BinaryOperationExpression(left, '&&', right);
    }
}
exports.Expression = Expression;
_a = JSII_RTTI_SYMBOL_1;
Expression[_a] = { fqn: "monocdk.aws_iotevents.Expression", version: "1.149.0" };
class StringExpression extends Expression {
    constructor(value) {
        super();
        this.value = value;
    }
    evaluate() {
        return this.value;
    }
}
class BinaryOperationExpression extends Expression {
    constructor(left, operator, right) {
        super();
        this.left = left;
        this.operator = operator;
        this.right = right;
    }
    evaluate() {
        return `${this.left.evaluate()} ${this.operator} ${this.right.evaluate()}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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