import { IInput } from './input';
/**
 * Expression for events in Detector Model state.
 * @see https://docs.aws.amazon.com/iotevents/latest/developerguide/iotevents-expressions.html
 */
export declare abstract class Expression {
    /**
     * Create a expression from the given string.
     */
    static fromString(value: string): Expression;
    /**
     * Create a expression for function `currentInput()`.
     * It is evaluated to true if the specified input message was received.
     */
    static currentInput(input: IInput): Expression;
    /**
     * Create a expression for get an input attribute as `$input.TemperatureInput.temperatures[2]`.
     */
    static inputAttribute(input: IInput, path: string): Expression;
    /**
     * Create a expression for the Equal operator.
     */
    static eq(left: Expression, right: Expression): Expression;
    /**
     * Create a expression for the AND operator.
     */
    static and(left: Expression, right: Expression): Expression;
    constructor();
    /**
     * This is called to evaluate the expression.
     */
    abstract evaluate(): string;
}
