"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetVariableAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The action to create a variable with a specified value.
 */
class SetVariableAction {
    /**
     * @param variableName the name of the variable
     * @param value the new value of the variable
     */
    constructor(variableName, value) {
        this.variableName = variableName;
        this.value = value;
        jsiiDeprecationWarnings.monocdk_aws_iotevents_Expression(value);
    }
    bind(_scope, _options) {
        jsiiDeprecationWarnings.monocdk_aws_iotevents_ActionBindOptions(_options);
        return {
            configuration: {
                setVariable: {
                    variableName: this.variableName,
                    value: this.value.evaluate(),
                },
            },
        };
    }
}
exports.SetVariableAction = SetVariableAction;
_a = JSII_RTTI_SYMBOL_1;
SetVariableAction[_a] = { fqn: "monocdk.aws_iotevents_actions.SetVariableAction", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2V0LXZhcmlhYmxlLWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNldC12YXJpYWJsZS1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLGlCQUFpQjtJQUM1Qjs7O09BR0c7SUFDSCxZQUE2QixZQUFvQixFQUFtQixLQUEyQjtRQUFsRSxpQkFBWSxHQUFaLFlBQVksQ0FBUTtRQUFtQixVQUFLLEdBQUwsS0FBSyxDQUFzQjs7S0FDOUY7SUFFRCxJQUFJLENBQUMsTUFBaUIsRUFBRSxRQUFxQzs7UUFDM0QsT0FBTztZQUNMLGFBQWEsRUFBRTtnQkFDYixXQUFXLEVBQUU7b0JBQ1gsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO29CQUMvQixLQUFLLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUU7aUJBQzdCO2FBQ0Y7U0FDRixDQUFDO0tBQ0g7O0FBakJILDhDQWtCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlvdGV2ZW50cyBmcm9tICcuLi8uLi9hd3MtaW90ZXZlbnRzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIFRoZSBhY3Rpb24gdG8gY3JlYXRlIGEgdmFyaWFibGUgd2l0aCBhIHNwZWNpZmllZCB2YWx1ZS5cbiAqL1xuZXhwb3J0IGNsYXNzIFNldFZhcmlhYmxlQWN0aW9uIGltcGxlbWVudHMgaW90ZXZlbnRzLklBY3Rpb24ge1xuICAvKipcbiAgICogQHBhcmFtIHZhcmlhYmxlTmFtZSB0aGUgbmFtZSBvZiB0aGUgdmFyaWFibGVcbiAgICogQHBhcmFtIHZhbHVlIHRoZSBuZXcgdmFsdWUgb2YgdGhlIHZhcmlhYmxlXG4gICAqL1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHZhcmlhYmxlTmFtZTogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IHZhbHVlOiBpb3RldmVudHMuRXhwcmVzc2lvbikge1xuICB9XG5cbiAgYmluZChfc2NvcGU6IENvbnN0cnVjdCwgX29wdGlvbnM6IGlvdGV2ZW50cy5BY3Rpb25CaW5kT3B0aW9ucyk6IGlvdGV2ZW50cy5BY3Rpb25Db25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBjb25maWd1cmF0aW9uOiB7XG4gICAgICAgIHNldFZhcmlhYmxlOiB7XG4gICAgICAgICAgdmFyaWFibGVOYW1lOiB0aGlzLnZhcmlhYmxlTmFtZSxcbiAgICAgICAgICB2YWx1ZTogdGhpcy52YWx1ZS5ldmFsdWF0ZSgpLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG4iXX0=